/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.gestori;

import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.slf4j.Logger;

public class GestoreConsistenzaDati
implements Runnable {
    public static boolean gestoreConsistenzaDatiInEsecuzione = false;
    public static boolean gestoreConsistenzaDatiEseguitoConErrore = false;
    private Logger log = ControlStationLogger.getPddConsoleCoreLogger();
    private boolean initForceMapping;
    private boolean stop = false;

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public GestoreConsistenzaDati(boolean initForceMapping) {
        this.initForceMapping = initForceMapping;
    }

    @Override
    public void run() {
        if (gestoreConsistenzaDatiInEsecuzione) {
            this.log.info("Gestore Consistenza Dati risulta gi\u00e0 avviato");
            return;
        }
        gestoreConsistenzaDatiInEsecuzione = true;
        String statoOperazione = "";
        try {
            ControlStationCore core = null;
            if (!this.stop) {
                core = new ControlStationCore();
            }
            if (!this.stop) {
                statoOperazione = "[Inizializzazione Mapping Erogazione] ";
                this.log.debug("Controllo Consistenza Dati Mapping Erogazione-PA ....");
                core.initMappingErogazione(this.initForceMapping, this.log);
                this.log.debug("Controllo Consistenza Dati Mapping Erogazione-PA completato con successo");
            }
            if (!this.stop) {
                statoOperazione = "[Inizializzazione Mapping Fruizione] ";
                this.log.debug("Controllo Consistenza Dati Mapping Fruizione-PD ....");
                core.initMappingFruizione(this.initForceMapping, this.log);
                this.log.debug("Controllo Consistenza Dati Mapping Fruizione-PD completato con successo");
            }
            this.log.info("Attivit\u00e0 di Controllo Consistenza Dati completato con successo.");
        }
        catch (Exception e) {
            gestoreConsistenzaDatiEseguitoConErrore = true;
            this.log.error(statoOperazione + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            gestoreConsistenzaDatiInEsecuzione = false;
        }
    }
}

