/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.TipiDocumentoCoordinamento;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiServizioParteComuneAllegatiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            AccordiServizioParteComuneHelper apcHelper = new AccordiServizioParteComuneHelper(request, pd, session);
            ArchiviHelper archiviHelper = new ArchiviHelper(request, pd, session);
            Boolean isShowAccordiCooperazione = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, Boolean.class, (String)"ShowAccordiCooperazione");
            String idAccordo = apcHelper.getParameter("id");
            long idAccordoLong = Long.parseLong(idAccordo);
            String ruolo = apcHelper.getParameter("ruolo");
            String tipoFile = apcHelper.getParameter("tipoFile");
            String tipoAccordo = apcHelper.getParameter("tipoAccordo");
            if ("".equals(tipoAccordo)) {
                tipoAccordo = null;
            }
            List<BinaryParameter> binaryParameterDocumenti = apcHelper.getBinaryParameters("theFile");
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore();
            apcHelper.makeMenu();
            AccordoServizioParteComune as = apcCore.getAccordoServizioFull(idAccordoLong);
            String labelASTitle = apcHelper.getLabelIdAccordo(as);
            String[] ruoli = null;
            ruoli = isShowAccordiCooperazione != null && isShowAccordiCooperazione != false ? (as.getServizioComposto() == null ? new String[2] : new String[3]) : new String[]{RuoliDocumento.allegato.toString(), RuoliDocumento.specificaSemiformale.toString()};
            if (isShowAccordiCooperazione != null && isShowAccordiCooperazione.booleanValue() && as.getServizioComposto() != null) {
                ruoli[2] = RuoliDocumento.specificaCoordinamento.toString();
            }
            String[] tipiAmmessi = null;
            String[] tipiAmmessiLabel = null;
            if (ruolo != null && !"".equals(ruolo)) {
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        break;
                    }
                    case specificaCoordinamento: {
                        tipiAmmessi = TipiDocumentoCoordinamento.toEnumNameArray();
                        tipiAmmessiLabel = TipiDocumentoCoordinamento.toStringArray();
                        break;
                    }
                    case specificaSemiformale: {
                        tipiAmmessi = TipiDocumentoSemiformale.toEnumNameArray();
                        tipiAmmessiLabel = TipiDocumentoSemiformale.toStringArray();
                        break;
                    }
                }
            }
            boolean find = false;
            if (tipoFile != null && StringUtils.isNotEmpty((String)tipoFile) && tipiAmmessi != null && tipiAmmessi.length > 0) {
                for (String t : tipiAmmessi) {
                    if (!tipoFile.equals(t)) continue;
                    find = true;
                    break;
                }
            }
            if (!find) {
                tipoFile = null;
            }
            IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
            String uri = idAccordoFactory.getUriFromAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", idAccordo);
            Parameter pNomeAccordo = new Parameter("nome", uri);
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByOrganizationType(as.getSoggettoReferente().getTipo());
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)session, (HttpServletRequest)request, (Boolean)false).getValue();
            List<Parameter> listaParams = apcHelper.getTitoloApc(TipoOperazione.ADD, as, tipoAccordo, labelASTitle, null, false);
            String labelAllegati = isModalitaVistaApiCustom != null && isModalitaVistaApiCustom != false ? "Allegati" : "Allegati di " + labelASTitle;
            listaParams.add(new Parameter(labelAllegati, "accordiServizioParteComuneAllegatiList.do", new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo}));
            listaParams.add(new Parameter("Aggiungi", null));
            if (apcHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                ArrayList<Object> dati = new ArrayList<Object>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                apcHelper.addAccordiAllegatiToDati(dati, TipoOperazione.ADD, idAccordo, ruolo, ruoli, tipiAmmessi, tipiAmmessiLabel, tipoAccordo, tipoFile, null, null, as, null, null, binaryParameterDocumenti);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiServizioParteComuneAllegati", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = archiviHelper.accordiAllegatiCheckData(TipoOperazione.ADD, binaryParameterDocumenti, as.getId(), ProprietariDocumento.accordoServizio, pf);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                ArrayList<Object> dati = new ArrayList<Object>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                apcHelper.addAccordiAllegatiToDati(dati, TipoOperazione.ADD, idAccordo, ruolo, ruoli, tipiAmmessi, tipiAmmessiLabel, tipoAccordo, tipoFile, null, null, as, null, null, binaryParameterDocumenti);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiServizioParteComuneAllegati", (ForwardParams)ForwardParams.ADD());
            }
            for (BinaryParameter binaryParameter : binaryParameterDocumenti) {
                Documento documento = new Documento();
                documento.setRuolo(RuoliDocumento.valueOf((String)ruolo).toString());
                documento.setByteContenuto(binaryParameter.getValue());
                documento.setFile(binaryParameter.getFilename());
                documento.setIdProprietarioDocumento(as.getId());
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        documento.setTipo(binaryParameter.getFilename().substring(binaryParameter.getFilename().lastIndexOf(46) + 1, binaryParameter.getFilename().length()));
                        as.addAllegato(documento);
                        break;
                    }
                    case specificaSemiformale: {
                        documento.setTipo(TipiDocumentoSemiformale.valueOf((String)tipoFile).getNome());
                        as.addSpecificaSemiformale(documento);
                        break;
                    }
                    case specificaCoordinamento: {
                        documento.setTipo(TipiDocumentoCoordinamento.valueOf((String)tipoFile).getNome());
                        AccordoServizioParteComuneServizioComposto assc = as.getServizioComposto();
                        if (assc == null) {
                            assc = new AccordoServizioParteComuneServizioComposto();
                        }
                        assc.addSpecificaCoordinamento(documento);
                        as.setServizioComposto(assc);
                        break;
                    }
                }
            }
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<Documento> lista = apcCore.accordiAllegatiList(idAccordoLong, (ISearch)ricerca);
            apcHelper.prepareAccordiAllegatiList(as, (ISearch)ricerca, lista, tipoAccordo);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteComuneAllegati", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteComuneAllegati", (ForwardParams)ForwardParams.ADD());
        }
    }
}

