/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.MessagePart;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceParameter;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.ParameterType;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.IDAccordoDB;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.manifest.constants.InterfaceType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.registro.GestoreRegistroServiziRemoto;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordoServizioParteComuneInUsoCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordoServizioParteComuneMappingCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordoServizioParteComuneRestCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordoServizioParteComuneServiziCompostiCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordoServizioParteComuneSinteticoCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordoServizioParteComuneSoapCore;
import org.openspcoop2.web.lib.mvc.BinaryParameter;

public class AccordiServizioParteComuneCore
extends ControlStationCore {
    private AccordoServizioParteComuneSoapCore soapCore = new AccordoServizioParteComuneSoapCore(this);
    private AccordoServizioParteComuneRestCore restCore = new AccordoServizioParteComuneRestCore(this);
    private AccordoServizioParteComuneInUsoCore inUsoCore = new AccordoServizioParteComuneInUsoCore(this);
    private AccordoServizioParteComuneSinteticoCore sinteticoCore = new AccordoServizioParteComuneSinteticoCore(this);
    private AccordoServizioParteComuneServiziCompostiCore serviziCompostiCore = new AccordoServizioParteComuneServiziCompostiCore(this);
    private AccordoServizioParteComuneMappingCore mappingCore = new AccordoServizioParteComuneMappingCore(this);

    public AccordiServizioParteComuneCore() throws DriverControlStationException {
    }

    public AccordiServizioParteComuneCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    public boolean isSupportatoSoggettoReferente(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoSoggettoReferente";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean showWsdlDefinitorio(String protocollo, ServiceBinding serviceBinding, InterfaceType interfaceType) throws DriverRegistroServiziException {
        String nomeMetodo = "showWsdlDefinitorio";
        try {
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createProtocolConfiguration().isSupportoSchemaEsternoInterfaccia(serviceBinding, interfaceType);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean showConversazioni(String protocollo, ServiceBinding serviceBinding, InterfaceType interfaceType) throws DriverRegistroServiziException {
        String nomeMetodo = "showConversazioni";
        try {
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createProtocolConfiguration().isSupportoSpecificaConversazioni(serviceBinding, interfaceType);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean showPortiAccesso(String protocollo, ServiceBinding serviceBinding, InterfaceType interfaceType) throws DriverRegistroServiziException {
        String nomeMetodo = "showPortiAccesso";
        try {
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createProtocolConfiguration().isSupportoPortiAccessoAccordiParteSpecifica(serviceBinding, interfaceType);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public void validaStatoAccordoServizio(AccordoServizioParteComune as, boolean utilizzoAzioniDiretteInAccordoAbilitato, boolean logValidazioneError) throws DriverRegistroServiziException, ValidazioneStatoPackageException {
        Connection con = null;
        String nomeMetodo = "validaStatoAccordoServizio";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            driver.validaStatoAccordoServizio(as, utilizzoAzioniDiretteInAccordoAbilitato);
        }
        catch (ValidazioneStatoPackageException e) {
            if (logValidazioneError) {
                ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] ValidazioneStatoPackageException :" + e.getMessage(), e);
            }
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] DriverRegistroServiziException :" + e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ValidazioneResult validazione(AccordoServizioParteComune as, String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "validazione";
        try {
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createValidazioneAccordi().valida(as);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public ValidazioneResult validaInterfacciaWsdlParteComune(AccordoServizioParteComune as, String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "validaInterfacciaWsdlParteComune";
        try {
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createValidazioneDocumenti().validaSpecificaInterfaccia(as);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public ValidazioneResult validaSpecificaConversazione(AccordoServizioParteComune as, String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "validaSpecificaConversazione";
        try {
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createValidazioneDocumenti().validaSpecificaConversazione(as);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean isAccordoInUso(IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        return this.inUsoCore.isAccordoInUso(idAccordo, whereIsInUso, normalizeObjectIds);
    }

    public boolean isAccordoInUso(AccordoServizioParteComune as, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        return this.inUsoCore.isAccordoInUso(as, whereIsInUso, normalizeObjectIds);
    }

    public long getIdAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getIdAccordoServizio";
        try {
            con = ControlStationCore.dbM.getConnection();
            long l = DBUtils.getIdAccordoServizioParteComune((IDAccordo)idAccordo, (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteComune getAccordoServizioFull(IDAccordo idAccordo) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getAccordoServizioFull";
        DriverControlStationDB driver = null;
        try {
            if (this.isRegistroServiziLocale()) {
                con = ControlStationCore.dbM.getConnection();
                driver = new DriverControlStationDB(con, null, this.tipoDB);
                AccordoServizioParteComune accordoServizioParteComune = driver.getDriverRegistroServiziDB().getAccordoServizioParteComune(idAccordo);
                ControlStationCore.dbM.releaseConnection(con);
                return accordoServizioParteComune;
            }
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
                throw de;
                catch (Exception e) {
                    ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
                    throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                ControlStationCore.dbM.releaseConnection(con);
                throw throwable;
            }
        }
        {
            AccordoServizioParteComune accordoServizioParteComune = GestoreRegistroServiziRemoto.getDriverRegistroServizi(ControlStationCore.log).getAccordoServizioParteComune(idAccordo);
            ControlStationCore.dbM.releaseConnection(con);
            return accordoServizioParteComune;
        }
    }

    public AccordoServizioParteComune getAccordoServizioFull(IDAccordo idAccordo, boolean deepRead) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAccordoServizioFull(idAccordo,deepRead)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoServizioParteComune accordoServizioParteComune = driver.getDriverRegistroServiziDB().getAccordoServizioParteComune(idAccordo, deepRead, deepRead);
            return accordoServizioParteComune;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public AccordoServizioParteComune[] getAllIdAccordiWithSoggettoReferente(IDSoggetto idsoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAllIdAccordiWithSoggettoReferente";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoServizioParteComune[] accordoServizioParteComuneArray = driver.getDriverRegistroServiziDB().getAllIdAccordiWithSoggettoReferente(idsoggetto);
            return accordoServizioParteComuneArray;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Documento> accordiAllegatiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiAllegatiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().accordiAllegatiList(idAccordo, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Soggetto> accordiErogatoriList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiErogatoriList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().accordiErogatoriList(idAccordo, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDAccordoDB> idAccordiServizioParteComuneList(String superuser, ISearch ricerca, boolean soloAccordiConsistentiRest, boolean soloAccordiConsistentiSoap) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "idAccordiServizioParteComuneList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().idAccordiServizioParteComuneList(superuser, ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsAccordoServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existsAccordoServizioParteComune(idAccordo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IDAccordo> getAllIdAccordiServizio(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAllIdAccordiServizio";
        DriverControlStationDB driver = null;
        try {
            if (this.isRegistroServiziLocale()) {
                con = ControlStationCore.dbM.getConnection();
                driver = new DriverControlStationDB(con, null, this.tipoDB);
                List list = driver.getDriverRegistroServiziDB().getAllIdAccordiServizioParteComune(filtroRicerca);
                ControlStationCore.dbM.releaseConnection(con);
                return list;
            }
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
                throw de;
                catch (Exception e) {
                    ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
                    throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                ControlStationCore.dbM.releaseConnection(con);
                throw throwable;
            }
        }
        {
            List list = GestoreRegistroServiziRemoto.getDriverRegistroServizi(ControlStationCore.log).getAllIdAccordiServizioParteComune(filtroRicerca);
            ControlStationCore.dbM.releaseConnection(con);
            return list;
        }
    }

    public IDAccordo getIdAccordoServizio(long id) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getIdAccordoServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDAccordo iDAccordo = driver.getDriverRegistroServiziDB().getIdAccordoServizioParteComune(id);
            return iDAccordo;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public AccordoServizioParteComune getAccordoServizioFull(long id) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getAccordoServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean readContenutoAllegati = false;
            boolean readDatiRegistro = true;
            AccordoServizioParteComune accordoServizioParteComune = driver.getDriverRegistroServiziDB().getAccordoServizioParteComune(id, readContenutoAllegati, readDatiRegistro);
            return accordoServizioParteComune;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public int getAccordoServizioParteComuneNextVersion(IDAccordo idAccordo) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getAccordoServizioParteComuneNextVersion";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            int n = driver.getDriverRegistroServiziDB().getAccordoServizioParteComuneNextVersion(idAccordo);
            return n;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void deleteAzione(long idAccordo, String nomeAzione) throws DriverRegistroServiziException {
        this.soapCore.deleteAzione(idAccordo, nomeAzione);
    }

    public List<Azione> accordiAzioniList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soapCore.accordiAzioniList(idAccordo, ricerca);
    }

    public List<Azione> accordiAzioniList(long idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soapCore.accordiAzioniList(idAccordo, profiloCollaborazione, ricerca);
    }

    public List<PortType> accordiPorttypeList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soapCore.accordiPorttypeList(idAccordo, ricerca);
    }

    public List<PortType> accordiPorttypeList(long idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soapCore.accordiPorttypeList(idAccordo, profiloCollaborazione, ricerca);
    }

    public List<Operation> accordiPorttypeOperationList(long idPortType, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soapCore.accordiPorttypeOperationList(idPortType, ricerca);
    }

    public List<Operation> accordiPorttypeOperationList(long idPortType, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soapCore.accordiPorttypeOperationList(idPortType, profiloCollaborazione, ricerca);
    }

    public List<MessagePart> accordiPorttypeOperationMessagePartList(long idOperation, boolean isInput, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soapCore.accordiPorttypeOperationMessagePartList(idOperation, isInput, ricerca);
    }

    public boolean existsAccordoServizioPorttype(String nome, long idAccordo) throws DriverRegistroServiziException {
        return this.soapCore.existsAccordoServizioPorttype(nome, idAccordo);
    }

    public boolean existsAccordoServizioPorttypeOperation(String nome, long idPortType) throws DriverRegistroServiziException {
        return this.soapCore.existsAccordoServizioPorttypeOperation(nome, idPortType);
    }

    public boolean existsAccordoServizioPorttypeOperation(String nome, IDAccordo idAccordo, String nomePortType) throws DriverRegistroServiziException {
        return this.soapCore.existsAccordoServizioPorttypeOperation(nome, idAccordo, nomePortType);
    }

    public boolean isUnicaAzioneInAccordi(String azione) throws DriverRegistroServiziException {
        return this.soapCore.isUnicaAzioneInAccordi(azione);
    }

    public boolean isAzioneCorrelata(long idAccordo, String nomeAzione, String owner) throws DriverRegistroServiziException {
        return this.soapCore.isAzioneCorrelata(idAccordo, nomeAzione, owner);
    }

    public boolean isOperationCorrelata(long idPortType, String nomeCorrelata, String owner) throws DriverRegistroServiziException {
        return this.soapCore.isOperationCorrelata(idPortType, nomeCorrelata, owner);
    }

    public boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.soapCore.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare);
    }

    public boolean isOperationCorrelataRichiesta(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.soapCore.isOperationCorrelataRichiesta(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare);
    }

    public boolean existsAccordoServizioAzione(long idAzione) throws DriverRegistroServiziException {
        return this.soapCore.existsAccordoServizioAzione(idAzione);
    }

    public boolean existsAccordoServizioOperation(long idAzione) throws DriverRegistroServiziException {
        return this.soapCore.existsAccordoServizioOperation(idAzione);
    }

    public boolean existsAccordoServizioAzione(String nome, long idAccordo) throws DriverRegistroServiziException {
        return this.soapCore.existsAccordoServizioAzione(nome, idAccordo);
    }

    public List<IDPortType> getAllIdPortType(FiltroRicercaPortTypes filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.soapCore.getAllIdPortType(filtroRicerca);
    }

    public List<IDPortTypeAzione> getAllIdOperation(FiltroRicercaOperations filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.soapCore.getAllIdOperation(filtroRicerca);
    }

    public List<Resource> accordiResourceList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        return this.restCore.accordiResourceList(idAccordo, ricerca);
    }

    public List<ResourceResponse> accordiResourceResponseList(Long idRisorsa, ISearch ricerca) throws DriverRegistroServiziException {
        return this.restCore.accordiResourceResponseList(idRisorsa, ricerca);
    }

    public List<ResourceRepresentation> accordiResourceRepresentationsList(Long idRisorsa, boolean isRequest, Long idRisposta, ISearch ricerca) throws DriverRegistroServiziException {
        return this.restCore.accordiResourceRepresentationsList(idRisorsa, isRequest, idRisposta, ricerca);
    }

    public List<ResourceParameter> accordiResourceParametersList(Long idRisorsa, boolean isRequest, Long idRisposta, ISearch ricerca) throws DriverRegistroServiziException {
        return this.restCore.accordiResourceParametersList(idRisorsa, isRequest, idRisposta, ricerca);
    }

    public boolean existsAccordoServizioResource(String nome, long idAccordo) throws DriverRegistroServiziException {
        return this.restCore.existsAccordoServizioResource(nome, idAccordo);
    }

    public boolean existsAccordoServizioResource(String httpMethod, String path, long idAccordo, String excludeResourceWithName) throws DriverRegistroServiziException {
        return this.restCore.existsAccordoServizioResource(httpMethod, path, idAccordo, excludeResourceWithName);
    }

    public boolean existsAccordoServizioResourceResponse(long idRisorsa, int httpStatus) throws DriverRegistroServiziException {
        return this.restCore.existsAccordoServizioResourceResponse(idRisorsa, httpStatus);
    }

    public boolean existsAccordoServizioResourceRepresentation(Long idRisorsa, boolean isRequest, Long idResponse, String mediaType) throws DriverRegistroServiziException {
        return this.restCore.existsAccordoServizioResourceRepresentation(idRisorsa, isRequest, idResponse, mediaType);
    }

    public boolean existsAccordoServizioResourceParameter(Long idRisorsa, boolean isRequest, Long idResponse, ParameterType tipoParametro, String nome) throws DriverRegistroServiziException {
        return this.restCore.existsAccordoServizioResourceParameter(idRisorsa, isRequest, idResponse, tipoParametro, nome);
    }

    public List<IDResource> getAllIdResource(FiltroRicercaResources filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.restCore.getAllIdResource(filtroRicerca);
    }

    public AccordoServizioParteComuneSintetico getAccordoServizioSintetico(IDAccordo idAccordo) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        return this.sinteticoCore.getAccordoServizioSintetico(idAccordo);
    }

    public List<AccordoServizioParteComuneSintetico> accordiServizioParteComuneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.sinteticoCore.accordiServizioParteComuneList(superuser, ricerca);
    }

    public List<AccordoServizioParteComuneSintetico> accordiServizioCompostiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.sinteticoCore.accordiServizioCompostiList(superuser, ricerca);
    }

    public AccordoServizioParteComuneSintetico getAccordoServizioSintetico(long id) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        return this.sinteticoCore.getAccordoServizioSintetico(id);
    }

    public List<IDAccordoDB> idAccordiServizioCompostiList(String superuser, ISearch ricerca, boolean soloAccordiConsistentiRest, boolean soloAccordiConsistentiSoap) throws DriverRegistroServiziException {
        return this.serviziCompostiCore.idAccordiServizioCompostiList(superuser, ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
    }

    public List<AccordoServizioParteComune> accordiServizioServiziComponentiConSoggettoErogatore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        return this.serviziCompostiCore.accordiServizioServiziComponentiConSoggettoErogatore(idSoggetto);
    }

    public List<AccordoServizioParteComune> accordiServizioServiziComponenti(IDServizio idServizio) throws DriverRegistroServiziException {
        return this.serviziCompostiCore.accordiServizioServiziComponenti(idServizio);
    }

    public List<AccordoServizioParteComune> accordiServizioWithAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione) throws DriverRegistroServiziException {
        return this.serviziCompostiCore.accordiServizioWithAccordoCooperazione(idAccordoCooperazione);
    }

    public List<AccordoServizioParteComuneServizioCompostoServizioComponente> accordiComponentiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        return this.serviziCompostiCore.accordiComponentiList(idAccordo, ricerca);
    }

    public List<String[]> getAccordiServizioCompostoLabels(AccordoServizioParteComune as, long idAccordoLong, String userLogin, List<String> tipiServiziCompatibili, List<String> tipiSoggettiCompatibili, ConsoleHelper helper) {
        return this.serviziCompostiCore.getAccordiServizioCompostoLabels(as, idAccordoLong, userLogin, tipiServiziCompatibili, tipiSoggettiCompatibili, helper);
    }

    public void mappingAutomatico(String protocollo, AccordoServizioParteComune as, boolean validazioneDocumenti) throws DriverRegistroServiziException {
        this.mappingCore.mappingAutomatico(protocollo, as, validazioneDocumenti);
    }

    public void popolaResourceDaUnAltroASPC(AccordoServizioParteComune aspcDestinazione, AccordoServizioParteComune aspcSorgente, boolean aggiornaRisorseEsistenti, boolean eliminaRisorseNonPresentiNuovaInterfaccia, List<IDResource> risorseEliminate) throws DriverRegistroServiziException {
        this.mappingCore.popolaResourceDaUnAltroASPC(aspcDestinazione, aspcSorgente, aggiornaRisorseEsistenti, eliminaRisorseNonPresentiNuovaInterfaccia, risorseEliminate);
    }

    public void popolaPorttypeOperationDaUnAltroASPC(AccordoServizioParteComune aspcDestinazione, AccordoServizioParteComune aspcSorgente, boolean aggiornaServiziAzioniEsistenti, boolean eliminaServiziAzioniNonPresentiNuovaInterfaccia, List<IDPortType> portTypeEliminati, List<IDPortTypeAzione> operationEliminate) throws DriverRegistroServiziException {
        this.mappingCore.popolaPorttypeOperationDaUnAltroASPC(aspcDestinazione, aspcSorgente, aggiornaServiziAzioniEsistenti, eliminaServiziAzioniNonPresentiNuovaInterfaccia, portTypeEliminati, operationEliminate);
    }

    public void estraiSchemiFromWSDLTypesAsAllegati(AccordoServizioParteComune as, byte[] wsdl, String tipoWSDL, Map<String, byte[]> schemiAggiuntiInQuestaOperazione) throws Exception {
        this.mappingCore.estraiSchemiFromWSDLTypesAsAllegati(as, wsdl, tipoWSDL, schemiAggiuntiInQuestaOperazione);
    }

    public String readEndpoint(AccordoServizioParteComuneSintetico as, String portTypeParam, String servcorr, BinaryParameter wsdlimpler, BinaryParameter wsdlimplfru) {
        return this.mappingCore.readEndpoint(as, portTypeParam, servcorr, wsdlimpler, wsdlimplfru);
    }

    public String getDettagliAccordoInUso(IDAccordo idAccordo) throws DriverRegistroServiziException {
        return this.inUsoCore.getDettagliAccordoInUso(idAccordo);
    }

    public boolean isRisorsaInUso(IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        return this.inUsoCore.isRisorsaInUso(idRisorsa, whereIsInUso, normalizeObjectIds);
    }

    public String getDettagliRisorsaInUso(IDResource idResource) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        return this.inUsoCore.getDettagliRisorsaInUso(idResource);
    }

    public boolean isPortTypeInUso(IDPortType idPT, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        return this.inUsoCore.isPortTypeInUso(idPT, whereIsInUso, normalizeObjectIds);
    }

    public String getDettagliPortTypeInUso(IDPortType idPT) throws DriverRegistroServiziException {
        return this.inUsoCore.getDettagliPortTypeInUso(idPT);
    }

    public boolean isOperazioneInUso(IDPortTypeAzione idOperazione, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        return this.inUsoCore.isOperazioneInUso(idOperazione, whereIsInUso, normalizeObjectIds);
    }

    public String getDettagliOperazioneInUso(IDPortTypeAzione idOperazione) throws DriverRegistroServiziException {
        return this.inUsoCore.getDettagliOperazioneInUso(idOperazione);
    }
}

