/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc.api;

import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.GruppiAccordo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.GruppoSintetico;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.manifest.constants.InterfaceType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.CheckboxStatusType;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementImage;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TargetType;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class ApiHelper
extends AccordiServizioParteComuneHelper {
    public ApiHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public void prepareApiList(List<AccordoServizioParteComuneSintetico> lista, ISearch ricerca, String tipoAccordo) throws DriverControlStationException {
        try {
            List<String> protocolli;
            List<String> l;
            if (lista == null) {
                throw new DriverControlStationException("Param lista is null");
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneApi", (Parameter[])new Parameter[]{new Parameter("tipoAccordo", tipoAccordo)});
            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)true, (String)"vistaApi");
            this.pd.setCustomListViewName("api");
            boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            boolean showServiceBinding = true;
            boolean showResources = true;
            boolean showServices = true;
            if (!showProtocolli && !(l = this.core.getProtocolli(this.request, this.session)).isEmpty()) {
                IProtocolFactory p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(l.get(0));
                if (p.getManifest().getBinding().getRest() == null) {
                    showResources = false;
                }
                if (p.getManifest().getBinding().getSoap() == null) {
                    showServices = false;
                }
                if (!showResources || !showServices) {
                    showServiceBinding = false;
                }
            }
            int idLista = Liste.ACCORDI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            String filterProtocol = this.addFilterProtocol(ricerca, idLista, true);
            String protocolloS = filterProtocol;
            if (protocolloS == null && (protocolli = this.core.getProtocolli(this.request, this.session)) != null && protocolli.size() == 1) {
                protocolloS = protocolli.get(0);
            }
            boolean profiloModipaSelezionato = false;
            if (this.core.getProtocolli().contains("modipa")) {
                ArrayList<String> profiloModipaSelezionatoOpzioniAccettate = new ArrayList<String>();
                profiloModipaSelezionatoOpzioniAccettate.add("modipa");
                if (this.core.isModipaFiltroRicercaProfiloQualsiasiVisualizzaDatiModi()) {
                    profiloModipaSelezionatoOpzioniAccettate.add("");
                }
                if (filterProtocol != null && profiloModipaSelezionatoOpzioniAccettate.contains(filterProtocol) || filterProtocol == null && protocolloS != null && profiloModipaSelezionatoOpzioniAccettate.contains(protocolloS)) {
                    profiloModipaSelezionato = true;
                }
            }
            String filterTipoAccordo = null;
            if (showServiceBinding) {
                filterTipoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroServiceBinding");
                boolean postBackServiceBinding = profiloModipaSelezionato;
                this.addFilterServiceBinding(filterTipoAccordo, postBackServiceBinding, false);
            }
            String filterGruppo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroGruppo");
            this.addFilterGruppo(filterProtocol, filterGruppo, false);
            CanaliConfigurazione canali = this.confCore.getCanaliConfigurazione(false);
            if (canali != null && StatoFunzionalita.ABILITATO.equals((Object)canali.getStato())) {
                String filterCanale = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroCanale");
                this.addFilterCanale(canali, filterCanale, false);
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                String filterStatoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroStatoAccordo");
                this.addFilterStatoAccordo(filterStatoAccordo, false);
            }
            if (profiloModipaSelezionato) {
                this.addFilterSubtitle("subtDatiProfiloModI", "Dati Profilo ModI", false);
                this.addFilterModISicurezzaCanale(ricerca, idLista);
                this.addFilterModISicurezzaMessaggio(ricerca, idLista, filterTipoAccordo);
                this.addFilterModIGenerazioneToken(ricerca, idLista);
                this.addFilterModIDigestRichiesta(ricerca, idLista);
                this.addFilterModIInfoUtente(ricerca, idLista);
                this.impostaAperturaSubtitle("subtDatiProfiloModI");
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String termine = AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo);
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(termine, "accordiServizioParteComuneList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(termine, "accordiServizioParteComuneList.do"), new Parameter("Risultati ricerca", null)});
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)termine, (String)search);
            }
            ArrayList<String> labelLst = new ArrayList<String>();
            labelLst.add("");
            labelLst.add(termine);
            String[] labels = labelLst.toArray(new String[labelLst.size()]);
            this.pd.setLabels(labels);
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            List<String> tagsDisponibili = this.gruppiCore.getAllGruppiOrdinatiPerDataRegistrazione();
            CanaliConfigurazione gestioneCanali = this.confCore.getCanaliConfigurazione(false);
            boolean gestioneCanaliEnabled = gestioneCanali != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
            List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
            CanaleConfigurazione canaleConfigurazioneDefault = null;
            if (gestioneCanaliEnabled) {
                canaleConfigurazioneDefault = this.getCanaleDefault(canaleList);
            }
            for (int i = 0; i < lista.size(); ++i) {
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                AccordoServizioParteComuneSintetico accordoServizio = lista.get(i);
                Parameter pIdAccordo = new Parameter("id", "" + accordoServizio.getId());
                Parameter pNomeAccordo = new Parameter("nome", accordoServizio.getNome());
                Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
                ServiceBinding serviceBinding = this.apcCore.toMessageServiceBinding(accordoServizio.getServiceBinding());
                String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(accordoServizio.getSoggettoReferente().getTipo());
                DataElement de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setUrl("accordiServizioParteComuneApiChange.do", new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo});
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
                String labelAccordo = this.getLabelIdAccordo(protocollo, idAccordo);
                de.setValue(labelAccordo);
                de.setIdToRemove("" + accordoServizio.getId());
                e.add(de);
                de = new DataElement();
                Object labelServiceBinding = null;
                switch (serviceBinding) {
                    case REST: {
                        labelServiceBinding = "Rest";
                        break;
                    }
                    default: {
                        labelServiceBinding = "Soap";
                    }
                }
                InterfaceType interfaceType = this.apcCore.formatoSpecifica2InterfaceType(accordoServizio.getFormatoSpecifica());
                labelServiceBinding = (String)labelServiceBinding + " " + this.getLabelWSDLFromFormatoSpecifica(interfaceType);
                if (gestioneCanaliEnabled) {
                    String labelCanale = accordoServizio.getCanale();
                    if (labelCanale == null) {
                        labelCanale = canaleConfigurazioneDefault.getNome();
                    }
                    if (showProtocolli) {
                        String labelProtocollo = this.getLabelProtocollo(protocollo);
                        de.setValue(MessageFormat.format("API {0}, Canale: {1}, Profilo Interoperabilit&agrave;: {2}", labelServiceBinding, labelCanale, labelProtocollo));
                    } else {
                        de.setValue(MessageFormat.format("API {0}, Canale: {1}", labelServiceBinding, labelCanale));
                    }
                } else if (showProtocolli) {
                    String labelProtocollo = this.getLabelProtocollo(protocollo);
                    de.setValue(MessageFormat.format("API {0}, Profilo Interoperabilit&agrave;: {1}", labelServiceBinding, labelProtocollo));
                } else {
                    de.setValue(MessageFormat.format("API {0}", labelServiceBinding));
                }
                de.setType(DataElementType.SUBTITLE);
                e.add(de);
                de = new DataElement();
                de.setName("statoServ");
                de.setType(DataElementType.CHECKBOX);
                ConsoleSearch searchForCount = new ConsoleSearch(true);
                switch (serviceBinding) {
                    case REST: {
                        this.apcCore.accordiResourceList(accordoServizio.getId().intValue(), (ISearch)searchForCount);
                        int numRisorse = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES);
                        if (numRisorse > 0) {
                            de.setStatusType(CheckboxStatusType.ABILITATO);
                            de.setStatusToolTip("API correttamente configurata");
                            break;
                        }
                        de.setStatusType(CheckboxStatusType.DISABILITATO);
                        de.setStatusToolTip("Nessuna risorsa configurata sull'API");
                        break;
                    }
                    default: {
                        List<PortType> accordiPorttypeList = this.apcCore.accordiPorttypeList(accordoServizio.getId().intValue(), (ISearch)searchForCount);
                        int numeroTotaleServizi = accordiPorttypeList.size();
                        int numeroServiziAbilitati = 0;
                        for (PortType portType : accordiPorttypeList) {
                            if (portType.sizeAzioneList() <= 0) continue;
                            ++numeroServiziAbilitati;
                        }
                        if (numeroTotaleServizi == 0) {
                            de.setStatusType(CheckboxStatusType.DISABILITATO);
                            de.setStatusToolTip("Nessun servizio configurato sull'API");
                            break;
                        }
                        if (numeroServiziAbilitati == 0) {
                            de.setStatusType(CheckboxStatusType.DISABILITATO);
                            if (numeroTotaleServizi == 1) {
                                de.setStatusToolTip("Nessun'azione configurata sul servizio dell'API");
                                break;
                            }
                            de.setStatusToolTip("Tutti i servizi dell'API non possiedono azioni");
                            break;
                        }
                        if (numeroServiziAbilitati == numeroTotaleServizi) {
                            de.setStatusType(CheckboxStatusType.ABILITATO);
                            de.setStatusToolTip("API correttamente configurata");
                            break;
                        }
                        de.setStatusType(CheckboxStatusType.WARNING_ONLY);
                        de.setStatusToolTip("Per alcuni servizi dell'API non sono state configurate azioni");
                    }
                }
                de.setWidthPx(16);
                e.add(de);
                List gruppo = accordoServizio.getGruppo();
                if (gruppo != null && !gruppo.isEmpty()) {
                    for (int j = 0; j < gruppo.size(); ++j) {
                        GruppoSintetico gruppoSintetico = (GruppoSintetico)gruppo.get(j);
                        de = new DataElement();
                        de.setName("gruppo_" + j);
                        de.setType(DataElementType.BUTTON);
                        de.setLabel(gruppoSintetico.getNome());
                        int indexOf = tagsDisponibili.indexOf(gruppoSintetico.getNome());
                        if (indexOf == -1) {
                            indexOf = 0;
                        }
                        de.setStyleClass("label-info-" + (indexOf %= CostantiControlStation.NUMERO_GRUPPI_CSS.intValue()));
                        e.add(de);
                    }
                }
                this.addInUsoButton(e, labelAccordo, "" + accordoServizio.getId(), InUsoType.ACCORDO_SERVIZIO_PARTE_COMUNE);
                if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
                    ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
                    listaParametriChange.add(pIdAccordo);
                    listaParametriChange.add(pNomeAccordo);
                    listaParametriChange.add(pTipoAccordo);
                    this.addComandoResetCacheButton(e, labelAccordo, "accordiServizioParteComuneApiChange.do", listaParametriChange);
                }
                if (this.existsProprietaOggetto(accordoServizio.getProprietaOggetto(), accordoServizio.getDescrizione())) {
                    this.addProprietaOggettoButton(e, labelAccordo, "" + accordoServizio.getId(), InUsoType.ACCORDO_SERVIZIO_PARTE_COMUNE);
                }
                dati.add(e);
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport()) {
                ExporterUtils exporterUtils = new ExporterUtils(this.archiviCore);
                boolean exists = false;
                exists = "apc".equals(tipoAccordo) ? exporterUtils.existsAtLeastOneExportMode(ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE, this.request, this.session) : exporterUtils.existsAtLeastOneExportMode(ArchiveType.ACCORDO_SERVIZIO_COMPOSTO, this.request, this.session);
                if (exists) {
                    ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                    AreaBottoni ab = new AreaBottoni();
                    ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setValue("Esporta");
                    if ("apc".equals(tipoAccordo)) {
                        de.setOnClick(AccordiServizioParteComuneCostanti.LABEL_APC_ESPORTA_SELEZIONATI_ONCLICK);
                    } else {
                        de.setOnClick(AccordiServizioParteComuneCostanti.LABEL_ASC_ESPORTA_SELEZIONATI_ONCLICK);
                    }
                    de.setDisabilitaAjaxStatus();
                    otherbott.add(de);
                    ab.setBottoni(otherbott);
                    bottoni.add(ab);
                    this.pd.setAreaBottoni(bottoni);
                }
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareApiChange(TipoOperazione tipoOp, AccordoServizioParteComune as) throws DriverControlStationException, DriverRegistroServiziException, ProtocolException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String tipoAccordo = this.getParameter("tipoAccordo");
        Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
        IDAccordo idAccordoOLD = this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)as.getSoggettoReferente()), as.getVersione());
        String tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(as.getSoggettoReferente().getTipo());
        String labelASTitle = this.getLabelIdAccordo(tipoProtocollo, idAccordoOLD);
        ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)true, (String)"vistaApi");
        ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
        String termine = AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo);
        lstParm.add(new Parameter(termine, "accordiServizioParteComuneApiList.do", new Parameter[]{pTipoAccordo}));
        lstParm.add(new Parameter(labelASTitle, null));
        ServletUtils.setPageDataTitle((PageData)this.pd, lstParm);
        this.makeMenu();
        List<List<DataElement>> datiPagina = new ArrayList<List<DataElement>>();
        ArrayList<DataElement> dati = new ArrayList<DataElement>();
        datiPagina.add(dati);
        dati.add(ServletUtils.getDataElementForEditModeFinished());
        ServiceBinding serviceBinding = this.apcCore.toMessageServiceBinding(as.getServiceBinding());
        datiPagina = this.addApiToDati(datiPagina, tipoOp, as, tipoAccordo, tipoProtocollo, serviceBinding);
        this.pd.setDati(datiPagina);
        this.pd.disableEditMode();
    }

    public ActionForward prepareApiResetCache(ActionMapping mapping, GeneralData gd, TipoOperazione tipoOp, AccordoServizioParteComune as) throws Exception {
        String tipoAccordo = this.getParameter("tipoAccordo");
        Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
        IDAccordo idAccordoOLD = this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID((IdSoggetto)as.getSoggettoReferente()), as.getVersione());
        String tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(as.getSoggettoReferente().getTipo());
        String labelASTitle = this.getLabelIdAccordo(tipoProtocollo, idAccordoOLD);
        ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)true, (String)"vistaApi");
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)this.session);
        ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
        String termine = AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo);
        lstParm.add(new Parameter(termine, "accordiServizioParteComuneApiList.do", new Parameter[]{pTipoAccordo}));
        lstParm.add(new Parameter(labelASTitle, null));
        ServletUtils.setPageDataTitle((PageData)this.pd, lstParm);
        this.makeMenu();
        List<String> aliases = this.apcCore.getJmxPdDAliases();
        String alias = null;
        if (aliases != null && !aliases.isEmpty()) {
            alias = aliases.get(0);
        }
        this.apcCore.invokeJmxMethodAllNodesAndSetResult(this.pd, this.apcCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.apcCore.getJmxPdDConfigurazioneSistemaNomeMetodoRipulisciRiferimentiCacheApi(alias), MessageFormat.format("{0} eliminato dalla cache", labelASTitle), MessageFormat.format("Eliminazione {0} dalla cache non riuscita: ", labelASTitle), as.getId());
        String resetElementoCacheS = this.getParameter("rmElFromCache");
        boolean resetElementoCache = ServletUtils.isCheckBoxEnabled((String)resetElementoCacheS);
        if (resetElementoCache) {
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, ConsoleSearch.class);
            int idLista = Liste.ACCORDI;
            List<AccordoServizioParteComuneSintetico> lista = null;
            if (this.apcCore.isRegistroServiziLocale() && !ServletUtils.isSearchDone((IConsoleHelper)this)) {
                lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)this.request, (HttpSession)this.session, (int)idLista, AccordoServizioParteComuneSintetico.class);
            }
            ricerca = this.checkSearchParameters(idLista, ricerca);
            if (lista == null) {
                lista = AccordiServizioParteComuneUtilities.accordiList(this.apcCore, userLogin, ricerca, tipoAccordo);
            }
            if (!this.isPostBackFilterElement()) {
                ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (int)idLista, lista);
            }
            this.prepareApiList(lista, (ISearch)ricerca, tipoAccordo);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (GeneralData)gd, (PageData)this.pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteComuneApi", (ForwardParams)CostantiControlStation.TIPO_OPERAZIONE_RESET_CACHE_ELEMENTO);
        }
        this.prepareApiChange(tipoOp, as);
        ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (GeneralData)gd, (PageData)this.pd);
        return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteComuneApi", (ForwardParams)ForwardParams.CHANGE());
    }

    private List<List<DataElement>> addApiToDati(List<List<DataElement>> datiPagina, TipoOperazione tipoOp, AccordoServizioParteComune as, String tipoAccordo, String tipoProtocollo, ServiceBinding serviceBinding) throws DriverRegistroServiziException, DriverControlStationException, ProtocolException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean gestioneCanaliEnabled;
        boolean asWithAllegati;
        if (tipoOp != null) {
            // empty if block
        }
        this.pd.setCustomListViewName("api");
        Parameter pIdAccordo = new Parameter("id", "" + as.getId());
        Parameter pNomeAccordo = new Parameter("nome", as.getNome());
        Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
        IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(as);
        String labelAccordo = this.getLabelIdAccordo(tipoProtocollo, idAccordo);
        boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
        List<DataElement> dati = datiPagina.get(0);
        ArrayList<Parameter> listParametersApi = new ArrayList<Parameter>();
        listParametersApi.add(new Parameter("apiGestioneParziale", ""));
        listParametersApi.add(pIdAccordo);
        listParametersApi.add(pNomeAccordo);
        listParametersApi.add(pTipoAccordo);
        this.addComandoInUsoButton(labelAccordo, "" + as.getId(), InUsoType.ACCORDO_SERVIZIO_PARTE_COMUNE);
        if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
            ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
            listaParametriChange.add(pIdAccordo);
            listaParametriChange.add(pNomeAccordo);
            listaParametriChange.add(pTipoAccordo);
            this.pd.addComandoResetCacheElementoButton("accordiServizioParteComuneApiChange.do", listaParametriChange);
        }
        if (this.existsProprietaOggetto(as.getProprietaOggetto(), as.getDescrizione())) {
            this.addComandoProprietaOggettoButton(labelAccordo, "" + as.getId(), InUsoType.ACCORDO_SERVIZIO_PARTE_COMUNE);
        }
        DataElement de = new DataElement();
        de.setType(DataElementType.CHECKBOX);
        de.setLabel("Nome");
        de.setValue(this.getLabelIdAccordoSenzaReferente(tipoProtocollo, idAccordo));
        de.setStatusValue(this.getLabelIdAccordoSenzaReferente(tipoProtocollo, idAccordo));
        DataElementImage image = new DataElementImage();
        ((Parameter)listParametersApi.get(0)).setValue("apiInfoGenerali");
        image.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
        image.setToolTip(MessageFormat.format("Modifica {0}", "Informazioni Generali"));
        image.setImage("&#xE3C9;");
        de.addImage(image);
        if (as.getDescrizione() == null || StringUtils.isEmpty((String)as.getDescrizione())) {
            image = new DataElementImage();
            ((Parameter)listParametersApi.get(0)).setValue("apiDescrizione");
            image.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Aggiungi {0}", "Descrizione"));
            image.setImage("&#xE873;");
            de.addImage(image);
        }
        ConsoleSearch searchForCount = new ConsoleSearch(true);
        switch (serviceBinding) {
            case REST: {
                this.apcCore.accordiResourceList(as.getId().intValue(), (ISearch)searchForCount);
                int numRisorse = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES);
                if (numRisorse > 0) {
                    de.setStatusType(CheckboxStatusType.ABILITATO);
                    de.setStatusToolTip("API correttamente configurata");
                    break;
                }
                de.setStatusType(CheckboxStatusType.DISABILITATO);
                de.setStatusToolTip("Nessuna risorsa configurata sull'API");
                break;
            }
            default: {
                List<PortType> accordiPorttypeList = this.apcCore.accordiPorttypeList(as.getId().intValue(), (ISearch)searchForCount);
                int numeroTotaleServizi = accordiPorttypeList.size();
                int numeroServiziAbilitati = 0;
                for (PortType portType : accordiPorttypeList) {
                    if (portType.sizeAzioneList() <= 0) continue;
                    ++numeroServiziAbilitati;
                }
                if (numeroTotaleServizi == 0) {
                    de.setStatusType(CheckboxStatusType.DISABILITATO);
                    de.setStatusToolTip("Nessun servizio configurato sull'API");
                    break;
                }
                if (numeroServiziAbilitati == 0) {
                    de.setStatusType(CheckboxStatusType.DISABILITATO);
                    if (numeroTotaleServizi == 1) {
                        de.setStatusToolTip("Nessun'azione configurata sul servizio dell'API");
                        break;
                    }
                    de.setStatusToolTip("Tutti i servizi dell'API non possiedono azioni");
                    break;
                }
                if (numeroServiziAbilitati == numeroTotaleServizi) {
                    de.setStatusType(CheckboxStatusType.ABILITATO);
                    de.setStatusToolTip("API correttamente configurata");
                    break;
                }
                de.setStatusType(CheckboxStatusType.WARNING_ONLY);
                de.setStatusToolTip("Per alcuni servizi dell'API non sono state configurate azioni");
            }
        }
        dati.add(de);
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        IProtocolFactory protocolFactory = protocolFactoryManager.getProtocolFactoryByName(tipoProtocollo);
        boolean supportatoSoggettoReferente = protocolFactory.createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune();
        if (supportatoSoggettoReferente) {
            de = new DataElement();
            de.setLabel("Soggetto Referente");
            de.setValue(this.getLabelNomeSoggetto(tipoProtocollo, as.getSoggettoReferente().getTipo(), as.getSoggettoReferente().getNome()));
            de.setType(DataElementType.TEXT);
            image = new DataElementImage();
            ((Parameter)listParametersApi.get(0)).setValue("apiSoggettoReferente");
            image.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Modifica {0}", "Soggetto Referente"));
            image.setImage("&#xE3C9;");
            de.setImage(image);
            dati.add(de);
        }
        IConsoleDynamicConfiguration consoleDynamicConfiguration = protocolFactory.createDynamicConfigurationConsole();
        IRegistryReader registryReader = this.apcCore.getRegistryReader(protocolFactory);
        IConfigIntegrationReader configRegistryReader = this.apcCore.getConfigIntegrationReader(protocolFactory);
        ConsoleConfiguration consoleConfiguration = "asc".equals(tipoAccordo) ? consoleDynamicConfiguration.getDynamicConfigAccordoServizioComposto(ConsoleOperationType.CHANGE, (IConsoleHelper)this, registryReader, configRegistryReader, idAccordo) : consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteComune(ConsoleOperationType.CHANGE, (IConsoleHelper)this, registryReader, configRegistryReader, idAccordo);
        boolean modificaDatiProfilo = false;
        if (consoleConfiguration != null && consoleConfiguration.getConsoleItem() != null && !consoleConfiguration.getConsoleItem().isEmpty()) {
            modificaDatiProfilo = true;
        }
        if (showProtocolli || modificaDatiProfilo) {
            de = new DataElement();
            String labelProtocollo = this.getLabelProtocollo(tipoProtocollo);
            de.setLabel("Profilo Interoperabilit\u00e0");
            de.setValue(labelProtocollo);
            de.setType(DataElementType.TEXT);
            if (modificaDatiProfilo) {
                image = new DataElementImage();
                ((Parameter)listParametersApi.get(0)).setValue("apiProfilo");
                image.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
                image.setToolTip(MessageFormat.format("Modifica {0}", "Profilo Interoperabilit\u00e0"));
                image.setImage("&#xE3C9;");
                de.setImage(image);
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Interfaccia");
        de.setType(DataElementType.TEXT);
        String labelServiceBinding = null;
        String tipoWsdl = null;
        String tipologiaDocumentoScaricare = null;
        boolean download = false;
        switch (serviceBinding) {
            case REST: {
                labelServiceBinding = "Rest";
                tipoWsdl = "wsdlconc";
                tipologiaDocumentoScaricare = "wsdlConcettuale";
                download = as.getByteWsdlConcettuale() != null && as.getByteWsdlConcettuale().length > 0;
                break;
            }
            default: {
                labelServiceBinding = "Soap";
                tipoWsdl = "wsdlserv";
                tipologiaDocumentoScaricare = "wsdlLogicoErogatore";
                download = as.getByteWsdlLogicoErogatore() != null && as.getByteWsdlLogicoErogatore().length > 0;
            }
        }
        InterfaceType interfaceType = this.apcCore.formatoSpecifica2InterfaceType(as.getFormatoSpecifica());
        String labelWsdlCon = this.getLabelWSDLFromFormatoSpecifica(interfaceType);
        StringBuilder sb = new StringBuilder();
        sb.append(labelServiceBinding).append(" ").append(labelWsdlCon);
        de.setValue(sb.toString());
        Parameter pNascondiSezioneDownload = new Parameter("apiGestioneParziale", "apiWsdlChange");
        Parameter pTipoWsdl = new Parameter("tipo", tipoWsdl);
        ArrayList<Parameter> listParametersApiWsdlChange = new ArrayList<Parameter>();
        listParametersApiWsdlChange.add(pIdAccordo);
        listParametersApiWsdlChange.add(pTipoAccordo);
        listParametersApiWsdlChange.add(pTipoWsdl);
        listParametersApiWsdlChange.add(pNascondiSezioneDownload);
        image = new DataElementImage();
        if (this.isModalitaStandard()) {
            image.setUrl("accordiServizioParteComuneWSDLChange.do", listParametersApiWsdlChange.toArray(new Parameter[1]));
        } else {
            ((Parameter)listParametersApi.get(0)).setValue("apiGestioneSpecificaInterfacce");
            image.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
        }
        image.setToolTip(MessageFormat.format("Modifica {0}", "Interfaccia"));
        image.setImage("&#xE3C9;");
        image.setTarget(TargetType.SELF);
        de.addImage(image);
        if (download) {
            ArrayList<Parameter> listParametersApiWsdlDownload = new ArrayList<Parameter>();
            Parameter pIdAccordoDownload = new Parameter("idAccordo", "" + as.getId());
            Parameter pTipoDocumentoDownload = new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare);
            Parameter pTipoAccordoDownload = new Parameter("tipoDocumento", "aspc");
            listParametersApiWsdlDownload.add(pIdAccordoDownload);
            listParametersApiWsdlDownload.add(pTipoDocumentoDownload);
            listParametersApiWsdlDownload.add(pTipoAccordoDownload);
            image = new DataElementImage();
            image.setUrl("downloadDocumento", listParametersApiWsdlDownload.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Download {0}", "Interfaccia"));
            image.setImage("&#xE884;");
            image.setTarget(TargetType.SELF);
            image.setDisabilitaAjaxStatus();
            de.addImage(image);
        }
        if (!this.isModalitaStandard() && (asWithAllegati = this.asWithAllegatiXsd(as))) {
            ArrayList<Parameter> listParametersApiWsdlDownload = new ArrayList<Parameter>();
            Parameter pIdAccordoDownload = new Parameter("idAccordo", "" + as.getId());
            Parameter pTipoDocumentoDownload = new Parameter("tipoDocumentoDaScaricare", "xsdSchemaCollection");
            Parameter pTipoAccordoDownload = new Parameter("tipoDocumento", "aspc");
            Parameter pApiGestioneParziale = new Parameter("apiGestioneParziale", "apiGestioneSpecificaInterfacce");
            listParametersApiWsdlDownload.add(pIdAccordoDownload);
            listParametersApiWsdlDownload.add(pTipoDocumentoDownload);
            listParametersApiWsdlDownload.add(pTipoAccordoDownload);
            listParametersApiWsdlDownload.add(pApiGestioneParziale);
            image = new DataElementImage();
            image.setUrl("downloadDocumento", listParametersApiWsdlDownload.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Download {0}", "XSD Schema Collection"));
            image.setImage("&#xE149;");
            image.setTarget(TargetType.SELF);
            image.setDisabilitaAjaxStatus();
            de.addImage(image);
        }
        dati.add(de);
        if (as.getDescrizione() != null && StringUtils.isNotEmpty((String)as.getDescrizione())) {
            de = new DataElement();
            de.setType(DataElementType.TEXT);
            de.setLabel("Descrizione");
            int length = 150;
            Object descrizione = null;
            descrizione = as.getDescrizione() != null && as.getDescrizione().length() > length ? as.getDescrizione().substring(0, length - 4) + " ..." : as.getDescrizione();
            de.setValue(descrizione != null ? StringEscapeUtils.escapeHtml((String)descrizione) : null);
            de.setToolTip(as.getDescrizione());
            de.setCopyToClipboard(as.getDescrizione());
            ((Parameter)listParametersApi.get(0)).setValue("apiDescrizione");
            de.setIcon("&#xE3C9;");
            image = new DataElementImage();
            ((Parameter)listParametersApi.get(0)).setValue("apiDescrizione");
            image.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Modifica {0}", "Descrizione"));
            image.setImage("&#xE3C9;");
            de.setImage(image);
            dati.add(de);
        }
        de = new DataElement();
        de.setType(DataElementType.BUTTON);
        de.setLabel("Tags");
        ArrayList<String> labelsGruppi = new ArrayList<String>();
        ArrayList<CallSite> valuesGruppi = new ArrayList<CallSite>();
        GruppiAccordo gruppi = as.getGruppi();
        if (gruppi != null) {
            List<String> tagsDisponibili = this.gruppiCore.getAllGruppiOrdinatiPerDataRegistrazione();
            for (int i = 0; i < gruppi.sizeGruppoList(); ++i) {
                GruppoAccordo gruppo = gruppi.getGruppo(i);
                int indexOf = tagsDisponibili.indexOf(gruppo.getNome());
                if (indexOf == -1) {
                    indexOf = 0;
                }
                labelsGruppi.add(gruppo.getNome());
                valuesGruppi.add((CallSite)((Object)("label-info-" + (indexOf %= CostantiControlStation.NUMERO_GRUPPI_CSS.intValue()))));
            }
        }
        de.setLabels(labelsGruppi);
        de.setValues(valuesGruppi);
        ((Parameter)listParametersApi.get(0)).setValue("apiGruppi");
        de.setIcon("&#xE3C9;");
        image = new DataElementImage();
        ((Parameter)listParametersApi.get(0)).setValue("apiGruppi");
        image.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
        image.setToolTip(MessageFormat.format("Modifica {0}", "Tags"));
        image.setImage("&#xE3C9;");
        de.setImage(image);
        dati.add(de);
        CanaliConfigurazione gestioneCanali = this.confCore.getCanaliConfigurazione(false);
        boolean bl = gestioneCanaliEnabled = gestioneCanali != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
        if (gestioneCanaliEnabled) {
            List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
            de = new DataElement();
            de.setType(DataElementType.TEXT);
            de.setLabel("Canale");
            this.setStatoCanale(de, as.getCanale(), canaleList);
            ((Parameter)listParametersApi.get(0)).setValue("apiCanale");
            de.setIcon("&#xE3C9;");
            image = new DataElementImage();
            ((Parameter)listParametersApi.get(0)).setValue("apiCanale");
            image.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Modifica {0}", "Canale"));
            image.setImage("&#xE3C9;");
            de.setImage(image);
            dati.add(de);
        }
        this.addProprietaOggetto(dati, as.getProprietaOggetto());
        switch (serviceBinding) {
            case REST: {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                ((Parameter)listParametersApi.get(0)).setValue("");
                de.setUrl("accordiServizioParteComuneResourcesList.do", listParametersApi.toArray(new Parameter[1]));
                de.setValue("Risorse");
                de.setIcon("&#xE896;");
                dati.add(de);
                break;
            }
            default: {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                ((Parameter)listParametersApi.get(0)).setValue("");
                de.setUrl("accordiServizioParteComunePortTypesList.do", listParametersApi.toArray(new Parameter[1]));
                de.setValue("Servizi");
                de.setIcon("&#xE896;");
                dati.add(de);
            }
        }
        de = new DataElement();
        de.setType(DataElementType.LINK);
        ((Parameter)listParametersApi.get(0)).setValue("");
        de.setUrl("accordiServizioParteComuneAllegatiList.do", listParametersApi.toArray(new Parameter[1]));
        de.setValue("Allegati");
        de.setIcon("&#xE2BC;");
        dati.add(de);
        if (this.isModalitaAvanzata()) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            ((Parameter)listParametersApi.get(0)).setValue("apiOpzioniAvanzate");
            de.setUrl("accordiServizioParteComuneChange.do", listParametersApi.toArray(new Parameter[1]));
            de.setValue("Opzioni Avanzate");
            de.setIcon("&#xE8B8;");
            dati.add(de);
        }
        de = new DataElement();
        de.setType(DataElementType.LINK);
        ArrayList<Parameter> listParametersNuovaVersione = new ArrayList<Parameter>();
        listParametersNuovaVersione.add(new Parameter("apiNewVersion", "true"));
        listParametersNuovaVersione.add(pIdAccordo);
        listParametersNuovaVersione.add(pTipoAccordo);
        de.setUrl("accordiServizioParteComuneApiAdd.do", listParametersNuovaVersione.toArray(new Parameter[1]));
        de.setValue("Nuova Versione");
        de.setIcon("&#xE02E;");
        de.spostaLinkADestra();
        dati.add(de);
        return datiPagina;
    }
}

