/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.utils.AllarmiUtils;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneUtilities;
import org.slf4j.Logger;

public class ArchiveEngine
extends AbstractArchiveEngine {
    private ArchiviCore archiviCore;
    private boolean smista;
    private String userLogin;
    private AlarmEngineConfig alarmEngineConfig;
    private ConfigurazioneCore allarmiConfigurazioneCore;
    private boolean archiviUpdated = false;

    public ArchiveEngine(DriverRegistroServiziDB driverRegistroServizi, DriverConfigurazioneDB driverConfigurazione, JDBCServiceManager serviceManagerPlugins, org.openspcoop2.core.controllo_traffico.dao.jdbc.JDBCServiceManager serviceManagerControlloTraffico, org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager serviceManagerAllarmi, ArchiviCore archiviCore, boolean smista, String userLogin) throws Exception {
        super(driverRegistroServizi, driverConfigurazione, serviceManagerPlugins, serviceManagerControlloTraffico, serviceManagerAllarmi);
        this.archiviCore = archiviCore;
        this.smista = smista;
        this.userLogin = userLogin;
        if (this.archiviCore.isConfigurazioneAllarmiEnabled()) {
            this.allarmiConfigurazioneCore = new ConfigurazioneCore(archiviCore);
            this.alarmEngineConfig = this.allarmiConfigurazioneCore.getAllarmiConfig();
        }
    }

    public boolean isVisioneOggettiGlobale(String userLogin) {
        return this.archiviCore.isVisioneOggettiGlobale(userLogin);
    }

    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, gruppo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, gruppo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, gruppo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, ruolo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, ruolo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, ruolo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createScope(Scope scope) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, scope);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateScope(Scope scope) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, scope);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteScope(Scope scope) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, scope);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createSoggettoRegistro(Soggetto soggetto) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateSoggettoRegistro(Soggetto soggetto) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteSoggettoRegistro(Soggetto soggetto) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createSoggettoConfigurazione(org.openspcoop2.core.config.Soggetto soggetto) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, soggetto);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateSoggettoConfigurazione(org.openspcoop2.core.config.Soggetto soggetto) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, soggetto);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteSoggettoConfigurazione(org.openspcoop2.core.config.Soggetto soggetto) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, soggetto);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createServizioApplicativo(ServizioApplicativo servizioApplicativo) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, servizioApplicativo);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateServizioApplicativo(ServizioApplicativo servizioApplicativo) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, servizioApplicativo);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteServizioApplicativo(ServizioApplicativo servizioApplicativo) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, servizioApplicativo);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizioParteComune) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, accordoServizioParteComune);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizioParteComune) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, accordoServizioParteComune);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizioParteComune) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, accordoServizioParteComune);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, accordoServizioParteSpecifica);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, accordoServizioParteSpecifica);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, accordoServizioParteSpecifica);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createMappingErogazione(String nome, String descrizione, boolean isDefault, IDServizio idServizio, IDPortaApplicativa idPortaApplicativa) throws DriverRegistroServiziException {
        try {
            MappingErogazionePortaApplicativa mapping = new MappingErogazionePortaApplicativa();
            mapping.setIdServizio(idServizio);
            mapping.setIdPortaApplicativa(idPortaApplicativa);
            mapping.setNome(nome);
            mapping.setDescrizione(descrizione);
            mapping.setDefault(isDefault);
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, mapping);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa) throws DriverRegistroServiziException {
        try {
            MappingErogazionePortaApplicativa mapping = new MappingErogazionePortaApplicativa();
            mapping.setIdServizio(idServizio);
            mapping.setIdPortaApplicativa(idPortaApplicativa);
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, mapping);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createMappingFruizione(String nome, String descrizione, boolean isDefault, IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata) throws DriverRegistroServiziException {
        try {
            MappingFruizionePortaDelegata mapping = new MappingFruizionePortaDelegata();
            mapping.setIdFruitore(idFruitore);
            mapping.setIdServizio(idServizio);
            mapping.setIdPortaDelegata(idPortaDelegata);
            mapping.setNome(nome);
            mapping.setDescrizione(descrizione);
            mapping.setDefault(isDefault);
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, mapping);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata) throws DriverRegistroServiziException {
        try {
            MappingFruizionePortaDelegata mapping = new MappingFruizionePortaDelegata();
            mapping.setIdFruitore(idFruitore);
            mapping.setIdServizio(idServizio);
            mapping.setIdPortaDelegata(idPortaDelegata);
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, mapping);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
    }

    public void createPortaDelegata(PortaDelegata portaDelegata) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, portaDelegata);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updatePortaDelegata(PortaDelegata portaDelegata) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, portaDelegata);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deletePortaDelegata(PortaDelegata portaDelegata) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, portaDelegata);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createPortaApplicativa(PortaApplicativa portaApplicativa) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, portaApplicativa);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updatePortaApplicativa(PortaApplicativa portaApplicativa) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, portaApplicativa);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deletePortaApplicativa(PortaApplicativa portaApplicativa) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, portaApplicativa);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateControlloTraffico_configurazione(ConfigurazioneGenerale configurazione) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, configurazione);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteControlloTraffico_Configurazione(ConfigurazioneGenerale configurazione) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, configurazione);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createControlloTraffico_configurationPolicy(ConfigurazionePolicy policy) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, policy);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateControlloTraffico_configurationPolicy(ConfigurazionePolicy policy) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, policy);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteControlloTraffico_configurationPolicy(ConfigurazionePolicy policy) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, policy);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createControlloTraffico_activePolicy(AttivazionePolicy policy, Logger log) throws DriverConfigurazioneException {
        this.updatePosizioneBeforeCreate(policy, log);
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, policy);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateControlloTraffico_activePolicy(AttivazionePolicy policy) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, policy);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteControlloTraffico_activePolicy(AttivazionePolicy policy) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, policy);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createAllarme(Allarme allarme, Logger log) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, allarme);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
        try {
            ConfigurazioneAllarmeBean allarmeWrap = this.allarmiConfigurazioneCore.getAllarme(allarme);
            AllarmiUtils.notifyStateActiveThread((boolean)true, (boolean)false, (boolean)false, null, (ConfigurazioneAllarmeBean)allarmeWrap, (Logger)log, (AlarmEngineConfig)this.alarmEngineConfig);
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Allarme {0} salvato correttamente nel registro, ma la notifica verso il gestore degli allarmi \u00e8 fallita: {1}", allarme.getAlias(), e.getMessage());
            log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
    }

    public void updateAllarme(Allarme allarme, Logger log) throws DriverConfigurazioneException {
        ConfigurazioneAllarmeBean allarmeWrap = null;
        ConfigurazioneAllarmeBean oldAllarmeWrap = null;
        try {
            allarmeWrap = this.allarmiConfigurazioneCore.getAllarme(allarme);
            oldAllarmeWrap = this.allarmiConfigurazioneCore.getAllarme(allarme.getId());
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, allarme);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
        boolean modificatoInformazioniHistory = false;
        if (allarme.getEnabled().intValue() != oldAllarmeWrap.getEnabled().intValue()) {
            modificatoInformazioniHistory = true;
        }
        if (modificatoInformazioniHistory && this.alarmEngineConfig.isHistoryEnabled()) {
            AllarmeHistory history = ConfigurazioneUtilities.createAllarmeHistory(allarme, this.userLogin);
            try {
                this.allarmiConfigurazioneCore.performCreateOperation(this.userLogin, this.smista, history);
            }
            catch (Throwable e) {
                String json = "";
                try {
                    json = history.toJson();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                log.error("Registrazione stato allarme nell'hitstory non riuscita [" + json + "]: " + e.getMessage(), e);
            }
        }
        try {
            AllarmiUtils.notifyStateActiveThread((boolean)false, (boolean)false, (boolean)false, null, (ConfigurazioneAllarmeBean)allarmeWrap, (Logger)log, (AlarmEngineConfig)this.alarmEngineConfig);
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Allarme {0} salvato correttamente nel registro, ma la notifica verso il gestore degli allarmi \u00e8 fallita: {1}", allarme.getAlias(), e.getMessage());
            log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
    }

    public void deleteAllarme(Allarme allarme, Logger log) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, allarme);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
        try {
            ArrayList<String> allarmeList = new ArrayList<String>();
            allarmeList.add(allarme.getNome());
            AllarmiUtils.stopActiveThreads(allarmeList, (Logger)log, (AlarmEngineConfig)this.alarmEngineConfig);
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Allarme {0} eliminato correttamente, ma la notifica verso il gestore degli allarmi \u00e8 fallita: {1}", allarme.getAlias(), e.getMessage());
            log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg);
        }
    }

    public void createGenericProperties(GenericProperties gp) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, gp);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateGenericProperties(GenericProperties gp) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, gp);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteGenericProperties(GenericProperties gp) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, gp);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createPluginClasse(Plugin plugin) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, plugin);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updatePluginClasse(Plugin plugin) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, plugin);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deletePluginClasse(Plugin plugin) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, plugin);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createPluginArchivio(RegistroPlugin rp) throws DriverConfigurazioneException {
        this.updatePosizioneBeforeCreate(rp);
        this.updateDate(rp);
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, rp);
            this.archiviUpdated = true;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updatePluginArchivio(RegistroPlugin rp) throws DriverConfigurazioneException {
        this.updateDate(rp);
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, rp);
            ConfigurazioneCore confCore = new ConfigurazioneCore(this.archiviCore);
            if (rp.sizeArchivioList() > 0) {
                for (RegistroPluginArchivio rpa : rp.getArchivioList()) {
                    rpa.setNomePlugin(rp.getNome());
                    if (confCore.existsRegistroPluginArchivio(rpa.getNomePlugin(), rpa.getNome())) {
                        this.archiviCore.performUpdateOperation(this.userLogin, this.smista, rpa);
                        continue;
                    }
                    this.archiviCore.performCreateOperation(this.userLogin, this.smista, rpa);
                }
            }
            this.archiviUpdated = true;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deletePluginArchivio(RegistroPlugin rp) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, rp);
            this.archiviUpdated = true;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void createUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        this.updatePosizioneBeforeCreate(regola);
        try {
            this.archiviCore.performCreateOperation(this.userLogin, this.smista, regola);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, regola);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteUrlInvocazioneRegola(ConfigurazioneUrlInvocazioneRegola regola) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, regola);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateConfigurazione_UrlInvocazione(ConfigurazioneUrlInvocazione configurazione) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, configurazione);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performUpdateOperation(this.userLogin, this.smista, configurazione);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        try {
            this.archiviCore.performDeleteOperation(this.userLogin, this.smista, configurazione);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void finalizeImport(Archive archive) throws DriverConfigurazioneException {
        if (this.archiviUpdated) {
            try {
                this.archiviCore.updatePluginClassLoader();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void finalizeDelete(Archive archive) throws DriverConfigurazioneException {
        if (this.archiviUpdated) {
            try {
                this.archiviCore.updatePluginClassLoader();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

