/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveActivePolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveAllarme;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;

public class ExporterUtils {
    private ArchiviCore archiviCore;
    private SoggettiCore soggettiCore;
    private AccordiServizioParteComuneCore aspcCore;
    private AccordiServizioParteSpecificaCore aspsCore;
    private AccordiCooperazioneCore acCore;
    private ServiziApplicativiCore saCore;
    private RuoliCore ruoliCore;
    private ScopeCore scopeCore;
    private ConfigurazioneCore confCore;
    private static final String FORMATO_DIVERSO_ATTESO = "Formato diverso da quello atteso";

    public ExporterUtils(ArchiviCore archiviCore) throws Exception {
        this.archiviCore = archiviCore;
        this.soggettiCore = new SoggettiCore(archiviCore);
        this.aspcCore = new AccordiServizioParteComuneCore(archiviCore);
        this.aspsCore = new AccordiServizioParteSpecificaCore(archiviCore);
        this.acCore = new AccordiCooperazioneCore(archiviCore);
        this.saCore = new ServiziApplicativiCore(archiviCore);
        this.ruoliCore = new RuoliCore(archiviCore);
        this.scopeCore = new ScopeCore(archiviCore);
        this.confCore = new ConfigurazioneCore(archiviCore);
    }

    public List<ExportMode> getExportModesCompatibleWithAllProtocol(List<String> protocolli, ArchiveType archiveType) throws ProtocolException {
        ArrayList<ExportMode> exportModes = new ArrayList<ExportMode>();
        for (int i = 0; i < protocolli.size(); ++i) {
            String protocolName = protocolli.get(i);
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolName);
            IArchive archiveEngine = pf.createArchive();
            List exportModesByProtocol = archiveEngine.getExportModes(archiveType);
            for (ExportMode exportMode : exportModesByProtocol) {
                boolean found = true;
                for (int j = 0; j < protocolli.size(); ++j) {
                    if (j == i) continue;
                    String protocolCheck = protocolli.get(j);
                    IProtocolFactory pfCheck = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolCheck);
                    IArchive archiveEngineCheck = pfCheck.createArchive();
                    List exportModesByProtocolCheck = archiveEngineCheck.getExportModes(archiveType);
                    if (exportModesByProtocolCheck.contains(exportMode)) continue;
                    found = false;
                    break;
                }
                if (!found || exportModes.contains(exportMode)) continue;
                exportModes.add(exportMode);
            }
        }
        return exportModes;
    }

    public Map<ExportMode, String> getExportModesWithProtocol(List<String> protocolli, ArchiveType archiveType) throws ProtocolException {
        HashMap<ExportMode, String> exportModes = new HashMap<ExportMode, String>();
        for (int i = 0; i < protocolli.size(); ++i) {
            String protocolName = protocolli.get(i);
            if ("-".equals(protocolName)) continue;
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolName);
            IArchive archiveEngine = pf.createArchive();
            List exportModesByProtocol = archiveEngine.getExportModes(archiveType);
            for (ExportMode exp : exportModesByProtocol) {
                if (exportModes.containsKey(exp)) continue;
                exportModes.put(exp, protocolName);
            }
        }
        return exportModes;
    }

    public boolean existsAtLeastOneExportMode(ArchiveType archiveType, HttpServletRequest request, HttpSession session) throws ProtocolException, DriverRegistroServiziException {
        List<String> protocolli = this.archiviCore.getProtocolli(request, session);
        return this.getExportModesWithProtocol(protocolli, archiveType).size() > 0;
    }

    public List<IDSoggetto> getIdsSoggetti(String ids) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        ArrayList<IDSoggetto> idsSoggetti = new ArrayList<IDSoggetto>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idLong = Long.parseLong(id);
            idsSoggetti.add(this.soggettiCore.getIdSoggettoRegistro(idLong));
        }
        return idsSoggetti;
    }

    public List<IDServizioApplicativo> getIdsServiziApplicativi(String ids) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        ArrayList<IDServizioApplicativo> idsSA = new ArrayList<IDServizioApplicativo>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idLong = Long.parseLong(id);
            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idLong);
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
            idSA.setNome(sa.getNome());
            idsSA.add(idSA);
        }
        return idsSA;
    }

    public List<IDAccordo> getIdsAccordiServizioComposti(String ids) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        return this.getIdsAccordiServizioParteComune(ids);
    }

    public List<IDAccordo> getIdsAccordiServizioParteComune(String ids) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        ArrayList<IDAccordo> idsAccordi = new ArrayList<IDAccordo>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idLong = Long.parseLong(id);
            idsAccordi.add(this.aspcCore.getIdAccordoServizio(idLong));
        }
        return idsAccordi;
    }

    public List<IDResource> getIdsAccordiServizioParteComuneRisorsa(String ids) throws DriverRegistroServiziException {
        ArrayList<IDResource> idsAccordi = new ArrayList<IDResource>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            if (!id.contains("@")) {
                throw new DriverRegistroServiziException(FORMATO_DIVERSO_ATTESO);
            }
            String[] tmp = id.split("@");
            if (tmp == null || tmp.length != 2) {
                throw new DriverRegistroServiziException(FORMATO_DIVERSO_ATTESO);
            }
            IDResource idR = new IDResource();
            idR.setNome(tmp[0]);
            idR.setIdAccordo(IDAccordoFactory.getInstance().getIDAccordoFromUri(tmp[1]));
            idsAccordi.add(idR);
        }
        return idsAccordi;
    }

    public List<IDPortType> getIdsAccordiServizioParteComunePortType(String ids) throws DriverRegistroServiziException {
        ArrayList<IDPortType> idsAccordi = new ArrayList<IDPortType>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            if (!id.contains("@")) {
                throw new DriverRegistroServiziException(FORMATO_DIVERSO_ATTESO);
            }
            String[] tmp = id.split("@");
            if (tmp == null || tmp.length != 2) {
                throw new DriverRegistroServiziException(FORMATO_DIVERSO_ATTESO);
            }
            IDPortType idPT = new IDPortType();
            idPT.setNome(tmp[0]);
            idPT.setIdAccordo(IDAccordoFactory.getInstance().getIDAccordoFromUri(tmp[1]));
            idsAccordi.add(idPT);
        }
        return idsAccordi;
    }

    public List<IDPortTypeAzione> getIdsAccordiServizioParteComuneOperazione(String ids) throws DriverRegistroServiziException {
        ArrayList<IDPortTypeAzione> idsAccordi = new ArrayList<IDPortTypeAzione>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            if (!id.contains("@")) {
                throw new DriverRegistroServiziException(FORMATO_DIVERSO_ATTESO);
            }
            String[] tmp = id.split("@");
            if (tmp == null || tmp.length != 3) {
                throw new DriverRegistroServiziException(FORMATO_DIVERSO_ATTESO);
            }
            IDPortTypeAzione idOperazione = new IDPortTypeAzione();
            idOperazione.setNome(tmp[0]);
            IDPortType idPT = new IDPortType();
            idPT.setNome(tmp[1]);
            idPT.setIdAccordo(IDAccordoFactory.getInstance().getIDAccordoFromUri(tmp[2]));
            idOperazione.setIdPortType(idPT);
            idsAccordi.add(idOperazione);
        }
        return idsAccordi;
    }

    public List<?> getIdsAccordiServizioParteSpecifica(String ids, boolean isFruizione) throws DriverRegistroServiziException {
        ArrayList<IDServizio> idsAccordi = new ArrayList<IDServizio>();
        ArrayList<IDFruizione> fruizioni = new ArrayList<IDFruizione>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            try {
                if (isFruizione) {
                    if (!id.contains("@")) {
                        throw new DriverRegistroServiziException("atteso @");
                    }
                    String idServ = id.split("@")[0];
                    IDServizio idS = IDServizioFactory.getInstance().getIDServizioFromUri(idServ);
                    String idFruitore = id.split("@")[1];
                    IDSoggetto fruitore = new IDSoggetto(idFruitore.split("/")[0], idFruitore.split("/")[1]);
                    IDFruizione idFruizione = new IDFruizione();
                    idFruizione.setIdFruitore(fruitore);
                    idFruizione.setIdServizio(idS);
                    fruizioni.add(idFruizione);
                    continue;
                }
                if (id.contains("@")) {
                    id = id.split("@")[0];
                }
                IDServizio idS = IDServizioFactory.getInstance().getIDServizioFromUri(id);
                idsAccordi.add(idS);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Formato id '" + id + "' non valido: " + e.getMessage(), (Throwable)e);
            }
        }
        if (isFruizione) {
            return fruizioni;
        }
        return idsAccordi;
    }

    public List<IDAccordoCooperazione> getIdsAccordiCooperazione(String ids) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        ArrayList<IDAccordoCooperazione> idsAccordi = new ArrayList<IDAccordoCooperazione>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idLong = Long.parseLong(id);
            idsAccordi.add(this.acCore.getIdAccordoCooperazione(idLong));
        }
        return idsAccordi;
    }

    public List<IDGruppo> getIdsGruppi(String ids) {
        ArrayList<IDGruppo> idsGruppi = new ArrayList<IDGruppo>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            IDGruppo idGruppo = new IDGruppo(id);
            idsGruppi.add(idGruppo);
        }
        return idsGruppi;
    }

    public List<IDRuolo> getIdsRuoli(String ids) {
        ArrayList<IDRuolo> idsRuoli = new ArrayList<IDRuolo>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            IDRuolo idRuolo = new IDRuolo(id);
            idsRuoli.add(idRuolo);
        }
        return idsRuoli;
    }

    public List<IDScope> getIdsScope(String ids) {
        ArrayList<IDScope> idsScope = new ArrayList<IDScope>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            IDScope idScope = new IDScope(id);
            idsScope.add(idScope);
        }
        return idsScope;
    }

    public List<CanaleConfigurazione> getIdsCanali(String ids) {
        ArrayList<CanaleConfigurazione> idsCanali = new ArrayList<CanaleConfigurazione>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            CanaleConfigurazione canale = new CanaleConfigurazione();
            canale.setNome(id);
            idsCanali.add(canale);
        }
        return idsCanali;
    }

    public List<IDGenericProperties> getIdsAttributeAuthority(String ids) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getIdsTokenPolicy(ids);
    }

    public List<IDGenericProperties> getIdsTokenPolicy(String ids) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<IDGenericProperties> idsTokenPolicy = new ArrayList<IDGenericProperties>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idGenericProperties = Long.parseLong(id);
            GenericProperties policy = this.confCore.getGenericProperties(idGenericProperties);
            IDGenericProperties idGP = new IDGenericProperties();
            idGP.setNome(policy.getNome());
            idGP.setTipologia(policy.getTipologia());
            idsTokenPolicy.add(idGP);
        }
        return idsTokenPolicy;
    }

    public List<IdPolicy> getIdsControlloTrafficoConfigPolicy(String ids) throws DriverControlStationNotFound, DriverControlStationException {
        ArrayList<IdPolicy> idsRateLimitingPolicy = new ArrayList<IdPolicy>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idPolicy = Long.parseLong(id);
            ConfigurazionePolicy policy = this.confCore.getConfigurazionePolicy(idPolicy);
            IdPolicy idGP = new IdPolicy();
            idGP.setNome(policy.getIdPolicy());
            idsRateLimitingPolicy.add(idGP);
        }
        return idsRateLimitingPolicy;
    }

    public List<IdActivePolicy> getIdsControlloTrafficoActivePolicy(String ids) throws DriverControlStationNotFound, DriverControlStationException {
        ArrayList<IdActivePolicy> idsRateLimitingPolicy = new ArrayList<IdActivePolicy>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idPolicy = Long.parseLong(id);
            AttivazionePolicy attivazionePolicy = this.confCore.getAttivazionePolicy(idPolicy);
            IdActivePolicy idAttivazionePolicy = new IdActivePolicy();
            idAttivazionePolicy.setNome(attivazionePolicy.getIdActivePolicy());
            idAttivazionePolicy.setIdPolicy(attivazionePolicy.getIdPolicy());
            idAttivazionePolicy.setAlias(attivazionePolicy.getAlias());
            idAttivazionePolicy.setEnabled(attivazionePolicy.isEnabled());
            idAttivazionePolicy.setUpdateTime(attivazionePolicy.getUpdateTime());
            idAttivazionePolicy.setPosizione(attivazionePolicy.getPosizione());
            idAttivazionePolicy.setContinuaValutazione(attivazionePolicy.isContinuaValutazione());
            if (attivazionePolicy.getFiltro() != null) {
                idAttivazionePolicy.setFiltroRuoloPorta(attivazionePolicy.getFiltro().getRuoloPorta());
                idAttivazionePolicy.setFiltroNomePorta(attivazionePolicy.getFiltro().getNomePorta());
            }
            idsRateLimitingPolicy.add(idAttivazionePolicy);
        }
        return idsRateLimitingPolicy;
    }

    public List<IdAllarme> getIdsAllarmi(String ids) throws DriverControlStationException {
        ArrayList<IdAllarme> idsAllarmi = new ArrayList<IdAllarme>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idAllarmeLong = Long.parseLong(id);
            Allarme allarme = this.confCore.getAllarmeSenzaPlugin(idAllarmeLong);
            IdAllarme idAllarme = new IdAllarme();
            idAllarme.setNome(allarme.getNome());
            idAllarme.setTipo(allarme.getTipo());
            idAllarme.setEnabled(allarme.getEnabled());
            idAllarme.setAlias(allarme.getAlias());
            if (allarme.getFiltro() != null) {
                idAllarme.setFiltroRuoloPorta(allarme.getFiltro().getRuoloPorta());
                idAllarme.setFiltroNomePorta(allarme.getFiltro().getNomePorta());
            }
            idsAllarmi.add(idAllarme);
        }
        return idsAllarmi;
    }

    public List<IdPlugin> getIdsPluginClassi(String ids) throws DriverConfigurazioneException {
        ArrayList<IdPlugin> idsPlugins = new ArrayList<IdPlugin>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            long idPluginLong = Long.parseLong(id);
            Plugin plugin = this.confCore.getPlugin(idPluginLong);
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setClassName(plugin.getClassName());
            idPlugin.setLabel(plugin.getLabel());
            idPlugin.setTipo(plugin.getTipo());
            idPlugin.setTipoPlugin(plugin.getTipoPlugin());
            idsPlugins.add(idPlugin);
        }
        return idsPlugins;
    }

    public List<String> getIdsPluginArchivi(String ids) {
        ArrayList<String> idsPlugins = new ArrayList<String>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        for (String id : idsToExport) {
            idsPlugins.add(id);
        }
        return idsPlugins;
    }

    public List<String> getIdsUrlInvocazioneRegole(String ids) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ConfigurazioneUrlInvocazione urlInvocazione = this.confCore.getConfigurazioneGenerale().getUrlInvocazione();
        ArrayList<String> idsRegole = new ArrayList<String>();
        ArrayList<String> idsToExport = Utilities.parseIdsToRemove(ids);
        block0: for (String id : idsToExport) {
            long idRegolaLong = Long.parseLong(id);
            for (int j = 0; j < urlInvocazione.sizeRegolaList(); ++j) {
                ConfigurazioneUrlInvocazioneRegola regola = urlInvocazione.getRegola(j);
                if (regola.getId() != idRegolaLong) continue;
                idsRegole.add(regola.getNome());
                continue block0;
            }
        }
        return idsRegole;
    }

    public void filterByProtocol(List<String> tipiSoggetti, List<String> tipiServizi, Archive archive) throws ProtocolException {
        boolean filtra;
        int i;
        ArrayList<Object> listFiltrata;
        if (archive.getSoggetti() != null && archive.getSoggetti().size() > 0) {
            listFiltrata = new ArrayList<Object>();
            for (i = 0; i < archive.getSoggetti().size(); ++i) {
                if (((ArchiveSoggetto)archive.getSoggetti().get(i)).getIdSoggetto() == null || !tipiSoggetti.contains(((ArchiveSoggetto)archive.getSoggetti().get(i)).getIdSoggetto().getTipo())) continue;
                listFiltrata.add((ArchiveSoggetto)archive.getSoggetti().get(i));
            }
            while (archive.getSoggetti().size() > 0) {
                archive.getSoggetti().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveSoggetto archiveSoggetto : listFiltrata) {
                    archive.getSoggetti().add((Object)archiveSoggetto);
                }
            }
        }
        if (archive.getServiziApplicativi() != null && archive.getServiziApplicativi().size() > 0) {
            listFiltrata = new ArrayList();
            for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
                if (((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getIdSoggettoProprietario() == null || !tipiSoggetti.contains(((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getIdSoggettoProprietario().getTipo())) continue;
                listFiltrata.add((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i));
            }
            while (archive.getServiziApplicativi().size() > 0) {
                archive.getServiziApplicativi().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveServizioApplicativo archiveServizioApplicativo : listFiltrata) {
                    archive.getServiziApplicativi().add((Object)archiveServizioApplicativo);
                }
            }
        }
        if (archive.getPorteDelegate() != null && archive.getPorteDelegate().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i2 = 0; i2 < archive.getPorteDelegate().size(); ++i2) {
                if (((ArchivePortaDelegata)archive.getPorteDelegate().get(i2)).getIdSoggettoProprietario() == null || !tipiSoggetti.contains(((ArchivePortaDelegata)archive.getPorteDelegate().get(i2)).getIdSoggettoProprietario().getTipo())) continue;
                listFiltrata.add((ArchivePortaDelegata)archive.getPorteDelegate().get(i2));
            }
            while (archive.getPorteDelegate().size() > 0) {
                archive.getPorteDelegate().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchivePortaDelegata archivePortaDelegata : listFiltrata) {
                    archive.getPorteDelegate().add((Object)archivePortaDelegata);
                }
            }
        }
        if (archive.getPorteApplicative() != null && archive.getPorteApplicative().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i3 = 0; i3 < archive.getPorteApplicative().size(); ++i3) {
                if (((ArchivePortaApplicativa)archive.getPorteApplicative().get(i3)).getIdSoggettoProprietario() == null || !tipiSoggetti.contains(((ArchivePortaApplicativa)archive.getPorteApplicative().get(i3)).getIdSoggettoProprietario().getTipo())) continue;
                listFiltrata.add((ArchivePortaApplicativa)archive.getPorteApplicative().get(i3));
            }
            while (archive.getPorteApplicative().size() > 0) {
                archive.getPorteApplicative().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchivePortaApplicativa archivePortaApplicativa : listFiltrata) {
                    archive.getPorteApplicative().add((Object)archivePortaApplicativa);
                }
            }
        }
        if (archive.getAccordiCooperazione() != null && archive.getAccordiCooperazione().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i4 = 0; i4 < archive.getAccordiCooperazione().size(); ++i4) {
                if (((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i4)).getIdSoggettoReferente() == null || !tipiSoggetti.contains(((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i4)).getIdSoggettoReferente().getTipo())) continue;
                listFiltrata.add((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i4));
            }
            while (archive.getAccordiCooperazione().size() > 0) {
                archive.getAccordiCooperazione().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAccordoCooperazione archiveAccordoCooperazione : listFiltrata) {
                    archive.getAccordiCooperazione().add((Object)archiveAccordoCooperazione);
                }
            }
        }
        if (archive.getAccordiServizioParteComune() != null && archive.getAccordiServizioParteComune().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i5 = 0; i5 < archive.getAccordiServizioParteComune().size(); ++i5) {
                if (((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i5)).getIdSoggettoReferente() == null || !tipiSoggetti.contains(((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i5)).getIdSoggettoReferente().getTipo())) continue;
                listFiltrata.add((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i5));
            }
            while (archive.getAccordiServizioParteComune().size() > 0) {
                archive.getAccordiServizioParteComune().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune : listFiltrata) {
                    archive.getAccordiServizioParteComune().add((Object)archiveAccordoServizioParteComune);
                }
            }
        }
        if (archive.getAccordiServizioComposto() != null && archive.getAccordiServizioComposto().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i6 = 0; i6 < archive.getAccordiServizioComposto().size(); ++i6) {
                if (((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i6)).getIdSoggettoReferente() == null || !tipiSoggetti.contains(((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i6)).getIdSoggettoReferente().getTipo())) continue;
                listFiltrata.add((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i6));
            }
            while (archive.getAccordiServizioComposto().size() > 0) {
                archive.getAccordiServizioComposto().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAccordoServizioComposto archiveAccordoServizioComposto : listFiltrata) {
                    archive.getAccordiServizioComposto().add((Object)archiveAccordoServizioComposto);
                }
            }
        }
        if (archive.getAccordiServizioParteSpecifica() != null && archive.getAccordiServizioParteSpecifica().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i7 = 0; i7 < archive.getAccordiServizioParteSpecifica().size(); ++i7) {
                if (((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i7)).getIdSoggettoErogatore() == null || !tipiSoggetti.contains(((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i7)).getIdSoggettoErogatore().getTipo())) continue;
                listFiltrata.add((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i7));
            }
            while (archive.getAccordiServizioParteSpecifica().size() > 0) {
                archive.getAccordiServizioParteSpecifica().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica : listFiltrata) {
                    archive.getAccordiServizioParteSpecifica().add((Object)archiveAccordoServizioParteSpecifica);
                }
            }
        }
        if (archive.getAccordiFruitori() != null && archive.getAccordiFruitori().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i8 = 0; i8 < archive.getAccordiFruitori().size(); ++i8) {
                if (((ArchiveFruitore)archive.getAccordiFruitori().get(i8)).getIdSoggettoFruitore() == null || !tipiSoggetti.contains(((ArchiveFruitore)archive.getAccordiFruitori().get(i8)).getIdSoggettoFruitore().getTipo())) continue;
                listFiltrata.add((ArchiveFruitore)archive.getAccordiFruitori().get(i8));
            }
            while (archive.getAccordiFruitori().size() > 0) {
                archive.getAccordiFruitori().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveFruitore archiveFruitore : listFiltrata) {
                    archive.getAccordiFruitori().add((Object)archiveFruitore);
                }
            }
        }
        if (archive.getControlloTraffico_activePolicies() != null && archive.getControlloTraffico_activePolicies().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i9 = 0; i9 < archive.getControlloTraffico_activePolicies().size(); ++i9) {
                ArchiveActivePolicy archiveActivePolicy = (ArchiveActivePolicy)archive.getControlloTraffico_activePolicies().get(i9);
                filtra = false;
                if (archiveActivePolicy.getPolicy().getFiltro() != null) {
                    if (archiveActivePolicy.getPolicy().getFiltro().getTipoErogatore() != null && !tipiSoggetti.contains(archiveActivePolicy.getPolicy().getFiltro().getTipoErogatore())) {
                        filtra = true;
                    }
                    if (archiveActivePolicy.getPolicy().getFiltro().getTipoFruitore() != null && !tipiSoggetti.contains(archiveActivePolicy.getPolicy().getFiltro().getTipoFruitore())) {
                        filtra = true;
                    }
                    if (archiveActivePolicy.getPolicy().getFiltro().getTipoServizio() != null && !tipiServizi.contains(archiveActivePolicy.getPolicy().getFiltro().getTipoServizio())) {
                        filtra = true;
                    }
                }
                if (filtra) continue;
                listFiltrata.add(archiveActivePolicy);
            }
            while (archive.getControlloTraffico_activePolicies().size() > 0) {
                archive.getControlloTraffico_activePolicies().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveActivePolicy archiveActivePolicy : listFiltrata) {
                    archive.getControlloTraffico_activePolicies().add((Object)archiveActivePolicy);
                }
            }
        }
        if (archive.getAllarmi() != null && archive.getAllarmi().size() > 0) {
            listFiltrata = new ArrayList();
            for (int i10 = 0; i10 < archive.getAllarmi().size(); ++i10) {
                ArchiveAllarme archiveAllarme = (ArchiveAllarme)archive.getAllarmi().get(i10);
                filtra = false;
                if (archiveAllarme.getAllarme().getFiltro() != null) {
                    if (archiveAllarme.getAllarme().getFiltro().getTipoErogatore() != null && !tipiSoggetti.contains(archiveAllarme.getAllarme().getFiltro().getTipoErogatore())) {
                        filtra = true;
                    }
                    if (archiveAllarme.getAllarme().getFiltro().getTipoFruitore() != null && !tipiSoggetti.contains(archiveAllarme.getAllarme().getFiltro().getTipoFruitore())) {
                        filtra = true;
                    }
                    if (archiveAllarme.getAllarme().getFiltro().getTipoServizio() != null && !tipiServizi.contains(archiveAllarme.getAllarme().getFiltro().getTipoServizio())) {
                        filtra = true;
                    }
                }
                if (filtra) continue;
                listFiltrata.add(archiveAllarme);
            }
            while (archive.getAllarmi().size() > 0) {
                archive.getAllarmi().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAllarme archiveAllarme : listFiltrata) {
                    archive.getAllarmi().add((Object)archiveAllarme);
                }
            }
        }
    }

    public void filterBySoggettoSelezionato(IDSoggetto idSoggettoSelezionato, Archive archive) throws ProtocolException {
        IDServizio idServizio;
        IDSoggetto idSoggettoFruitore;
        IDServizio idServizio2;
        int i;
        ArrayList<IDSoggetto> idSoggettiCoinvolti = new ArrayList<IDSoggetto>();
        idSoggettiCoinvolti.add(idSoggettoSelezionato);
        ArrayList<IDServizio> idServiziCoinvolti = new ArrayList<IDServizio>();
        ArrayList<IDServizioApplicativo> idServiziApplicativiCoinvolti = new ArrayList<IDServizioApplicativo>();
        ArrayList<IDAccordo> idAccordiCoinvolti = new ArrayList<IDAccordo>();
        ArrayList<IDAccordoCooperazione> idAccordiCooperazioneCoinvolti = new ArrayList<IDAccordoCooperazione>();
        if (archive.getServiziApplicativi() != null && archive.getServiziApplicativi().size() > 0) {
            for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
                IDServizioApplicativo idSA;
                if (((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getIdSoggettoProprietario() == null || !idSoggettoSelezionato.equals((Object)((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getIdSoggettoProprietario()) || idServiziApplicativiCoinvolti.contains(idSA = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getIdServizioApplicativo())) continue;
                idServiziApplicativiCoinvolti.add(idSA);
            }
        }
        if (archive.getPorteDelegate() != null && archive.getPorteDelegate().size() > 0) {
            for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
                if (((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).getIdSoggettoProprietario() == null || !idSoggettoSelezionato.equals((Object)((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).getIdSoggettoProprietario())) continue;
                idServizio2 = ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).getIdPortaDelegata().getIdentificativiFruizione().getIdServizio();
                IDSoggetto idSoggettoErogatore = idServizio2.getSoggettoErogatore();
                if (!idSoggettiCoinvolti.contains(idSoggettoErogatore)) {
                    idSoggettiCoinvolti.add(idSoggettoErogatore);
                }
                if (idServiziCoinvolti.contains(idServizio2)) continue;
                idServiziCoinvolti.add(idServizio2);
            }
        }
        if (archive.getPorteApplicative() != null && archive.getPorteApplicative().size() > 0) {
            for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
                int j;
                if (((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).getIdSoggettoProprietario() == null || !idSoggettoSelezionato.equals((Object)((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).getIdSoggettoProprietario())) continue;
                PortaApplicativa pa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).getPortaApplicativa();
                if (pa.getSoggetti() != null && pa.getSoggetti().sizeSoggettoList() > 0) {
                    for (j = 0; j < pa.getSoggetti().sizeSoggettoList(); ++j) {
                        PortaApplicativaAutorizzazioneSoggetto authSoggetto = pa.getSoggetti().getSoggetto(j);
                        IDSoggetto idSoggettoAutorizzato = new IDSoggetto(authSoggetto.getTipo(), authSoggetto.getNome());
                        if (idSoggettiCoinvolti.contains(idSoggettoAutorizzato)) continue;
                        idSoggettiCoinvolti.add(idSoggettoAutorizzato);
                    }
                }
                if (pa.getServiziApplicativiAutorizzati() == null || pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() <= 0) continue;
                for (j = 0; j < pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList(); ++j) {
                    PortaApplicativaAutorizzazioneServizioApplicativo authSA = pa.getServiziApplicativiAutorizzati().getServizioApplicativo(j);
                    IDSoggetto idSoggettoProprietarioSAAutorizzato = new IDSoggetto(authSA.getTipoSoggettoProprietario(), authSA.getNomeSoggettoProprietario());
                    if (!idSoggettiCoinvolti.contains(idSoggettoProprietarioSAAutorizzato)) {
                        idSoggettiCoinvolti.add(idSoggettoProprietarioSAAutorizzato);
                    }
                    IDServizioApplicativo idSAAutorizzato = new IDServizioApplicativo();
                    idSAAutorizzato.setIdSoggettoProprietario(idSoggettoProprietarioSAAutorizzato);
                    idSAAutorizzato.setNome(authSA.getNome());
                    if (idServiziApplicativiCoinvolti.contains(idSAAutorizzato)) continue;
                    idServiziApplicativiCoinvolti.add(idSAAutorizzato);
                }
            }
        }
        if (archive.getAccordiCooperazione() != null && archive.getAccordiCooperazione().size() > 0) {
            for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
                IDSoggetto idSoggettoReferente;
                if (((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).getIdSoggettoReferente() == null || !idSoggettoSelezionato.equals((Object)((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).getIdSoggettoReferente())) continue;
                IDAccordoCooperazione idAC = ((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).getIdAccordoCooperazione();
                if (!idAccordiCooperazioneCoinvolti.contains(idAC)) {
                    idAccordiCooperazioneCoinvolti.add(idAC);
                }
                if (idSoggettiCoinvolti.contains(idSoggettoReferente = ((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).getIdSoggettoReferente())) continue;
                idSoggettiCoinvolti.add(idSoggettoReferente);
            }
        }
        if (archive.getAccordiServizioParteComune() != null && archive.getAccordiServizioParteComune().size() > 0) {
            for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
                if (((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getIdSoggettoReferente() == null) continue;
                try {
                    IDSoggetto idSoggettoReferente;
                    String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getIdSoggettoReferente().getTipo());
                    boolean soggettoReferenteSupportato = this.aspcCore.isSupportatoSoggettoReferente(protocollo);
                    if (soggettoReferenteSupportato && !idSoggettoSelezionato.equals((Object)((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getIdSoggettoReferente())) continue;
                    IDAccordo idAccordo = ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getIdAccordoServizioParteComune();
                    if (!idAccordiCoinvolti.contains(idAccordo)) {
                        idAccordiCoinvolti.add(idAccordo);
                    }
                    if (idSoggettiCoinvolti.contains(idSoggettoReferente = ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getIdSoggettoReferente())) continue;
                    idSoggettiCoinvolti.add(idSoggettoReferente);
                    continue;
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (archive.getAccordiServizioComposto() != null && archive.getAccordiServizioComposto().size() > 0) {
            for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
                AccordoServizioParteComune apc;
                IDSoggetto idSoggettoReferente;
                if (((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getIdSoggettoReferente() == null || !idSoggettoSelezionato.equals((Object)((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getIdSoggettoReferente())) continue;
                IDAccordo idAccordo = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getIdAccordoServizioParteComune();
                if (!idAccordiCoinvolti.contains(idAccordo)) {
                    idAccordiCoinvolti.add(idAccordo);
                }
                if (!idSoggettiCoinvolti.contains(idSoggettoReferente = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getIdSoggettoReferente())) {
                    idSoggettiCoinvolti.add(idSoggettoReferente);
                }
                if ((apc = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune()).getServizioComposto() == null) continue;
                if (apc.getServizioComposto().sizeServizioComponenteList() > 0) {
                    for (int j = 0; j < apc.getServizioComposto().sizeServizioComponenteList(); ++j) {
                        AccordoServizioParteComuneServizioCompostoServizioComponente componente = apc.getServizioComposto().getServizioComponente(j);
                        try {
                            IDServizio idServizioComponente = IDServizioFactory.getInstance().getIDServizioFromValues(componente.getTipo(), componente.getNome(), componente.getTipoSoggetto(), componente.getNomeSoggetto(), componente.getVersione().intValue());
                            if (idServiziCoinvolti.contains(idServizioComponente)) continue;
                            idServiziCoinvolti.add(idServizioComponente);
                            continue;
                        }
                        catch (Exception e) {
                            ControlStationCore.logError("AccordoServizioComposto [" + idAccordo + "]: " + e.getMessage(), e);
                        }
                    }
                }
                if (apc.getServizioComposto().getAccordoCooperazione() == null) continue;
                String uriAC = apc.getServizioComposto().getAccordoCooperazione();
                try {
                    IDAccordoCooperazione idAC = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(uriAC);
                    if (idAccordiCooperazioneCoinvolti.contains(idAC)) continue;
                    idAccordiCooperazioneCoinvolti.add(idAC);
                    continue;
                }
                catch (Exception e) {
                    ControlStationCore.logError("AccordoServizioComposto [" + idAccordo + "]: " + e.getMessage(), e);
                }
            }
        }
        if (archive.getAccordiServizioParteSpecifica() != null && archive.getAccordiServizioParteSpecifica().size() > 0) {
            for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
                if (((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getIdSoggettoErogatore() == null || !idSoggettoSelezionato.equals((Object)((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getIdSoggettoErogatore())) continue;
                idServizio2 = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getIdAccordoServizioParteSpecifica();
                if (!idServiziCoinvolti.contains(idServizio2)) {
                    idServiziCoinvolti.add(idServizio2);
                }
                String uriAccordoServizioParteComune = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica().getAccordoServizioParteComune();
                try {
                    IDAccordo idApc = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordoServizioParteComune);
                    if (idAccordiCoinvolti.contains(idApc)) continue;
                    idAccordiCoinvolti.add(idApc);
                    continue;
                }
                catch (Exception e) {
                    ControlStationCore.logError("AccordoServizioParteSpecifica [" + idServizio2 + "]: " + e.getMessage(), e);
                }
            }
        }
        if (archive.getAccordiFruitori() != null && archive.getAccordiFruitori().size() > 0) {
            block24: for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
                if (((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getIdSoggettoFruitore() == null || !idSoggettoSelezionato.equals((Object)((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getIdSoggettoFruitore())) continue;
                idServizio2 = ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getIdAccordoServizioParteSpecifica();
                IDSoggetto idSoggettoErogatore = idServizio2.getSoggettoErogatore();
                if (!idSoggettiCoinvolti.contains(idSoggettoErogatore)) {
                    idSoggettiCoinvolti.add(idSoggettoErogatore);
                }
                if (!idServiziCoinvolti.contains(idServizio2)) {
                    idServiziCoinvolti.add(idServizio2);
                }
                if (archive.getAccordiServizioParteSpecifica() == null || archive.getAccordiServizioParteSpecifica().size() <= 0) continue;
                for (int j = 0; j < archive.getAccordiServizioParteSpecifica().size(); ++j) {
                    IDServizio idServizioCheck = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(j)).getIdAccordoServizioParteSpecifica();
                    if (!idServizio2.equals((Object)idServizioCheck)) continue;
                    String uriAccordoServizioParteComune = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(j)).getAccordoServizioParteSpecifica().getAccordoServizioParteComune();
                    try {
                        IDAccordo idApc = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordoServizioParteComune);
                        if (idAccordiCoinvolti.contains(idApc)) continue block24;
                        idAccordiCoinvolti.add(idApc);
                    }
                    catch (Exception e) {
                        ControlStationCore.logError("Fruitore[" + idSoggettoSelezionato + "] AccordoServizioParteSpecifica [" + idServizio2 + "]: " + e.getMessage(), e);
                    }
                    continue block24;
                }
            }
        }
        if (archive.getSoggetti() != null && archive.getSoggetti().size() > 0) {
            ArrayList<ArchiveSoggetto> listFiltrata = new ArrayList<ArchiveSoggetto>();
            for (int i2 = 0; i2 < archive.getSoggetti().size(); ++i2) {
                if (((ArchiveSoggetto)archive.getSoggetti().get(i2)).getIdSoggetto() == null || !idSoggettiCoinvolti.contains(((ArchiveSoggetto)archive.getSoggetti().get(i2)).getIdSoggetto())) continue;
                listFiltrata.add((ArchiveSoggetto)archive.getSoggetti().get(i2));
            }
            while (archive.getSoggetti().size() > 0) {
                archive.getSoggetti().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveSoggetto archiveFiltrato : listFiltrata) {
                    archive.getSoggetti().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getServiziApplicativi() != null && archive.getServiziApplicativi().size() > 0) {
            ArrayList<ArchiveServizioApplicativo> listFiltrata = new ArrayList<ArchiveServizioApplicativo>();
            for (int i3 = 0; i3 < archive.getServiziApplicativi().size(); ++i3) {
                if (((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i3)).getIdSoggettoProprietario() == null || !idServiziApplicativiCoinvolti.contains(((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i3)).getIdServizioApplicativo())) continue;
                listFiltrata.add((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i3));
            }
            while (archive.getServiziApplicativi().size() > 0) {
                archive.getServiziApplicativi().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveServizioApplicativo archiveFiltrato : listFiltrata) {
                    archive.getServiziApplicativi().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getPorteDelegate() != null && archive.getPorteDelegate().size() > 0) {
            ArrayList<ArchivePortaDelegata> listFiltrata = new ArrayList<ArchivePortaDelegata>();
            for (int i4 = 0; i4 < archive.getPorteDelegate().size(); ++i4) {
                if (((ArchivePortaDelegata)archive.getPorteDelegate().get(i4)).getIdSoggettoProprietario() == null || !idSoggettoSelezionato.equals((Object)((ArchivePortaDelegata)archive.getPorteDelegate().get(i4)).getIdSoggettoProprietario())) continue;
                listFiltrata.add((ArchivePortaDelegata)archive.getPorteDelegate().get(i4));
            }
            while (archive.getPorteDelegate().size() > 0) {
                archive.getPorteDelegate().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchivePortaDelegata archiveFiltrato : listFiltrata) {
                    archive.getPorteDelegate().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getPorteApplicative() != null && archive.getPorteApplicative().size() > 0) {
            ArrayList<ArchivePortaApplicativa> listFiltrata = new ArrayList<ArchivePortaApplicativa>();
            for (int i5 = 0; i5 < archive.getPorteApplicative().size(); ++i5) {
                if (((ArchivePortaApplicativa)archive.getPorteApplicative().get(i5)).getIdSoggettoProprietario() == null || !idSoggettoSelezionato.equals((Object)((ArchivePortaApplicativa)archive.getPorteApplicative().get(i5)).getIdSoggettoProprietario())) continue;
                listFiltrata.add((ArchivePortaApplicativa)archive.getPorteApplicative().get(i5));
            }
            while (archive.getPorteApplicative().size() > 0) {
                archive.getPorteApplicative().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchivePortaApplicativa archiveFiltrato : listFiltrata) {
                    archive.getPorteApplicative().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getAccordiCooperazione() != null && archive.getAccordiCooperazione().size() > 0) {
            ArrayList<ArchiveAccordoCooperazione> listFiltrata = new ArrayList<ArchiveAccordoCooperazione>();
            for (int i6 = 0; i6 < archive.getAccordiCooperazione().size(); ++i6) {
                if (((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i6)).getIdSoggettoReferente() == null || !idAccordiCooperazioneCoinvolti.contains(((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i6)).getIdAccordoCooperazione())) continue;
                listFiltrata.add((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i6));
            }
            while (archive.getAccordiCooperazione().size() > 0) {
                archive.getAccordiCooperazione().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAccordoCooperazione archiveFiltrato : listFiltrata) {
                    archive.getAccordiCooperazione().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getAccordiServizioParteComune() != null && archive.getAccordiServizioParteComune().size() > 0) {
            ArrayList<ArchiveAccordoServizioParteComune> listFiltrata = new ArrayList<ArchiveAccordoServizioParteComune>();
            for (int i7 = 0; i7 < archive.getAccordiServizioParteComune().size(); ++i7) {
                if (((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i7)).getIdSoggettoReferente() == null || !idAccordiCoinvolti.contains(((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i7)).getIdAccordoServizioParteComune())) continue;
                listFiltrata.add((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i7));
            }
            while (archive.getAccordiServizioParteComune().size() > 0) {
                archive.getAccordiServizioParteComune().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAccordoServizioParteComune archiveFiltrato : listFiltrata) {
                    archive.getAccordiServizioParteComune().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getAccordiServizioComposto() != null && archive.getAccordiServizioComposto().size() > 0) {
            ArrayList<ArchiveAccordoServizioComposto> listFiltrata = new ArrayList<ArchiveAccordoServizioComposto>();
            for (int i8 = 0; i8 < archive.getAccordiServizioComposto().size(); ++i8) {
                if (((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i8)).getIdSoggettoReferente() == null || !idAccordiCoinvolti.contains(((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i8)).getIdAccordoServizioParteComune())) continue;
                listFiltrata.add((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i8));
            }
            while (archive.getAccordiServizioComposto().size() > 0) {
                archive.getAccordiServizioComposto().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAccordoServizioComposto archiveFiltrato : listFiltrata) {
                    archive.getAccordiServizioComposto().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getAccordiServizioParteSpecifica() != null && archive.getAccordiServizioParteSpecifica().size() > 0) {
            ArrayList<ArchiveAccordoServizioParteSpecifica> listFiltrata = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
            for (int i9 = 0; i9 < archive.getAccordiServizioParteSpecifica().size(); ++i9) {
                if (((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i9)).getIdSoggettoErogatore() == null || !idServiziCoinvolti.contains(((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i9)).getIdAccordoServizioParteSpecifica())) continue;
                listFiltrata.add((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i9));
            }
            while (archive.getAccordiServizioParteSpecifica().size() > 0) {
                archive.getAccordiServizioParteSpecifica().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAccordoServizioParteSpecifica archiveFiltrato : listFiltrata) {
                    archive.getAccordiServizioParteSpecifica().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getAccordiFruitori() != null && archive.getAccordiFruitori().size() > 0) {
            ArrayList<ArchiveFruitore> listFiltrata = new ArrayList<ArchiveFruitore>();
            for (int i10 = 0; i10 < archive.getAccordiFruitori().size(); ++i10) {
                if (((ArchiveFruitore)archive.getAccordiFruitori().get(i10)).getIdSoggettoFruitore() == null || !idSoggettoSelezionato.equals((Object)((ArchiveFruitore)archive.getAccordiFruitori().get(i10)).getIdSoggettoFruitore())) continue;
                listFiltrata.add((ArchiveFruitore)archive.getAccordiFruitori().get(i10));
            }
            while (archive.getAccordiFruitori().size() > 0) {
                archive.getAccordiFruitori().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveFruitore archiveFiltrato : listFiltrata) {
                    archive.getAccordiFruitori().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getControlloTraffico_activePolicies() != null && archive.getControlloTraffico_activePolicies().size() > 0) {
            ArrayList<ArchiveActivePolicy> listFiltrata = new ArrayList<ArchiveActivePolicy>();
            for (int i11 = 0; i11 < archive.getControlloTraffico_activePolicies().size(); ++i11) {
                ArchiveActivePolicy archivePolicy = (ArchiveActivePolicy)archive.getControlloTraffico_activePolicies().get(i11);
                boolean filtra = false;
                if (archivePolicy.getPolicy().getFiltro() != null) {
                    IDSoggetto idSoggettoErogatore = null;
                    if (archivePolicy.getPolicy().getFiltro().getTipoErogatore() != null && archivePolicy.getPolicy().getFiltro().getNomeErogatore() != null && !idSoggettiCoinvolti.contains(idSoggettoErogatore = new IDSoggetto(archivePolicy.getPolicy().getFiltro().getTipoErogatore(), archivePolicy.getPolicy().getFiltro().getNomeErogatore()))) {
                        filtra = true;
                    }
                    if (archivePolicy.getPolicy().getFiltro().getTipoFruitore() != null && archivePolicy.getPolicy().getFiltro().getNomeFruitore() != null && !idSoggettiCoinvolti.contains(idSoggettoFruitore = new IDSoggetto(archivePolicy.getPolicy().getFiltro().getTipoFruitore(), archivePolicy.getPolicy().getFiltro().getNomeFruitore()))) {
                        filtra = true;
                    }
                    if (idSoggettoErogatore != null && archivePolicy.getPolicy().getFiltro().getTipoServizio() != null && archivePolicy.getPolicy().getFiltro().getNomeServizio() != null && archivePolicy.getPolicy().getFiltro().getVersioneServizio() != null) {
                        try {
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(archivePolicy.getPolicy().getFiltro().getTipoServizio(), archivePolicy.getPolicy().getFiltro().getNomeServizio(), idSoggettoErogatore, archivePolicy.getPolicy().getFiltro().getVersioneServizio().intValue());
                            if (!idServiziCoinvolti.contains(idServizio)) {
                                filtra = true;
                            }
                        }
                        catch (Exception e) {
                            ControlStationCore.logError("ControlloTraffico activePolicies [" + archivePolicy.getPolicy().getIdActivePolicy() + "]: " + e.getMessage(), e);
                        }
                    }
                }
                if (filtra) continue;
                listFiltrata.add(archivePolicy);
            }
            while (archive.getControlloTraffico_activePolicies().size() > 0) {
                archive.getControlloTraffico_activePolicies().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveActivePolicy archiveFiltrato : listFiltrata) {
                    archive.getControlloTraffico_activePolicies().add((Object)archiveFiltrato);
                }
            }
        }
        if (archive.getAllarmi() != null && archive.getAllarmi().size() > 0) {
            ArrayList<ArchiveAllarme> listFiltrata = new ArrayList<ArchiveAllarme>();
            for (int i12 = 0; i12 < archive.getAllarmi().size(); ++i12) {
                ArchiveAllarme archiveAllarme = (ArchiveAllarme)archive.getAllarmi().get(i12);
                boolean filtra = false;
                if (archiveAllarme.getAllarme().getFiltro() != null) {
                    IDSoggetto idSoggettoErogatore = null;
                    if (archiveAllarme.getAllarme().getFiltro().getTipoErogatore() != null && archiveAllarme.getAllarme().getFiltro().getNomeErogatore() != null && !idSoggettiCoinvolti.contains(idSoggettoErogatore = new IDSoggetto(archiveAllarme.getAllarme().getFiltro().getTipoErogatore(), archiveAllarme.getAllarme().getFiltro().getNomeErogatore()))) {
                        filtra = true;
                    }
                    if (archiveAllarme.getAllarme().getFiltro().getTipoFruitore() != null && archiveAllarme.getAllarme().getFiltro().getNomeFruitore() != null && !idSoggettiCoinvolti.contains(idSoggettoFruitore = new IDSoggetto(archiveAllarme.getAllarme().getFiltro().getTipoFruitore(), archiveAllarme.getAllarme().getFiltro().getNomeFruitore()))) {
                        filtra = true;
                    }
                    if (idSoggettoErogatore != null && archiveAllarme.getAllarme().getFiltro().getTipoServizio() != null && archiveAllarme.getAllarme().getFiltro().getNomeServizio() != null && archiveAllarme.getAllarme().getFiltro().getVersioneServizio() != null) {
                        try {
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(archiveAllarme.getAllarme().getFiltro().getTipoServizio(), archiveAllarme.getAllarme().getFiltro().getNomeServizio(), idSoggettoErogatore, archiveAllarme.getAllarme().getFiltro().getVersioneServizio().intValue());
                            if (!idServiziCoinvolti.contains(idServizio)) {
                                filtra = true;
                            }
                        }
                        catch (Exception e) {
                            ControlStationCore.logError("Allarmi [" + archiveAllarme.getAllarme().getNome() + "]: " + e.getMessage(), e);
                        }
                    }
                }
                if (filtra) continue;
                listFiltrata.add(archiveAllarme);
            }
            while (archive.getAllarmi().size() > 0) {
                archive.getAllarmi().remove(0);
            }
            if (!listFiltrata.isEmpty()) {
                for (ArchiveAllarme archiveFiltrato : listFiltrata) {
                    archive.getAllarmi().add((Object)archiveFiltrato);
                }
            }
        }
    }
}

