/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.audit;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.lib.audit.AuditException;
import org.openspcoop2.web.lib.audit.DriverAuditDBAppender;
import org.openspcoop2.web.lib.audit.dao.Configurazione;
import org.openspcoop2.web.lib.audit.log.Operation;

public class AuditingCore
extends ControlStationCore {
    public AuditingCore() throws Exception {
    }

    public AuditingCore(ControlStationCore core) throws Exception {
        super(core);
    }

    public List<Operation> auditOperationList(ISearch ricerca, String datainizio, String datafine, String tipooperazione, String tipooggetto, String id, String oldid, String utente, String statooperazione, String contoggetto) throws AuditException {
        Connection con = null;
        String nomeMetodo = "auditOperationList";
        DriverAuditDBAppender driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverAuditDBAppender(con, this.tipoDB);
            List list = driver.auditOperationList(ricerca, Liste.AUDIT_REPORT, datainizio, datafine, tipooperazione, tipooggetto, id, oldid, utente, statooperazione, contoggetto);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new AuditException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Operation getAuditOperation(long idOp) throws AuditException {
        Connection con = null;
        String nomeMetodo = "getAuditOperation";
        DriverAuditDBAppender driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverAuditDBAppender(con, this.tipoDB);
            Operation operation = driver.getOperation(idOp);
            return operation;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new AuditException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Configurazione getConfigurazioneAudit() throws AuditException {
        Connection con = null;
        String nomeMetodo = "getConfigurazioneAudit";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Configurazione configurazione = driver.getDriverAuditDB().getConfigurazione();
            return configurazione;
        }
        catch (AuditException ae) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)ae)), ae);
            throw ae;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new AuditException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

