/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.Cache;
import org.openspcoop2.core.config.constants.AlgoritmoCache;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class ConfigurazioneAccessoRegistro
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            String statocache = confHelper.getParameter("statocacheRegistry");
            String dimensionecache = confHelper.getParameter("dimensionecacheRegistry");
            String algoritmocache = confHelper.getParameter("algoritmocacheRegistry");
            String idlecache = confHelper.getParameter("idlecacheRegistry");
            String lifecache = confHelper.getParameter("lifecacheRegistry");
            String applicaModificaS = confHelper.getParameter("applicaMod");
            boolean applicaModifica = ServletUtils.isCheckBoxEnabled((String)applicaModificaS);
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            confHelper.makeMenu();
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Registro", null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            AccessoRegistro ar = confCore.getAccessoRegistro();
            if (confHelper.isEditModeInProgress() && !applicaModifica) {
                Cache arc = ar.getCache();
                if (arc == null) {
                    if (statocache == null) {
                        statocache = ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO;
                    }
                    dimensionecache = "";
                    algoritmocache = "lru";
                    idlecache = "";
                    lifecache = "";
                } else {
                    if (statocache == null) {
                        statocache = ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO;
                    }
                    dimensionecache = arc.getDimensione();
                    if (arc.getAlgoritmo() != null) {
                        algoritmocache = arc.getAlgoritmo().toString();
                    }
                    idlecache = arc.getItemIdleTime();
                    lifecache = arc.getItemLifeSecond();
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addConfigurazioneRegistroToDati(statocache, dimensionecache, algoritmocache, idlecache, lifecache, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneAccessoRegistroServizi", (ForwardParams)ConfigurazioneCostanti.TIPO_OPERAZIONE_CONFIGURAZIONE_ACCESSO_REGISTRO_SERVIZI);
            }
            boolean isOk = confHelper.registroCheckData();
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addConfigurazioneRegistroToDati(statocache, dimensionecache, algoritmocache, idlecache, lifecache, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneAccessoRegistroServizi", (ForwardParams)ConfigurazioneCostanti.TIPO_OPERAZIONE_CONFIGURAZIONE_ACCESSO_REGISTRO_SERVIZI);
            }
            if (statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO)) {
                Cache arcNew = new Cache();
                arcNew.setDimensione(dimensionecache);
                arcNew.setAlgoritmo(AlgoritmoCache.toEnumConstant((String)algoritmocache));
                arcNew.setItemIdleTime(idlecache);
                arcNew.setItemLifeSecond(confHelper.convertLifeCacheValue(lifecache));
                ar.setCache(arcNew);
            } else {
                ar.setCache(null);
            }
            confCore.performUpdateOperation(userLogin, confHelper.smista(), ar);
            List<DataElement> dati = new ArrayList<DataElement>();
            dati = confHelper.addConfigurazioneRegistroToDati(statocache, dimensionecache, algoritmocache, idlecache, lifecache, dati);
            pd.setDati(dati);
            pd.setMessage("Configurazione Registro modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneAccessoRegistroServizi", (ForwardParams)ConfigurazioneCostanti.TIPO_OPERAZIONE_CONFIGURAZIONE_ACCESSO_REGISTRO_SERVIZI);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneAccessoRegistroServizi", (ForwardParams)ConfigurazioneCostanti.TIPO_OPERAZIONE_CONFIGURAZIONE_ACCESSO_REGISTRO_SERVIZI);
        }
    }
}

