/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.allarmi.AllarmeFiltro;
import org.openspcoop2.core.allarmi.AllarmeMail;
import org.openspcoop2.core.allarmi.AllarmeParametro;
import org.openspcoop2.core.allarmi.AllarmeRaggruppamento;
import org.openspcoop2.core.allarmi.AllarmeScript;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.utils.AllarmiUtils;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.monitor.sdk.plugins.IAlarmProcessing;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ConfigurazioneAllarmiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        TipoOperazione tipoOperazione = TipoOperazione.ADD;
        String pluginSelectedExceptionMessage = null;
        try {
            StringBuilder sbParsingError = new StringBuilder();
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            boolean first = confHelper.isFirstTimeFromHttpParameters("allFirstTime");
            String ruoloPortaParam = confHelper.getParameter("allRuoloPorta");
            RuoloPorta ruoloPorta = null;
            if (ruoloPortaParam != null) {
                ruoloPorta = RuoloPorta.toEnumConstant((String)ruoloPortaParam);
            }
            String nomePorta = confHelper.getParameter("allNomePorta");
            ServiceBinding serviceBinding = null;
            String serviceBindingParam = confHelper.getParameter("allServiceBinding");
            if (serviceBindingParam != null && !"".equals(serviceBindingParam)) {
                serviceBinding = ServiceBinding.valueOf((String)serviceBindingParam);
            }
            String nomePlugin = confHelper.getParameter("allPlugin");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            SoggettiCore soggettiCore = new SoggettiCore(confCore);
            PorteDelegateCore pdCore = new PorteDelegateCore(confCore);
            PorteApplicativeCore paCore = new PorteApplicativeCore(confCore);
            AlarmEngineConfig alarmEngineConfig = confCore.getAllarmiConfig();
            ConfigurazioneAllarmeBean allarme = new ConfigurazioneAllarmeBean();
            allarme.setEnabled(Integer.valueOf(1));
            allarme.setTipo(null);
            allarme.setTipoAllarme(null);
            allarme.setMail(new AllarmeMail());
            allarme.getMail().setInvia(Integer.valueOf(0));
            allarme.getMail().setInviaWarning(Integer.valueOf(0));
            allarme.setScript(new AllarmeScript());
            allarme.getScript().setInvoca(Integer.valueOf(0));
            allarme.getScript().setInvocaWarning(Integer.valueOf(0));
            allarme.setFiltro(new AllarmeFiltro());
            allarme.setGroupBy(new AllarmeRaggruppamento());
            if (first) {
                confHelper.savePluginIntoSession(request, session, null);
                confHelper.saveParametriIntoSession(request, session, null);
            }
            List<Parameter<?>> parameters = confHelper.readParametriFromSession(request, session);
            String applicabilita = "Configurazione";
            if (ruoloPorta != null) {
                applicabilita = RuoloPorta.DELEGATA.equals((Object)ruoloPorta) ? "Fruizione" : "Erogazione";
            }
            List<Plugin> listaPlugin = confCore.pluginsAllarmiList(applicabilita, true);
            int numeroPluginRegistrati = listaPlugin.size();
            Plugin plugin = confHelper.readPluginFromSession(request, session);
            allarme.setPlugin(plugin);
            String errorAttivazione = confHelper.readAllarmeFromRequest(tipoOperazione, first, allarme, alarmEngineConfig, plugin, parameters);
            if (errorAttivazione != null) {
                confHelper.addParsingError(sbParsingError, errorAttivazione);
            }
            if (ruoloPorta != null) {
                PortaDelegata porta;
                String protocollo = null;
                Object tipoSoggettoProprietario = null;
                String nomeSoggettoProprietario = null;
                if (RuoloPorta.DELEGATA.equals((Object)ruoloPorta)) {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(nomePorta);
                    porta = pdCore.getPortaDelegata(idPD);
                    protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(porta.getTipoSoggettoProprietario());
                    tipoSoggettoProprietario = porta.getTipoSoggettoProprietario();
                    nomeSoggettoProprietario = porta.getNomeSoggettoProprietario();
                } else {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(nomePorta);
                    porta = paCore.getPortaApplicativa(idPA);
                    protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(porta.getTipoSoggettoProprietario());
                }
                allarme.getFiltro().setEnabled(true);
                allarme.getFiltro().setProtocollo(protocollo);
                allarme.getFiltro().setRuoloPorta(ruoloPorta);
                allarme.getFiltro().setNomePorta(nomePorta);
                if (RuoloPorta.DELEGATA.equals((Object)ruoloPorta)) {
                    allarme.getFiltro().setTipoFruitore((String)tipoSoggettoProprietario);
                    allarme.getFiltro().setNomeFruitore(nomeSoggettoProprietario);
                }
            }
            confHelper.makeMenu();
            String postBackElementName = confHelper.getPostBackElementName();
            if (postBackElementName != null && postBackElementName.equals("allPlugin")) {
                if (nomePlugin.equals("[Nessuno]")) {
                    allarme.setNome(null);
                    allarme.setTipoAllarme(null);
                    allarme.setPlugin(null);
                    parameters = null;
                    confHelper.removeParametriFromSession(request, session);
                    confHelper.removePluginFromSession(request, session);
                } else {
                    for (Plugin pluginBean : listaPlugin) {
                        String key = pluginBean.getLabel() + "__$$__$$__" + pluginBean.getClassName();
                        if (!key.equals(nomePlugin)) continue;
                        plugin = pluginBean;
                        break;
                    }
                    allarme.setPlugin(plugin);
                    parameters = null;
                    if (allarme.getPlugin() != null) {
                        allarme.setNome(allarme.getPlugin().getLabel());
                        allarme.setTipo(allarme.getPlugin().getTipo());
                        try {
                            Context context = confHelper.createAlarmContext(allarme, parameters);
                            if (confCore.isShowAllarmiFormNomeSuggeritoCreazione() != null && confCore.isShowAllarmiFormNomeSuggeritoCreazione().booleanValue()) {
                                allarme.setAlias(AllarmiUtils.costruisciAliasAllarme((ConfigurazioneAllarmeBean)allarme, (Logger)ControlStationCore.getLog(), (Context)context));
                            }
                            String serialId = confCore.getNextAlarmInstanceSerialId(allarme.getPlugin().getTipo());
                            allarme.setNome(AllarmiDriverUtils.buildIdAlarm((String)allarme.getPlugin().getTipo(), (String)serialId));
                            allarme.setDescrizione(allarme.getPlugin().getDescrizione());
                            IDynamicLoader dl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, allarme.getPlugin().getTipo(), allarme.getPlugin().getClassName(), ControlStationCore.getLog());
                            IAlarmProcessing alarm = (IAlarmProcessing)dl.newInstance();
                            switch (alarm.getAlarmType()) {
                                case ACTIVE: {
                                    allarme.setTipoAllarme(TipoAllarme.ATTIVO);
                                    break;
                                }
                                case PASSIVE: {
                                    allarme.setTipoAllarme(TipoAllarme.PASSIVO);
                                }
                            }
                            parameters = confCore.getParameters(allarme, context);
                            confHelper.saveParametriIntoSession(request, session, parameters);
                            confHelper.savePluginIntoSession(request, session, allarme.getPlugin());
                        }
                        catch (Exception e) {
                            ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                            allarme.setNome(null);
                            allarme.setTipoAllarme(null);
                            allarme.setPlugin(null);
                            allarme.setTipo(null);
                            parameters = null;
                            pluginSelectedExceptionMessage = e.getMessage();
                            confHelper.removeParametriFromSession(request, session);
                            confHelper.removePluginFromSession(request, session);
                        }
                    }
                }
            }
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamSession = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = null;
            if (ruoloPorta != null) {
                parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("allRuoloPorta", ruoloPorta.getValue());
                lstParamSession.add(parRuoloPorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parNomePorta = null;
            if (nomePorta != null) {
                parNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("allNomePorta", nomePorta);
                lstParamSession.add(parNomePorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = null;
            if (serviceBinding != null) {
                parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("allServiceBinding", serviceBinding.name());
                lstParamSession.add(parServiceBinding);
            }
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParamPorta = null;
            if (ruoloPorta != null) {
                lstParamPorta = confHelper.getTitleListAllarmi(ruoloPorta, nomePorta, serviceBinding, "Aggiungi");
            }
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParam = null;
            if (lstParamPorta != null) {
                lstParam = lstParamPorta;
            } else {
                lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                if (!lstParamSession.isEmpty()) {
                    lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Allarmi", "configurazioneAllarmiList.do", lstParamSession.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamSession.size()])));
                } else {
                    lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Allarmi", "configurazioneAllarmiList.do"));
                }
                lstParam.add(ServletUtils.getParameterAggiungi());
            }
            if (confHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addAllarmeToDati(dati, tipoOperazione, allarme, alarmEngineConfig, listaPlugin, parameters, ruoloPorta, nomePorta, serviceBinding);
                confHelper.addToDatiFirstTimeDisabled(dati, "allFirstTime");
                if (pluginSelectedExceptionMessage != null) {
                    pd.setMessage(pluginSelectedExceptionMessage);
                }
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneAllarmi", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.allarmeCheckData(sbParsingError, TipoOperazione.ADD, null, allarme, numeroPluginRegistrati, parameters);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addAllarmeToDati(dati, tipoOperazione, allarme, alarmEngineConfig, listaPlugin, parameters, ruoloPorta, nomePorta, serviceBinding);
                confHelper.addToDatiFirstTimeDisabled(dati, "allFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneAllarmi", (ForwardParams)ForwardParams.ADD());
            }
            if (parameters != null && !parameters.isEmpty()) {
                for (Parameter<?> par : parameters) {
                    boolean found = false;
                    for (AllarmeParametro parDB : allarme.getAllarmeParametroList()) {
                        if (!parDB.getIdParametro().equals(par.getId())) continue;
                        parDB.setValore(par.getValueAsString());
                        found = true;
                        break;
                    }
                    if (found) continue;
                    AllarmeParametro parDB = new AllarmeParametro();
                    parDB.setIdParametro(par.getId());
                    parDB.setValore(par.getValueAsString());
                    allarme.addAllarmeParametro(parDB);
                }
            }
            allarme.setStato(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.OK)));
            allarme.setStatoPrecedente(Integer.valueOf(AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.OK)));
            allarme.setLasttimestampCreate(new Date());
            allarme.setAcknowledged(Integer.valueOf(0));
            if (allarme.getPlugin() != null) {
                try {
                    Context context;
                    String ackCriteria;
                    IDynamicLoader dl = DynamicFactory.getInstance().newDynamicLoader(TipoPlugin.ALLARME, allarme.getPlugin().getTipo(), allarme.getPlugin().getClassName(), ControlStationCore.getLog());
                    IAlarmProcessing alarm = (IAlarmProcessing)dl.newInstance();
                    if (alarm.isManuallyAckCriteria() && (ackCriteria = alarm.getDefaultManuallyAckCriteria(context = confHelper.createAlarmContext(allarme, parameters))) != null) {
                        allarme.setDettaglioAcknowledged(ackCriteria);
                    }
                }
                catch (Exception e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                }
            }
            confCore.performCreateOperation(userLogin, confHelper.smista(), allarme);
            try {
                AllarmiUtils.notifyStateActiveThread((boolean)true, (boolean)false, (boolean)false, null, (ConfigurazioneAllarmeBean)allarme, (Logger)ControlStationCore.getLog(), (AlarmEngineConfig)alarmEngineConfig);
            }
            catch (Exception e) {
                String errorMsg = MessageFormat.format("Allarme {0} salvato correttamente nel registro, ma la notifica verso il gestore degli allarmi \u00e8 fallita: {1}", allarme.getAlias(), e.getMessage());
                ControlStationCore.getLog().error(errorMsg, (Throwable)e);
                pd.setMessage(errorMsg);
            }
            int idLista = Liste.CONFIGURAZIONE_ALLARMI;
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<ConfigurazioneAllarmeBean> lista = confCore.allarmiList(ricerca, ruoloPorta, nomePorta);
            confHelper.prepareAllarmiList(ricerca, lista, ruoloPorta, nomePorta, serviceBinding);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneAllarmi", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneAllarmi", (ForwardParams)ForwardParams.ADD());
        }
    }
}

