/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneUtilities;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ConfigurazioneControlloTrafficoAttivazionePolicyDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            confHelper.makeMenu();
            String ruoloPortaParam = confHelper.getParameter("CTPolicyRuoloPorta");
            RuoloPolicy ruoloPorta = null;
            if (ruoloPortaParam != null) {
                ruoloPorta = RuoloPolicy.toEnumConstant((String)ruoloPortaParam);
            }
            String nomePorta = confHelper.getParameter("CTPolicyNomePorta");
            ServiceBinding serviceBinding = null;
            String serviceBindingParam = confHelper.getParameter("CTPolicyServiceBinding");
            if (serviceBindingParam != null && !"".equals(serviceBindingParam)) {
                serviceBinding = ServiceBinding.valueOf((String)serviceBindingParam);
            }
            String objToRemove = confHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            ArrayList<AttivazionePolicy> policyDaEliminare = new ArrayList<AttivazionePolicy>();
            StringBuilder inUsoMessage = new StringBuilder();
            for (int i = 0; i < idsToRemove.size(); ++i) {
                long idPolicy = Long.parseLong(idsToRemove.get(i));
                AttivazionePolicy policy = confCore.getAttivazionePolicy(idPolicy);
                policyDaEliminare.add(policy);
            }
            ArrayList<AttivazionePolicy> policyRimosse = new ArrayList<AttivazionePolicy>();
            ConfigurazioneUtilities.deleteAttivazionePolicy(policyDaEliminare, confHelper, confCore, userLogin, inUsoMessage, "<br/>", policyRimosse);
            Object msgCompletato = confHelper.eseguiResetJmx(TipoOperazione.DEL, ruoloPorta, nomePorta);
            if (msgCompletato != null && !"".equals(msgCompletato)) {
                if (inUsoMessage.length() > 0) {
                    msgCompletato = !policyRimosse.isEmpty() ? (String)msgCompletato + "<br/><br/>" + inUsoMessage.toString() : inUsoMessage.toString();
                }
            } else {
                msgCompletato = inUsoMessage.toString();
            }
            if (msgCompletato != null && !"".equals(msgCompletato)) {
                if (inUsoMessage.length() > 0) {
                    pd.setMessage((String)msgCompletato);
                } else {
                    pd.setMessage((String)msgCompletato, Costanti.MESSAGE_TYPE_INFO);
                }
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<TipoRisorsaPolicyAttiva> listaTipoRisorsa = confHelper.gestisciCriteriFiltroRisorsaPolicy(ricerca, ruoloPorta, nomePorta);
            List<AttivazionePolicy> lista = confCore.attivazionePolicyList(ricerca, ruoloPorta, nomePorta);
            confHelper.prepareAttivazionePolicyList(ricerca, lista, listaTipoRisorsa, idLista, ruoloPorta, nomePorta, serviceBinding);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.DEL());
        }
    }
}

