/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.constants.RegistroTipo;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazioneRegistriAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            String nome = confHelper.getParameter("nome");
            String location = confHelper.getParameter("location");
            String tipo = confHelper.getParameter("tipo");
            if (tipo == null) {
                tipo = "xml";
            }
            String utente = confHelper.getParameter("utente");
            String password = confHelper.getParameter("password");
            String confpw = confHelper.getParameter("confpw");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            confHelper.makeMenu();
            if (confHelper.isEditModeInProgress()) {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
                lstParam.add(new Parameter("Registro", "configurazioneAccessoRegistroServizi.do"));
                lstParam.add(new Parameter("Elenco registri", "configurazioneRegistriList.do"));
                lstParam.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addRegistroToDati(TipoOperazione.ADD, nome != null ? nome : "", location != null ? location : "", tipo, "", "", "", dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneRegistri", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.registriCheckData(TipoOperazione.ADD);
            if (!isOk) {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
                lstParam.add(new Parameter("Registro", "configurazioneAccessoRegistroServizi.do"));
                lstParam.add(new Parameter("Elenco registri", "configurazioneRegistriList.do"));
                lstParam.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addRegistroToDati(TipoOperazione.ADD, nome, location, tipo, utente, password, confpw, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneRegistri", (ForwardParams)ForwardParams.ADD());
            }
            AccessoRegistro ar = confCore.getAccessoRegistro();
            AccessoRegistroRegistro arr = new AccessoRegistroRegistro();
            arr.setNome(nome);
            arr.setLocation(location);
            arr.setTipo(RegistroTipo.toEnumConstant((String)tipo));
            if (tipo.equals("uddi")) {
                arr.setUser(utente);
                arr.setPassword(password);
            }
            ar.addRegistro(arr);
            confCore.performUpdateOperation(userLogin, confHelper.smista(), ar);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<AccessoRegistroRegistro> lista = confCore.registriList((ISearch)ricerca);
            confHelper.prepareRegistriList((ISearch)ricerca, lista);
            pd.setMessage("Configurazione Registro modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneRegistri", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneRegistri", (ForwardParams)ForwardParams.ADD());
        }
    }
}

