/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.Route;
import org.openspcoop2.core.config.RouteGateway;
import org.openspcoop2.core.config.RouteRegistro;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazioneRouteAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            String[] tipiSoggettiLabel;
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            String nome = confHelper.getParameter("nome");
            String tipo = confHelper.getParameter("tipo");
            String tiporotta = confHelper.getParameter("tiporotta");
            if (tiporotta == null) {
                tiporotta = "registro";
            }
            String tiposoggrotta = confHelper.getParameter("tiposoggrotta");
            String nomesoggrotta = confHelper.getParameter("nomesoggrotta");
            String registrorotta = confHelper.getParameter("registrorotta");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            SoggettiCore soggettiCore = new SoggettiCore(confCore);
            ArrayList<String> tipiSoggetti = new ArrayList<String>();
            tipiSoggetti.add("-");
            tipiSoggetti.addAll(soggettiCore.getTipiSoggettiGestiti());
            String[] tipiSoggettiLabelPerProtocollo = tipiSoggettiLabel = tipiSoggetti.toArray(new String[1]);
            if (tipo != null && !"".equals(tipo) && !"-".equals(tipo)) {
                ArrayList<String> tipiSoggettiPerRotta = new ArrayList<String>();
                tipiSoggettiPerRotta.add("-");
                tipiSoggettiPerRotta.addAll(soggettiCore.getTipiSoggettiGestitiProtocollo(soggettiCore.getProtocolloAssociatoTipoSoggetto(tipo)));
                tipiSoggettiLabelPerProtocollo = tipiSoggettiPerRotta.toArray(new String[1]);
            }
            confHelper.makeMenu();
            List<AccessoRegistroRegistro> list = confCore.registriList((ISearch)new ConsoleSearch(true));
            String[] registriList = new String[list.size() + 1];
            String[] registriListLabel = new String[list.size() + 1];
            registriList[0] = "0";
            registriListLabel[0] = "all";
            int i = 1;
            for (AccessoRegistroRegistro arr : list) {
                registriList[i] = arr.getNome();
                registriListLabel[i] = arr.getNome();
                ++i;
            }
            if (confHelper.isEditModeInProgress()) {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
                lstParam.add(new Parameter("Tabella di Routing", "configurazioneRouting.do"));
                lstParam.add(new Parameter("Destinazioni", "configurazioneRouteList.do"));
                lstParam.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addValoriRottaToDati(TipoOperazione.ADD, nome, tipo, tiporotta, "all", registriList, registriListLabel, dati, "", "", tipiSoggettiLabel, tipiSoggettiLabelPerProtocollo);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneRoute", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.routingListCheckData(TipoOperazione.ADD, registriList);
            if (!isOk) {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
                lstParam.add(new Parameter("Tabella di Routing", "configurazioneRouting.do"));
                lstParam.add(new Parameter("Destinazioni", "configurazioneRouteList.do"));
                lstParam.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addValoriRottaToDati(TipoOperazione.ADD, nome, tipo, tiporotta, registrorotta, registriList, registriListLabel, dati, "", "", tipiSoggettiLabel, tipiSoggettiLabelPerProtocollo);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneRoute", (ForwardParams)ForwardParams.ADD());
            }
            RoutingTable rt = confCore.getRoutingTable();
            RoutingTableDestinazione rtd = new RoutingTableDestinazione();
            rtd.setNome(nome);
            rtd.setTipo(tipo);
            Route tmpR = new Route();
            if (tiporotta.equals("gateway")) {
                RouteGateway rg = new RouteGateway();
                rg.setTipo(tiposoggrotta);
                rg.setNome(nomesoggrotta);
                tmpR.setGateway(rg);
            } else {
                RouteRegistro rr = new RouteRegistro();
                rr.setNome(registrorotta);
                tmpR.setRegistro(rr);
            }
            rtd.addRoute(tmpR);
            rt.addDestinazione(rtd);
            confCore.performUpdateOperation(userLogin, confHelper.smista(), rt);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<RoutingTableDestinazione> lista = confCore.routingList((ISearch)ricerca);
            confHelper.prepareRoutingList((ISearch)ricerca, lista);
            pd.setMessage("Configurazione Tabella di Routing modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneRoute", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneRoute", (ForwardParams)ForwardParams.ADD());
        }
    }
}

