/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.utils.AllarmiUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.Dialog;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class ConfigurazioneSistemaAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            String allarmeOp;
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            List<String> aliases = confCore.getJmxPdDAliases();
            if (aliases == null || aliases.isEmpty()) {
                throw new DriverControlStationException("Pagina non prevista, la sezione configurazione non permette di accedere a questa pagina, se la configurazione non e' corretta");
            }
            String[] aliasNodi = confHelper.getParameterValues("aliasNodi");
            String alias = confHelper.getParameter("aliasNodo");
            String nomeCache = confHelper.getParameter("nomeCache");
            String nomeMetodo = confHelper.getParameter("nomeMetodo");
            if ((alias == null || "".equals(alias)) && aliases.size() > 1) {
                boolean error = false;
                if (!"ResetAllCaches".equals(nomeCache) || !"__resetAllCachesAllNodes__".equals(nomeMetodo)) {
                    if ("ResetSelectedCaches".equals(nomeCache) && "__resetAllCachesSelectedNodes__".equals(nomeMetodo)) {
                        if (aliasNodi == null || aliasNodi.length <= 0) {
                            pd.setMessage("L'operazione richiesta richiede la selezione di almeno un ID Cluster", MessageType.ERROR);
                            error = true;
                        }
                    } else if (!confHelper.isEditModeInProgress()) {
                        if (aliasNodi == null || aliasNodi.length <= 0) {
                            pd.setMessage("L'operazione richiesta richiede la selezione di un ID Cluster", MessageType.ERROR);
                            error = true;
                        } else if (aliasNodi.length > 1) {
                            pd.setMessage("L'operazione richiesta richiede la selezione di un solo ID Cluster; ne sono stati selezionati " + aliasNodi.length, MessageType.ERROR);
                            error = true;
                        } else {
                            alias = aliasNodi[0];
                        }
                    }
                }
                if (error) {
                    ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                    lstParam.add(new Parameter("Runtime", null));
                    ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                    List<DataElement> dati = new ArrayList<DataElement>();
                    dati.add(ServletUtils.getDataElementForEditModeFinished());
                    pd.setLabelBottoneInvia("Accedi");
                    dati = confHelper.addConfigurazioneSistemaSelectListNodiCluster(dati, aliasNodi);
                    pd.setDati(dati);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneSistema", (ForwardParams)ForwardParams.ADD());
                }
            }
            String nomeParametroPostBack = confHelper.getPostBackElementName();
            if (alias == null || "".equals(alias)) {
                if (aliases.size() == 1) {
                    alias = aliases.get(0);
                } else {
                    ArrayList<String> aliasesForResetAllCaches = null;
                    if ("ResetAllCaches".equals(nomeCache) && "__resetAllCachesAllNodes__".equals(nomeMetodo)) {
                        aliasesForResetAllCaches = new ArrayList<String>();
                        aliasesForResetAllCaches.addAll(aliases);
                        aliasNodi = null;
                    } else if ("ResetSelectedCaches".equals(nomeCache) && "__resetAllCachesSelectedNodes__".equals(nomeMetodo)) {
                        aliasesForResetAllCaches = new ArrayList();
                        if (aliasNodi != null && aliasNodi.length > 0) {
                            aliasesForResetAllCaches.addAll(Arrays.asList(aliasNodi));
                        }
                        aliasNodi = null;
                    }
                    if (aliasesForResetAllCaches != null && !aliasesForResetAllCaches.isEmpty()) {
                        boolean rilevatoErrore = false;
                        StringBuilder messagePerOperazioneEffettuataSB = new StringBuilder();
                        int index = 0;
                        for (String aliasForResetCache : aliasesForResetAllCaches) {
                            StringBuilder bfExternal = new StringBuilder();
                            String descrizione = confCore.getJmxPdDDescrizione(aliasForResetCache);
                            if (index > 0) {
                                bfExternal.append("<br/>");
                            }
                            bfExternal.append("ID Cluster").append(" ").append(descrizione).append("<br/>");
                            List<String> caches = confCore.getJmxPdDCaches(aliasForResetCache);
                            if (caches != null && !caches.isEmpty()) {
                                HashMap<String, List<String>> esitiCache = new HashMap<String, List<String>>();
                                for (String cache : caches) {
                                    String stato;
                                    block171: {
                                        stato = null;
                                        try {
                                            stato = confCore.getInvoker().readJMXAttribute(aliasForResetCache, confCore.getJmxPdDConfigurazioneSistemaType(aliasForResetCache), cache, confCore.getJmxPdDCacheNomeAttributoCacheAbilitata(aliasForResetCache));
                                            if (stato.equalsIgnoreCase("true")) {
                                                stato = "abilitata";
                                                break block171;
                                            }
                                            if (stato.equalsIgnoreCase("false")) {
                                                stato = "disabilitata";
                                                break block171;
                                            }
                                            throw new DriverControlStationException("Stato [" + stato + "] sconosciuto");
                                        }
                                        catch (Exception e) {
                                            ControlStationCore.logError("Errore durante la lettura dello stato della cache [" + cache + "](jmxResourcePdD) (node:" + aliasForResetCache + "): " + e.getMessage(), e);
                                            stato = "Informazione non disponibile";
                                            rilevatoErrore = true;
                                            this.addEsito(esitiCache, stato, cache);
                                        }
                                    }
                                    if (!"abilitata".equals(stato)) continue;
                                    Object result = null;
                                    try {
                                        String nomeMetodoResetCache = confCore.getJmxPdDCacheNomeMetodoResetCache(aliasForResetCache);
                                        result = confCore.getInvoker().invokeJMXMethod(aliasForResetCache, confCore.getJmxPdDCacheType(aliasForResetCache), cache, nomeMetodoResetCache);
                                    }
                                    catch (Exception e) {
                                        String errorMessage = this.getPrefixErrorInvokeMethod(nomeMetodo) + "sulla cache [" + nomeCache + "] (node:" + aliasForResetCache + "): " + e.getMessage();
                                        ControlStationCore.getLog().error(errorMessage, (Throwable)e);
                                        result = errorMessage;
                                        rilevatoErrore = true;
                                    }
                                    this.addEsito(esitiCache, (String)result, cache);
                                }
                                bfExternal.append(this.toString(esitiCache));
                                if (messagePerOperazioneEffettuataSB.length() > 0) {
                                    messagePerOperazioneEffettuataSB.append("<br/>");
                                }
                                messagePerOperazioneEffettuataSB.append(bfExternal.toString());
                            }
                            ++index;
                        }
                        if (messagePerOperazioneEffettuataSB != null) {
                            if (rilevatoErrore) {
                                pd.setMessage(messagePerOperazioneEffettuataSB.toString());
                            } else {
                                pd.setMessage(messagePerOperazioneEffettuataSB.toString(), Costanti.MESSAGE_TYPE_INFO);
                            }
                        }
                    }
                    ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                    lstParam.add(new Parameter("Runtime", null));
                    ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                    List<DataElement> dati = new ArrayList<DataElement>();
                    dati.add(ServletUtils.getDataElementForEditModeFinished());
                    pd.setLabelBottoneInvia("Accedi");
                    dati = confHelper.addConfigurazioneSistemaSelectListNodiCluster(dati, aliasNodi);
                    pd.setDati(dati);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneSistema", (ForwardParams)ForwardParams.ADD());
                }
            }
            String descrizioneAlias = confCore.getJmxPdDDescrizione(alias);
            Object messagePerOperazioneEffettuata = null;
            boolean rilevatoErrore = false;
            if (!(nomeCache == null || "".equals(nomeCache) || nomeMetodo == null || "".equals(nomeMetodo) || nomeParametroPostBack != null && !"".equals(nomeParametroPostBack))) {
                String nomeMetodoResetCache = confCore.getJmxPdDCacheNomeMetodoResetCache(alias);
                String nomeMetodoResetConnettoriPrioritari = confCore.getJmxPdDConfigurazioneSistemaNomeMetodoResetConnettoriPrioritari(alias);
                boolean resetMultiplo = false;
                boolean resetConnettoriPrioritari = false;
                if (nomeMetodoResetCache != null && nomeMetodoResetCache.equals(nomeMetodo)) {
                    if ("ResetAllCaches".equals(nomeCache)) {
                        resetMultiplo = true;
                    }
                } else if (nomeMetodoResetConnettoriPrioritari != null && nomeMetodoResetConnettoriPrioritari.equals(nomeMetodo)) {
                    resetConnettoriPrioritari = true;
                }
                if (resetMultiplo) {
                    HashMap<String, List<String>> esitiCache = new HashMap<String, List<String>>();
                    List<String> caches = confCore.getJmxPdDCaches(alias);
                    if (caches != null && !caches.isEmpty()) {
                        for (String cache : caches) {
                            String stato;
                            block172: {
                                stato = null;
                                try {
                                    stato = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), cache, confCore.getJmxPdDCacheNomeAttributoCacheAbilitata(alias));
                                    if (stato.equalsIgnoreCase("true")) {
                                        stato = "abilitata";
                                        break block172;
                                    }
                                    if (stato.equalsIgnoreCase("false")) {
                                        stato = "disabilitata";
                                        break block172;
                                    }
                                    throw new DriverControlStationException("Stato [" + stato + "] sconosciuto");
                                }
                                catch (Exception e) {
                                    ControlStationCore.logError("Errore durante la lettura dello stato della cache [" + cache + "](jmxResourcePdD): " + e.getMessage(), e);
                                    stato = "Informazione non disponibile";
                                    rilevatoErrore = true;
                                    this.addEsito(esitiCache, stato, cache);
                                }
                            }
                            if (!"abilitata".equals(stato)) continue;
                            Object result = null;
                            try {
                                result = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDCacheType(alias), cache, nomeMetodoResetCache);
                            }
                            catch (Exception e) {
                                String errorMessage = this.getPrefixErrorInvokeMethod(nomeMetodo) + "sulla cache [" + nomeCache + "]: " + e.getMessage();
                                ControlStationCore.getLog().error(errorMessage, (Throwable)e);
                                result = errorMessage;
                                rilevatoErrore = true;
                            }
                            this.addEsito(esitiCache, (String)result, cache);
                        }
                        messagePerOperazioneEffettuata = this.toString(esitiCache);
                    }
                } else {
                    try {
                        String result;
                        if (resetConnettoriPrioritari) {
                            result = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDCacheType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConsegnaContenutiApplicativi(alias), nomeMetodo, nomeCache);
                            messagePerOperazioneEffettuata = "Coda [" + confCore.getConsegnaNotificaCodaLabel(nomeCache) + "]: " + result;
                        } else {
                            result = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDCacheType(alias), nomeCache, nomeMetodo);
                            messagePerOperazioneEffettuata = "Cache [" + nomeCache + "]: " + result;
                        }
                    }
                    catch (Exception e) {
                        String oggetto = "cache";
                        if (resetConnettoriPrioritari) {
                            oggetto = "coda";
                        }
                        String errorMessage = this.getPrefixErrorInvokeMethod(nomeMetodo) + "sulla " + oggetto + " [" + nomeCache + "]: " + e.getMessage();
                        ControlStationCore.getLog().error(errorMessage, (Throwable)e);
                        messagePerOperazioneEffettuata = errorMessage;
                        rilevatoErrore = true;
                    }
                }
            }
            String labelDialog = null;
            String noteDialog = null;
            Object messageDialog = null;
            if ((nomeParametroPostBack == null || "".equals(nomeParametroPostBack)) && (allarmeOp = confHelper.getParameter("allarmiAttiviManager")) != null && !"".equals(allarmeOp)) {
                nomeParametroPostBack = allarmeOp;
            }
            if (nomeParametroPostBack != null && !"".equals(nomeParametroPostBack)) {
                String nomeAttributo = null;
                String nomeAttributo2 = null;
                String nomeMetodoJmx = null;
                String nomeRisorsa = null;
                Object nuovoStato = null;
                String tipo = null;
                boolean startAllarmi = false;
                boolean stopAllarmi = false;
                boolean restartAllarmi = false;
                try {
                    if ("severita".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoSeveritaDiagnostici(alias);
                        nuovoStato = confHelper.getParameter("severita");
                        tipo = "livello di severit\u00e0 dei diagnostici";
                        labelDialog = "Livello di Log su DB";
                    } else if ("severita_log4j".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoSeveritaDiagnosticiLog4j(alias);
                        nuovoStato = confHelper.getParameter("severita_log4j");
                        tipo = "livello di severit\u00e0 log4j dei diagnostici";
                        labelDialog = "Livello di Log su File";
                    } else if ("registrazioneTracce".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTracciamento(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("registrazioneTracce"));
                        tipo = "stato del tracciamento delle buste";
                        labelDialog = "Informazioni Tracciamento Buste";
                    } else if ("dumpConnettorePD".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoDumpPD(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("dumpConnettorePD"));
                        tipo = "stato del dump binario della Porta Delegata";
                        labelDialog = "Log4j Dump Binario Fruizioni";
                    } else if ("dumpConnettorePA".equals(nomeParametroPostBack)) {
                        labelDialog = "Log4j Dump Binario Erogazioni";
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoDumpPA(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("dumpConnettorePA"));
                        tipo = "stato del dump binario della Porta Applicativa";
                    } else if ("fileTraceUpdate".equals(nomeParametroPostBack)) {
                        nuovoStato = confHelper.getParameter("fileTraceUpdate");
                        if (CostantiConfigurazione.ABILITATO.getValue().equals(nuovoStato)) {
                            nomeMetodoJmx = confCore.getJmxPdDConfigurazioneSistemaNomeMetodoUpdateFileTrace(alias);
                            nomeRisorsa = confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias);
                            tipo = "update configurazione FileTrace";
                            labelDialog = "File Trace";
                        }
                    } else if ("trErrStatusCode".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorStatusCode(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("trErrStatusCode"));
                        labelDialog = tipo = "Http Header / Problem Detail";
                    } else if ("trErrStatusCodeAsSoapFault".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorUseStatusCodeAsFaultCode(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("trErrStatusCodeAsSoapFault"));
                        labelDialog = tipo = "SOAP Fault Code";
                    } else if ("trErrTypeProcessRequest".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalRequestError(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("trErrTypeProcessRequest"));
                        labelDialog = tipo = "Codici di errore 'GovWay-Transaction-ErrorType' Richiesta";
                    } else if ("trErrTypeProcessResponse".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeBadResponse(alias);
                        nomeAttributo2 = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalResponseError(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("trErrTypeProcessResponse"));
                        labelDialog = tipo = "Codici di errore 'GovWay-Transaction-ErrorType' Risposta";
                    } else if ("trErrTypeInternalError".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalError(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("trErrTypeInternalError"));
                        labelDialog = tipo = "Codici di errore 'GovWay-Transaction-ErrorType' Errori Interni";
                    } else if ("trErrDetails".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorDetails(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("trErrDetails"));
                        tipo = "Dettagli di errore puntuali 'Stato'";
                        labelDialog = "Dettagli di errore puntuali";
                    } else if ("trErrInstanceId".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorInstanceId(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("trErrInstanceId"));
                        tipo = "Claim 'instance' nei Problem 'Stato'";
                        labelDialog = "Claim 'instance' nei Problem";
                    } else if ("trErrGenerateHttpCodeSoap".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorGenerateHttpHeaderGovWayCode(alias);
                        nuovoStato = CostantiConfigurazione.ABILITATO.getValue().equals(confHelper.getParameter("trErrGenerateHttpCodeSoap"));
                        tipo = "Header http 'GovWay-Transaction-ErrorCode' su protocollo SOAP 'Stato'";
                        labelDialog = "Header http 'GovWay-Transaction-ErrorCode' su protocollo SOAP";
                    } else if ("statoServizioPD".equals(nomeParametroPostBack)) {
                        nuovoStato = confHelper.getParameter("statoServizioPD");
                        nomeMetodoJmx = CostantiConfigurazione.ABILITATO.getValue().equals(nuovoStato) ? confCore.getJmxPdDConfigurazioneSistemaNomeMetodoAbilitaServizioPortaDelegata(alias) : confCore.getJmxPdDConfigurazioneSistemaNomeMetodoDisabilitaServizioPortaDelegata(alias);
                        nomeRisorsa = confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias);
                        tipo = "stato del servizio Porta Applicativa";
                        labelDialog = "Stato Servizi Porta Delegata";
                    } else if ("statoServizioPA".equals(nomeParametroPostBack)) {
                        nuovoStato = confHelper.getParameter("statoServizioPA");
                        nomeMetodoJmx = CostantiConfigurazione.ABILITATO.getValue().equals(nuovoStato) ? confCore.getJmxPdDConfigurazioneSistemaNomeMetodoAbilitaServizioPortaApplicativa(alias) : confCore.getJmxPdDConfigurazioneSistemaNomeMetodoDisabilitaServizioPortaApplicativa(alias);
                        nomeRisorsa = confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias);
                        tipo = "stato del servizio Integration Manager";
                        labelDialog = "Stato Servizi Porta Applicativa";
                    } else if ("statoServizioIM".equals(nomeParametroPostBack)) {
                        nuovoStato = confHelper.getParameter("statoServizioIM");
                        nomeMetodoJmx = CostantiConfigurazione.ABILITATO.getValue().equals(nuovoStato) ? confCore.getJmxPdDConfigurazioneSistemaNomeMetodoAbilitaServizioIntegrationManager(alias) : confCore.getJmxPdDConfigurazioneSistemaNomeMetodoDisabilitaServizioIntegrationManager(alias);
                        nomeRisorsa = confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias);
                        tipo = "stato del servizio IntegrationManager";
                        labelDialog = "Stato Servizi Integration Manager";
                    } else if ("timerConsegnaContenutiApplicativi".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerConsegnaContenutiApplicativi(alias);
                        nuovoStato = confHelper.getParameter("timerConsegnaContenutiApplicativi");
                        tipo = "stato del timer 'Consegna Notifiche'";
                        labelDialog = "Timer Consegna Notifiche";
                    } else if ("timerGestoreMessaggiVerificaConnessioniAttive".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiVerificaConnessioniAttive(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreMessaggiVerificaConnessioniAttive");
                        tipo = "stato del timer 'Verifica Connessioni Attive'";
                        labelDialog = "Timer Verifica Connessioni Attive";
                    } else if ("timerStatisticheOrarie".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheOrarie(alias);
                        nuovoStato = confHelper.getParameter("timerStatisticheOrarie");
                        tipo = "stato del timer 'Statistiche Orarie'";
                        labelDialog = "Timer Statistiche Orarie";
                    } else if ("timerStatisticheGiornaliere".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheGiornaliere(alias);
                        nuovoStato = confHelper.getParameter("timerStatisticheGiornaliere");
                        tipo = "stato del timer 'Statistiche Giornaliere'";
                        labelDialog = "Timer Statistiche Giornaliere";
                    } else if ("timerStatisticheSettimanali".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheSettimanali(alias);
                        nuovoStato = confHelper.getParameter("timerStatisticheSettimanali");
                        tipo = "stato del timer 'Statistiche Settimanali'";
                        labelDialog = "Timer Statistiche Settimanali";
                    } else if ("timerStatisticheMensili".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheMensili(alias);
                        nuovoStato = confHelper.getParameter("timerStatisticheMensili");
                        tipo = "stato del timer 'Statistiche Mensili'";
                        labelDialog = "Timer Statistiche Mensili";
                    } else if ("timerGestoreMessaggiPuliziaMessaggiEliminati".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiEliminati(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreMessaggiPuliziaMessaggiEliminati");
                        tipo = "stato del timer 'Cancellazione Messaggi Gestiti'";
                        labelDialog = "Timer Cancellazione Messaggi Gestiti";
                    } else if ("timerGestoreMessaggiPuliziaMessaggiScaduti".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiScaduti(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreMessaggiPuliziaMessaggiScaduti");
                        tipo = "stato del timer 'Cancellazione Messaggi Scaduti'";
                        labelDialog = "Timer Cancellazione Messaggi Scaduti";
                    } else if ("timerGestoreRepositoryBuste".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreRepositoryBuste(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreRepositoryBuste");
                        tipo = "stato del timer 'Cancellazione Buste Gestite/Scadute'";
                        labelDialog = "Timer Cancellazione Buste Gestite/Scadute";
                    } else if ("timerGestoreMessaggiPuliziaCorrelazioneApplicativa".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaCorrelazioneApplicativa(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreMessaggiPuliziaCorrelazioneApplicativa");
                        tipo = "stato del timer 'Cancellazione Correlazioni Applicative Scadute'";
                        labelDialog = "Timer Cancellazione Correlazioni Applicative Scadute";
                    } else if ("timerGestoreMessaggiPuliziaMessaggiNonGestiti".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiNonGestiti(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreMessaggiPuliziaMessaggiNonGestiti");
                        tipo = "stato del timer 'Cancellazione Richieste Parziali'";
                        labelDialog = "Timer Cancellazione Richieste Parziali";
                    } else if ("timerGestorePuliziaMessaggiAnomali".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestorePuliziaMessaggiAnomali(alias);
                        nuovoStato = confHelper.getParameter("timerGestorePuliziaMessaggiAnomali");
                        tipo = "stato del timer 'Cancellazione Messaggi Inconsistenti'";
                        labelDialog = "Timer Cancellazione Messaggi Inconsistenti";
                    } else if ("timerMonitoraggioRisorseThread".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerMonitoraggioRisorseThread(alias);
                        nuovoStato = confHelper.getParameter("timerMonitoraggioRisorseThread");
                        tipo = "stato del timer 'Monitoraggio Risorse di Sistema'";
                        labelDialog = "Timer Monitoraggio Risorse di Sistema";
                    } else if ("timerThresholdThread".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerThresholdThread(alias);
                        nuovoStato = confHelper.getParameter("timerThresholdThread");
                        tipo = "stato del timer 'Monitoraggio Spazio Disco'";
                        labelDialog = "Timer Monitoraggio Spazio Disco";
                    } else if ("timerEventi".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerEventi(alias);
                        nuovoStato = confHelper.getParameter("timerEventi");
                        tipo = "stato del timer 'Generazione Eventi'";
                        labelDialog = "Timer Generazione Eventi";
                    } else if ("timerFileSystemRecovery".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerFileSystemRecovery(alias);
                        nuovoStato = confHelper.getParameter("timerFileSystemRecovery");
                        tipo = "stato del timer 'FileSystem Recovery'";
                        labelDialog = "Timer FileSystem Recovery";
                    } else if ("timerGestoreBusteOnewayNonRiscontrate".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreBusteOnewayNonRiscontrate(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreBusteOnewayNonRiscontrate");
                        tipo = "stato del timer 'Rispedizione Ack Oneway'";
                        labelDialog = "Timer Rispedizione Ack Oneway";
                    } else if ("timerGestoreBusteAsincroneNonRiscontrate".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreBusteAsincroneNonRiscontrate(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreBusteAsincroneNonRiscontrate");
                        tipo = "stato del timer 'Rispedizione Ack Asincroni'";
                        labelDialog = "Timer Rispedizione Ack Asincroni";
                    } else if ("timerRepositoryStatefulThread".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerRepositoryStatefulThread(alias);
                        nuovoStato = confHelper.getParameter("timerRepositoryStatefulThread");
                        tipo = "stato del timer 'Repository Stateful'";
                        labelDialog = "Timer Repository Stateful";
                    } else if ("timerGestoreOpRemote".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreOperazioniRemote(alias);
                        nuovoStato = confHelper.getParameter("timerGestoreOpRemote");
                        tipo = "stato del timer 'Esecuzione Operazioni Remote'";
                        labelDialog = "Timer Esecuzione Operazioni Remote";
                    } else if ("timerDeleteOpRemote".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerSvecchiamentoOperazioniRemote(alias);
                        nuovoStato = confHelper.getParameter("timerDeleteOpRemote");
                        tipo = "stato del timer 'Svecchiamento Operazioni'";
                        labelDialog = "Timer Svecchiamento Operazioni";
                    } else if ("allarmiAttiviStart".equals(nomeParametroPostBack)) {
                        startAllarmi = true;
                        tipo = "Avvia tutti gli allarmi";
                        labelDialog = "Avvio Allarmi Attivi";
                    } else if ("allarmiAttiviStop".equals(nomeParametroPostBack)) {
                        stopAllarmi = true;
                        tipo = "Termina tutti gli allarmi";
                        labelDialog = "Fermo Allarmi Attivi";
                    } else if ("allarmiAttiviRestart".equals(nomeParametroPostBack)) {
                        restartAllarmi = true;
                        tipo = "Riavvia tutti gli allarmi";
                        labelDialog = "Riavvio Allarmi Attivi";
                    } else if ("timerChiaviPDND".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreChiaviPDND(alias);
                        nuovoStato = confHelper.getParameter("timerChiaviPDND");
                        tipo = "stato del timer 'Gestione Eventi'";
                        labelDialog = "Timer Gestione Eventi Repository Chiavi PDND";
                    } else if ("timerCacheChiaviPDND".equals(nomeParametroPostBack)) {
                        nomeAttributo = confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreCacheChiaviPDND(alias);
                        nuovoStato = confHelper.getParameter("timerCacheChiaviPDND");
                        tipo = "stato del timer 'Gestione Cache'";
                        labelDialog = "Timer Gestione Cache Repository Chiavi PDND";
                    }
                    if (nomeAttributo != null) {
                        confCore.getInvoker().setJMXAttribute(alias, confCore.getJmxPdDCacheType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), nomeAttributo, nuovoStato);
                        if (nomeAttributo2 != null) {
                            confCore.getInvoker().setJMXAttribute(alias, confCore.getJmxPdDCacheType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), nomeAttributo2, nuovoStato);
                        }
                        String tmp = "Configurazione aggiornata con successo (" + tipo + "): " + nuovoStato;
                        noteDialog = "<BR><b>Attenzione:</b> Le modifiche saranno operative fino al prossimo riavvio di GovWay";
                        messagePerOperazioneEffettuata = messagePerOperazioneEffettuata != null ? (String)messagePerOperazioneEffettuata + "\n" + tmp : tmp;
                        messageDialog = confCore.isClusterAsyncUpdate() ? "Operazione effettuata con successo; " + "la richiesta \u00e8 stata registrata e verr\u00e0 evasa entro SECONDI secondi".replace("SECONDI", "" + confCore.getClusterAsyncUpdateCheckInterval()) : "Operazione effettuata con successo";
                    } else if (nomeMetodoJmx != null) {
                        String tmp = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDCacheType(alias), nomeRisorsa, nomeMetodoJmx);
                        if (!"fileTraceUpdate".equals(nomeParametroPostBack)) {
                            noteDialog = "<BR><b>Attenzione:</b> La modifica effettuata rimarr\u00e0 persistente anche dopo un riavvio di GovWay";
                        }
                        messagePerOperazioneEffettuata = messagePerOperazioneEffettuata != null ? (String)messagePerOperazioneEffettuata + "\n" + tmp : tmp;
                        messageDialog = tmp;
                    } else if (startAllarmi || stopAllarmi || restartAllarmi) {
                        AlarmEngineConfig alarmEngineConfig = confCore.getAllarmiConfig();
                        if (startAllarmi) {
                            AllarmiUtils.startActiveThreads((Logger)ControlStationCore.getLog(), (AlarmEngineConfig)alarmEngineConfig);
                        } else if (stopAllarmi) {
                            AllarmiUtils.stopActiveThreads((Logger)ControlStationCore.getLog(), (AlarmEngineConfig)alarmEngineConfig);
                        } else if (restartAllarmi) {
                            AllarmiUtils.restartActiveThreads((Logger)ControlStationCore.getLog(), (AlarmEngineConfig)alarmEngineConfig);
                        }
                        messageDialog = labelDialog + " effettuato con successo";
                        noteDialog = null;
                        messagePerOperazioneEffettuata = "Operazione effettuata con successo (" + tipo + ")";
                        Utilities.sleep((long)3000L);
                    }
                }
                catch (Exception e) {
                    String errorMessage = "Errore durante l'aggiornamento (" + tipo + "): " + e.getMessage();
                    ControlStationCore.getLog().error(errorMessage, (Throwable)e);
                    messagePerOperazioneEffettuata = messagePerOperazioneEffettuata != null ? (String)messagePerOperazioneEffettuata + "\n" + errorMessage : errorMessage;
                    rilevatoErrore = true;
                    messageDialog = "Errore durante l'aggiornamento: " + e.getMessage();
                }
            }
            if (messagePerOperazioneEffettuata != null) {
                if (nomeParametroPostBack != null && !"".equals(nomeParametroPostBack) && messageDialog != null) {
                    Dialog dialog = new Dialog();
                    dialog.setTitolo(rilevatoErrore ? "Messaggio di Errore" : "Attenzione");
                    dialog.setHeaderRiga1(labelDialog);
                    dialog.setHeaderRiga2(messageDialog);
                    StringBuilder sbNoteDialog = new StringBuilder();
                    if (noteDialog != null) {
                        sbNoteDialog.append(noteDialog);
                        if (confCore.isClusterAsyncUpdate()) {
                            sbNoteDialog.append("<br/>");
                        }
                    }
                    if (confCore.isClusterAsyncUpdate()) {
                        sbNoteDialog.append("<BR><b>Attenzione:</b> Solo dopo che l'operazione verr\u00e0 evasa il nuovo stato verr\u00e0 visualizzato in questa sezione 'Runtime'");
                    }
                    if (sbNoteDialog.length() > 0) {
                        dialog.setNotaFinale(sbNoteDialog.toString());
                    }
                    String[][] bottoni = new String[][]{{"Chiudi", ""}};
                    pd.setBottoni(bottoni);
                    pd.setDialog(dialog);
                } else if (rilevatoErrore) {
                    pd.setMessage(messagePerOperazioneEffettuata);
                } else {
                    pd.setMessage(messagePerOperazioneEffettuata, Costanti.MESSAGE_TYPE_INFO);
                }
            }
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            if (confCore.isSinglePdD()) {
                if (aliases.size() > 1) {
                    lstParam.add(new Parameter("Runtime", "configurazioneSistemaAdd.do"));
                    lstParam.add(new Parameter(descrizioneAlias, null));
                } else {
                    lstParam.add(new Parameter("Runtime", null));
                }
            } else {
                lstParam.add(new Parameter("Porte di Dominio", "pddList.do"));
                lstParam.add(new Parameter("Runtime", null));
            }
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            List<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            dati = confHelper.addConfigurazioneSistema(dati, alias);
            pd.setDati(dati);
            pd.disableOnlyButton();
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneSistema", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneSistema", (ForwardParams)ForwardParams.ADD());
        }
    }

    private void addEsito(Map<String, List<String>> esitiCache, String esito, String cache) {
        List<Object> caches = null;
        if (esitiCache.containsKey(esito)) {
            caches = esitiCache.get(esito);
        } else {
            caches = new ArrayList();
            esitiCache.put(esito, caches);
        }
        caches.add(cache);
    }

    private String toString(Map<String, List<String>> esitiCache) {
        if (esitiCache.size() == 1) {
            return esitiCache.entrySet().iterator().next().getKey();
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : esitiCache.entrySet()) {
            if (sb.length() > 0) {
                sb.append("<br/>");
            }
            List<String> caches = entry.getValue();
            sb.append("- Cache " + caches.toString() + ": " + entry.getKey());
        }
        return sb.toString();
    }

    private String getPrefixErrorInvokeMethod(String nomeMetodo) {
        return "Errore durante l'invocazione dell'operazione [" + nomeMetodo + "] ";
    }
}

