/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.transport.http.credential.IPrincipalReader;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderException;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderFactory;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderType;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.Login;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginCore;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginSessionUtilities;
import org.openspcoop2.web.ctrlstat.servlet.utils.UtilsCostanti;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public final class AuthorizationFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private ControlStationCore core = null;
    private static Logger log = ControlStationLogger.getPddConsoleCoreLogger();
    private boolean loginApplication = true;
    private IPrincipalReader principalReader = null;
    private String loginUtenteNonAutorizzatoRedirectUrl = null;
    private String loginUtenteNonValidoRedirectUrl = null;
    private String loginErroreInternoRedirectUrl = null;
    private String loginSessioneScadutaRedirectUrl = null;

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        try {
            this.core = new ControlStationCore();
        }
        catch (DriverControlStationException e) {
            AuthorizationFilter.logError(log, "Errore durante il caricamento iniziale: " + e.getMessage(), (Throwable)((Object)e));
        }
        this.loginApplication = this.core.isLoginApplication();
        boolean loginOAuth2Enabled = this.core.isLoginOAuth2Enabled();
        try {
            if (!this.loginApplication || loginOAuth2Enabled) {
                String loginTipo = this.core.getLoginTipo();
                if (StringUtils.isEmpty((String)loginTipo)) {
                    loginTipo = PrincipalReaderType.PRINCIPAL.getValue();
                }
                this.principalReader = PrincipalReaderFactory.getReader((Logger)log, (String)loginTipo);
                Properties prop = this.core.getLoginProperties();
                this.principalReader.init(new Object[]{prop});
                this.loginUtenteNonAutorizzatoRedirectUrl = this.core.getLoginUtenteNonAutorizzatoRedirectUrl();
                this.loginUtenteNonValidoRedirectUrl = this.core.getLoginUtenteNonValidoRedirectUrl();
                this.loginErroreInternoRedirectUrl = this.core.getLoginErroreInternoRedirectUrl();
                this.loginSessioneScadutaRedirectUrl = this.core.getLoginSessioneScadutaRedirectUrl();
            }
        }
        catch (PrincipalReaderException e) {
            AuthorizationFilter.logError(log, "Impossibile caricare il principal reader: " + e.getMessage(), e);
        }
        catch (Exception e) {
            AuthorizationFilter.logError(log, "Impossibile leggere la configurazione della console: " + e.getMessage(), e);
        }
        log.debug("Usa il principal per il controllo autorizzazione utente [{}]", (Object)(!this.loginApplication ? 1 : 0));
    }

    private boolean isUtilizzaGestioneUtenzeApplication() {
        return this.loginApplication || this.core.isLoginOAuth2Enabled();
    }

    /*
     * Exception decompiling
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isSessionInvalid(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getSession(false) != null && !httpServletRequest.isRequestedSessionIdValid();
    }

    private boolean isRisorsaProtetta(HttpServletRequest request) {
        String urlRichiesta = request.getRequestURI();
        HttpSession session = request.getSession(true);
        String changePwd = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"changePwdScaduta");
        if (changePwd != null && urlRichiesta.indexOf("/utentePasswordChange.do") > -1) {
            return false;
        }
        return urlRichiesta.indexOf("/login.do") == -1 && urlRichiesta.indexOf("/loginMessagePage.do") == -1 && urlRichiesta.indexOf("/images") == -1 && urlRichiesta.indexOf("/css") == -1 && urlRichiesta.indexOf("/fonts") == -1 && urlRichiesta.indexOf("/js") == -1 && urlRichiesta.indexOf("/about.do") == -1 && urlRichiesta.indexOf("/public") == -1 && urlRichiesta.indexOf("/oauth2/callback") == -1 && urlRichiesta.indexOf("/oauth2/user") == -1 && urlRichiesta.indexOf("/oauth2/loginStart") == -1;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public static void setLoginWelcomeMsg(GeneralHelper gh, HttpSession session, HttpServletRequest request, HttpServletResponse response, String servletDispatcher, LoginCore loginCore, ServletContext servletContext) throws IOException, ServletException {
        PageData pd = gh.initPageData();
        GeneralData gd = gh.initGeneralData(request, "login.do");
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        if (userLogin != null) {
            try {
                LoginHelper lH = new LoginHelper(gh.getCore(), request, pd, session);
                lH.makeMenu();
                LoginSessionUtilities.setLoginParametersSession(request, session, (ControlStationCore)loginCore, userLogin);
                ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                lH.initializeFilter(ricerca);
                Login.impostaMessaggioEsitoLogin(pd, loginCore);
                gd = gh.initGeneralData(request);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
        servletContext.getRequestDispatcher(servletDispatcher).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void setErrorMsg(GeneralHelper gh, HttpSession session, HttpServletRequest request, HttpServletResponse response, String servletDispatcher, String msgErrore, ServletContext servletContext, HttpStatus httpStatus) throws IOException, ServletException {
        AuthorizationFilter.setErrorMsg(gh, session, request, response, servletDispatcher, msgErrore, null, MessageType.ERROR, servletContext, httpStatus);
    }

    public static void setErrorMsg(GeneralHelper gh, HttpSession session, HttpServletRequest request, HttpServletResponse response, String servletDispatcher, String msgErrore, MessageType messageType, ServletContext servletContext, HttpStatus httpStatus) throws IOException, ServletException {
        AuthorizationFilter.setErrorMsg(gh, session, request, response, servletDispatcher, msgErrore, null, messageType, servletContext, httpStatus);
    }

    public static void setErrorMsg(GeneralHelper gh, HttpSession session, HttpServletRequest request, HttpServletResponse response, String servletDispatcher, String msgErrore, String msgErroreTitle, MessageType messageType, ServletContext servletContext, HttpStatus httpStatus) throws IOException, ServletException {
        PageData pd = gh.initPageData();
        GeneralData gd = gh.initGeneralData(request, "login.do");
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        if (userLogin != null) {
            try {
                LoginHelper lH = new LoginHelper(gh.getCore(), request, pd, session);
                lH.makeMenu();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (msgErrore != null) {
            pd.setMessage(msgErrore, msgErroreTitle, messageType);
        }
        if (httpStatus == null) {
            httpStatus = HttpStatus.SERVICE_UNAVAILABLE;
        }
        ServletUtils.setErrorStatusCodeInRequestAttribute((HttpServletRequest)request, (HttpStatus)httpStatus);
        ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
        servletContext.getRequestDispatcher(servletDispatcher).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static String getRedirectToMessageServlet() {
        return new Parameter("", "messagePage.do", new Parameter[]{new Parameter("mpText", "Console ripristinata con successo."), new Parameter("mpType", MessageType.INFO_SINTETICO.toString())}).getValue();
    }

    public static String getRedirectToMessageServletRefreshSessione(String contextPath, HttpStatus httpStatus) {
        return new Parameter("", contextPath + "/messagePage.do", new Parameter[]{new Parameter("mpText", "Sessione scaduta; &egrave; stata creata una nuova sessione per consentire l'utilizzo della console."), new Parameter("mpType", MessageType.INFO_SINTETICO.toString()), new Parameter("mpCode", "" + httpStatus.value())}).getValue();
    }

    private String verificaCSRF(GeneralHelper gh, HttpSession session, HttpServletRequest request, LoginHelper loginHelper) throws Exception {
        String csfrTokenFromRequest;
        String msg = null;
        if (this.isRichiestaScrittura(request, loginHelper) && !ServletUtils.verificaTokenCSRF((String)(csfrTokenFromRequest = loginHelper.getParameter("_csrf")), (HttpServletRequest)request, (HttpSession)session, (Integer)this.core.getValiditaTokenCsrf())) {
            msg = "Controllo validit&agrave; CSRF non superato, l'operazione non verr&agrave; eseguita.";
        }
        if (this.isGeneraNuovoTokenCSRF(request, loginHelper)) {
            ServletUtils.generaESalvaTokenCSRF((HttpServletRequest)request, (HttpSession)session);
        }
        return msg;
    }

    public static void setErrorCSRFMsg(GeneralHelper gh, HttpSession session, HttpServletRequest request, HttpServletResponse response, String msgErrore, ServletContext servletContext) throws IOException, ServletException {
        String servletDispatcher = "/jsplib/info.jsp";
        MessageType messageType = MessageType.ERROR;
        String msgErroreTitle = null;
        AuthorizationFilter.setErrorMsg(gh, session, request, response, servletDispatcher, msgErrore, msgErroreTitle, messageType, servletContext, HttpStatus.FORBIDDEN);
    }

    private boolean isRichiestaScrittura(HttpServletRequest request, LoginHelper loginHelper) throws DriverControlStationException {
        return !loginHelper.isPostBack() && loginHelper.getParameter("azione") != null;
    }

    private boolean isGeneraNuovoTokenCSRF(HttpServletRequest request, LoginHelper loginHelper) {
        String urlRichiesta = request.getRequestURI();
        boolean containsServletName = UtilsCostanti.getServletUtils().stream().anyMatch(name -> urlRichiesta.contains("/" + name));
        if (containsServletName) {
            ControlStationCore.logDebug("Richiesta Risorsa [" + urlRichiesta + "], Token CSRF non verra' aggiornato.");
            return false;
        }
        return true;
    }

    private boolean isRedirectToLoginAndSessioneScaduta(String urlRichiesta) {
        ArrayList<String> servletsToExclude = new ArrayList<String>();
        servletsToExclude.add("exporterArchivi");
        servletsToExclude.add("exporterDiagnostica");
        servletsToExclude.add("exporterTracce");
        servletsToExclude.add("downloadDocumento");
        servletsToExclude.add("exporterConfigurazione");
        servletsToExclude.add("downloadResoconto");
        servletsToExclude.addAll(UtilsCostanti.getServletUtils());
        boolean shouldProcessRequest = servletsToExclude.stream().noneMatch(servlet -> urlRichiesta.indexOf("/" + servlet) == -1);
        return urlRichiesta.indexOf(".do") == -1 && urlRichiesta.indexOf(".js") == -1 && shouldProcessRequest;
    }

    public static void logError(Logger log, String message, Throwable t) {
        log.error(message, t);
    }
}

