/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.utils.oauth2.OAuth2Utilities;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginCore;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginSessionUtilities;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class Logout
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        GeneralHelper generalHelper = new GeneralHelper(session);
        PageData pd = generalHelper.initPageData();
        GeneralData gd = generalHelper.initGeneralData(request, "login.do");
        try {
            String loggedUser = ServletUtils.getUserLoginFromSession((HttpSession)session);
            LoginCore loginCore = new LoginCore();
            if (loggedUser != null && !"".equals(loggedUser)) {
                loginCore.performAuditLogout(loggedUser);
            }
            String idToken = (String)session.getAttribute("oauthIdToken");
            String oauth2LogoutUrl = loginCore.getLoginProperties().getProperty("oauth2.logout.endpoint");
            LoginSessionUtilities.cleanLoginParametersSession(request, session);
            pd.setMessage("Logout effettuato con successo", Costanti.MESSAGE_TYPE_INFO_SINTETICO);
            ServletUtils.removeCookieFromResponse((String)"JSESSIONID_GW_CONSOLE", (HttpServletRequest)request, (HttpServletResponse)response);
            gd = generalHelper.initGeneralData(request, "login.do");
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            String logoutUrlDestinazione = loginCore.getLogoutUrlDestinazione();
            if (idToken != null && oauth2LogoutUrl != null) {
                String redirPageUrl = StringUtils.isNotEmpty((String)logoutUrlDestinazione) ? logoutUrlDestinazione : new Parameter("", ServletUtils.buildInternalRedirectUrl((HttpServletRequest)request, (String)"login.do"), new Parameter[]{new Parameter("mpText", "Logout effettuato con successo"), new Parameter("mpType", MessageType.INFO_SINTETICO.toString())}).getValue();
                String logoutUrl = OAuth2Utilities.creaUrlLogout((String)idToken, (String)oauth2LogoutUrl, (String)redirPageUrl);
                response.sendRedirect(logoutUrl);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"logout", (ForwardParams)ForwardParams.LOGOUT());
            }
            if (StringUtils.isBlank((String)logoutUrlDestinazione) || loginCore.isLoginApplication() && idToken == null) {
                if (loginCore.isLoginApplication()) {
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"logout", (ForwardParams)ForwardParams.LOGOUT());
                }
                pd.setMostraLinkHome(true);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"loginMessagePage", (ForwardParams)ForwardParams.LOGOUT());
            }
            response.sendRedirect(logoutUrlDestinazione);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"logout", (ForwardParams)ForwardParams.LOGOUT());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"logout", (ForwardParams)ForwardParams.LOGOUT());
        }
    }
}

