/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.operazioni;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.operazioni.OperazioniFormBean;
import org.openspcoop2.web.lib.queue.ClassQueue;
import org.openspcoop2.web.lib.queue.ClassQueueException;
import org.openspcoop2.web.lib.queue.costanti.OperationStatus;
import org.openspcoop2.web.lib.queue.dao.Operation;

public class OperazioniCore
extends ControlStationCore {
    public OperazioniCore() throws Exception {
    }

    public OperazioniCore(ControlStationCore core) throws Exception {
        super(core);
    }

    public Operation getOperation(long idOperation) throws ClassQueueException {
        Connection con = null;
        String nomeMetodo = "getOperation";
        ClassQueue driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new ClassQueue(con, this.tipoDB);
            Operation operation = driver.getOperation(idOperation);
            return operation;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new ClassQueueException(this.getPrefixError(nomeMetodo, e));
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public int updateOperation(Operation operation) throws ClassQueueException {
        Connection con = null;
        String nomeMetodo = "updateOperation";
        ClassQueue driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new ClassQueue(con, this.tipoDB);
            int n = driver.updateOperation(operation);
            return n;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new ClassQueueException(this.getPrefixError(nomeMetodo, e));
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Operation> operationsList(ConsoleSearch ricerca, OperazioniFormBean formBean, String logAdm) throws ClassQueueException {
        Connection con = null;
        String nomeMetodo = "operationsList";
        ClassQueue driver = null;
        OperationStatus os = formBean.getTipoOperationStatus();
        List<String> utenti = formBean.getUtenti();
        ricerca.addFilter(this.getIdLista(formBean), "filtroUtente", formBean.getUtente());
        String hostname = formBean.getHostname() != null ? formBean.getHostname() : "";
        String pezzoAny = formBean.getPezzoAny() != null ? formBean.getPezzoAny() : "";
        String daSql = formBean.getDataInizio() != null ? formBean.getDataInizio() : "";
        String aSql = formBean.getDataFine() != null ? formBean.getDataFine() : "";
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new ClassQueue(con, this.tipoDB);
            List list = driver.operationsList((ISearch)ricerca, os, utenti, logAdm, hostname, pezzoAny, daSql, aSql);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new ClassQueueException(this.getPrefixError(nomeMetodo, e));
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> hostnameList() throws ClassQueueException {
        Connection con = null;
        String nomeMetodo = "hostnameList";
        ClassQueue driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new ClassQueue(con, this.tipoDB);
            List list = driver.hostnameList();
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new ClassQueueException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public int getIdLista(OperazioniFormBean formBean) {
        return this.getIdLista(formBean.getTipoOperationStatus());
    }

    public int getIdLista(OperationStatus os) {
        int idLista = -1;
        if (os == null) {
            return idLista;
        }
        if (os.toString().equals("SUCCESS")) {
            idLista = Liste.OPERATIONS_ESEGUITE;
        }
        if (os.toString().equals("ERROR")) {
            idLista = Liste.OPERATIONS_FALLITE;
        }
        if (os.toString().equals("INVALID")) {
            idLista = Liste.OPERATIONS_INVALIDE;
        }
        if (os.toString().equals("NOT_SET")) {
            idLista = Liste.OPERATIONS_CODA;
        }
        if (os.toString().equals("WAIT")) {
            idLista = Liste.OPERATIONS_WAITING;
        }
        return idLista;
    }
}

