/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.operazioni;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.operazioni.OperazioniCostanti;
import org.openspcoop2.web.ctrlstat.servlet.operazioni.OperazioniFormBean;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.queue.costanti.OperationStatus;
import org.openspcoop2.web.lib.queue.dao.Operation;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.openspcoop2.web.lib.users.dao.User;

public class OperazioniHelper
extends ConsoleHelper {
    private SimpleDateFormat formatter = DateUtils.getSimpleDateFormatSecond();

    public OperazioniHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public OperazioniHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public void prepareOperazioniList(ConsoleSearch ricerca, List<Operation> lista) throws Exception {
        try {
            ArrayList<String> errors = new ArrayList<String>();
            OperazioniFormBean formBean = this.getBeanForm(errors);
            Parameter pUtente = new Parameter("user", formBean.getUtente());
            Parameter pOperazione = new Parameter("op", formBean.getTipo());
            Parameter pDetail = new Parameter("method", "details");
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"operazioni", (Parameter[])new Parameter[]{pOperazione, pUtente});
            int idLista = this.operazioniCore.getIdLista(formBean);
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            String elencoLabel = OperazioniCostanti.getTipoOperazioneLabelFromValue(formBean.getTipo());
            lstParam.add(new Parameter("Coda Configurazioni", "operazioni.do", new Parameter[]{pUtente, pOperazione}));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter(elencoLabel, null));
            } else {
                lstParam.add(new Parameter(elencoLabel, "operazioni.do", new Parameter[]{pUtente, pOperazione}));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])lstParam.toArray(new Parameter[lstParam.size()]));
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Configurazioni", (String)search);
            }
            List<String> listaLabel = this.getListaLabel(formBean);
            String[] labels = listaLabel.toArray(new String[listaLabel.size()]);
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Operation op : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    Parameter pId = new Parameter("idOp", "" + op.getId());
                    DataElement de = new DataElement();
                    de.setUrl("operazioni.do", new Parameter[]{pId, pOperazione, pUtente, pDetail});
                    de.setValue("" + op.getId());
                    de.setIdToRemove(op.getId().toString());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(op.getOperation());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(op.getHostname());
                    e.add(de);
                    User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                    if (user.getPermessi().isUtenti()) {
                        de = new DataElement();
                        de.setValue(op.getSuperUser());
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setValue(this.formatter.format(op.getTimeReq().getTime()));
                    e.add(de);
                    if (!formBean.getTipo().equals("coda")) {
                        de = new DataElement();
                        de.setValue(this.formatter.format(op.getTimeExecute().getTime()));
                        e.add(de);
                    }
                    if (formBean.getTipo().equals("eseguite")) {
                        de = new DataElement();
                        if (op.isDeleted()) {
                            de.setValue("Eliminata dall'utente");
                        } else {
                            de.setValue("");
                        }
                        e.add(de);
                    }
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(false);
            if (formBean.getTipo().equals("eseguite")) {
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            }
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private List<String> getListaLabel(OperazioniFormBean formBean) {
        ArrayList<String> listaLabel = new ArrayList<String>();
        User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
        String operazione = formBean.getTipo();
        listaLabel.add("Id");
        listaLabel.add("Tipo");
        listaLabel.add("Coda");
        if (user.getPermessi().isUtenti()) {
            listaLabel.add("Utente");
        }
        listaLabel.add("Data di Richiesta");
        if (!operazione.equals("coda")) {
            listaLabel.add("Data di Esecuzione");
        }
        if (operazione.equals("eseguite")) {
            listaLabel.add("Dettagli");
        }
        return listaLabel;
    }

    public void showForm(String azione, String soglia, OperazioniFormBean formBean) throws Exception {
        try {
            User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
            PermessiUtente permessi = user.getPermessi();
            boolean hasPermessiUtenti = permessi.isUtenti();
            ServletUtils.setPageDataTitle_ServletFirst((PageData)this.pd, (String)"Coda Configurazioni", (String)"operazioni.do");
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            String[] tipoOperazioneValori = OperazioniCostanti.getParametroOperazioniOperazioneList();
            String[] tipoOperazioneLabel = OperazioniCostanti.getLabelParametroOperazioniOperazioneList();
            DataElement de = new DataElement();
            de.setLabel("Tipo");
            de.setValues(tipoOperazioneValori);
            de.setLabels(tipoOperazioneLabel);
            de.setSelected(formBean.getTipo());
            de.setType(DataElementType.SELECT);
            de.setName("op");
            if (!hasPermessiUtenti) {
                de.setSize(this.getSize());
            }
            dati.add(de);
            de = new DataElement();
            if (hasPermessiUtenti) {
                de.setLabel("Filtro Ricerca");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.SELECT);
                List<User> listaUser = formBean.getListaUser();
                ArrayList<String> utentiLabels = new ArrayList<String>();
                ArrayList<String> utentiValues = new ArrayList<String>();
                if (listaUser != null && !listaUser.isEmpty()) {
                    for (User ut : listaUser) {
                        utentiLabels.add(ut.getLogin());
                        utentiValues.add(ut.getLogin());
                    }
                }
                utentiLabels.add(0, "--");
                utentiValues.add(0, "*");
                de.setLabels(utentiLabels);
                de.setValues(utentiValues);
                de.setSelected(formBean.getUtente());
            } else {
                de.setValue(formBean.getUtente());
                de.setType(DataElementType.HIDDEN);
            }
            de.setLabel("Utente");
            de.setName("user");
            dati.add(de);
            this.pd.setDati(dati);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public OperazioniFormBean getBeanForm(List<String> errors) throws Exception {
        try {
            OperazioniFormBean form = null;
            String operazione = null;
            boolean trovato = false;
            operazione = this.getParameter("op");
            if (operazione == null || operazione.equals("")) {
                operazione = "coda";
            }
            String[] tipiOperazione = OperazioniCostanti.getParametroOperazioniOperazioneList();
            for (int i = 0; i < tipiOperazione.length && !trovato; ++i) {
                if (!operazione.equals(tipiOperazione[i])) continue;
                trovato = true;
            }
            if (!trovato) {
                errors.add("Tipo selezionato sconosciuto. Selezionare un tipo tra: In Coda, Eseguite, In Attesa, Invalideo Fallite.");
                throw new Exception("Tipo Operazione selezionato SCONOSCIUTO.");
            }
            form = new OperazioniFormBean();
            form.setTipo(operazione);
            String idOperazione = this.getParameter("idOp");
            if (idOperazione != null && !idOperazione.equals("")) {
                form.setIdOperazione(idOperazione);
            }
            String utente = this.getParameter("user");
            ArrayList<User> userList = new ArrayList();
            String utenteTmp = null;
            HttpSession session = this.request.getSession(true);
            User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)session);
            PermessiUtente permessi = user.getPermessi();
            if (permessi.isUtenti()) {
                utenteTmp = "*";
                userList = this.utentiCore.userList((ISearch)new ConsoleSearch(true));
            } else {
                utenteTmp = user.getLogin();
                userList = new ArrayList();
            }
            if (utente == null) {
                form.setUtente(utenteTmp);
            } else {
                form.setUtente(utente);
            }
            form.setListaUser(userList);
            String metodo = this.getParameter("method");
            if (metodo == null) {
                metodo = "form";
            }
            form.setMethod(metodo);
            return form;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public List<Parameter> getFormBeanAsParameters(OperazioniFormBean formBean) {
        ArrayList<Parameter> listaParametri = new ArrayList<Parameter>();
        if (formBean.getTipo() != null) {
            listaParametri.add(new Parameter("op", formBean.getTipo()));
        }
        if (formBean.getMethod() != null) {
            listaParametri.add(new Parameter("method", formBean.getMethod()));
        }
        if (formBean.getUtente() != null) {
            listaParametri.add(new Parameter("user", formBean.getUtente()));
        }
        return listaParametri;
    }

    public void showDettagliMessaggio(Operation op, OperazioniFormBean formBean) throws Exception {
        try {
            List<Parameter> lstUrlParam = this.getFormBeanAsParameters(formBean);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Coda Configurazioni", "operazioni.do", lstUrlParam));
            String elencoLabel = OperazioniCostanti.getTipoOperazioneLabelFromValue(formBean.getTipo());
            lstParam.add(new Parameter(elencoLabel, "operazioniList.do", lstUrlParam));
            lstParam.add(new Parameter(op.getOperation() + " (" + op.getId() + ") - " + op.getHostname(), null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            DataElement de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Dettagli");
            dati.add(de);
            DataElement timereq = new DataElement();
            timereq.setLabel("Richiesta il ");
            timereq.setValue("" + op.getTimeReq());
            dati.add(timereq);
            if (OperationStatus.NOT_SET.equals((Object)op.getStatus())) {
                String tmpDet = op.getDetails();
                if (tmpDet != null && !tmpDet.equals("")) {
                    DataElement errore = new DataElement();
                    errore.setLabel("Errore");
                    errore.setValue(this.formatDetail(op.getDetails()));
                    errore.setName("errore");
                    dati.add(errore);
                }
            } else {
                DataElement timexecute = new DataElement();
                if (op.isDeleted()) {
                    timexecute.setLabel("Eliminata il");
                } else {
                    timexecute.setLabel("Eseguita il");
                }
                timexecute.setValue("" + op.getTimeExecute());
                timexecute.setName("timexecute");
                dati.add(timexecute);
            }
            if (OperationStatus.ERROR.equals((Object)op.getStatus()) || OperationStatus.INVALID.equals((Object)op.getStatus()) || OperationStatus.WAIT.equals((Object)op.getStatus())) {
                DataElement errore = new DataElement();
                errore.setLabel("Errore");
                errore.setValue(this.formatDetail(op.getDetails()));
                errore.setName("errore");
                dati.add(errore);
            }
            if (OperationStatus.WAIT.equals((Object)op.getStatus())) {
                DataElement timeWait = new DataElement();
                timeWait.setLabel("Waiting Time");
                Object tw = "";
                String val = op.getStatus().toString();
                if (val.equals("WAIT")) {
                    tw = "" + op.getWaitTime();
                }
                timeWait.setValue((String)tw);
                timeWait.setName("waitTime");
                dati.add(timeWait);
            }
            DataElement partitle = new DataElement();
            partitle.setType(DataElementType.TITLE);
            partitle.setLabel("Parametri");
            dati.add(partitle);
            org.openspcoop2.web.lib.queue.dao.Parameter[] parList = op.getParameters();
            for (int i = 0; i < parList.length; ++i) {
                org.openspcoop2.web.lib.queue.dao.Parameter singlePar = parList[i];
                DataElement par = new DataElement();
                String name = singlePar.getName();
                par.setLabel(name);
                if (name.equals("Password") || name.equals("NuovaPassword")) {
                    par.setValue("********");
                } else {
                    par.setValue(singlePar.getValue());
                }
                par.setType(DataElementType.TEXT);
                par.setName("par");
                dati.add(par);
            }
            this.pd.setDati(dati);
            this.pd.setMode("view-noeditbutton");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private String formatDetail(String detail) {
        if (detail == null) {
            return null;
        }
        return detail.replaceAll("\n", "<br/>");
    }
}

