/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.AutorizzazioneRuoli;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.GestioneTokenAutenticazione;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.MtomProcessorFlowParameter;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetti;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneToken;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaSoggetto;
import org.openspcoop2.core.config.TrasformazioneRegolaParametro;
import org.openspcoop2.core.config.TrasformazioneRegolaRisposta;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.config.constants.RuoloTipologia;
import org.openspcoop2.core.config.constants.ScopeTipoMatch;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mvc.properties.utils.DBPropertiesUtils;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.AzioneSintetica;
import org.openspcoop2.core.registry.beans.OperationSintetica;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.web.ctrlstat.core.AutorizzazioneUtilities;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class PorteApplicativeCore
extends ControlStationCore {
    private static boolean showGroup = true;

    public PorteApplicativeCore() throws DriverControlStationException {
    }

    public PorteApplicativeCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    public void configureControlloAccessiPortaApplicativa(PortaApplicativa pa, String erogazioneAutenticazione, String erogazioneAutenticazioneOpzionale, TipoAutenticazionePrincipal erogazioneAutenticazionePrincipal, List<String> erogazioneAutenticazioneParametroList, String erogazioneAutorizzazione, String erogazioneAutorizzazioneAutenticati, String erogazioneAutorizzazioneRuoli, String erogazioneAutorizzazioneRuoliTipologia, String erogazioneAutorizzazioneRuoliMatch, String nomeSA, String erogazioneRuolo, IDSoggetto idErogazioneSoggettoAutenticato, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken, String erogazioneAutorizzazioneTokenOptions, String erogazioneAutorizzazioneScope, String erogazioneScope, String erogazioneAutorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String identificazioneAttributiStato, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi) {
        ScopeTipoMatch scopeTipoMatch;
        RuoloTipoMatch tipoRuoloMatch;
        pa.setAutenticazione(erogazioneAutenticazione);
        if (erogazioneAutenticazioneOpzionale != null) {
            if (ServletUtils.isCheckBoxEnabled((String)erogazioneAutenticazioneOpzionale)) {
                pa.setAutenticazioneOpzionale(StatoFunzionalita.ABILITATO);
            } else {
                pa.setAutenticazioneOpzionale(StatoFunzionalita.DISABILITATO);
            }
        } else {
            pa.setAutenticazioneOpzionale(null);
        }
        pa.getProprietaAutenticazioneList().clear();
        List<Proprieta> proprietaAutenticazione = this.convertToAutenticazioneProprieta(erogazioneAutenticazione, erogazioneAutenticazionePrincipal, erogazioneAutenticazioneParametroList);
        if (proprietaAutenticazione != null && !proprietaAutenticazione.isEmpty()) {
            pa.getProprietaAutenticazioneList().addAll(proprietaAutenticazione);
        }
        pa.setAutorizzazione(AutorizzazioneUtilities.convertToTipoAutorizzazioneAsString(erogazioneAutorizzazione, ServletUtils.isCheckBoxEnabled((String)erogazioneAutorizzazioneAutenticati), ServletUtils.isCheckBoxEnabled((String)erogazioneAutorizzazioneRuoli), ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticatiToken), ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoliToken), ServletUtils.isCheckBoxEnabled((String)erogazioneAutorizzazioneScope), erogazioneAutorizzazioneTokenOptions, org.openspcoop2.core.registry.constants.RuoloTipologia.toEnumConstant((String)erogazioneAutorizzazioneRuoliTipologia)));
        if (erogazioneAutorizzazione != null && erogazioneAutorizzazione.equals("xacml-Policy") && allegatoXacmlPolicy.getValue() != null) {
            pa.setXacmlPolicy(new String(allegatoXacmlPolicy.getValue()));
        } else {
            pa.setXacmlPolicy(null);
        }
        if (erogazioneAutorizzazioneRuoliMatch != null && !"".equals(erogazioneAutorizzazioneRuoliMatch) && (tipoRuoloMatch = RuoloTipoMatch.toEnumConstant((String)erogazioneAutorizzazioneRuoliMatch)) != null) {
            if (pa.getRuoli() == null) {
                pa.setRuoli(new AutorizzazioneRuoli());
            }
            pa.getRuoli().setMatch(tipoRuoloMatch);
        }
        if (nomeSA != null && !"".equals(nomeSA) && !"-".equals(nomeSA)) {
            PortaApplicativaServizioApplicativo sa = new PortaApplicativaServizioApplicativo();
            sa.setNome(nomeSA);
            pa.addServizioApplicativo(sa);
        }
        if (erogazioneRuolo != null && !"".equals(erogazioneRuolo) && !"-".equals(erogazioneRuolo)) {
            if (pa.getRuoli() == null) {
                pa.setRuoli(new AutorizzazioneRuoli());
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(erogazioneRuolo);
            pa.getRuoli().addRuolo(ruolo);
        }
        if (idErogazioneSoggettoAutenticato != null) {
            if (pa.getSoggetti() == null) {
                pa.setSoggetti(new PortaApplicativaAutorizzazioneSoggetti());
            }
            PortaApplicativaAutorizzazioneSoggetto soggetto = new PortaApplicativaAutorizzazioneSoggetto();
            soggetto.setTipo(idErogazioneSoggettoAutenticato.getTipo());
            soggetto.setNome(idErogazioneSoggettoAutenticato.getNome());
            pa.getSoggetti().addSoggetto(soggetto);
        }
        if (ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticatiToken)) {
            if (pa.getAutorizzazioneToken() == null) {
                pa.setAutorizzazioneToken(new PortaApplicativaAutorizzazioneToken());
            }
            pa.getAutorizzazioneToken().setAutorizzazioneApplicativi(StatoFunzionalita.ABILITATO);
        } else if (pa.getAutorizzazioneToken() != null) {
            pa.getAutorizzazioneToken().setAutorizzazioneApplicativi(null);
            pa.getAutorizzazioneToken().setServiziApplicativi(null);
        }
        if (ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoliToken)) {
            if (pa.getAutorizzazioneToken() == null) {
                pa.setAutorizzazioneToken(new PortaApplicativaAutorizzazioneToken());
            }
            pa.getAutorizzazioneToken().setAutorizzazioneRuoli(StatoFunzionalita.ABILITATO);
            if (autorizzazioneRuoliTipologiaToken != null && !"".equals(autorizzazioneRuoliTipologiaToken)) {
                RuoloTipologia ruoloTipologia = RuoloTipologia.toEnumConstant((String)autorizzazioneRuoliTipologiaToken);
                pa.getAutorizzazioneToken().setTipologiaRuoli(ruoloTipologia);
            } else {
                pa.getAutorizzazioneToken().setTipologiaRuoli(null);
            }
            if (autorizzazioneRuoliMatchToken != null && !"".equals(autorizzazioneRuoliMatchToken)) {
                RuoloTipoMatch ruoloTipoMatch = RuoloTipoMatch.toEnumConstant((String)autorizzazioneRuoliMatchToken);
                if (ruoloTipoMatch != null) {
                    if (pa.getAutorizzazioneToken().getRuoli() == null) {
                        pa.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
                    }
                    pa.getAutorizzazioneToken().getRuoli().setMatch(ruoloTipoMatch);
                } else if (pa.getAutorizzazioneToken().getRuoli() != null) {
                    pa.getAutorizzazioneToken().getRuoli().setMatch(null);
                }
            } else if (pa.getAutorizzazioneToken().getRuoli() != null) {
                pa.getAutorizzazioneToken().getRuoli().setMatch(null);
            }
        } else if (pa.getAutorizzazioneToken() != null) {
            pa.getAutorizzazioneToken().setAutorizzazioneRuoli(null);
            pa.getAutorizzazioneToken().setTipologiaRuoli(null);
            pa.getAutorizzazioneToken().setRuoli(null);
        }
        if (ServletUtils.isCheckBoxEnabled((String)erogazioneAutorizzazioneScope)) {
            if (pa.getScope() == null) {
                pa.setScope(new AutorizzazioneScope());
            }
            pa.getScope().setStato(StatoFunzionalita.ABILITATO);
        } else {
            pa.setScope(null);
        }
        if (erogazioneScope != null && !"".equals(erogazioneScope) && !"-".equals(erogazioneScope)) {
            if (pa.getScope() == null) {
                pa.setScope(new AutorizzazioneScope());
            }
            Scope scope = new Scope();
            scope.setNome(erogazioneScope);
            pa.getScope().addScope(scope);
        }
        if (erogazioneAutorizzazioneScopeMatch != null && !"".equals(erogazioneAutorizzazioneScopeMatch) && (scopeTipoMatch = ScopeTipoMatch.toEnumConstant((String)erogazioneAutorizzazioneScopeMatch)) != null) {
            if (pa.getScope() == null) {
                pa.setScope(new AutorizzazioneScope());
            }
            pa.getScope().setMatch(scopeTipoMatch);
        }
        while (pa.sizeAttributeAuthorityList() > 0) {
            pa.removeAttributeAuthority(0);
        }
        if (StatoFunzionalita.ABILITATO.getValue().equals(identificazioneAttributiStato) && attributeAuthoritySelezionate != null && attributeAuthoritySelezionate.length > 0) {
            for (String aaName : attributeAuthoritySelezionate) {
                pa.addAttributeAuthority(this.buildAttributeAuthority(attributeAuthoritySelezionate.length, aaName, attributeAuthorityAttributi));
            }
        }
    }

    public void configureControlloAccessiGestioneToken(PortaApplicativa portaApplicativa, String gestioneToken, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, String autorizzazioneTokenOptions) {
        if (portaApplicativa.getGestioneToken() == null) {
            portaApplicativa.setGestioneToken(new GestioneToken());
        }
        if (gestioneToken != null && gestioneToken.equals(StatoFunzionalita.ABILITATO.getValue())) {
            portaApplicativa.getGestioneToken().setPolicy(gestioneTokenPolicy);
            if (ServletUtils.isCheckBoxEnabled((String)gestioneTokenOpzionale)) {
                portaApplicativa.getGestioneToken().setTokenOpzionale(StatoFunzionalita.ABILITATO);
            } else {
                portaApplicativa.getGestioneToken().setTokenOpzionale(StatoFunzionalita.DISABILITATO);
            }
            portaApplicativa.getGestioneToken().setValidazione(StatoFunzionalitaConWarning.toEnumConstant((String)gestioneTokenValidazioneInput));
            portaApplicativa.getGestioneToken().setIntrospection(StatoFunzionalitaConWarning.toEnumConstant((String)gestioneTokenIntrospection));
            portaApplicativa.getGestioneToken().setUserInfo(StatoFunzionalitaConWarning.toEnumConstant((String)gestioneTokenUserInfo));
            portaApplicativa.getGestioneToken().setForward(StatoFunzionalita.toEnumConstant((String)gestioneTokenForward));
            portaApplicativa.getGestioneToken().setOptions(autorizzazioneTokenOptions);
            if (portaApplicativa.getGestioneToken().getAutenticazione() == null) {
                portaApplicativa.getGestioneToken().setAutenticazione(new GestioneTokenAutenticazione());
            }
            portaApplicativa.getGestioneToken().getAutenticazione().setIssuer(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenIssuer) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenIssuer));
            portaApplicativa.getGestioneToken().getAutenticazione().setClientId(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenClientId) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenClientId));
            portaApplicativa.getGestioneToken().getAutenticazione().setSubject(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenSubject) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenSubject));
            portaApplicativa.getGestioneToken().getAutenticazione().setUsername(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenUsername) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenUsername));
            portaApplicativa.getGestioneToken().getAutenticazione().setEmail(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenEMail) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.toEnumConstant((String)autenticazioneTokenEMail));
        } else {
            portaApplicativa.getGestioneToken().setPolicy(null);
            portaApplicativa.getGestioneToken().setTokenOpzionale(StatoFunzionalita.DISABILITATO);
            portaApplicativa.getGestioneToken().setValidazione(StatoFunzionalitaConWarning.DISABILITATO);
            portaApplicativa.getGestioneToken().setIntrospection(StatoFunzionalitaConWarning.DISABILITATO);
            portaApplicativa.getGestioneToken().setUserInfo(StatoFunzionalitaConWarning.DISABILITATO);
            portaApplicativa.getGestioneToken().setForward(StatoFunzionalita.DISABILITATO);
            portaApplicativa.getGestioneToken().setOptions(null);
            if (portaApplicativa.getGestioneToken().getAutenticazione() != null) {
                portaApplicativa.getGestioneToken().setAutenticazione(null);
            }
        }
    }

    public List<PortaApplicativa> porteAppWithServizio(long idSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppWithTipoNomeServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppWithServizio(idSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPortaApplicativa";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            PortaApplicativa portaApplicativa = driver.getDriverConfigurazioneDB().getPortaApplicativa(idPA);
            return portaApplicativa;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ProprietaOggetto getProprietaOggetto(IDPortaApplicativa idPA) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getProprietaOggetto";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ProprietaOggetto proprietaOggetto = driver.getDriverConfigurazioneDB().getProprietaOggetto(idPA);
            return proprietaOggetto;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void updateProprietaOggetto(IDPortaApplicativa idPA, String user) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "updateProprietaOggetto";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            driver.getDriverConfigurazioneDB().updateProprietaOggetto(idPA, user);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativa> porteAppList(long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppList(idSoggetto, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativa> porteAppList(String superUser, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppList(superUser, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativa> getPorteApplicativeBySoggettoVirtuale(IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPorteApplicativeBySoggettoVirtuale";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPorteApplicativeBySoggettoVirtuale(soggettoVirtuale);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e));
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteAppPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppPropList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> nomiProprietaPA(String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoServiziProtocollo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "nomiProprietaPA";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().nomiProprietaPA(filterSoggettoTipo, filterSoggettoNome, tipoServiziProtocollo);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ServizioApplicativo> porteAppServizioApplicativoList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppServizioApplicativoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppServizioApplicativoList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativaAutorizzazioneSoggetto> porteAppSoggettoList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppSoggettoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppSoggettoList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativaAutorizzazioneServizioApplicativo> porteAppServiziApplicativiAutorizzatiList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppServiziApplicativiAutorizzatiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppServiziApplicativiAutorizzatiList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativaAutorizzazioneServizioApplicativo> porteAppServiziApplicativiAutorizzatiTokenList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppServiziApplicativiAutorizzatiTokenList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppServiziApplicativiAutorizzatiTokenList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MessageSecurityFlowParameter> porteAppMessageSecurityRequestList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppMessageSecurityRequestList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppMessageSecurityRequestList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativa> porteAppWithIdServizio(long idServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppWithIdServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppWithIdServizio(idServizio);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MessageSecurityFlowParameter> porteAppMessageSecurityResponseList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppMessageSecurityResponseList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppMessageSecurityResponseList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<CorrelazioneApplicativaElemento> porteApplicativeCorrelazioneApplicativaList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeCorrelazioneApplicativaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeCorrelazioneApplicativaList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<CorrelazioneApplicativaRispostaElemento> porteApplicativeCorrelazioneApplicativaRispostaList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeCorrelazioneApplicativaRispostaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeCorrelazioneApplicativaRispostaList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e));
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativaAzione> porteAppAzioneList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppAzioneList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteAppAzioneList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public PortaApplicativa getPortaApplicativa(long idPortaApplicativa) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPortaApplicativa";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            PortaApplicativa portaApplicativa = driver.getDriverConfigurazioneDB().getPortaApplicativa(idPortaApplicativa);
            return portaApplicativa;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsPortaApplicativa";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativa(idPA);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsPortaApplicativa(IDServizio idServizio, boolean ricercaPuntuale) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsPortaApplicativa (ricercaPuntuale)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPorteApplicative(idServizio, ricercaPuntuale);
            boolean bl = list != null && !list.isEmpty();
            return bl;
        }
        catch (DriverConfigurazioneNotFound nfe) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsPortaApplicativaVirtuale(IDServizio idServizio, IDSoggetto soggettoVirtuale, boolean ricercaPuntuale) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsPortaApplicativa_soggettoVirtuale (ricercaPuntuale)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPorteApplicativeVirtuali(soggettoVirtuale, idServizio, ricercaPuntuale);
            boolean bl = list != null && !list.isEmpty();
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsPortaApplicativaAzione(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsPortaApplicativaAzione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaAzione(nome);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean azioneUsataInTrasformazioniPortaApplicativa(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "azioneUsataInTrasformazioniPortaApplicativa";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().azioneUsataInTrasformazioniPortaApplicativa(nome);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MappingErogazionePortaApplicativa> getMappingConGruppiPerAzione(String nomeAzione, List<IDServizio> list) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getMappingConGruppiPerAzione";
        try {
            con = ControlStationCore.dbM.getConnection();
            ArrayList<MappingErogazionePortaApplicativa> listInUtilizzo = new ArrayList<MappingErogazionePortaApplicativa>();
            if (list != null && !list.isEmpty()) {
                for (IDServizio idServizio : list) {
                    List lPA = DBMappingUtils.mappingErogazionePortaApplicativaList((Connection)con, (String)this.tipoDB, (IDServizio)idServizio, (boolean)false);
                    if (lPA == null || lPA.isEmpty()) continue;
                    for (MappingErogazionePortaApplicativa mapping : lPA) {
                        try {
                            PortaApplicativa pa = this.getPortaApplicativa(mapping.getIdPortaApplicativa());
                            if (pa == null || pa.getAzione() == null || pa.getAzione().getAzioneDelegataList() == null || !pa.getAzione().getAzioneDelegataList().contains(nomeAzione)) continue;
                            listInUtilizzo.add(mapping);
                        }
                        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                    }
                }
            }
            ArrayList<MappingErogazionePortaApplicativa> arrayList = listInUtilizzo;
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MappingErogazionePortaApplicativa> getMapping(List<IDServizio> list, boolean addDefault, boolean addNotDefault) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getMapping";
        try {
            con = ControlStationCore.dbM.getConnection();
            ArrayList<MappingErogazionePortaApplicativa> listMappingDefault = new ArrayList<MappingErogazionePortaApplicativa>();
            if (list != null && !list.isEmpty()) {
                for (IDServizio idServizio : list) {
                    List lPA = DBMappingUtils.mappingErogazionePortaApplicativaList((Connection)con, (String)this.tipoDB, (IDServizio)idServizio, (boolean)false);
                    if (lPA == null || lPA.isEmpty()) continue;
                    for (MappingErogazionePortaApplicativa mapping : lPA) {
                        if (mapping.isDefault()) {
                            if (!addDefault) continue;
                            listMappingDefault.add(mapping);
                            continue;
                        }
                        if (!addNotDefault) continue;
                        listMappingDefault.add(mapping);
                    }
                }
            }
            ArrayList<MappingErogazionePortaApplicativa> arrayList = listMappingDefault;
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDPortaApplicativa> getPortaApplicativaAzione(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        String nomeMetodo = "getPortaApplicativaAzione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPortaApplicativaAzione(nome);
            return list;
        }
        catch (DriverConfigurazioneNotFound dNotF) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] Exception :" + dNotF.getMessage(), dNotF);
            throw dNotF;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativa> getPorteApplicativaByIdProprietario(long idProprietario) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPorteApplicativaByIdProprietario";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPorteApplicativaByIdProprietario(idProprietario);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativa> getPorteApplicativeWithServizio(Long idServizio, String tiposervizio, String nomeservizio, Integer versioneServizio, Long idSoggetto, String tiposoggetto, String nomesoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPorteApplicativeWithServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getPorteApplicativeWithServizio(idServizio, tiposervizio, nomeservizio, versioneServizio, idSoggetto, tiposoggetto, nomesoggetto);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public PortaApplicativa getPortaApplicativaWithSoggettoAndServizio(String nome, Long idSoggetto, Long idServizio, String tipoServizio, String nomeServizio, Integer versioneServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getPortaApplicativaWithSoggettoAndServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            PortaApplicativa portaApplicativa = driver.getDriverConfigurazioneDB().getPortaApplicativaWithSoggettoAndServizio(nome, idSoggetto, idServizio, tipoServizio, nomeServizio, versioneServizio);
            return portaApplicativa;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MtomProcessorFlowParameter> porteApplicativeMTOMRequestList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeMTOMRequestList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeMTOMRequestList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MtomProcessorFlowParameter> porteApplicativeMTOMResponseList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeMTOMResponseList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeMTOMResponseList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public IDPortaApplicativa getIDPortaApplicativaAssociataDefault(IDServizio idServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIDPortaApplicativaAssociataDefault";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDPortaApplicativa iDPortaApplicativa = driver.getIDPortaApplicativaAssociataDefault(idServizio);
            return iDPortaApplicativa;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public IDPortaApplicativa getIDPortaApplicativaAssociataAzione(IDServizio idServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIDPortaApplicativaAssociataAzione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDPortaApplicativa iDPortaApplicativa = driver.getIDPortaApplicativaAssociataAzione(idServizio);
            return iDPortaApplicativa;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDPortaApplicativa> getIDPorteApplicativeAssociate(IDServizio idServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIDPorteApplicativeAssociate";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<IDPortaApplicativa> list = driver.getIDPorteApplicativeAssociate(idServizio);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsMappingErogazionePortaApplicativa(MappingErogazionePortaApplicativa mapping) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsMappingErogazionePortaApplicativa";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.existsMappingErogazionePortaApplicativa(mapping);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void aggiornaDescrizioneMappingErogazionePortaApplicativa(MappingErogazionePortaApplicativa mapping, String user) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "aggiornaDescrizioneMappingErogazionePortaApplicativa";
        try {
            con = ControlStationCore.dbM.getConnection();
            DBMappingUtils.updateMappingErogazione((long)mapping.getTableId(), (String)mapping.getDescrizione(), (Connection)con, (String)this.tipoDB);
            if (mapping.getIdPortaApplicativa() != null) {
                this.updateProprietaOggetto(mapping.getIdPortaApplicativa(), user);
            }
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public MappingErogazionePortaApplicativa getMappingErogazionePortaApplicativa(PortaApplicativa pa) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getMappingErogazionePortaApplicativa";
        try {
            con = ControlStationCore.dbM.getConnection();
            IDPortaApplicativa idPA = new IDPortaApplicativa();
            idPA.setNome(pa.getNome());
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
            MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = DBMappingUtils.getMappingErogazione((IDServizio)idServizio, (IDPortaApplicativa)idPA, (Connection)con, (String)this.tipoDB);
            return mappingErogazionePortaApplicativa;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MappingErogazionePortaApplicativa> countMappingErogazionePortaApplicativa(IDServizio idServizio) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "countMappingErogazionePortaApplicativa";
        try {
            con = ControlStationCore.dbM.getConnection();
            List list = DBMappingUtils.mappingErogazionePortaApplicativaList((Connection)con, (String)this.tipoDB, (IDServizio)idServizio, (boolean)false);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public static boolean isShowGroup() {
        return showGroup;
    }

    public static void setShowGroup(boolean showGroup) {
        PorteApplicativeCore.showGroup = showGroup;
    }

    public String getLabelRegolaMappingErogazionePortaApplicativa(String functionDi, String function, PortaApplicativa pa) throws DriverConfigurazioneException {
        return this.getLabelRegolaMappingErogazionePortaApplicativa(functionDi, function, pa, 50, false);
    }

    public String getLabelRegolaMappingErogazionePortaApplicativa(String functionDi, String function, PortaApplicativa pa, boolean forceGroupName) throws DriverConfigurazioneException {
        return this.getLabelRegolaMappingErogazionePortaApplicativa(functionDi, function, pa, 50, forceGroupName);
    }

    public String getLabelRegolaMappingErogazionePortaApplicativa(String functionDi, String function, PortaApplicativa pa, int sizeSubstring) throws DriverConfigurazioneException {
        return this.getLabelRegolaMappingErogazionePortaApplicativa(functionDi, function, pa, sizeSubstring, false);
    }

    public String getLabelRegolaMappingErogazionePortaApplicativa(String functionDi, String function, PortaApplicativa pa, int sizeSubstring, boolean forceGroupName) throws DriverConfigurazioneException {
        List listaAzioni;
        MappingErogazionePortaApplicativa mapping;
        String prefix = "";
        if (functionDi != null) {
            prefix = functionDi;
            if (showGroup) {
                prefix = this.convertPrefixConfigDelGruppo(prefix);
            }
        }
        if ((mapping = this.getMappingErogazionePortaApplicativa(pa)).isDefault()) {
            if (this.countMappingErogazionePortaApplicativa(mapping.getIdServizio()).size() > 1 || forceGroupName) {
                if (showGroup) {
                    return prefix + this.getLabelGroup(mapping.getDescrizione());
                }
                return prefix + "Default";
            }
            return function != null ? function : "Default";
        }
        if (showGroup) {
            StringBuilder sb = new StringBuilder(mapping.getDescrizione());
            if (sb.length() > sizeSubstring) {
                return prefix + this.getLabelGroup(sb.toString().substring(0, sizeSubstring - 3) + "...");
            }
            return prefix + this.getLabelGroup(sb.toString());
        }
        List list = listaAzioni = pa.getAzione() != null ? pa.getAzione().getAzioneDelegataList() : new ArrayList();
        if (!listaAzioni.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String string : listaAzioni) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(string);
            }
            if (sb.length() > sizeSubstring) {
                return prefix + sb.toString().substring(0, sizeSubstring - 3) + "...";
            }
            return prefix + sb.toString();
        }
        return prefix + "???";
    }

    public List<IDPortaApplicativa> getAllIdPorteApplicative(FiltroRicercaPorteApplicative filtroRicerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getAllIdPorteApplicative";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getAllIdPorteApplicative(filtroRicerca);
            return list;
        }
        catch (DriverConfigurazioneNotFound notFound) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] Exception :" + notFound.getMessage(), notFound);
            ArrayList<IDPortaApplicativa> arrayList = new ArrayList<IDPortaApplicativa>();
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> portaApplicativaRuoliList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "portaApplicativaRuoliList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().portaApplicativaRuoliList(idPA, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> portaApplicativaRuoliTokenList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "portaApplicativaRuoliTokenList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().portaApplicativaRuoliTokenList(idPA, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> portaApplicativaScopeList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "portaApplicativaScopeList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().portaApplicativaScopeList(idPA, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Map<String, Properties> readMessageSecurityRequestPropertiesConfiguration(long idPortaDelegata) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "readMessageSecurityRequestPropertiesConfiguration";
        try {
            con = ControlStationCore.dbM.getConnection();
            Map readProperties = DBPropertiesUtils.readProperties((Connection)con, (String)this.tipoDB, (String)"pa_security_request", (String)"nome", (String)"valore", (String)"enc_value", (String)"id_porta", (Long)idPortaDelegata, (IDriverBYOK)this.getDriverBYOKUtilities().getDriverBYOKManagerNode(false, true));
            Map map = DBPropertiesUtils.toMultiMap((Map)readProperties);
            return map;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Map<String, Properties> readMessageSecurityResponsePropertiesConfiguration(long idPortaDelegata) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "readMessageSecurityResponsePropertiesConfiguration";
        try {
            con = ControlStationCore.dbM.getConnection();
            Map readProperties = DBPropertiesUtils.readProperties((Connection)con, (String)this.tipoDB, (String)"pa_security_response", (String)"nome", (String)"valore", (String)"enc_value", (String)"id_porta", (Long)idPortaDelegata, (IDriverBYOK)this.getDriverBYOKUtilities().getDriverBYOKManagerNode(false, true));
            Map map = DBPropertiesUtils.toMultiMap((Map)readProperties);
            return map;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<ResponseCachingConfigurazioneRegola> getResponseCachingConfigurazioneRegolaList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getResponseCachingConfigurazioneRegolaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().portaApplicativaResponseCachingConfigurazioneRegolaList(idPA, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsResponseCachingConfigurazioneRegola(long idPorta, Integer statusMin, Integer statusMax, boolean fault) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsResponseCachingConfigurazioneRegola";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaResponseCachingConfigurazioneRegola(idPorta, statusMin, statusMax, fault);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegola> porteAppTrasformazioniList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppTrasformazioniList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeTrasformazioniList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaTrasformazione(idPorta, azioni, pattern, contentType, connettori);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaTrasformazione(idPorta, nome);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegola getTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori, List<TrasformazioneRegolaApplicabilitaSoggetto> soggetti, List<TrasformazioneRegolaApplicabilitaServizioApplicativo> applicativi, boolean interpretaNullList) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegola trasformazioneRegola = driver.getDriverConfigurazioneDB().getPortaApplicativaTrasformazione(idPorta, azioni, pattern, contentType, connettori, soggetti, applicativi, interpretaNullList);
            return trasformazioneRegola;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegola getTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegola trasformazioneRegola = driver.getDriverConfigurazioneDB().getPortaApplicativaTrasformazione(idPorta, nome);
            return trasformazioneRegola;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaRisposta> porteAppTrasformazioniRispostaList(long idPortaApplicativa, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppTrasformazioniRispostaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeTrasformazioniRispostaList(idPortaApplicativa, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRisposta";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRisposta";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaTrasformazioneRisposta(idPorta, idTrasformazione, nome);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaRisposta getTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRisposta";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaRisposta trasformazioneRegolaRisposta = driver.getDriverConfigurazioneDB().getPortaApplicativaTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType);
            return trasformazioneRegolaRisposta;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaRisposta getTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRisposta";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaRisposta trasformazioneRegolaRisposta = driver.getDriverConfigurazioneDB().getPortaApplicativaTrasformazioneRisposta(idPorta, idTrasformazione, nome);
            return trasformazioneRegolaRisposta;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaParametro> porteAppTrasformazioniRispostaHeaderList(long idPortaApplicativa, long idTrasformazione, long idTrasformazioneRisposta, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppTrasformazioniRispostaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeTrasformazioniRispostaHeaderList(idPortaApplicativa, idTrasformazione, idTrasformazioneRisposta, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRispostaHeader";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaParametro getTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRispostaHeader";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaParametro trasformazioneRegolaParametro = driver.getDriverConfigurazioneDB().getPortaApplicativaTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo);
            return trasformazioneRegolaParametro;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaParametro> porteAppTrasformazioniRichiestaHeaderList(long idPortaApplicativa, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppTrasformazioniRichiestaHeaderList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeTrasformazioniRichiestaHeaderList(idPortaApplicativa, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaParametro> porteAppTrasformazioniRichiestaUrlParameterList(long idPortaApplicativa, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppTrasformazioniRichiestaUrlParameterList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeTrasformazioniRichiestaUrlParameterList(idPortaApplicativa, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRichiestaHeader";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaParametro getTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRichiestaHeader";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaParametro trasformazioneRegolaParametro = driver.getDriverConfigurazioneDB().getPortaApplicativaTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo);
            return trasformazioneRegolaParametro;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsTrasformazioneRichiestaUrlParameter";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsPortaApplicativaTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public TrasformazioneRegolaParametro getTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getTrasformazioneRichiestaUrlParameter";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            TrasformazioneRegolaParametro trasformazioneRegolaParametro = driver.getDriverConfigurazioneDB().getPortaApplicativaTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo);
            return trasformazioneRegolaParametro;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaApplicabilitaSoggetto> porteAppTrasformazioniSoggettoList(long idPortaApplicativa, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppTrasformazioniSoggettoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeTrasformazioniSoggettiList(idPortaApplicativa, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<TrasformazioneRegolaApplicabilitaServizioApplicativo> porteAppTrasformazioniServiziApplicativiAutorizzatiList(long idPortaApplicativa, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteAppTrasformazioniServiziApplicativiAutorizzatiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeTrasformazioniServiziApplicativiList(idPortaApplicativa, idTrasformazione, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteApplicativeAutenticazioneCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeAutenticazioneCustomPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeAutenticazioneCustomPropList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteApplicativeAutorizzazioneCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeAutorizzazioneCustomPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeAutorizzazioneCustomPropList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteApplicativeAutorizzazioneContenutoCustomPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeAutorizzazioneContenutoCustomPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeAutorizzazioneContenutoCustomPropList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteApplicativeConnettoriMultipliConfigPropList(long idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeConnettoriMultipliConfigPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeConnettoriMultipliConfigPropList(idPortaApplicativa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Proprieta> porteApplicativeConnettoriMultipliPropList(long idPaSa, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeConnettoriMultipliPropList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeConnettoriMultipliPropList(idPaSa, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDPortaApplicativa> porteApplicativeWithApplicativoErogatore(IDServizioApplicativo idSA) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "porteApplicativeWithApplicativoErogatore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().porteApplicativeWithApplicativoErogatore(idSA);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean azioniTutteOneway(AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico as, List<String> azioniDaControllare) {
        String profiloCollaborazioneAccordo = as.getProfiloCollaborazione().toString();
        if (profiloCollaborazioneAccordo.equals(CostantiRegistroServizi.ONEWAY.getValue())) {
            profiloCollaborazioneAccordo = "oneway";
        } else if (profiloCollaborazioneAccordo.equals(CostantiRegistroServizi.SINCRONO.getValue())) {
            profiloCollaborazioneAccordo = "sincrono";
        } else if (profiloCollaborazioneAccordo.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO.getValue())) {
            profiloCollaborazioneAccordo = "asincronoSimmetrico";
        } else if (profiloCollaborazioneAccordo.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.getValue())) {
            profiloCollaborazioneAccordo = "asincronoAsimmetrico";
        }
        for (String nomeAzione : azioniDaControllare) {
            boolean isProfiloOneWay = true;
            String profiloCollaborazioneAzione = "";
            if (nomeAzione != null && !nomeAzione.equals("")) {
                if (asps.getPortType() != null) {
                    for (PortTypeSintetico pt : as.getPortType()) {
                        if (!pt.getNome().equals(asps.getPortType())) continue;
                        for (OperationSintetica op : pt.getAzione()) {
                            if (!op.getNome().equals(nomeAzione)) continue;
                            if ("ridefinito".equals(op.getProfAzione())) {
                                if (op.getProfiloCollaborazione() == null) continue;
                                profiloCollaborazioneAzione = op.getProfiloCollaborazione().toString();
                                continue;
                            }
                            if (!"ridefinito".equals(pt.getProfiloPT()) || pt.getProfiloCollaborazione() == null) continue;
                            profiloCollaborazioneAzione = pt.getProfiloCollaborazione().toString();
                        }
                    }
                } else {
                    for (int i = 0; i < as.getAzione().size(); ++i) {
                        AzioneSintetica tmpAz = (AzioneSintetica)as.getAzione().get(i);
                        if (!tmpAz.getProfAzione().equals("ridefinito")) continue;
                        if (tmpAz.getProfiloCollaborazione() == null) break;
                        profiloCollaborazioneAzione = tmpAz.getProfiloCollaborazione().toString();
                        break;
                    }
                }
            }
            if (nomeAzione != null && !nomeAzione.equals("")) {
                if (profiloCollaborazioneAzione != null && !profiloCollaborazioneAzione.equals("")) {
                    if (!profiloCollaborazioneAzione.equals(CostantiRegistroServizi.ONEWAY.getValue())) {
                        isProfiloOneWay = false;
                    }
                } else if (!profiloCollaborazioneAccordo.equals(CostantiRegistroServizi.ONEWAY.getValue())) {
                    isProfiloOneWay = false;
                }
            } else if (!profiloCollaborazioneAccordo.equals(CostantiRegistroServizi.ONEWAY.getValue())) {
                isProfiloOneWay = false;
            }
            if (isProfiloOneWay) continue;
            return false;
        }
        return true;
    }
}

