/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pdd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCostanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.User;

public class PddHelper
extends ConsoleHelper {
    public PddHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        super(request, pd, session);
    }

    public PddHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        super(core, request, pd, session);
    }

    public boolean isPdDEsterna(PdDControlStation pdd) {
        return PddTipologia.ESTERNO.toString().equals(pdd.getTipo());
    }

    public boolean isPdDOperativa(PdDControlStation pdd) {
        return PddTipologia.OPERATIVO.equals(pdd.getTipo());
    }

    public boolean isPdDNonOperativa(PdDControlStation pdd) {
        return PddTipologia.NONOPERATIVO.equals(pdd.getTipo());
    }

    public List<DataElement> addPddToDati(List<DataElement> dati, String nome, String id, String ip, String subject, String password, String confpw, PddTipologia tipo, TipoOperazione tipoOp, String[] protocolli, String protocollo, String protocolloGestione, int porta, String descrizione, String ipGestione, int portaGestione, String implementazione, String clientAuth, boolean singlePdd) throws DriverRegistroServiziException {
        DataElement de = new DataElement();
        de.setLabel("Porta di Dominio");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            de = new DataElement();
            de.setLabel("Id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        if (tipoOp.equals((Object)TipoOperazione.ADD) || this.core.isSinglePdD()) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setValue(nome);
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("descrizione");
        de.setValue(descrizione);
        de.setSize(this.getSize());
        dati.add(de);
        if (!singlePdd) {
            de = new DataElement();
            de.setLabel("Protocollo");
            if (tipoOp.equals((Object)TipoOperazione.ADD) && !tipo.equals((Object)PddTipologia.ESTERNO)) {
                de.setType(DataElementType.SELECT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("protocollo");
            de.setValues(protocolli);
            de.setSelected(protocollo);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Indirizzo pubblico (IP/Hostname)");
            if (tipoOp.equals((Object)TipoOperazione.ADD) && !tipo.equals((Object)PddTipologia.ESTERNO)) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("ip");
            de.setValue(ip);
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Porta pubblica");
            if (tipoOp.equals((Object)TipoOperazione.ADD) && !tipo.equals((Object)PddTipologia.ESTERNO)) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("porta");
            de.setValue((String)(porta <= 0 ? "80" : "" + porta));
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Protocollo gestione");
            if (tipoOp.equals((Object)TipoOperazione.ADD) && !tipo.equals((Object)PddTipologia.ESTERNO)) {
                de.setType(DataElementType.SELECT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("protocollo_gestione");
            de.setValues(protocolli);
            de.setSelected(protocolloGestione);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Indirizzo gestione (IP/Hostname)");
            if (tipoOp.equals((Object)TipoOperazione.ADD) && !tipo.equals((Object)PddTipologia.ESTERNO)) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("ip_gestione");
            de.setValue(ipGestione);
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Porta gestione");
            if (tipoOp.equals((Object)TipoOperazione.ADD) && !tipo.equals((Object)PddTipologia.ESTERNO)) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("porta_gestione");
            de.setValue((String)(portaGestione <= 0 ? "80" : "" + portaGestione));
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo");
            de.setType(DataElementType.SELECT);
            de.setName("tipo");
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                de.setLabels(PddCostanti.getLabelTipi());
                de.setValues(PddTipologia.TIPI);
            } else if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                if (tipo.equals((Object)PddTipologia.ESTERNO)) {
                    de.setLabels(PddCostanti.getLabelTipoSoloEsterno());
                    de.setValues(PddTipologia.TIPO_SOLO_ESTERNO);
                } else {
                    de.setLabels(PddCostanti.getLabelTipiSoloOperativi());
                    de.setValues(PddTipologia.TIPI_SOLO_OPERATIVI);
                }
            }
            de.setSelected(tipo.toString());
            de.setPostBack(true);
            dati.add(de);
        } else if (!TipoOperazione.ADD.equals((Object)tipoOp)) {
            de = new DataElement();
            de.setLabel("Tipo");
            de.setType(DataElementType.TEXT);
            de.setName("tipo");
            de.setValue(tipo.toString());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Implementazione");
        if (this.isModalitaAvanzata()) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("implementazione");
        de.setValue(implementazione);
        de.setSize(this.getSize());
        dati.add(de);
        String[] tipiAuth = new String[]{CostantiConfigurazione.DISABILITATO.toString(), CostantiConfigurazione.ABILITATO.toString()};
        de = new DataElement();
        de.setLabel("Client Auth");
        de.setType(DataElementType.SELECT);
        de.setName("client_auth");
        de.setSelected(clientAuth);
        de.setValues(tipiAuth);
        de.setSize(this.getSize());
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Subject");
        de.setType(DataElementType.TEXT_EDIT);
        de.setValue(StringEscapeUtils.escapeHtml((String)subject));
        if (clientAuth != null && clientAuth.equals(CostantiRegistroServizi.ABILITATO.getValue())) {
            de.setRequired(true);
        }
        de.setName("subject");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    boolean pddCheckData(TipoOperazione tipoOp, boolean singlePdd) throws Exception {
        try {
            String nome = this.getParameter("nome");
            String ip = this.getParameter("ip");
            String ipGestione = this.getParameter("ip_gestione");
            String tipoParam = this.getParameter("tipo");
            PddTipologia tipo = PddTipologia.toPddTipologia((String)tipoParam);
            String implementazione = this.getParameter("implementazione");
            String clientAuth = this.getParameter("client_auth");
            String subject = this.getParameter("subject");
            String porta = this.getParameter("porta");
            String portaGestione = this.getParameter("porta_gestione");
            if (implementazione == null || "".equals(implementazione)) {
                this.pd.setMessage("Il campo Implementazione deve essere specificato.");
                return false;
            }
            if (subject != null && !"".equals(subject)) {
                try {
                    CertificateUtils.validaPrincipal((String)subject, (PrincipalType)PrincipalType.SUBJECT);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il subject fornito non \u00e8 valido: " + e.getMessage());
                    return false;
                }
            }
            if (CostantiConfigurazione.ABILITATO.toString().equals(clientAuth) && (subject == null || "".equals(subject))) {
                this.pd.setMessage("&Egrave; necessario specificare il subject in caso di Client Auth abilitato.");
                return false;
            }
            if (!(singlePdd || tipo.equals((Object)PddTipologia.OPERATIVO) || tipo.equals((Object)PddTipologia.NONOPERATIVO) || tipo.equals((Object)PddTipologia.ESTERNO))) {
                this.pd.setMessage("Tipo dev'essere operativo, non-operativo o esterno");
                return false;
            }
            if (singlePdd || tipo.equals((Object)PddTipologia.ESTERNO)) {
                if (nome == null || nome.equals("")) {
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Nome.");
                    return false;
                }
                if (nome.indexOf(" ") != -1) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
                if (singlePdd ? !this.checkNCName(nome, "Nome") : !this.checkSimpleName(nome, "Nome")) {
                    return false;
                }
            } else {
                if (nome.equals("") || ip.equals("") || ipGestione.equals("") || porta.equals("") || portaGestione.equals("")) {
                    Object tmpElenco = "";
                    if (nome.equals("")) {
                        tmpElenco = "Nome";
                    }
                    if (ip.equals("")) {
                        tmpElenco = ((String)tmpElenco).equals("") ? "Indirizzo IP" : (String)tmpElenco + ", Indirizzo IP";
                    }
                    if (ipGestione.equals("")) {
                        tmpElenco = ((String)tmpElenco).equals("") ? "Indirizzo IP Gestione" : (String)tmpElenco + ", Indirizzo IP Gestione";
                    }
                    if (porta.equals("")) {
                        tmpElenco = ((String)tmpElenco).equals("") ? "Porta" : (String)tmpElenco + ", Porta";
                    }
                    if (portaGestione.equals("")) {
                        tmpElenco = ((String)tmpElenco).equals("") ? "Porta Gestione" : (String)tmpElenco + ", Porta Gestione";
                    }
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                    return false;
                }
                if (nome.indexOf(" ") != -1 || ip.indexOf(" ") != -1 || ipGestione.indexOf(" ") != -1 || porta.indexOf(" ") != -1 || portaGestione.indexOf(" ") != -1) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
                if (!this.checkSimpleName(nome, "Nome")) {
                    return false;
                }
                if (!RegExpUtilities.isIPOrHostname((String)ip)) {
                    this.pd.setMessage("Indirizzo pubblico dev'essere un ip o un hostname valido");
                    return false;
                }
                if (!RegExpUtilities.isIPOrHostname((String)ipGestione)) {
                    this.pd.setMessage("Indirizzo gestione dev'essere un ip o un hostname valido");
                    return false;
                }
                if (!this.checkNumber(porta, "Porta pubblica", false)) {
                    return false;
                }
                if (!this.checkNumber(portaGestione, "Porta gestione", false)) {
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovatoPdd;
                boolean bl = trovatoPdd = this.pddCore.existPdd(nome) > 0L;
                if (trovatoPdd) {
                    this.pd.setMessage("Esiste gi&agrave; una Porta di Dominio con nome " + nome);
                    return false;
                }
            }
            if (subject != null && !"".equals(subject)) {
                List<PortaDominio> pddList = this.pddCore.porteDominioWithSubject(subject);
                for (int i = 0; i < pddList.size(); ++i) {
                    PortaDominio pdd = pddList.get(i);
                    if (tipoOp.equals((Object)TipoOperazione.CHANGE) && nome.equals(pdd.getNome())) continue;
                    this.pd.setMessage("La Porta di Dominio " + pdd.getNome() + " possiede gia' le credenziali ssl indicate.");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void preparePddSinglePddList(List<PdDControlStation> lista, ISearch ricerca) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"pddSinglePdD", (Parameter[])new Parameter[0]);
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            int idLista = Liste.PDD;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", "pddSinglePdDList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", "pddSinglePdDList.do"), new Parameter("Risultati ricerca", null)});
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Porte di Dominio", (String)search);
            }
            String[] labels = new String[]{"Nome", "Tipo", "Implementazione", "Soggetti"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            Iterator<PdDControlStation> it = lista.iterator();
            PdDControlStation pdd = null;
            while (it.hasNext()) {
                pdd = it.next();
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setUrl("pddSinglePdDChange.do", new Parameter[]{new Parameter("id", pdd.getId().toString()), new Parameter("nome", pdd.getNome())});
                de.setValue(pdd.getNome());
                de.setIdToRemove(pdd.getNome());
                e.add(de);
                de = new DataElement();
                de.setValue(pdd.getTipo());
                e.add(de);
                de = new DataElement();
                de.setValue(pdd.getImplementazione());
                e.add(de);
                de = new DataElement();
                de.setUrl("pddSoggettiList.do", new Parameter[]{new Parameter("id", pdd.getId().toString())});
                if (contaListe.booleanValue()) {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.pddCore.pddSoggettiList(pdd.getId().intValue(), (ISearch)searchForCount);
                    int numSog = 0;
                    numSog = searchForCount.getNumEntries(Liste.PDD_SOGGETTI);
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numSog));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                e.add(de);
                dati.add(e);
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void preparePddList(List<PdDControlStation> lista, ISearch ricerca) throws Exception {
        try {
            User user;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"pdd", (Parameter[])new Parameter[0]);
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            int idLista = Liste.PDD;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", "pddList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", "pddList.do"), new Parameter("Risultati ricerca", null)});
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Porte di Dominio", (String)search);
            }
            boolean showConfigurazioneSistema = (user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session)) != null && user.getPermessi() != null && user.getPermessi().isSistema() && this.pddCore.getJmxPdDAliases() != null && this.pddCore.getJmxPdDAliases().size() > 0;
            ArrayList<String> listLabels = new ArrayList<String>();
            listLabels.add("Nome");
            listLabels.add("IP/Hostname");
            listLabels.add("Tipo");
            listLabels.add("Implementazione");
            if (showConfigurazioneSistema) {
                listLabels.add("Configurazione");
            }
            listLabels.add("Soggetti");
            String[] labels = listLabels.toArray(new String[1]);
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            Iterator<PdDControlStation> it = lista.iterator();
            PdDControlStation pdd = null;
            while (it.hasNext()) {
                pdd = it.next();
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setUrl("pddChange.do", new Parameter[]{new Parameter("id", pdd.getId().toString()), new Parameter("nome", pdd.getNome())});
                de.setValue(pdd.getNome());
                de.setIdToRemove(pdd.getId().toString());
                e.add(de);
                de = new DataElement();
                if (PddTipologia.ESTERNO.toString().equals(pdd.getTipo())) {
                    de.setValue("");
                } else {
                    de.setValue(pdd.getIp());
                }
                e.add(de);
                de = new DataElement();
                de.setValue(pdd.getTipo());
                e.add(de);
                de = new DataElement();
                de.setValue(pdd.getImplementazione());
                e.add(de);
                if (showConfigurazioneSistema) {
                    de = new DataElement();
                    if (PddTipologia.OPERATIVO.toString().equals(pdd.getTipo())) {
                        de.setUrl("configurazioneSistemaAdd.do", new Parameter[]{new Parameter("aliasNodo", pdd.getNome())});
                        de.setValue("visualizza");
                    } else {
                        de.setType(DataElementType.TEXT);
                        de.setValue("-");
                    }
                    e.add(de);
                }
                de = new DataElement();
                de.setUrl("pddSoggettiList.do", new Parameter[]{new Parameter("id", pdd.getId().toString())});
                if (contaListe.booleanValue()) {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.pddCore.pddSoggettiList(pdd.getId().intValue(), (ISearch)searchForCount);
                    int numSog = 0;
                    numSog = searchForCount.getNumEntries(Liste.PDD_SOGGETTI);
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numSog));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                e.add(de);
                dati.add(e);
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void preparePddSoggettiList(String nomePdd, int id, List<Soggetto> lista, ISearch ricerca) throws Exception {
        try {
            boolean sPdD;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"pddSoggetti", (Parameter[])new Parameter[]{new Parameter("id", "" + id)});
            Boolean singlePdD = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"singlePdD");
            int idLista = Liste.PDD_SOGGETTI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String t2URL = "pddSinglePdDList.do";
            boolean bl = sPdD = singlePdD != null ? singlePdD : false;
            if (!sPdD) {
                t2URL = "pddList.do";
            }
            String t3Label = "Soggetti associati alla Porta di Dominio " + nomePdd;
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", t2URL), new Parameter(t3Label, null)});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Porte di Dominio", t2URL), new Parameter(t3Label, "pddSoggettiList.do?id=" + id), new Parameter("Risultati ricerca", null)});
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Soggetti", (String)search);
            }
            String[] labels = new String[]{"Soggetti"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Soggetto sog : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", sog.getId().toString()), new Parameter("nomeprov", sog.getNome()), new Parameter("tipoprov", sog.getTipo())});
                    de.setValue(sog.getTipo() + "/" + sog.getNome());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(false);
            this.pd.setSelect(false);
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }
}

