/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.remote_stores;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.pdd.core.keystore.RemoteStore;
import org.openspcoop2.pdd.core.keystore.RemoteStoreKeyEntry;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class RemoteStoresHelper
extends ConsoleHelper {
    public RemoteStoresHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        super(request, pd, session);
    }

    public RemoteStoresHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        super(core, request, pd, session);
    }

    public void prepareRemoteStoreKeysList(ConsoleSearch ricerca, List<RemoteStoreKeyEntry> lista, long remoteStoreId) {
        try {
            Parameter pIdRemoteStore = new Parameter("remoteStoreId", "" + remoteStoreId);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"remoteStoresKeys", (Parameter[])new Parameter[]{pIdRemoteStore});
            int idLista = Liste.REMOTE_STORE_KEY;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            Object filterRemoteStoreId = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRemoteStoreId");
            if (StringUtils.isEmpty((String)filterRemoteStoreId)) {
                filterRemoteStoreId = "" + remoteStoreId;
            }
            this.addFilterRemoteStoreId((String)filterRemoteStoreId, true);
            String filterRemoteStoreKid = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRemoteStoreKeyKid");
            this.addFilterRemoteStoreKid(filterRemoteStoreKid);
            String filterRemoteStoreClientId = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRemoteStoreKeyClientId");
            this.addFilterRemoteStoreClientId(filterRemoteStoreClientId);
            String filterRemoteStoreOrganizzazione = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRemoteStoreKeyOrganizzazione");
            this.addFilterRemoteStoreOrganizzazione(filterRemoteStoreOrganizzazione);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            this.pd.nascondiTextFilterAutomatico();
            ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Cache PDND", "remoteStoresKeysList.do")});
            String[] labels = new String[]{"Data Registrazione", "Chiave Pubblica", "Client Id", "Dettagli Organizzazione"};
            this.pd.setLabels(labels);
            ArrayList<List<DataElement>> dati = new ArrayList<List<DataElement>>();
            if (lista != null) {
                Iterator<RemoteStoreKeyEntry> it = lista.iterator();
                while (it.hasNext()) {
                    List<DataElement> e = this.creaEntry(it, pIdRemoteStore);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(false);
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<DataElement> creaEntry(Iterator<RemoteStoreKeyEntry> it, Parameter pIdRemoteStore) {
        RemoteStoreKeyEntry entry = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DateTimeFormatterWrapper formatter = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
        DataElement de = new DataElement();
        Parameter pId = new Parameter("remoteStoreKeyId", "" + entry.getId());
        de.setUrl("remoteStoresKeysChange.do", new Parameter[]{pId, pIdRemoteStore});
        de.setValue(formatter.format(entry.getDataRegistrazione()));
        de.setIdToRemove("" + entry.getId());
        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        e.add(de);
        de = new DataElement();
        if (entry.getContentKey() != null && this.isKidNotStartsWithClientId(entry.getKid())) {
            de.setValue(entry.getKid());
            de.setToolTip("Download".toLowerCase());
            de.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", "" + entry.getId()), new Parameter("tipoDocumentoDaScaricare", "chPub"), new Parameter("tipoDocumento", "remStEntry")});
            de.setDisabilitaAjaxStatus();
        } else {
            de.setValue("-");
        }
        e.add(de);
        e.add(this.creaEntryClientId(entry));
        e.add(this.creaEntryOrganization(entry));
        return e;
    }

    private DataElement creaEntryClientId(RemoteStoreKeyEntry entry) {
        DataElement de = new DataElement();
        if (entry.getClientId() != null) {
            de.setValue(entry.getClientId());
            StringBuilder sbTooltip = new StringBuilder();
            if (entry.getClientName() != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entry.getClientName())) {
                sbTooltip.append(entry.getClientName());
            }
            if (entry.getClientDescription() != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entry.getClientDescription())) {
                if (sbTooltip.length() > 0) {
                    sbTooltip.append(" (");
                }
                sbTooltip.append(entry.getClientDescription());
                if (sbTooltip.length() > 0) {
                    sbTooltip.append(")");
                }
            }
            de.setToolTip(sbTooltip.toString());
            de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        } else {
            de.setValue("-");
        }
        return de;
    }

    private DataElement creaEntryOrganization(RemoteStoreKeyEntry entry) {
        DataElement de = new DataElement();
        if (entry.getOrganizationName() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getOrganizationName()).append(" (").append(entry.getOrganizationExternalOrigin()).append(" ").append(entry.getOrganizationExternalId()).append(")");
            de.setValue(sb.toString());
            StringBuilder sbTooltip = new StringBuilder();
            if (entry.getOrganizationCategory() != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entry.getOrganizationCategory())) {
                sbTooltip.append(entry.getOrganizationCategory());
            }
            if (entry.getOrganizationSubunit() != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entry.getOrganizationSubunit())) {
                if (sbTooltip.length() > 0) {
                    sbTooltip.append(" (");
                }
                sbTooltip.append(entry.getOrganizationSubunit());
                if (sbTooltip.length() > 0) {
                    sbTooltip.append(")");
                }
            }
            de.setToolTip(sbTooltip.toString());
            de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        } else {
            de.setValue("-");
        }
        return de;
    }

    private boolean isKidNotStartsWithClientId(String kid) {
        return kid != null && !kid.startsWith("ClientId--");
    }

    private void addFilterRemoteStoreOrganizzazione(String filterRemoteStoreOrganizzazione) throws Exception {
        String label = "Dettagli Organizzazione";
        this.pd.addTextFilter("filtroRemoteStoreKeyOrganizzazione", label, filterRemoteStoreOrganizzazione, this.getSize());
    }

    private void addFilterRemoteStoreClientId(String filterRemoteStoreClientId) throws Exception {
        String label = "Client Id";
        this.pd.addTextFilter("filtroRemoteStoreKeyClientId", label, filterRemoteStoreClientId, this.getSize());
    }

    private void addFilterRemoteStoreKid(String filterRemoteStoreKid) throws Exception {
        String label = "Kid";
        this.pd.addTextFilter("filtroRemoteStoreKeyKid", label, filterRemoteStoreKid, this.getSize());
    }

    private void addFilterRemoteStoreId(String filterRemoteStoreId, boolean postback) throws Exception {
        List<RemoteStore> remoteStoresList = this.remoteStoresCore.remoteStoresList();
        if (remoteStoresList.size() > 1) {
            String label = "Remote Store";
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<CallSite> values = new ArrayList<CallSite>();
            for (RemoteStore remoteStore : remoteStoresList) {
                labels.add(remoteStore.getNome());
                values.add((CallSite)((Object)("" + remoteStore.getId())));
            }
            this.pd.addFilter("filtroRemoteStoreId", label, filterRemoteStoreId, values.toArray(new String[values.size()]), labels.toArray(new String[labels.size()]), postback, this.getSize());
        } else {
            this.pd.addHiddenFilter("filtroRemoteStoreId", filterRemoteStoreId, this.getSize());
        }
    }

    public List<DataElement> addRemoteStoreKeyToDati(long remoteStoreId, long id, RemoteStoreKeyEntry entry, List<DataElement> dati) {
        this.pd.disableEditMode();
        DateTimeFormatterWrapper formatter = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
        DataElement de = new DataElement();
        de.setLabel("Data Registrazione");
        de.setValue(formatter.format(entry.getDataRegistrazione()));
        de.setType(DataElementType.TEXT_EDIT);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setValue("" + remoteStoreId);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setValue("" + id);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        if (this.isKidNotStartsWithClientId(entry.getKid())) {
            if (entry.getDataAggiornamento() != null || entry.getContentKey() != null) {
                de = new DataElement();
                de.setType(DataElementType.SUBTITLE);
                de.setLabel("Chiave Pubblica");
                dati.add(de);
            }
            if (entry.getDataAggiornamento() != null) {
                de = new DataElement();
                de.setLabel("Data Ultimo Aggiornamento");
                de.setValue(formatter.format(entry.getDataAggiornamento()));
                de.setType(DataElementType.TEXT_EDIT);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Kid");
            de.setValue(entry.getKid());
            de.setType(DataElementType.TEXT_EDIT);
            dati.add(de);
            if (entry.getContentKey() != null) {
                de = new DataElement();
                de.setLabel("Chiave Pubblica");
                de.setValue(new String(entry.getContentKey()));
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                dati.add(de);
                de = new DataElement();
                de.setLabel("");
                de.setValue("Download".toLowerCase());
                de.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", "" + entry.getId()), new Parameter("tipoDocumentoDaScaricare", "chPub"), new Parameter("tipoDocumento", "remStEntry")});
                de.setDisabilitaAjaxStatus();
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
        }
        if (entry.getClientId() != null) {
            de = new DataElement();
            de.setType(DataElementType.SUBTITLE);
            de.setLabel("Informazioni Client");
            dati.add(de);
            if (entry.getClientDataAggiornamento() != null) {
                de = new DataElement();
                de.setLabel("Data Ultimo Aggiornamento");
                de.setValue(formatter.format(entry.getClientDataAggiornamento()));
                de.setType(DataElementType.TEXT_EDIT);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Client Id");
            de.setValue(entry.getClientId());
            de.setType(DataElementType.TEXT_EDIT);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Dettagli Client");
            de.setValue(entry.getClientDetails());
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Dettagli Organizzazione");
            de.setValue(entry.getOrganizationDetails());
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            dati.add(de);
        }
        return dati;
    }
}

