/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.scope;

import java.sql.Connection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;

public class ScopeCore
extends ControlStationCore {
    public ScopeCore() throws Exception {
    }

    public ScopeCore(ControlStationCore core) throws Exception {
        super(core);
    }

    public List<Scope> scopeList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "scopeList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().scopeList(superuser, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Scope getScope(long id) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getScope";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Scope scope = driver.getDriverRegistroServiziDB().getScope(id);
            return scope;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Scope getScope(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getScope";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDScope idScope = new IDScope(nome);
            Scope scope = driver.getDriverRegistroServiziDB().getScope(idScope);
            return scope;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug("[ControlStationCore::" + nomeMetodo + "] NotFound :" + e.getMessage(), e);
            throw new DriverConfigurazioneException("[ControlStationCore::" + nomeMetodo + "] NotFound :" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsScope(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsScope";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDScope idScope = new IDScope(nome);
            boolean bl = driver.getDriverRegistroServiziDB().existsScope(idScope);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isScopeInUso(String scope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "isScopeInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isScopeInUso(new IDScope(scope), whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isScopeConfigInUso(String scope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "isScopeConfigInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isScopeConfigInUso(new IDScope(scope), whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getDettagliScopeInUso(IDScope scope) throws DriverConfigurazioneException {
        EnumMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new EnumMap<ErrorsHandlerCostant, List<String>>(ErrorsHandlerCostant.class);
        boolean normalizeObjectIds = true;
        boolean saInUso = this.isScopeConfigInUso(scope.getNome(), whereIsInUso, normalizeObjectIds);
        StringBuilder inUsoMessage = new StringBuilder();
        if (saInUso) {
            String s = DBOggettiInUsoUtils.toString((IDScope)scope, whereIsInUso, (boolean)false, (String)"\n");
            if (s != null && s.startsWith("\n") && s.length() > 1) {
                s = s.substring(1);
            }
            inUsoMessage.append(s);
            inUsoMessage.append("\n");
        } else {
            inUsoMessage.append("Lo scope non risulta utilizzato in alcuna configurazione");
        }
        return inUsoMessage.toString();
    }
}

