/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiDelStatus;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettoUpdateUtilities;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class SoggettiUtilities {
    public static List<Object> getOggettiDaAggiornare(SoggettiCore soggettiCore, String oldnomeprov, String nomeprov, String oldtipoprov, String tipoprov, SoggettoCtrlStat sog) throws Exception {
        SoggettoUpdateUtilities soggettoUpdateUtilities = new SoggettoUpdateUtilities(soggettiCore, oldnomeprov, nomeprov, oldtipoprov, tipoprov, sog);
        soggettoUpdateUtilities.addSoggetto();
        soggettoUpdateUtilities.checkServiziApplicativi();
        soggettoUpdateUtilities.checkAccordiCooperazione();
        soggettoUpdateUtilities.checkAccordiServizioParteComune();
        soggettoUpdateUtilities.checkAccordiServizioParteSpecifica();
        soggettoUpdateUtilities.checkPorteDelegate();
        soggettoUpdateUtilities.checkPorteApplicative();
        soggettoUpdateUtilities.checkFruitori();
        soggettoUpdateUtilities.checkPolicyGlobali();
        soggettoUpdateUtilities.checkConfigurazione();
        return soggettoUpdateUtilities.getOggettiDaAggiornare();
    }

    public static SoggettiDelStatus deleteSoggetto(Soggetto soggettoRegistro, org.openspcoop2.core.config.Soggetto soggettoConfig, String userLogin, SoggettiCore soggettiCore, SoggettiHelper soggettiHelper, StringBuilder inUsoMessage, String newLine) throws Exception {
        PddCore pddCore = new PddCore(soggettiCore);
        UtentiCore utentiCore = new UtentiCore(soggettiCore);
        boolean deleteOperativo = false;
        boolean delete = false;
        IDSoggetto idSoggetto = null;
        if (soggettiCore.isRegistroServiziLocale()) {
            idSoggetto = new IDSoggetto(soggettoRegistro.getTipo(), soggettoRegistro.getNome());
            soggettoConfig = soggettiCore.getSoggetto(idSoggetto);
        } else {
            idSoggetto = new IDSoggetto(soggettoConfig.getTipo(), soggettoConfig.getNome());
        }
        boolean soggettoInUso = false;
        boolean normalizeObjectIds = !soggettiHelper.isModalitaCompleta();
        HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
        boolean verificaRuoli = false;
        soggettoInUso = soggettiCore.isRegistroServiziLocale() ? soggettiCore.isSoggettoInUso(soggettoRegistro, whereIsInUso, normalizeObjectIds, verificaRuoli) : soggettiCore.isSoggettoInUso(soggettoConfig, whereIsInUso, normalizeObjectIds, verificaRuoli);
        if (soggettoInUso) {
            inUsoMessage.append(DBOggettiInUsoUtils.toString((IDSoggetto)idSoggetto, whereIsInUso, (boolean)true, (String)newLine, (boolean)normalizeObjectIds));
            inUsoMessage.append(newLine);
        } else if (soggettoConfig.isDominioDefault()) {
            String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idSoggetto.getTipo());
            inUsoMessage.append("Il Soggetto '" + soggettiHelper.getLabelNomeSoggetto(protocollo, idSoggetto) + "',  essendo il soggeto predefinito per il profilo '" + soggettiHelper.getLabelProtocollo(protocollo) + "', non \u00e8 eliminabile");
            inUsoMessage.append(newLine);
            inUsoMessage.append(newLine);
        } else {
            SoggettoCtrlStat sog = new SoggettoCtrlStat(soggettoRegistro, soggettoConfig);
            soggettiCore.performDeleteOperation(userLogin, soggettiHelper.smista(), sog);
            delete = true;
            if (soggettoRegistro != null && !pddCore.isPddEsterna(soggettoRegistro.getPortaDominio())) {
                IDSoggetto idSoggettoSelezionato = new IDSoggetto(soggettoRegistro.getTipo(), soggettoRegistro.getNome());
                utentiCore.modificaSoggettoUtilizzatoConsole(idSoggettoSelezionato.toString(), null);
                deleteOperativo = true;
            }
        }
        SoggettiDelStatus delStatus = new SoggettiDelStatus();
        delStatus.setDeletedOperativo(deleteOperativo);
        delStatus.setDeleted(delete);
        return delStatus;
    }

    public static boolean soggettiCheckData(SoggettiCore soggettiCore, SoggettiHelper soggettiHelper, String newLine, String oldnomeprov, String oldtipoprov, boolean privato, TipoOperazione tipoOp, String id, String tipoprov, String nomeprov, String codiceIpa, String pdUrlPrefixRewriter, String paUrlPrefixRewriter, Soggetto soggettoOld, boolean isSupportatoAutenticazioneSoggetti, String descrizione, String portaDominio) throws Exception {
        String msg;
        StringBuilder bf;
        String tipoNome;
        Set<ErrorsHandlerCostant> keys;
        HashMap<ErrorsHandlerCostant, String> whereIsInUso;
        boolean isOk = soggettiHelper.soggettiCheckData(tipoOp, id, tipoprov, nomeprov, codiceIpa, pdUrlPrefixRewriter, paUrlPrefixRewriter, soggettoOld, isSupportatoAutenticazioneSoggetti, descrizione, portaDominio);
        if (isOk && soggettiCore.isRegistroServiziLocale() && soggettiHelper.isShowGestioneWorkflowStatoDocumenti() && (!oldnomeprov.equals(nomeprov) || !oldtipoprov.equals(tipoprov)) && soggettiCore.isSoggettoInUsoInPackageFinali(soggettoOld, whereIsInUso = new HashMap<ErrorsHandlerCostant, String>())) {
            keys = whereIsInUso.keySet();
            tipoNome = soggettoOld.getTipo() + "/" + soggettoOld.getNome();
            bf = new StringBuilder();
            bf.append("Tipo o Nome del soggetto ");
            bf.append(tipoNome);
            bf.append(" non modificabile poiche' :" + newLine);
            for (ErrorsHandlerCostant key : keys) {
                msg = whereIsInUso.get(key);
                if (ErrorsHandlerCostant.IN_USO_IN_SERVIZI.toString().equals(key.toString())) {
                    bf.append("- erogatore di Servizi in uno stato finale: " + msg + newLine);
                    continue;
                }
                if (ErrorsHandlerCostant.POSSIEDE_FRUITORI.toString().equals(key.toString())) {
                    bf.append("- fruitore in uno stato finale: " + msg + newLine);
                    continue;
                }
                if (ErrorsHandlerCostant.IS_REFERENTE.toString().equals(key.toString())) {
                    bf.append("- referente di un accordo di servizio in uno stato finale: " + msg + newLine);
                    continue;
                }
                if (ErrorsHandlerCostant.IS_REFERENTE_COOPERAZIONE.toString().equals(key.toString())) {
                    bf.append("- referente di un accordo di cooperazione in uno stato finale: " + msg + newLine);
                    continue;
                }
                if (!ErrorsHandlerCostant.IS_PARTECIPANTE_COOPERAZIONE.toString().equals(key.toString())) continue;
                bf.append("- soggetto partecipante di un accordo di cooperazione in uno stato finale: " + msg + newLine);
            }
            bf.append(newLine);
            isOk = false;
            soggettiHelper.getPd().setMessage(bf.toString(), Costanti.MESSAGE_TYPE_INFO);
        }
        if (isOk && soggettiCore.isRegistroServiziLocale() && soggettiCore.isShowFlagPrivato() && privato && soggettiCore.isSoggettoInUsoInPackagePubblici(soggettoOld, whereIsInUso = new HashMap())) {
            keys = whereIsInUso.keySet();
            tipoNome = soggettoOld.getTipo() + "/" + soggettoOld.getNome();
            bf = new StringBuilder();
            bf.append("Visibilita' del soggetto ");
            bf.append(tipoNome);
            bf.append(" non impostabile a privata poich\u00e8 :" + newLine);
            for (ErrorsHandlerCostant key : keys) {
                msg = whereIsInUso.get(key);
                if (ErrorsHandlerCostant.IN_USO_IN_SERVIZI.toString().equals(key.toString())) {
                    bf.append("- erogatore di Servizi con visibilita' pubblica: " + msg + newLine);
                    continue;
                }
                if (ErrorsHandlerCostant.POSSIEDE_FRUITORI.toString().equals(key.toString())) {
                    bf.append("- fruitore di servizi con visibilita' pubblica: " + msg + newLine);
                    continue;
                }
                if (ErrorsHandlerCostant.IS_REFERENTE.toString().equals(key.toString())) {
                    bf.append("- referente di un accordo di servizio con visibilita' pubblica: " + msg + newLine);
                    continue;
                }
                if (ErrorsHandlerCostant.IS_REFERENTE_COOPERAZIONE.toString().equals(key.toString())) {
                    bf.append("- referente di un accordo di cooperazione con visibilita' pubblica: " + msg + newLine);
                    continue;
                }
                if (!ErrorsHandlerCostant.IS_PARTECIPANTE_COOPERAZIONE.toString().equals(key.toString())) continue;
                bf.append("- soggetto partecipante di un accordo di cooperazione con visibilita' pubblica: " + msg + newLine);
            }
            bf.append("<br>");
            isOk = false;
            soggettiHelper.getPd().setMessage(bf.toString(), Costanti.MESSAGE_TYPE_INFO);
        }
        return isOk;
    }
}

