/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utenti;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public class UtentiServiziAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            UtentiHelper utentiHelper = new UtentiHelper(request, pd, session);
            String nomesu = utentiHelper.getParameter("nomesu");
            String servizio = utentiHelper.getParameter("servizio");
            String protocollo = utentiHelper.getParameter("protocollo");
            utentiHelper.makeMenu();
            UtentiCore utentiCore = new UtentiCore();
            AccordiServizioParteSpecificaCore aspsCore = new AccordiServizioParteSpecificaCore(utentiCore);
            User user = utentiCore.getUser(nomesu);
            ConsoleSearch searchServizi = new ConsoleSearch(true);
            List protocolli = user.getProtocolliSupportati();
            if (protocollo == null && protocolli != null && !protocolli.isEmpty()) {
                protocollo = utentiCore.getProtocolloDefault(request, null, protocolli);
            }
            searchServizi.addFilter(Liste.SERVIZI, "filtroProtocollo", protocollo);
            boolean[] permessiUtente = null;
            List<AccordoServizioParteSpecifica> serviziList = aspsCore.soggettiServizioList(null, (ISearch)searchServizi, permessiUtente, false, false);
            ArrayList<AccordoServizioParteSpecifica> listaServiziNonUtilizzati = new ArrayList<AccordoServizioParteSpecifica>();
            for (AccordoServizioParteSpecifica asps : serviziList) {
                boolean found = false;
                for (IDServizio idServ : user.getServizi()) {
                    if (!asps.getTipo().equals(idServ.getTipo()) || !asps.getNome().equals(idServ.getNome()) || asps.getVersione().intValue() != idServ.getVersione().intValue() || !asps.getTipoSoggettoErogatore().equals(idServ.getSoggettoErogatore().getTipo()) || !asps.getNomeSoggettoErogatore().equals(idServ.getSoggettoErogatore().getNome())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                listaServiziNonUtilizzati.add(asps);
            }
            String[] serviziLabels = new String[listaServiziNonUtilizzati.size() + 1];
            String[] serviziValues = new String[listaServiziNonUtilizzati.size() + 1];
            serviziLabels[0] = "--";
            serviziValues[0] = "-";
            for (int i = 0; i < listaServiziNonUtilizzati.size(); ++i) {
                AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)listaServiziNonUtilizzati.get(i);
                String protocolloTmp = aspsCore.getProtocolloAssociatoTipoServizio(asps.getTipo());
                serviziLabels[i + 1] = utentiHelper.getLabelNomeServizio(protocolloTmp, asps.getTipo(), asps.getNome(), asps.getVersione()) + " (" + utentiHelper.getLabelNomeSoggetto(protocolloTmp, asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()) + ")";
                serviziValues[i + 1] = "" + asps.getId();
            }
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Utenti", "utentiList.do"));
            lstParam.add(new Parameter(nomesu, "utentiChange.do", new Parameter[]{new Parameter("nomesu", nomesu)}));
            lstParam.add(new Parameter("API", "utentiServiziList.do", new Parameter[]{new Parameter("nomesu", nomesu)}));
            lstParam.add(ServletUtils.getParameterAggiungi());
            if (utentiHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (servizio == null) {
                    servizio = "";
                }
                if (listaServiziNonUtilizzati.isEmpty()) {
                    if (protocolli.size() == 1) {
                        pd.setMessage("Non esistono altri servizi associabili all'utente", MessageType.INFO);
                        pd.disableEditMode();
                        pd.setDati(dati);
                        ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                        return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"utentiServizi", (ForwardParams)ForwardParams.ADD());
                    }
                    String msf = MessageFormat.format(UtentiCostanti.LABEL_UTENTI_SERVIZI_DISPONIBILI_ESAURITI_PER_LA_MODALITA_XX, utentiHelper.getLabelProtocollo(protocollo));
                    pd.setMessage(msf, MessageType.INFO);
                    pd.disableOnlyButton();
                }
                utentiHelper.addUtentiServiziToDati(dati, TipoOperazione.ADD, nomesu, servizio, serviziValues, serviziLabels, protocolli, protocollo);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"utentiServizi", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = utentiHelper.utentiServiziCheckData(nomesu, servizio);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                utentiHelper.addUtentiServiziToDati(dati, TipoOperazione.ADD, nomesu, servizio, serviziValues, serviziLabels, protocolli, protocollo);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"utentiServizi", (ForwardParams)ForwardParams.ADD());
            }
            Long newId = Long.parseLong(servizio);
            IDServizio idServizio = aspsCore.getIdAccordoServizioParteSpecifica(newId);
            user.getServizi().add(idServizio);
            utentiCore.performUpdateOperation(userLogin, utentiHelper.smista(), user);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.UTENTI_SERVIZI;
            ricerca = utentiHelper.checkSearchParameters(idLista, ricerca);
            List<IDServizio> lista = utentiCore.utentiServiziList(nomesu, (ISearch)ricerca);
            utentiHelper.prepareUtentiServiziList(ricerca, lista, user);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"utentiServizi", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"utentiServizi", (ForwardParams)ForwardParams.ADD());
        }
    }
}

