/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi;

import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.protocol.basic.BasicFactory;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.sdi.builder.SDIBustaBuilder;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.config.SDIProtocolConfiguration;
import org.openspcoop2.protocol.sdi.config.SDIProtocolManager;
import org.openspcoop2.protocol.sdi.config.SDIProtocolVersionManager;
import org.openspcoop2.protocol.sdi.config.SDITraduttore;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneConSchema;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSemantica;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneSintattica;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.IValidazioneConSchema;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.slf4j.Logger;

public class SDIFactory
extends BasicFactory<SOAPElement> {
    private static final long serialVersionUID = -4246311511752079753L;
    private static IProtocolManager staticInstanceProtocolManager = null;
    private static Map<String, IProtocolVersionManager> staticInstanceProtocolVersionManager = null;
    private static ITraduttore staticInstanceTraduttore = null;
    private static IProtocolConfiguration staticInstanceProtocolConfiguration = null;

    public void init(Logger log, String protocol, ConfigurazionePdD configPdD, Openspcoop2 manifest) throws ProtocolException {
        super.init(log, protocol, configPdD, manifest);
        SDIProperties.initialize(configPdD.getConfigurationDir(), log);
        SDIProperties properties = SDIProperties.getInstance(log);
        properties.validaConfigurazione(configPdD.getLoader());
        BasicStaticInstanceConfig staticInstanceConfig = properties.getStaticInstanceConfig();
        super.initStaticInstance(staticInstanceConfig);
        if (staticInstanceConfig != null && staticInstanceConfig.isStaticConfig()) {
            staticInstanceProtocolManager = new SDIProtocolManager((IProtocolFactory<?>)this);
            staticInstanceProtocolVersionManager = new HashMap<String, IProtocolVersionManager>();
            staticInstanceTraduttore = new SDITraduttore((IProtocolFactory<?>)this);
            staticInstanceProtocolConfiguration = new SDIProtocolConfiguration((IProtocolFactory<?>)this);
        }
    }

    public SDIBustaBuilder createBustaBuilder(IState state) throws ProtocolException {
        return new SDIBustaBuilder((IProtocolFactory<SOAPElement>)this, state);
    }

    public SDIValidazioneSintattica createValidazioneSintattica(IState state) throws ProtocolException {
        return new SDIValidazioneSintattica((IProtocolFactory<SOAPElement>)this, state);
    }

    public IValidazioneSemantica createValidazioneSemantica(IState state) throws ProtocolException {
        return new SDIValidazioneSemantica((IProtocolFactory<?>)this, state);
    }

    public IValidazioneConSchema createValidazioneConSchema(IState state) throws ProtocolException {
        return new SDIValidazioneConSchema((IProtocolFactory<?>)this, state);
    }

    public IProtocolManager createProtocolManager() throws ProtocolException {
        return staticInstanceProtocolManager != null ? staticInstanceProtocolManager : new SDIProtocolManager((IProtocolFactory<?>)this);
    }

    public IProtocolVersionManager createProtocolVersionManager(String version) throws ProtocolException {
        if (staticInstanceProtocolVersionManager != null) {
            if (!staticInstanceProtocolVersionManager.containsKey(version)) {
                this.initProtocolVersionManager(version);
            }
            return staticInstanceProtocolVersionManager.get(version);
        }
        return new SDIProtocolVersionManager((IProtocolFactory<?>)this, version);
    }

    private synchronized void initProtocolVersionManager(String version) throws ProtocolException {
        if (!staticInstanceProtocolVersionManager.containsKey(version)) {
            staticInstanceProtocolVersionManager.put(version, new SDIProtocolVersionManager((IProtocolFactory<?>)this, version));
        }
    }

    public ITraduttore createTraduttore() throws ProtocolException {
        return staticInstanceTraduttore != null ? staticInstanceTraduttore : new SDITraduttore((IProtocolFactory<?>)this);
    }

    public IProtocolConfiguration createProtocolConfiguration() throws ProtocolException {
        return staticInstanceProtocolConfiguration != null ? staticInstanceProtocolConfiguration : new SDIProtocolConfiguration((IProtocolFactory<?>)this);
    }
}

