/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.utils;

import it.gov.fatturapa.sdi.fatturapa.v1_0.utils.XSDValidatorWithSignature;
import it.gov.fatturapa.sdi.fatturapa.v1_0.utils.serializer.JaxbDeserializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.openspcoop2.generic_project.serializer.AbstractDeserializerBase;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.constants.SDICostanti;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;

public class SDIFatturaUtils {
    public static void validazioneFattura(byte[] fattura, SDIProperties sdiProperties, List<Eccezione> eccezioniValidazione, SDIValidazioneUtils validazioneUtils, IProtocolFactory<?> protocolFactory, Busta busta, OpenSPCoop2Message msg, boolean addMsgInContextIfEnabled, boolean validaDatiTrasmissione, boolean forceDisableValidazioneXSD) throws Exception {
        boolean forceEccezioneLivelloInfo = false;
        if (validaDatiTrasmissione) {
            if (!sdiProperties.isEnableAccessoFattura().booleanValue()) {
                return;
            }
            if (sdiProperties.isEnableAccessoFatturaWarningMode().booleanValue()) {
                forceEccezioneLivelloInfo = true;
            }
        }
        String versioneFattura = busta.getProperty("FormatoFatturaPA");
        String codiceDestinatario = busta.getProperty("CodiceDestinatario");
        if (!forceDisableValidazioneXSD && sdiProperties.isEnableValidazioneXsdFattura().booleanValue()) {
            try {
                AbstractValidatoreXSD validatore = null;
                validatore = SDICostanti.SDI_VERSIONE_FATTURA_PA_10.equals(versioneFattura) ? XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger()) : (SDICostanti.SDI_VERSIONE_FATTURA_PA_11.equals(versioneFattura) ? it.gov.fatturapa.sdi.fatturapa.v1_1.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger()) : (SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10.equals(versioneFattura) ? it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger()) : it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.XSDValidatorWithSignature.getOpenSPCoop2MessageXSDValidator(protocolFactory.getLogger())));
                validatore.valida((InputStream)new ByteArrayInputStream(fattura));
            }
            catch (Exception e) {
                String msgErrore = "Elemento [File] contiene un file Fattura(" + versioneFattura + ") non valido rispetto allo schema XSD: " + e.getMessage();
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, msgErrore, e, forceEccezioneLivelloInfo));
                return;
            }
        }
        String attributoVersione = null;
        String trasmittenteIdPaese = null;
        String trasmittenteIdCodice = null;
        String trasmissioneProgressivoInvio = null;
        String trasmissioneFormatoTrasmissione = null;
        String trasmissioneCodiceDestinatario = null;
        String trasmissionePECDestinatario = null;
        String cedentePrestatoreIdPaese = null;
        String cedentePrestatoreIdCodice = null;
        String cedentePrestatoreDenominazione = null;
        String cedentePrestatoreNome = null;
        String cedentePrestatoreCognome = null;
        String cedentePrestatoreCodiceFiscale = null;
        String cessionarioCommittenteIdPaese = null;
        String cessionarioCommittenteIdCodice = null;
        String cessionarioCommittenteDenominazione = null;
        String cessionarioCommittenteNome = null;
        String cessionarioCommittenteCognome = null;
        String cessionarioCommittenteCodiceFiscale = null;
        String terzoIdPaese = null;
        String terzoIdCodice = null;
        String terzoDenominazione = null;
        String terzoNome = null;
        String terzoCognome = null;
        String terzoCodiceFiscale = null;
        String soggettoEmittente = null;
        try {
            BaseBean fatturaHeaderObject;
            BaseBean fatturaObject;
            AbstractDeserializerBase deserializer;
            if (SDICostanti.SDI_VERSIONE_FATTURA_PA_10.equals(versioneFattura)) {
                deserializer = new JaxbDeserializer();
                fatturaObject = deserializer.readFatturaElettronicaType(fattura);
                if (addMsgInContextIfEnabled && sdiProperties.isSaveFatturaInContext().booleanValue()) {
                    msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA, (Object)fatturaObject);
                }
                fatturaHeaderObject = fatturaObject.getFatturaElettronicaHeader();
                attributoVersione = fatturaObject.getVersione();
                trasmittenteIdPaese = fatturaHeaderObject.getDatiTrasmissione().getIdTrasmittente().getIdPaese();
                trasmittenteIdCodice = fatturaHeaderObject.getDatiTrasmissione().getIdTrasmittente().getIdCodice();
                trasmissioneProgressivoInvio = fatturaHeaderObject.getDatiTrasmissione().getProgressivoInvio();
                trasmissioneFormatoTrasmissione = fatturaHeaderObject.getDatiTrasmissione().getFormatoTrasmissione().name();
                trasmissioneCodiceDestinatario = fatturaHeaderObject.getDatiTrasmissione().getCodiceDestinatario();
                if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        cedentePrestatoreIdPaese = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        cedentePrestatoreIdCodice = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getCodiceFiscale() != null) {
                        cedentePrestatoreCodiceFiscale = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica() != null) {
                        cedentePrestatoreDenominazione = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        cedentePrestatoreNome = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getNome();
                        cedentePrestatoreCognome = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        cessionarioCommittenteIdPaese = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        cessionarioCommittenteIdCodice = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getCodiceFiscale() != null) {
                        cessionarioCommittenteCodiceFiscale = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica() != null) {
                        cessionarioCommittenteDenominazione = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        cessionarioCommittenteNome = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getNome();
                        cessionarioCommittenteCognome = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente() != null && fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        terzoIdPaese = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        terzoIdCodice = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getCodiceFiscale() != null) {
                        terzoCodiceFiscale = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica() != null) {
                        terzoDenominazione = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        terzoNome = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getNome();
                        terzoCognome = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getSoggettoEmittente() != null) {
                    soggettoEmittente = fatturaHeaderObject.getSoggettoEmittente().name();
                }
            } else if (SDICostanti.SDI_VERSIONE_FATTURA_PA_11.equals(versioneFattura)) {
                deserializer = new it.gov.fatturapa.sdi.fatturapa.v1_1.utils.serializer.JaxbDeserializer();
                fatturaObject = deserializer.readFatturaElettronicaType(fattura);
                if (addMsgInContextIfEnabled && sdiProperties.isSaveFatturaInContext().booleanValue()) {
                    msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA, (Object)fatturaObject);
                }
                fatturaHeaderObject = fatturaObject.getFatturaElettronicaHeader();
                attributoVersione = fatturaObject.getVersione();
                trasmittenteIdPaese = fatturaHeaderObject.getDatiTrasmissione().getIdTrasmittente().getIdPaese();
                trasmittenteIdCodice = fatturaHeaderObject.getDatiTrasmissione().getIdTrasmittente().getIdCodice();
                trasmissioneProgressivoInvio = fatturaHeaderObject.getDatiTrasmissione().getProgressivoInvio();
                trasmissioneFormatoTrasmissione = fatturaHeaderObject.getDatiTrasmissione().getFormatoTrasmissione().name();
                trasmissioneCodiceDestinatario = fatturaHeaderObject.getDatiTrasmissione().getCodiceDestinatario();
                if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        cedentePrestatoreIdPaese = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        cedentePrestatoreIdCodice = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getCodiceFiscale() != null) {
                        cedentePrestatoreCodiceFiscale = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica() != null) {
                        cedentePrestatoreDenominazione = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        cedentePrestatoreNome = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getNome();
                        cedentePrestatoreCognome = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        cessionarioCommittenteIdPaese = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        cessionarioCommittenteIdCodice = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getCodiceFiscale() != null) {
                        cessionarioCommittenteCodiceFiscale = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica() != null) {
                        cessionarioCommittenteDenominazione = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        cessionarioCommittenteNome = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getNome();
                        cessionarioCommittenteCognome = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente() != null && fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        terzoIdPaese = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        terzoIdCodice = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getCodiceFiscale() != null) {
                        terzoCodiceFiscale = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica() != null) {
                        terzoDenominazione = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        terzoNome = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getNome();
                        terzoCognome = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getSoggettoEmittente() != null) {
                    soggettoEmittente = fatturaHeaderObject.getSoggettoEmittente().name();
                }
            } else if (SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10.equals(versioneFattura)) {
                deserializer = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_0.utils.serializer.JaxbDeserializer();
                fatturaObject = deserializer.readFatturaElettronicaType(fattura);
                if (addMsgInContextIfEnabled && sdiProperties.isSaveFatturaInContext().booleanValue()) {
                    msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA, (Object)fatturaObject);
                }
                fatturaHeaderObject = fatturaObject.getFatturaElettronicaHeader();
                if (fatturaObject.getVersione() != null) {
                    attributoVersione = fatturaObject.getVersione().name();
                }
                trasmittenteIdPaese = fatturaHeaderObject.getDatiTrasmissione().getIdTrasmittente().getIdPaese();
                trasmittenteIdCodice = fatturaHeaderObject.getDatiTrasmissione().getIdTrasmittente().getIdCodice();
                trasmissioneProgressivoInvio = fatturaHeaderObject.getDatiTrasmissione().getProgressivoInvio();
                trasmissioneFormatoTrasmissione = fatturaHeaderObject.getDatiTrasmissione().getFormatoTrasmissione().name();
                trasmissioneCodiceDestinatario = fatturaHeaderObject.getDatiTrasmissione().getCodiceDestinatario();
                if (fatturaHeaderObject.getCedentePrestatore() != null) {
                    if (fatturaHeaderObject.getCedentePrestatore().getIdFiscaleIVA() != null) {
                        cedentePrestatoreIdPaese = fatturaHeaderObject.getCedentePrestatore().getIdFiscaleIVA().getIdPaese();
                        cedentePrestatoreIdCodice = fatturaHeaderObject.getCedentePrestatore().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getCodiceFiscale() != null) {
                        cedentePrestatoreCodiceFiscale = fatturaHeaderObject.getCedentePrestatore().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getDenominazione() != null) {
                        cedentePrestatoreDenominazione = fatturaHeaderObject.getCedentePrestatore().getDenominazione();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getNome() != null) {
                        cedentePrestatoreNome = fatturaHeaderObject.getCedentePrestatore().getNome();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getCognome() != null) {
                        cedentePrestatoreCognome = fatturaHeaderObject.getCedentePrestatore().getCognome();
                    }
                }
                if (fatturaHeaderObject.getCessionarioCommittente() != null) {
                    if (fatturaHeaderObject.getCessionarioCommittente().getIdentificativiFiscali() != null) {
                        if (fatturaHeaderObject.getCessionarioCommittente().getIdentificativiFiscali().getIdFiscaleIVA() != null) {
                            cessionarioCommittenteIdPaese = fatturaHeaderObject.getCessionarioCommittente().getIdentificativiFiscali().getIdFiscaleIVA().getIdPaese();
                            cessionarioCommittenteIdCodice = fatturaHeaderObject.getCessionarioCommittente().getIdentificativiFiscali().getIdFiscaleIVA().getIdCodice();
                        }
                        if (fatturaHeaderObject.getCessionarioCommittente().getIdentificativiFiscali().getCodiceFiscale() != null) {
                            cessionarioCommittenteCodiceFiscale = fatturaHeaderObject.getCessionarioCommittente().getIdentificativiFiscali().getCodiceFiscale();
                        }
                    }
                    if (fatturaHeaderObject.getCessionarioCommittente().getAltriDatiIdentificativi() != null) {
                        if (fatturaHeaderObject.getCessionarioCommittente().getAltriDatiIdentificativi().getDenominazione() != null) {
                            cessionarioCommittenteDenominazione = fatturaHeaderObject.getCessionarioCommittente().getAltriDatiIdentificativi().getDenominazione();
                        }
                        if (fatturaHeaderObject.getCessionarioCommittente().getAltriDatiIdentificativi().getNome() != null) {
                            cessionarioCommittenteNome = fatturaHeaderObject.getCessionarioCommittente().getAltriDatiIdentificativi().getNome();
                        }
                        if (fatturaHeaderObject.getCessionarioCommittente().getAltriDatiIdentificativi().getCognome() != null) {
                            cessionarioCommittenteCognome = fatturaHeaderObject.getCessionarioCommittente().getAltriDatiIdentificativi().getCognome();
                        }
                    }
                }
                if (fatturaHeaderObject.getSoggettoEmittente() != null) {
                    soggettoEmittente = fatturaHeaderObject.getSoggettoEmittente().name();
                }
            } else {
                deserializer = new it.gov.agenziaentrate.ivaservizi.docs.xsd.fatture.v1_2.utils.serializer.JaxbDeserializer();
                fatturaObject = deserializer.readFatturaElettronicaType(fattura);
                if (addMsgInContextIfEnabled && sdiProperties.isSaveFatturaInContext().booleanValue()) {
                    msg.addContextProperty(SDICostanti.SDI_MESSAGE_CONTEXT_FATTURA, (Object)fatturaObject);
                }
                fatturaHeaderObject = fatturaObject.getFatturaElettronicaHeader();
                if (fatturaObject.getVersione() != null) {
                    attributoVersione = fatturaObject.getVersione().getValue();
                }
                trasmittenteIdPaese = fatturaHeaderObject.getDatiTrasmissione().getIdTrasmittente().getIdPaese();
                trasmittenteIdCodice = fatturaHeaderObject.getDatiTrasmissione().getIdTrasmittente().getIdCodice();
                trasmissioneProgressivoInvio = fatturaHeaderObject.getDatiTrasmissione().getProgressivoInvio();
                trasmissioneFormatoTrasmissione = fatturaHeaderObject.getDatiTrasmissione().getFormatoTrasmissione().name();
                trasmissioneCodiceDestinatario = fatturaHeaderObject.getDatiTrasmissione().getCodiceDestinatario();
                trasmissionePECDestinatario = fatturaHeaderObject.getDatiTrasmissione().getPecDestinatario();
                if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        cedentePrestatoreIdPaese = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        cedentePrestatoreIdCodice = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getCodiceFiscale() != null) {
                        cedentePrestatoreCodiceFiscale = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica() != null) {
                        cedentePrestatoreDenominazione = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        cedentePrestatoreNome = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getNome();
                        cedentePrestatoreCognome = fatturaHeaderObject.getCedentePrestatore().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        cessionarioCommittenteIdPaese = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        cessionarioCommittenteIdCodice = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getCodiceFiscale() != null) {
                        cessionarioCommittenteCodiceFiscale = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica() != null) {
                        cessionarioCommittenteDenominazione = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        cessionarioCommittenteNome = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getNome();
                        cessionarioCommittenteCognome = fatturaHeaderObject.getCessionarioCommittente().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente() != null && fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici() != null) {
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA() != null) {
                        terzoIdPaese = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA().getIdPaese();
                        terzoIdCodice = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getIdFiscaleIVA().getIdCodice();
                    }
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getCodiceFiscale() != null) {
                        terzoCodiceFiscale = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getCodiceFiscale();
                    }
                    if (fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica() != null) {
                        terzoDenominazione = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getDenominazione();
                        terzoNome = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getNome();
                        terzoCognome = fatturaHeaderObject.getTerzoIntermediarioOSoggettoEmittente().getDatiAnagrafici().getAnagrafica().getCognome();
                    }
                }
                if (fatturaHeaderObject.getSoggettoEmittente() != null) {
                    soggettoEmittente = fatturaHeaderObject.getSoggettoEmittente().name();
                }
            }
        }
        catch (Exception e) {
            String msgErrore = "Elemento [File] contiene un file Fattura(" + versioneFattura + ") non valido: " + e.getMessage();
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, msgErrore, e, forceEccezioneLivelloInfo));
            return;
        }
        String attributoAtteso = null;
        boolean attributoVersioneNonCorretto = false;
        if (SDICostanti.SDI_VERSIONE_FATTURA_PA_10.equals(versioneFattura)) {
            if (!"1.0".equals(attributoVersione)) {
                attributoAtteso = "1.0";
                attributoVersioneNonCorretto = true;
            }
        } else if (SDICostanti.SDI_VERSIONE_FATTURA_PA_11.equals(versioneFattura)) {
            if (!"1.1".equals(attributoVersione)) {
                attributoAtteso = "1.1";
                attributoVersioneNonCorretto = true;
            }
        } else if (SDICostanti.SDI_VERSIONE_FATTURA_SEMPLIFICATA_10.equals(versioneFattura)) {
            if (!SDICostanti.SDI_ATTRIBUTE_VERSION_FATTURA_SEMPLIFICATA_10.equals(attributoVersione)) {
                attributoAtteso = SDICostanti.SDI_ATTRIBUTE_VERSION_FATTURA_SEMPLIFICATA_10;
                attributoVersioneNonCorretto = true;
            }
        } else if (SDICostanti.SDI_VERSIONE_FATTURA_PA_12.equals(versioneFattura)) {
            if (!SDICostanti.SDI_ATTRIBUTE_VERSION_FATTURA_PA_12.equals(attributoVersione)) {
                attributoAtteso = SDICostanti.SDI_ATTRIBUTE_VERSION_FATTURA_PA_12;
                attributoVersioneNonCorretto = true;
            }
        } else if (SDICostanti.SDI_VERSIONE_FATTURA_PR_12.equals(versioneFattura) && !SDICostanti.SDI_ATTRIBUTE_VERSION_FATTURA_PR_12.equals(attributoVersione)) {
            attributoAtteso = SDICostanti.SDI_ATTRIBUTE_VERSION_FATTURA_PR_12;
            attributoVersioneNonCorretto = true;
        }
        if (attributoVersioneNonCorretto) {
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Attributo versione presente [" + attributoVersione + "] differente da quello atteso [" + attributoAtteso + "] per la versione della fattura [" + versioneFattura + "]", sdiProperties.isEnableValidazioneCampiInterniFattura() == false));
            if (sdiProperties.isEnableValidazioneCampiInterniFattura().booleanValue()) {
                return;
            }
        }
        if (validaDatiTrasmissione) {
            String nomeFileSdi = busta.getProperty("NomeFile");
            String[] nomeFileSdiSplit = nomeFileSdi.split("_");
            String idPaese = nomeFileSdiSplit[0].substring(0, 2);
            String idCodice = nomeFileSdiSplit[0].substring(2);
            if (!idPaese.equals(trasmittenteIdPaese)) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "NomeFile presente nel messaggio SdI [" + nomeFileSdi + "] possiede un idPaese[" + idPaese + "] differente da quello presente nella fattura [" + trasmittenteIdPaese + "]", sdiProperties.isEnableValidazioneCampiInterniFattura() == false));
                if (sdiProperties.isEnableValidazioneCampiInterniFattura().booleanValue()) {
                    return;
                }
            }
            if (!idCodice.equals(trasmittenteIdCodice)) {
                eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "NomeFile presente nel messaggio SdI [" + nomeFileSdi + "] possiede un idCodice[" + idCodice + "] differente da quello presente nella fattura [" + trasmittenteIdCodice + "]", sdiProperties.isEnableValidazioneCampiInterniFattura() == false));
                if (sdiProperties.isEnableValidazioneCampiInterniFattura().booleanValue()) {
                    return;
                }
            }
        }
        busta.addProperty("DatiTrasmissione-IdTrasmittente-IdPaese", trasmittenteIdPaese);
        busta.addProperty("DatiTrasmissione-IdTrasmittente-IdCodice", trasmittenteIdCodice);
        busta.addProperty("DatiTrasmissione-ProgressivoInvio", trasmissioneProgressivoInvio);
        if (validaDatiTrasmissione && !versioneFattura.equals(trasmissioneFormatoTrasmissione)) {
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Formato di trasmissione indicato nel file Metadati [" + versioneFattura + "] differente da quello presente nella fattura [" + trasmissioneFormatoTrasmissione + "]", sdiProperties.isEnableValidazioneCampiInterniFattura() == false));
            if (sdiProperties.isEnableValidazioneCampiInterniFattura().booleanValue()) {
                return;
            }
        }
        if (validaDatiTrasmissione && !codiceDestinatario.equals(trasmissioneCodiceDestinatario)) {
            eccezioniValidazione.add(validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO, "Codice Destinatario indicato nel file Metadati [" + codiceDestinatario + "] differente da quello presente nella fattura [" + trasmissioneCodiceDestinatario + "]", sdiProperties.isEnableValidazioneCampiInterniFattura() == false));
            if (sdiProperties.isEnableValidazioneCampiInterniFattura().booleanValue()) {
                return;
            }
        }
        busta.addProperty("DatiTrasmissione-PECDestinatario", trasmissionePECDestinatario);
        if (cedentePrestatoreIdPaese != null) {
            busta.addProperty("CedentePrestatore-IdPaese", cedentePrestatoreIdPaese);
        }
        if (cedentePrestatoreIdCodice != null) {
            busta.addProperty("CedentePrestatore-IdCodice", cedentePrestatoreIdCodice);
        }
        if (cedentePrestatoreCodiceFiscale != null) {
            busta.addProperty("CedentePrestatore-CodiceFiscale", cedentePrestatoreCodiceFiscale);
        }
        if (cedentePrestatoreDenominazione != null) {
            busta.addProperty("CedentePrestatore-Denominazione", cedentePrestatoreDenominazione);
        }
        if (cedentePrestatoreNome != null) {
            busta.addProperty("CedentePrestatore-Nome", cedentePrestatoreNome);
        }
        if (cedentePrestatoreCognome != null) {
            busta.addProperty("CedentePrestatore-Cognome", cedentePrestatoreCognome);
        }
        if (cessionarioCommittenteIdPaese != null) {
            busta.addProperty("CessionarioCommittente-IdPaese", cessionarioCommittenteIdPaese);
        }
        if (cessionarioCommittenteIdCodice != null) {
            busta.addProperty("CessionarioCommittente-IdCodice", cessionarioCommittenteIdCodice);
        }
        if (cessionarioCommittenteCodiceFiscale != null) {
            busta.addProperty("CessionarioCommittente-CodiceFiscale", cessionarioCommittenteCodiceFiscale);
        }
        if (cessionarioCommittenteDenominazione != null) {
            busta.addProperty("CessionarioCommittente-Denominazione", cessionarioCommittenteDenominazione);
        }
        if (cessionarioCommittenteNome != null) {
            busta.addProperty("CessionarioCommittente-Nome", cessionarioCommittenteNome);
        }
        if (cessionarioCommittenteCognome != null) {
            busta.addProperty("CessionarioCommittente-Cognome", cessionarioCommittenteCognome);
        }
        if (terzoIdPaese != null) {
            busta.addProperty("TerzoIntermediarioOSoggettoEmittente-IdPaese", terzoIdPaese);
        }
        if (terzoIdCodice != null) {
            busta.addProperty("TerzoIntermediarioOSoggettoEmittente-IdCodice", terzoIdCodice);
        }
        if (terzoCodiceFiscale != null) {
            busta.addProperty("TerzoIntermediarioOSoggettoEmittente-CodiceFiscale", terzoCodiceFiscale);
        }
        if (terzoDenominazione != null) {
            busta.addProperty("TerzoIntermediarioOSoggettoEmittente-Denominazione", terzoDenominazione);
        }
        if (terzoNome != null) {
            busta.addProperty("TerzoIntermediarioOSoggettoEmittente-Nome", terzoNome);
        }
        if (terzoCognome != null) {
            busta.addProperty("TerzoIntermediarioOSoggettoEmittente-Cognome", terzoCognome);
        }
        if (soggettoEmittente != null) {
            busta.addProperty("SoggettoEmittente", soggettoEmittente);
        }
    }
}

