/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.utils;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDILottoUtils {
    public static List<byte[]> splitLotto(byte[] lotto) throws Exception {
        Node n;
        int i;
        ArrayList<byte[]> risultato = new ArrayList<byte[]>();
        XMLUtils xmlUtils = XMLUtils.getInstance();
        XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
        Element lottoElement = null;
        DynamicNamespaceContext dnc = null;
        try {
            lottoElement = xmlUtils.newElement(lotto);
            dnc = new DynamicNamespaceContext();
            dnc.findPrefixNamespace((Node)lottoElement);
        }
        catch (Exception e) {
            throw new Exception("Lettura lotto di fattura non riuscita: " + e.getMessage(), e);
        }
        NodeList nl = null;
        try {
            nl = (NodeList)xpathEngine.getMatchPattern(lottoElement, dnc, "//FatturaElettronicaBody", XPathReturnType.NODESET);
        }
        catch (XPathNotFoundException notFound) {
            throw new Exception("La fattura non contiene alcun body?: " + notFound.getMessage(), notFound);
        }
        catch (Exception e) {
            throw new Exception("Estrazione body dal lotto di fattura non riuscita: " + e.getMessage(), e);
        }
        if (nl == null) {
            throw new Exception("La fattura non contiene alcun body? (null)");
        }
        if (nl.getLength() < 1) {
            throw new Exception("La fattura non contiene alcun body? (size): " + nl.getLength());
        }
        if (nl.getLength() == 1) {
            risultato.add(lotto);
            return risultato;
        }
        ArrayList<Node> listBody = new ArrayList<Node>();
        try {
            for (i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i);
                listBody.add(n);
                lottoElement.removeChild(n);
            }
        }
        catch (Exception e) {
            throw new Exception("Elaborazione lotto di fattura (step1) non riuscita: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < listBody.size(); ++i) {
                n = (Node)listBody.get(i);
                lottoElement.appendChild(n);
                risultato.add(xmlUtils.toByteArray(lottoElement));
                lottoElement.removeChild(n);
            }
        }
        catch (Exception e) {
            throw new Exception("Elaborazione lotto di fattura (step2-" + i + ") non riuscita: " + e.getMessage(), e);
        }
        return risultato;
    }
}

