/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.protocol.basic.validator.ValidazioneSemantica;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreServizioRiceviFile;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreServizioRiceviNotifica;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreServizioRicezioneFatture;
import org.openspcoop2.protocol.sdi.validator.SDIValidatoreServizioTrasmissioneFatture;
import org.openspcoop2.protocol.sdi.validator.SDIValidazioneUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSemanticaResult;

public class SDIValidazioneSemantica
extends ValidazioneSemantica {
    protected SDIValidazioneUtils validazioneUtils;
    protected SDIProperties sdiProperties;
    protected List<Eccezione> erroriValidazione = new ArrayList<Eccezione>();
    protected List<Eccezione> erroriProcessamento = new ArrayList<Eccezione>();

    public SDIValidazioneSemantica(IProtocolFactory<?> factory, IState state) throws ProtocolException {
        super(factory, state);
        this.sdiProperties = SDIProperties.getInstance(this.log);
        this.validazioneUtils = new SDIValidazioneUtils(factory);
    }

    public ValidazioneSemanticaResult valida(OpenSPCoop2Message msg, Busta busta, ProprietaValidazione proprietaValidazione, RuoloBusta tipoBusta) throws ProtocolException {
        OpenSPCoop2SoapMessage soapMsg = null;
        try {
            soapMsg = msg.castAsSoap();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        this.valida(proprietaValidazione, soapMsg, busta, tipoBusta);
        List<Eccezione> erroriValidazione = null;
        if (this.erroriValidazione.size() > 0) {
            erroriValidazione = this.erroriValidazione;
        }
        List erroriProcessamento = null;
        if (this.erroriProcessamento.size() > 0) {
            erroriValidazione = this.erroriProcessamento;
        }
        ValidazioneSemanticaResult validazioneSemantica = new ValidazioneSemanticaResult(erroriValidazione, erroriProcessamento, null, null, null, null);
        return validazioneSemantica;
    }

    private void valida(ProprietaValidazione proprietaValidazione, OpenSPCoop2SoapMessage msg, Busta busta, RuoloBusta tipoBusta) throws ProtocolException {
        try {
            boolean isRichiesta = RuoloBusta.RICHIESTA.equals((Object)tipoBusta);
            if ("TrasmissioneFatture".equals(busta.getServizio())) {
                this.validaServizioTrasmissione(proprietaValidazione, (OpenSPCoop2Message)msg, busta, isRichiesta, SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)msg.getSOAPBody()));
            } else if ("RicezioneFatture".equals(busta.getServizio())) {
                this.validaServizioRicezione(proprietaValidazione, (OpenSPCoop2Message)msg, busta, isRichiesta, SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)msg.getSOAPBody()));
            } else if ("SdIRiceviNotifica".equals(busta.getServizio())) {
                this.validaServizioRiceviNotifica((OpenSPCoop2Message)msg, busta, isRichiesta, SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)msg.getSOAPBody()));
            } else if ("SdIRiceviFile".equals(busta.getServizio())) {
                this.validaServizioRiceviFile((OpenSPCoop2Message)msg, busta, isRichiesta, SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)msg.getSOAPBody()));
            }
        }
        catch (Exception e) {
            this.erroriProcessamento.add(this.validazioneUtils.newEccezioneProcessamento(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO, e.getMessage(), e));
            return;
        }
    }

    private void validaServizioTrasmissione(ProprietaValidazione proprietaValidazione, OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, SOAPElement sdiMessage) throws Exception {
        String azione = busta.getAzione();
        SDIValidatoreServizioTrasmissioneFatture validatore = new SDIValidatoreServizioTrasmissioneFatture(this, proprietaValidazione, msg, isRichiesta, sdiMessage, busta);
        if ("RicevutaConsegna".equals(azione)) {
            validatore.validaRicevutaConsegna();
        } else if ("NotificaMancataConsegna".equals(azione)) {
            validatore.validaNotificaMancataConsegna();
        } else if ("NotificaScarto".equals(azione)) {
            validatore.validaNotificaScarto();
        } else if ("NotificaEsito".equals(azione)) {
            validatore.validaNotificaEsito();
        } else if ("NotificaDecorrenzaTermini".equals(azione)) {
            validatore.validaNotificaDecorrenzaTermini();
        } else if ("AttestazioneTrasmissioneFattura".equals(azione)) {
            validatore.validaAttestazioneTrasmissioneFattura();
        } else {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA));
            return;
        }
    }

    private void validaServizioRicezione(ProprietaValidazione proprietaValidazione, OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, SOAPElement sdiMessage) throws Exception {
        String azione = busta.getAzione();
        SDIValidatoreServizioRicezioneFatture validatore = new SDIValidatoreServizioRicezioneFatture(this, proprietaValidazione, msg, isRichiesta, sdiMessage, busta);
        if ("RiceviFatture".equals(azione)) {
            validatore.validaRiceviFatture();
        } else if ("NotificaDecorrenzaTermini".equals(azione)) {
            validatore.validaNotificaDecorrenzaTermini();
        } else {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA));
            return;
        }
    }

    private void validaServizioRiceviNotifica(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, SOAPElement sdiMessage) throws Exception {
        String azione = busta.getAzione();
        SDIValidatoreServizioRiceviNotifica validatore = new SDIValidatoreServizioRiceviNotifica(this, msg, isRichiesta, sdiMessage, busta);
        if (!"NotificaEsito".equals(azione)) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA));
            return;
        }
        validatore.validaNotificaEsito();
    }

    private void validaServizioRiceviFile(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, SOAPElement sdiMessage) throws Exception {
        String azione = busta.getAzione();
        SDIValidatoreServizioRiceviFile validatore = new SDIValidatoreServizioRiceviFile(this, msg, isRichiesta, sdiMessage, busta);
        if (!"RiceviFile".equals(azione)) {
            this.erroriValidazione.add(this.validazioneUtils.newEccezioneValidazione(CodiceErroreCooperazione.AZIONE_NON_VALIDA));
            return;
        }
        validatore.validaRiceviFile();
    }
}

