/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.ast;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.ws.wadl.ast.AstMessages;
import org.jvnet.ws.wadl.ast.InvalidWADLException;
import org.jvnet.ws.wadl.ast.WadlAstBuilder;
import org.jvnet.ws.wadl.util.MessageListener;

public class ElementResolver {
    private Map<String, Object> map;
    private MessageListener messageListener;

    public ElementResolver(MessageListener messageListener) {
        this.messageListener = messageListener;
        this.map = new HashMap<String, Object>();
    }

    public Object get(String ref) {
        return this.map.get(ref);
    }

    public <T> T resolve(URI file, String href, T object) throws InvalidWADLException {
        Object o = null;
        String id = file.toString() + href.substring(href.indexOf(35));
        o = this.map.get(id);
        if (o == null) {
            throw WadlAstBuilder.messageStringFromObject(AstMessages.SKIPPING_REFERENCE(href), object);
        }
        if (!object.getClass().isInstance(o)) {
            throw WadlAstBuilder.messageStringFromObject(AstMessages.SKIPPING_REFERENCE_TYPE(href), object);
        }
        return (T)o;
    }

    public String addReference(URI file, String id, Object o) {
        String uniqueId = null;
        if (id != null && id.length() > 0) {
            uniqueId = file.toString() + "#" + id;
            this.map.put(uniqueId, o);
        }
        return uniqueId;
    }
}

