/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.ast;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.jvnet.ws.wadl.Doc;
import org.jvnet.ws.wadl.Method;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ast.AbstractNode;
import org.jvnet.ws.wadl.ast.FaultNode;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.jvnet.ws.wadl.ast.ResourceTypeNode;
import org.jvnet.ws.wadl.util.AbstractMultivaluedMap;
import org.xml.sax.Locator;

public class MethodNode
extends AbstractNode {
    private ResourceNode parentResource;
    private ResourceTypeNode parentResourceType;
    private String name;
    private List<Param> queryParams;
    private List<Param> headerParams;
    private List<Param> matrixParams;
    private List<RepresentationNode> supportedInputs;
    private MultivaluedMap<List<Long>, RepresentationNode> supportedOutputs;
    private MultivaluedMap<List<Long>, FaultNode> faults;
    private Method method;

    public MethodNode(Method m, ResourceNode r) {
        this.method = m;
        this.name = m.getName();
        this.parentResource = r;
        this.parentResourceType = null;
        this.queryParams = new ArrayList<Param>();
        this.queryParams.addAll(this.parentResource.getQueryParams());
        this.headerParams = new ArrayList<Param>();
        this.headerParams.addAll(this.parentResource.getHeaderParams());
        this.matrixParams = new ArrayList<Param>();
        this.matrixParams.addAll(this.parentResource.getMatrixParams());
        this.supportedInputs = new ArrayList<RepresentationNode>();
        this.supportedOutputs = new AbstractMultivaluedMap<List<Long>, RepresentationNode>(new LinkedHashMap()){};
        this.faults = new AbstractMultivaluedMap<List<Long>, FaultNode>(new LinkedHashMap()){};
        r.getMethods().add(this);
    }

    public MethodNode(Method m, ResourceTypeNode r) {
        this.method = m;
        this.name = m.getName();
        this.parentResource = null;
        this.parentResourceType = r;
        this.queryParams = new ArrayList<Param>();
        this.queryParams.addAll(r.getQueryParams());
        this.headerParams = new ArrayList<Param>();
        this.headerParams.addAll(r.getHeaderParams());
        this.matrixParams = new ArrayList<Param>();
        this.matrixParams.addAll(r.getMatrixParams());
        this.supportedInputs = new ArrayList<RepresentationNode>();
        this.supportedOutputs = new AbstractMultivaluedMap<List<Long>, RepresentationNode>(new LinkedHashMap()){};
        this.faults = new AbstractMultivaluedMap<List<Long>, FaultNode>(new LinkedHashMap()){};
        r.getMethods().add(this);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.method.getId();
    }

    public ResourceNode getOwningResource() {
        return this.parentResource;
    }

    public List<Param> getQueryParameters() {
        return this.queryParams;
    }

    public List<Param> getHeaderParameters() {
        return this.headerParams;
    }

    public List<Param> getMatrixParameters() {
        return this.matrixParams;
    }

    private List<Param> filterParams(List<Param> result, List<Param> toFilter, boolean required) {
        Boolean bRequired = required;
        for (Param p : toFilter) {
            if (p.isRequired() != bRequired.booleanValue()) continue;
            result.add(p);
        }
        return result;
    }

    public List<Param> getRequiredParameters() {
        ArrayList<Param> required = new ArrayList<Param>();
        this.filterParams(required, this.getQueryParameters(), true);
        this.filterParams(required, this.getHeaderParameters(), true);
        this.filterParams(required, this.getMatrixParameters(), true);
        return required;
    }

    public List<Param> getOptionalParameters() {
        ArrayList<Param> optional = new ArrayList<Param>();
        this.filterParams(optional, this.getQueryParameters(), false);
        this.filterParams(optional, this.getHeaderParameters(), false);
        return optional;
    }

    public boolean hasOptionalParameters() {
        return this.getOptionalParameters().size() > 0;
    }

    public List<RepresentationNode> getSupportedInputs() {
        return this.supportedInputs;
    }

    public MultivaluedMap<List<Long>, RepresentationNode> getSupportedOutputs() {
        return this.supportedOutputs;
    }

    public MultivaluedMap<List<Long>, FaultNode> getFaults() {
        return this.faults;
    }

    public List<Doc> getDoc() {
        return this.method.getDoc();
    }

    @Override
    public Locator getLocation() {
        return this.method.sourceLocation();
    }

    @Override
    public void visit(AbstractNode.NodeVisitor visitor) {
        super.visit(visitor);
        for (RepresentationNode node : this.getSupportedInputs()) {
            node.visit(visitor);
        }
        for (List nodeList : this.getSupportedOutputs().values()) {
            for (AbstractNode node : nodeList) {
                node.visit(visitor);
            }
        }
        for (List nodeList : this.getFaults().values()) {
            for (AbstractNode node : nodeList) {
                node.visit(visitor);
            }
        }
    }
}

