/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.ast;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.jvnet.ws.wadl.Application;
import org.jvnet.ws.wadl.Doc;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.Resource;
import org.jvnet.ws.wadl.Resources;
import org.jvnet.ws.wadl.ast.AbstractNode;
import org.jvnet.ws.wadl.ast.ElementResolver;
import org.jvnet.ws.wadl.ast.InvalidWADLException;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.PathSegment;
import org.jvnet.ws.wadl.ast.ResourceTypeNode;
import org.jvnet.ws.wadl2java.GeneratorUtil;
import org.xml.sax.Locator;

public class ResourceNode
extends AbstractNode {
    private Object rootElement;
    private ResourceNode parentResource;
    private String className;
    private PathSegment pathSegment;
    private List<ResourceNode> childResources;
    private List<MethodNode> methods;
    private List<ResourceTypeNode> types;
    private List<Doc> doc;

    public ResourceNode(URI baseURI, Application app, Resources resources) {
        this.doc = app.getDoc();
        this.parentResource = null;
        this.rootElement = resources;
        String baseString = resources.getBase();
        URI base = URI.create(baseString);
        if (!base.isAbsolute()) {
            UriBuilder builder = UriBuilder.fromUri((URI)baseURI);
            String originalPath = baseURI.getPath();
            if (baseString.startsWith("/")) {
                builder.replacePath(baseString);
            } else {
                if (!originalPath.endsWith("/") && originalPath.lastIndexOf(47) != -1) {
                    builder.replacePath(originalPath.substring(0, originalPath.lastIndexOf(47)));
                }
                builder.path(baseString);
            }
            base = builder.build(new Object[0]);
        }
        this.className = ResourceNode.createClassNameFromBase(base.toString());
        this.pathSegment = new PathSegment(resources == null ? "" : base.toString());
        this.childResources = new ArrayList<ResourceNode>();
        this.methods = new ArrayList<MethodNode>();
        this.types = new ArrayList<ResourceTypeNode>();
    }

    public static String createClassNameFromBase(String base) {
        try {
            URL url = new URL(base);
            String simpifiedURL = url.getHost() + (url.getPath().length() > 0 && !url.getPath().equals("/") ? "_" + url.getPath() : "");
            return GeneratorUtil.makeClassName(simpifiedURL);
        }
        catch (MalformedURLException me) {
            return GeneratorUtil.makeClassName(base);
        }
    }

    public ResourceNode(Resource resource, ResourceNode parent, URI file, ElementResolver idMap) throws InvalidWADLException {
        this.doc = resource.getDoc();
        this.rootElement = resource;
        this.parentResource = parent;
        this.pathSegment = new PathSegment(resource, file, idMap);
        this.className = GeneratorUtil.makeClassName(this.getUriTemplate());
        this.childResources = new ArrayList<ResourceNode>();
        this.methods = new ArrayList<MethodNode>();
        this.types = new ArrayList<ResourceTypeNode>();
    }

    public ResourceNode(Resource resource, ResourceTypeNode parent, URI file, ElementResolver idMap) throws InvalidWADLException {
        this.doc = resource.getDoc();
        this.rootElement = resource;
        this.parentResource = null;
        this.pathSegment = new PathSegment(resource, file, idMap);
        this.childResources = new ArrayList<ResourceNode>();
        this.methods = new ArrayList<MethodNode>();
        this.types = new ArrayList<ResourceTypeNode>();
    }

    public ResourceNode addChild(Resource r, URI file, ElementResolver idMap) throws InvalidWADLException {
        ResourceNode n = new ResourceNode(r, this, file, idMap);
        this.childResources.add(n);
        return n;
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = GeneratorUtil.makeClassName(this.getUriTemplate());
        }
        return this.className;
    }

    public String getUriTemplate() {
        return this.pathSegment.getTemplate();
    }

    public String getAllResourceUriTemplate() {
        StringBuilder sb = new StringBuilder("/");
        List<PathSegment> segments = this.getPathSegments();
        for (int segement = 1; segement < segments.size(); ++segement) {
            String pathSegment = segments.get(segement).getTemplate();
            boolean bufferEndsInSlash = sb.length() > 0 ? sb.charAt(sb.length() - 1) == '/' : false;
            boolean pathSegmentStartsWithSlash = pathSegment.startsWith("/");
            if (pathSegmentStartsWithSlash && bufferEndsInSlash) {
                sb.append(pathSegment, 1, pathSegment.length());
                continue;
            }
            if (pathSegmentStartsWithSlash ^ bufferEndsInSlash) {
                sb.append(pathSegment);
                continue;
            }
            sb.append('/');
            sb.append(pathSegment);
        }
        return sb.toString();
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<ResourceNode> getChildResources() {
        return this.childResources;
    }

    public PathSegment getPathSegment() {
        return this.pathSegment;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public void addResourceType(ResourceTypeNode n) {
        this.types.add(n);
        this.methods.addAll(n.getMethods());
        this.childResources.addAll(n.getResources());
        this.pathSegment.getQueryParameters().addAll(n.getQueryParams());
        this.pathSegment.getMatrixParameters().addAll(n.getMatrixParams());
    }

    public List<ResourceTypeNode> getResourceTypes() {
        return this.types;
    }

    public ResourceNode getParentResource() {
        return this.parentResource;
    }

    public List<PathSegment> getPathSegments() {
        ArrayList<PathSegment> list = new ArrayList<PathSegment>();
        for (ResourceNode n = this; n != null; n = n.getParentResource()) {
            list.add(0, n.getPathSegment());
        }
        return list;
    }

    public List<Param> getQueryParams() {
        ArrayList<Param> completeList = new ArrayList<Param>();
        completeList.addAll(this.getPathSegment().getQueryParameters());
        return completeList;
    }

    public List<Param> getHeaderParams() {
        ArrayList<Param> completeList = new ArrayList<Param>();
        completeList.addAll(this.getPathSegment().getHeaderParameters());
        return completeList;
    }

    public List<Param> getMatrixParams() {
        ArrayList<Param> completeList = new ArrayList<Param>();
        completeList.addAll(this.getPathSegment().getMatrixParameters());
        if (this.getParentResource() != null) {
            completeList.addAll(this.getParentResource().getMatrixParams());
        }
        return completeList;
    }

    public List<Doc> getDoc() {
        return this.doc;
    }

    @Override
    public Locator getLocation() {
        return this.rootElement instanceof Application ? ((Resources)this.rootElement).sourceLocation() : ((Resource)this.rootElement).sourceLocation();
    }

    @Override
    public void visit(AbstractNode.NodeVisitor visitor) {
        super.visit(visitor);
        for (ResourceTypeNode resourceTypeNode : this.getResourceTypes()) {
            resourceTypeNode.visit(visitor);
        }
        for (ResourceNode resourceNode : this.getChildResources()) {
            resourceNode.visit(visitor);
        }
        for (MethodNode methodNode : this.getMethods()) {
            methodNode.visit(visitor);
        }
    }
}

