/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.ast;

import com.sun.codemodel.JDefinedClass;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.ws.wadl.Doc;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.Resource;
import org.jvnet.ws.wadl.ResourceType;
import org.jvnet.ws.wadl.ast.AbstractNode;
import org.jvnet.ws.wadl.ast.ElementResolver;
import org.jvnet.ws.wadl.ast.InvalidWADLException;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.PathSegment;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.jvnet.ws.wadl2java.GeneratorUtil;
import org.xml.sax.Locator;

public class ResourceTypeNode
extends AbstractNode {
    private String interfaceName;
    private List<MethodNode> methods;
    private List<ResourceNode> resources;
    private PathSegment pathSegment;
    private List<Doc> doc;
    private JDefinedClass generatedInterface;
    private ResourceType resourceType;

    public ResourceTypeNode(ResourceType resourceType, URI file, ElementResolver idMap) throws InvalidWADLException {
        this.doc = resourceType.getDoc();
        this.pathSegment = new PathSegment(resourceType, file, idMap);
        this.interfaceName = GeneratorUtil.makeClassName(resourceType.getId());
        this.methods = new ArrayList<MethodNode>();
        this.resources = new ArrayList<ResourceNode>();
        this.generatedInterface = null;
        this.resourceType = resourceType;
    }

    public ResourceNode addChild(Resource r, URI file, ElementResolver idMap) throws InvalidWADLException {
        ResourceNode n = new ResourceNode(r, this, file, idMap);
        this.resources.add(n);
        return n;
    }

    public String getClassName() {
        return this.interfaceName;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<ResourceNode> getResources() {
        return this.resources;
    }

    public List<Param> getQueryParams() {
        return this.pathSegment.getQueryParameters();
    }

    public List<Param> getHeaderParams() {
        return this.pathSegment.getHeaderParameters();
    }

    public List<Param> getMatrixParams() {
        return this.pathSegment.getMatrixParameters();
    }

    public List<Doc> getDoc() {
        return this.doc;
    }

    public void setGeneratedInterface(JDefinedClass iface) {
        this.generatedInterface = iface;
    }

    public JDefinedClass getGeneratedInterface() {
        return this.generatedInterface;
    }

    @Override
    public Locator getLocation() {
        return this.resourceType.sourceLocation();
    }

    @Override
    public void visit(AbstractNode.NodeVisitor visitor) {
        super.visit(visitor);
        for (ResourceNode resourceNode : this.getResources()) {
            resourceNode.visit(visitor);
        }
        for (MethodNode methodNode : this.getMethods()) {
            methodNode.visit(visitor);
        }
    }
}

