/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.ast;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.ws.wadl.Application;
import org.jvnet.ws.wadl.Grammars;
import org.jvnet.ws.wadl.Include;
import org.jvnet.ws.wadl.Method;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ParamStyle;
import org.jvnet.ws.wadl.Representation;
import org.jvnet.ws.wadl.Request;
import org.jvnet.ws.wadl.Resource;
import org.jvnet.ws.wadl.ResourceType;
import org.jvnet.ws.wadl.Resources;
import org.jvnet.ws.wadl.Response;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.jvnet.ws.wadl.ast.AstMessages;
import org.jvnet.ws.wadl.ast.ElementResolver;
import org.jvnet.ws.wadl.ast.FaultNode;
import org.jvnet.ws.wadl.ast.InvalidWADLException;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.jvnet.ws.wadl.ast.ResourceTypeNode;
import org.jvnet.ws.wadl.util.MessageListener;
import org.jvnet.ws.wadl.xslt.WadlXsltUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class WadlAstBuilder {
    private ElementResolver idMap;
    private Map<String, ResourceTypeNode> ifaceMap;
    private MessageListener messageListener;
    private List<String> processedDocs;
    private JAXBContext jbc;
    private SchemaCallback schemaCallback;

    public WadlAstBuilder(SchemaCallback schemaCallback, MessageListener messageListener) {
        this.idMap = new ElementResolver(messageListener);
        this.ifaceMap = new HashMap<String, ResourceTypeNode>();
        this.processedDocs = new ArrayList<String>();
        this.schemaCallback = schemaCallback;
        this.messageListener = messageListener;
    }

    public Map<String, ResourceTypeNode> getInterfaceMap() {
        return new HashMap<String, ResourceTypeNode>(this.ifaceMap);
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jbc == null) {
            this.jbc = JAXBContext.newInstance((String)"org.jvnet.ws.wadl", (ClassLoader)this.getClass().getClassLoader());
        }
        return this.jbc;
    }

    public ApplicationNode buildAst(URI rootFile) throws InvalidWADLException, IOException {
        try {
            Application a = this.processDescription(rootFile);
            return this.buildAst(a, rootFile);
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Internal error", ex);
        }
    }

    protected ApplicationNode buildAst(Application a, URI rootFile) throws InvalidWADLException {
        for (String ifaceId : this.ifaceMap.keySet()) {
            this.buildResourceType(ifaceId, a);
        }
        for (String ifaceId : this.ifaceMap.keySet()) {
            this.buildResourceTypeTree(ifaceId, a);
        }
        List<Resources> rs = a.getResources();
        ArrayList<ResourceNode> ns = new ArrayList<ResourceNode>();
        for (Resources r : rs) {
            ResourceNode rootResourcesNode = new ResourceNode(rootFile, a, r);
            for (Resource child : r.getResource()) {
                this.buildResourceTree(rootResourcesNode, child, rootFile);
            }
            ns.add(rootResourcesNode);
        }
        return new ApplicationNode(a, ns);
    }

    protected void buildResourceType(String ifaceId, Application a) throws InvalidWADLException {
        try {
            URI file = new URI(ifaceId.substring(0, ifaceId.indexOf(35)));
            ResourceType type = (ResourceType)this.idMap.get(ifaceId);
            ResourceTypeNode node = new ResourceTypeNode(type, file, this.idMap);
            for (Object child : type.getMethodOrResource()) {
                if (!(child instanceof Method)) continue;
                this.addMethodToResourceType(node, (Method)child, file);
            }
            this.ifaceMap.put(ifaceId, node);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
    }

    protected void buildResourceTypeTree(String ifaceId, Application a) throws InvalidWADLException {
        try {
            URI file = new URI(ifaceId.substring(0, ifaceId.indexOf(35)));
            ResourceType type = (ResourceType)this.idMap.get(ifaceId);
            ResourceTypeNode node = this.ifaceMap.get(ifaceId);
            for (Object child : type.getMethodOrResource()) {
                if (!(child instanceof Resource)) continue;
                this.addResourceToResourceType(node, (Resource)child, file);
            }
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
    }

    protected void buildResourceTree(ResourceNode parent, Resource resource, URI file) throws InvalidWADLException {
        if (resource != null) {
            ResourceNode n = parent.addChild(resource, file, this.idMap);
            for (String type : resource.getType()) {
                this.addTypeToResource(n, resource, type, file);
            }
            for (Object child : resource.getMethodOrResource()) {
                if (child instanceof Resource) {
                    Resource childResource = (Resource)child;
                    this.buildResourceTree(n, childResource, file);
                    continue;
                }
                if (!(child instanceof Method)) continue;
                Method m = (Method)child;
                this.addMethodToResource(n, m, file);
            }
        }
    }

    protected void addTypeToResource(ResourceNode resourceNode, Resource resource, String href, URI file) throws InvalidWADLException {
        ResourceTypeNode n = this.ifaceMap.get((file = WadlAstBuilder.getReferencedFile(file, href)).toString() + href.substring(href.indexOf(35)));
        if (n == null) {
            throw WadlAstBuilder.messageStringFromObject(AstMessages.SKIPPING_REFERENCE(href), resource);
        }
        resourceNode.addResourceType(n);
    }

    protected void addMethodToResourceType(ResourceTypeNode resource, Method method, URI file) throws InvalidWADLException {
        this.addMethodToParent(resource, method, file);
    }

    protected void addResourceToResourceType(ResourceTypeNode type, Resource resource, URI file) throws InvalidWADLException {
        if (resource != null) {
            ResourceNode n = type.addChild(resource, file, this.idMap);
            for (String resourceType : resource.getType()) {
                this.addTypeToResource(n, resource, resourceType, file);
            }
            for (Object child : resource.getMethodOrResource()) {
                if (child instanceof Resource) {
                    Resource childResource = (Resource)child;
                    this.buildResourceTree(n, childResource, file);
                    continue;
                }
                if (!(child instanceof Method)) continue;
                Method m = (Method)child;
                this.addMethodToResource(n, m, file);
            }
        }
    }

    boolean isFaultResponse(Response response) {
        boolean isFault = false;
        for (long status : response.getStatus()) {
            if (status < 400L) continue;
            isFault = true;
            break;
        }
        return isFault;
    }

    protected void addMethodToResource(ResourceNode resource, Method method, URI file) throws InvalidWADLException {
        this.addMethodToParent(resource, method, file);
    }

    private void addMethodToParent(Object parent, Method method, URI file) throws InvalidWADLException {
        String href = method.getHref();
        if (href != null && href.length() > 0) {
            if (method.getDoc().size() > 0 || method.getId() != null || method.getRequest() != null || method.getResponse().size() > 0) {
                this.messageListener.warning(null, WadlAstBuilder.messageStringFromObject(AstMessages.LONELY_HREF_METHOD(), method));
            }
            file = WadlAstBuilder.getReferencedFile(file, href);
            method = this.idMap.resolve(file, href, method);
        }
        if (method != null) {
            if (method.getName() == null || method.getName().length() == 0) {
                InvalidWADLException errorMessage = WadlAstBuilder.messageStringFromObject(AstMessages.MISSING_METHOD_NAME(), method);
                this.messageListener.error(null, errorMessage);
                throw errorMessage;
            }
            MethodNode n = parent instanceof ResourceNode ? new MethodNode(method, (ResourceNode)parent) : new MethodNode(method, (ResourceTypeNode)parent);
            Request request = method.getRequest();
            if (request != null) {
                for (Param p : request.getParam()) {
                    href = p.getHref();
                    if (href != null && href.length() > 0) {
                        if (p.getDefault() != null || p.getDoc().size() > 0 || p.getFixed() != null || p.getId() != null || p.getLink() != null || p.getName() != null || p.getOption().size() > 0 || p.getPath() != null || p.getStyle() != null || !p.getType().equals(new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"))) {
                            this.messageListener.warning(null, WadlAstBuilder.messageStringFromObject(AstMessages.LONELY_HREF_PARAM(), p));
                        }
                        file = WadlAstBuilder.getReferencedFile(file, href);
                        p = this.idMap.resolve(file, href, p);
                    }
                    if (p == null) continue;
                    if (p.getStyle() == ParamStyle.HEADER) {
                        n.getHeaderParameters().add(p);
                        continue;
                    }
                    if (p.getStyle() != ParamStyle.QUERY) continue;
                    n.getQueryParameters().add(p);
                }
                for (Representation r : request.getRepresentation()) {
                    RepresentationNode rn = this.createRepresentationNode(r, file);
                    if (rn == null) continue;
                    n.getSupportedInputs().add(rn);
                }
            }
            for (Response response : method.getResponse()) {
                boolean isFault = this.isFaultResponse(response);
                for (Representation o : response.getRepresentation()) {
                    if (isFault) {
                        FaultNode fn = new FaultNode(o);
                        n.getFaults().add(response.getStatus(), (Object)fn);
                        continue;
                    }
                    RepresentationNode rn = this.createRepresentationNode(o, file);
                    if (rn == null) continue;
                    n.getSupportedOutputs().add(response.getStatus(), (Object)rn);
                }
            }
        }
    }

    protected RepresentationNode createRepresentationNode(Representation representation, URI file) throws InvalidWADLException {
        String href = representation.getHref();
        if (href != null && href.length() > 0) {
            if (representation.getDoc().size() > 0 || representation.getElement() != null || representation.getId() != null || representation.getMediaType() != null || representation.getParam().size() > 0 || representation.getProfile().size() > 0) {
                this.messageListener.warning(null, WadlAstBuilder.messageStringFromObject(AstMessages.LONELY_HREF_REPRESENTATION(), representation));
            }
            file = WadlAstBuilder.getReferencedFile(file, href);
            representation = this.idMap.resolve(file, href, representation);
        }
        if (representation != null) {
            RepresentationNode n = new RepresentationNode(representation);
            return n;
        }
        return null;
    }

    protected Application processDescription(URI desc) throws JAXBException, IOException {
        InputStream is = desc.toURL().openStream();
        return this.processDescription(desc, is);
    }

    protected Application processDescription(URI desc, InputStream is) throws JAXBException, IOException {
        if (this.processedDocs.contains(desc.toString())) {
            return null;
        }
        this.processedDocs.add(desc.toString());
        this.messageListener.info(AstMessages.PROCESSING(desc.toString()));
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            StreamSource stylesheet = new StreamSource(WadlXsltUtils.getUpgradeTransformAsStream());
            Transformer t = tf.newTransformer(stylesheet);
            t.transform(new StreamSource(is), result);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
        InputSource inputSource = new InputSource(new StringReader(sw.toString()));
        inputSource.setSystemId(desc.toString());
        Application a = (Application)this.getJAXBContext().createUnmarshaller().unmarshal(inputSource);
        Grammars g = a.getGrammars();
        if (g != null) {
            for (Include i : g.getInclude()) {
                URI incl = desc.resolve(i.getHref());
                if (this.processedDocs.contains(incl.toString())) continue;
                this.processedDocs.add(incl.toString());
                this.messageListener.info(AstMessages.PROCESSING(incl.toString()));
                InputSource input = new InputSource(new BufferedInputStream(incl.toURL().openStream()));
                input.setSystemId(incl.toString());
                this.schemaCallback.processSchema(input);
            }
            int embeddedSchemaNo = 0;
            for (Object any : g.getAny()) {
                if (!(any instanceof Element)) continue;
                Element element = (Element)any;
                this.schemaCallback.processSchema(desc.toString() + "#schema" + Integer.toString(embeddedSchemaNo), element);
                ++embeddedSchemaNo;
            }
        }
        this.buildIDMap(a, desc);
        return a;
    }

    protected void buildIDMap(Application a, URI desc) throws JAXBException, IOException {
        for (Object child : a.getResourceTypeOrMethodOrRepresentation()) {
            Object r;
            if (child instanceof Method) {
                Method m = (Method)child;
                if (m.getId() == null) {
                    this.messageListener.warning(null, WadlAstBuilder.messageStringFromObject(AstMessages.MISSING_ID_METHOD(), m));
                }
                this.extractMethodIds(m, desc);
                continue;
            }
            if (child instanceof ResourceType) {
                r = (ResourceType)child;
                if (((ResourceType)r).getId() == null) {
                    this.messageListener.warning(null, WadlAstBuilder.messageStringFromObject(AstMessages.MISSING_ID_RESOURCE_TYPE(), r));
                }
                this.extractResourceTypeIds((ResourceType)r, desc);
                continue;
            }
            if (child instanceof Representation) {
                r = (Representation)child;
                if (((Representation)r).getId() == null) {
                    this.messageListener.warning(null, WadlAstBuilder.messageStringFromObject(AstMessages.MISSING_ID_REPRESENTATION(), r));
                }
                this.extractRepresentationId((Representation)r, desc);
                continue;
            }
            r = (Param)child;
            if (((Param)r).getId() == null) {
                this.messageListener.warning(null, WadlAstBuilder.messageStringFromObject(AstMessages.MISSING_ID_PARAM(), r));
            }
            this.extractParamId((Param)r, desc);
        }
        if (a.getResources() != null) {
            for (Resources rs : a.getResources()) {
                for (Resource r : rs.getResource()) {
                    this.extractResourceIds(r, desc);
                }
            }
        }
    }

    public static InvalidWADLException messageStringFromObject(String message, Object obj) {
        try {
            java.lang.reflect.Method m = obj.getClass().getDeclaredMethod("sourceLocation", new Class[0]);
            Locator l = (Locator)m.invoke(obj, new Object[0]);
            if (l != null) {
                return new InvalidWADLException(message, l);
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (Exception ex) {
            Logger.getLogger(WadlAstBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new InvalidWADLException("[Error working out location] " + message, null);
    }

    protected String processIDHref(URI desc, String id, String href, Object o) throws JAXBException, IOException {
        String uniqueId = this.idMap.addReference(desc, id, o);
        if (href != null && !href.startsWith("#")) {
            this.processDescription(WadlAstBuilder.getReferencedFile(desc, href));
        }
        return uniqueId;
    }

    protected void extractRepresentationId(Representation r, URI file) throws JAXBException, IOException {
        this.processIDHref(file, r.getId(), r.getHref(), r);
        for (Param p : r.getParam()) {
            this.extractParamId(p, file);
        }
    }

    protected void extractParamId(Param p, URI file) throws JAXBException, IOException {
        this.processIDHref(file, p.getId(), p.getHref(), p);
    }

    protected void extractMethodIds(Method m, URI file) throws JAXBException, IOException {
        this.processIDHref(file, m.getId(), m.getHref(), m);
        if (m.getRequest() != null) {
            for (Param p : m.getRequest().getParam()) {
                this.extractParamId(p, file);
            }
            for (Representation r : m.getRequest().getRepresentation()) {
                this.extractRepresentationId(r, file);
            }
        }
        for (Response resp : m.getResponse()) {
            for (Param p : resp.getParam()) {
                this.extractParamId(p, file);
            }
            for (Representation r : resp.getRepresentation()) {
                this.extractRepresentationId(r, file);
            }
        }
    }

    protected void extractResourceIds(Resource r, URI file) throws JAXBException, IOException {
        this.processIDHref(file, r.getId(), null, r);
        for (String type : r.getType()) {
            this.processIDHref(file, null, type, r);
        }
        for (Param p : r.getParam()) {
            this.extractParamId(p, file);
        }
        for (Object child : r.getMethodOrResource()) {
            if (child instanceof Method) {
                this.extractMethodIds((Method)child, file);
                continue;
            }
            if (!(child instanceof Resource)) continue;
            this.extractResourceIds((Resource)child, file);
        }
    }

    protected void extractResourceTypeIds(ResourceType r, URI file) throws JAXBException, IOException {
        String id = this.processIDHref(file, r.getId(), null, r);
        if (id != null) {
            this.ifaceMap.put(id, null);
        }
        for (Param p : r.getParam()) {
            this.extractParamId(p, file);
        }
        for (Object child : r.getMethodOrResource()) {
            if (child instanceof Method) {
                this.extractMethodIds((Method)child, file);
                continue;
            }
            if (!(child instanceof Resource)) continue;
            this.extractResourceIds((Resource)child, file);
        }
    }

    protected static URI getReferencedFile(URI currentFile, String href) {
        if (href.startsWith("#")) {
            return currentFile;
        }
        return currentFile.resolve(href.substring(0, href.indexOf(35)));
    }

    public static interface SchemaCallback {
        public void processSchema(InputSource var1);

        public void processSchema(String var1, Element var2);
    }
}

