/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import com.sun.tools.xjc.api.impl.s2j.SchemaCompilerImpl;
import com.sun.tools.xjc.model.Model;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Generated;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.AnnotatorFactory;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ast.AbstractNode;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.jvnet.ws.wadl.ast.InvalidWADLException;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.jvnet.ws.wadl.ast.ResourceTypeNode;
import org.jvnet.ws.wadl.ast.WadlAstBuilder;
import org.jvnet.ws.wadl.util.MessageListener;
import org.jvnet.ws.wadl2java.JavaDocUtil;
import org.jvnet.ws.wadl2java.Resolver;
import org.jvnet.ws.wadl2java.ResourceClassGenerator;
import org.jvnet.ws.wadl2java.Wadl2JavaMessages;
import org.jvnet.ws.wadl2java.jaxrs.JAXRS20ResourceClassGenerator;
import org.jvnet.ws.wadl2java.jersey.Jersey1xResourceClassGenerator;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Wadl2Java {
    public static final String STYLE_JERSEY1X = "jersey1x";
    public static final String STYLE_JAXRS20 = "jaxrs20";
    public static final String STYLE_DEFAULT = "jersey1x";
    public static final Set<String> STYLE_SET = new HashSet<String>(){
        {
            this.add("jersey1x");
            this.add(Wadl2Java.STYLE_JAXRS20);
        }
    };
    public static final QName JSON_SCHEMA_DESCRIBEDBY = new QName("http://wadl.dev.java.net/2009/02/json-schema", "describedby");
    private Parameters parameters;
    private JPackage jPkg;
    private Map<URI, JType> jsonTypes = new HashMap<URI, JType>();
    private S2JJAXBModel s2jModel;
    private URI currentBaseUri;
    private Resolver resolver = new Resolver(){
        private Model _model;

        private Model getModel() {
            if (this._model == null) {
                try {
                    Field $model = Wadl2Java.this.s2jModel.getClass().getDeclaredField("model");
                    $model.setAccessible(true);
                    this._model = (Model)$model.get(Wadl2Java.this.s2jModel);
                }
                catch (Throwable th) {
                    Wadl2Java.this.parameters.messageListener.warning("Problem getting hold of the model", th);
                }
            }
            return this._model;
        }

        @Override
        public JType resolve(Object input) {
            if (input instanceof QName) {
                XSType type;
                QName element = (QName)input;
                Mapping map = Wadl2Java.this.s2jModel.get(element);
                if (map != null) {
                    return map.getType().getTypeClass();
                }
                Model model = this.getModel();
                XSElementDecl xelement = model.schemaComponent.getElementDecl(element.getNamespaceURI(), element.getLocalPart());
                if (xelement != null && (type = xelement.getType()) != null && type.isGlobal()) {
                    QName qname = new QName(type.getTargetNamespace(), type.getName());
                    TypeAndAnnotation taa = Wadl2Java.this.s2jModel.getJavaType(qname);
                    if (taa != null) {
                        return taa.getTypeClass();
                    }
                }
                return null;
            }
            if (input instanceof URI) {
                URI element = (URI)input;
                return (JType)Wadl2Java.this.jsonTypes.get(element);
            }
            throw new IllegalArgumentException("input value not of type URI or QName");
        }

        @Override
        public URI resolveURI(AbstractNode context, String path) {
            return Wadl2Java.this.currentBaseUri.resolve(path);
        }

        @Override
        public boolean isThereJsonMapping() {
            return !Wadl2Java.this.jsonTypes.isEmpty();
        }
    };
    private JCodeModel codeModel;
    private JavaDocUtil javaDoc;
    private SchemaCompiler s2j;
    private String generatedPackages = "";
    private WadlAstBuilder astBuilder;

    public Wadl2Java(Parameters parameters) {
        this.parameters = parameters.clone();
        assert (parameters.codeWriter != null);
        this.javaDoc = new JavaDocUtil();
        if (!STYLE_SET.contains(parameters.generationStyle)) {
            throw new IllegalArgumentException(Wadl2JavaMessages.INVALID_GENERATION_STYLE(parameters.generationStyle, STYLE_SET));
        }
    }

    public void process(final URI rootDesc) throws JAXBException, IOException, JClassAlreadyExistsException, InvalidWADLException {
        this.currentBaseUri = rootDesc;
        final LinkedHashSet jsonSchemas = new LinkedHashSet();
        this.s2j = new SchemaCompilerImpl();
        SchemaCompilerErrorListener errorListener = new SchemaCompilerErrorListener();
        if (!this.parameters.autoPackage) {
            this.s2j.setDefaultPackageName(this.parameters.pkg);
        }
        this.s2j.setErrorListener((ErrorListener)errorListener);
        this.astBuilder = new WadlAstBuilder(new WadlAstBuilder.SchemaCallback(){

            @Override
            public void processSchema(InputSource input) {
                InputStream is = input.getByteStream();
                is.mark(8192);
                String peakContent = null;
                try {
                    InputStreamReader r = new InputStreamReader(is, "UTF-8");
                    CharBuffer cb = CharBuffer.allocate(20);
                    ((Reader)r).read(cb);
                    cb.flip();
                    peakContent = cb.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("Internal problem pushing back buffer", e);
                }
                finally {
                    try {
                        is.reset();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Internal problem pushing back buffer", ex);
                    }
                }
                if (peakContent.matches("^\\s*\\{")) {
                    jsonSchemas.add(URI.create(input.getSystemId()));
                } else {
                    Wadl2Java.this.s2j.parseSchema(input);
                }
            }

            @Override
            public void processSchema(String uri, Element node) {
                Wadl2Java.this.s2j.parseSchema(uri, node);
            }
        }, this.parameters.messageListener);
        ApplicationNode an = this.astBuilder.buildAst(rootDesc);
        List<ResourceNode> rs = an.getResources();
        for (ResourceNode rootResourcesNode : rs) {
            String overrideName = (String)this.parameters.baseURIToClassName.get(rootResourcesNode.getUriTemplate());
            if (overrideName == null) continue;
            rootResourcesNode.setClassName(overrideName);
        }
        for (URI customization : this.parameters.customizations) {
            URI incl = rootDesc.resolve(customization);
            this.parameters.messageListener.info(Wadl2JavaMessages.PROCESSING(incl.toString()));
            InputSource input = new InputSource(incl.toURL().openStream());
            input.setSystemId(incl.toString());
            this.s2j.parseSchema(input);
        }
        this.applyXjcArguments(this.s2j.getOptions());
        this.s2jModel = this.s2j.bind();
        if (this.s2jModel != null) {
            this.codeModel = this.s2jModel.generateCode(null, (ErrorListener)errorListener);
            Iterator packages = this.codeModel.packages();
            StringBuilder buf = new StringBuilder();
            while (packages.hasNext()) {
                JPackage genPkg = (JPackage)packages.next();
                if (!genPkg.isDefined("ObjectFactory")) continue;
                if (buf.length() > 0) {
                    buf.append(':');
                }
                buf.append(genPkg.name());
            }
            this.generatedPackages = buf.toString();
            an.visit(new AbstractNode.NodeVisitor(){

                @Override
                public void visit(AbstractNode node) {
                    URI uri;
                    RepresentationNode rn;
                    String uriStr;
                    if (node instanceof RepresentationNode && (uriStr = (rn = (RepresentationNode)node).getOtherAttribute(JSON_SCHEMA_DESCRIBEDBY)) != null && (uri = rootDesc.resolve(uriStr)) != null) {
                        jsonSchemas.add(uri);
                    }
                }
            });
            final AnnotationStyle sa = "jersey1x".equals(this.parameters.generationStyle) ? AnnotationStyle.JACKSON1 : AnnotationStyle.JACKSON2;
            DefaultGenerationConfig gc = new DefaultGenerationConfig(){

                public AnnotationStyle getAnnotationStyle() {
                    return sa;
                }
            };
            AnnotatorFactory af = new AnnotatorFactory();
            SchemaMapper sm = new SchemaMapper(new RuleFactory((GenerationConfig)gc, af.getAnnotator(sa), new SchemaStore()), new SchemaGenerator());
            for (URI jsonSchema : jsonSchemas) {
                String jsonSchemaStr = jsonSchema.toString();
                String name = jsonSchemaStr.substring(jsonSchemaStr.lastIndexOf(47) + 1);
                String withoutExtension = name.lastIndexOf(46) != -1 ? name.substring(0, name.lastIndexOf(46)) : name;
                String className = Character.toUpperCase(withoutExtension.charAt(0)) + (withoutExtension.length() > 1 ? withoutExtension.substring(1) : "");
                sm.generate(this.codeModel, className, this.parameters.pkg, jsonSchema.toURL());
                this.jsonTypes.put(jsonSchema, (JType)this.codeModel._getClass(this.parameters.pkg + "." + className));
            }
            this.jPkg = this.codeModel._package(this.parameters.pkg);
            this.generateResourceTypeInterfaces();
            for (ResourceNode r : rs) {
                this.generateEndpointClass(rootDesc, r);
            }
            this.codeModel.build(this.parameters.codeWriter);
        }
        if (errorListener.hasFatalErrorOccured()) {
            throw new JAXBException(Wadl2JavaMessages.JAXB_PROCESSING_FAILED(), errorListener.getFirstFatalError());
        }
    }

    private void applyXjcArguments(Options options) {
        if (this.parameters.xjcArguments != null) {
            try {
                String[] args = this.parameters.xjcArguments.toArray(new String[0]);
                for (int i = 0; i < args.length; ++i) {
                    options.parseArgument(args, i);
                }
            }
            catch (BadCommandLineException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ResourceClassGenerator createGeneratorForResource(ResourceNode resource) {
        if (this.parameters.generationStyle == null || "jersey1x".equals(this.parameters.generationStyle)) {
            return new Jersey1xResourceClassGenerator(this.parameters.messageListener, this.resolver, this.codeModel, this.jPkg, this.generatedPackages, this.javaDoc, resource);
        }
        if (STYLE_JAXRS20.equals(this.parameters.generationStyle)) {
            return new JAXRS20ResourceClassGenerator(this.parameters.messageListener, this.resolver, this.codeModel, this.jPkg, this.generatedPackages, this.javaDoc, resource);
        }
        throw new IllegalStateException("Invalid generation style");
    }

    private ResourceClassGenerator createGeneratorForResourceType(JDefinedClass iface) {
        if (this.parameters.generationStyle == null || "jersey1x".equals(this.parameters.generationStyle)) {
            return new Jersey1xResourceClassGenerator(this.parameters.messageListener, this.resolver, this.codeModel, this.jPkg, this.generatedPackages, this.javaDoc, iface);
        }
        if (STYLE_JAXRS20.equals(this.parameters.generationStyle)) {
            return new JAXRS20ResourceClassGenerator(this.parameters.messageListener, this.resolver, this.codeModel, this.jPkg, this.generatedPackages, this.javaDoc, iface);
        }
        throw new IllegalStateException("Invalid generation style");
    }

    protected void generateResourceTypeInterfaces() throws JClassAlreadyExistsException {
        Map<String, ResourceTypeNode> ifaceMap = this.astBuilder.getInterfaceMap();
        for (String id : ifaceMap.keySet()) {
            ResourceTypeNode n = ifaceMap.get(id);
            JDefinedClass iface = this.jPkg._class(1, n.getClassName(), ClassType.INTERFACE);
            n.setGeneratedInterface(iface);
            this.javaDoc.generateClassDoc(n, iface);
            ResourceClassGenerator rcGen = this.createGeneratorForResourceType(iface);
            for (MethodNode m : n.getMethods()) {
                rcGen.generateMethodDecls(m, true);
            }
            List<Param> matrixParams = n.getMatrixParams();
            for (Param p : matrixParams) {
                rcGen.generateBeanProperty(iface, matrixParams, p, true);
            }
        }
    }

    protected void generateEndpointClass(URI rootResource, ResourceNode root) throws JClassAlreadyExistsException {
        JDefinedClass impl;
        int counter = 0;
        do {
            String proposedName = counter++ == 0 ? root.getClassName() : root.getClassName() + counter;
            try {
                impl = this.jPkg._class(1, proposedName);
                root.setClassName(proposedName);
            }
            catch (JClassAlreadyExistsException ex) {
                impl = null;
            }
        } while (impl == null);
        if (rootResource != null) {
            JAnnotationUse annUse = impl.annotate(Generated.class);
            JAnnotationArrayMember array = annUse.paramArray("value");
            array.param("wadl|" + rootResource.toString());
            URI packagePath = UriBuilder.fromUri((URI)this.parameters.rootDir).path(this.parameters.pkg.replace(".", "/") + "/").build(new Object[0]);
            for (URI customization : this.parameters.customizations) {
                array.param("customization|" + packagePath.relativize(customization));
            }
            annUse.param("comments", "wadl2java, http://wadl.java.net");
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(new Date());
            annUse.param("date", DatatypeConverter.printDateTime((Calendar)gc));
        }
        JFieldVar $base_uri = impl.field(25, URI.class, "BASE_URI");
        $base_uri.javadoc().append((Object)"The base URI for the resource represented by this proxy");
        for (ResourceNode r : root.getChildResources()) {
            this.generateSubClass(impl, (JVar)$base_uri, r);
        }
        JBlock staticInit = impl.init();
        JVar $originalURI = staticInit.decl($base_uri.type(), "originalURI").init((JExpression)this.codeModel.ref(URI.class).staticInvoke("create").arg(JExpr.lit((String)root.getUriTemplate())));
        staticInit.directStatement("// Look up to see if we have any indirection in the local copy\n        // of META-INF/java-rs-catalog.xml file, assuming it will be in the\n        // oasis:name:tc:entity:xmlns:xml:catalog namespace or similar duck type\n        java.io.InputStream is = " + impl.name() + ".class.getResourceAsStream(\"/META-INF/jax-rs-catalog.xml\");" + "\n        if (is!=null) {" + "\n            try {" + "\n                // Ignore the namespace in the catalog, can't use wildcard until" + "\n                // we are sure we have XPath 2.0" + "\n                String found = javax.xml.xpath.XPathFactory.newInstance().newXPath().evaluate(" + "\n                    \"/*[name(.) = 'catalog']/*[name(.) = 'uri' and @name ='\" + originalURI +\"']/@uri\", " + "\n                    new org.xml.sax.InputSource(is)); " + "\n                if (found!=null && found.length()>0) {" + "\n                    originalURI = java.net.URI.create(found);" + "\n                }" + "\n                " + "\n            }" + "\n            catch (Exception ex) {" + "\n                ex.printStackTrace();" + "\n            }" + "\n            finally {" + "\n                try {" + "\n                    is.close();" + "\n                } catch (java.io.IOException e) {" + "\n                }" + "\n            }" + "\n        }");
        staticInit.assign((JAssignmentTarget)$base_uri, (JExpression)$originalURI);
    }

    protected void generateSubClass(JDefinedClass parent, JVar $global_base_uri, ResourceNode resource) throws JClassAlreadyExistsException {
        ResourceClassGenerator rcGen = this.createGeneratorForResource(resource);
        JDefinedClass impl = rcGen.generateClass(parent, $global_base_uri);
        for (MethodNode m : resource.getMethods()) {
            rcGen.generateMethodDecls(m, false);
        }
        for (ResourceNode r : resource.getChildResources()) {
            this.generateSubClass(impl, $global_base_uri, r);
        }
    }

    protected class SchemaCompilerErrorListener
    implements ErrorListener {
        private Throwable firstFatalError;

        protected SchemaCompilerErrorListener() {
        }

        public boolean hasFatalErrorOccured() {
            return this.firstFatalError != null;
        }

        public Throwable getFirstFatalError() {
            return this.firstFatalError;
        }

        public void warning(SAXParseException sAXParseException) {
            Wadl2Java.this.parameters.messageListener.warning(Wadl2JavaMessages.WARNING(sAXParseException.getMessage()), sAXParseException);
        }

        public void info(SAXParseException sAXParseException) {
            Wadl2Java.this.parameters.messageListener.info(Wadl2JavaMessages.INFO(sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getSystemId()));
        }

        public void fatalError(SAXParseException sAXParseException) {
            if (this.firstFatalError == null) {
                this.firstFatalError = sAXParseException;
            }
            Wadl2Java.this.parameters.messageListener.error(Wadl2JavaMessages.ERROR_FATAL(sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getSystemId()), sAXParseException);
        }

        public void error(SAXParseException sAXParseException) {
            Wadl2Java.this.parameters.messageListener.error(Wadl2JavaMessages.ERROR(sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getSystemId()), sAXParseException);
        }
    }

    public static class Parameters
    implements Cloneable {
        private CodeWriter codeWriter;
        private List<URI> customizations;
        private List<String> xjcArguments;
        private String pkg;
        private String generationStyle = "jersey1x";
        private boolean autoPackage;
        private URI rootDir;
        private Map<String, String> baseURIToClassName = Collections.EMPTY_MAP;
        private MessageListener messageListener = new MessageListener(){

            @Override
            public void warning(String message, Throwable throwable) {
                System.err.println(Wadl2JavaMessages.LOGGER_WARNING(message != null ? message : throwable.getMessage()));
            }

            @Override
            public void info(String message) {
                System.err.println(Wadl2JavaMessages.LOGGER_INFO(message));
            }

            @Override
            public void error(String message, Throwable throwable) {
                System.err.println(Wadl2JavaMessages.LOGGER_ERROR(message != null ? message : throwable.getMessage()));
            }
        };

        public Parameters clone() {
            try {
                Parameters parameters = (Parameters)super.clone();
                parameters.customizations = new ArrayList<URI>(this.customizations);
                parameters.baseURIToClassName = new HashMap<String, String>(this.baseURIToClassName);
                parameters.xjcArguments = this.xjcArguments == null ? null : new ArrayList<String>(this.xjcArguments);
                return parameters;
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(Wadl2Java.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        public Parameters setCodeWriter(CodeWriter codeWriter) {
            this.codeWriter = codeWriter;
            return this;
        }

        public Parameters setGenerationStyle(String generationStyle) {
            this.generationStyle = generationStyle;
            return this;
        }

        public Parameters setCustomizations(List<URI> customizations) {
            this.customizations = new ArrayList<URI>(customizations);
            return this;
        }

        public Parameters setCustomizationsAsFiles(List<File> customizations) {
            this.customizations = Parameters.convertToURIList(customizations);
            return this;
        }

        private static List<URI> convertToURIList(List<File> files) {
            ArrayList<URI> copy = new ArrayList<URI>();
            for (File file : files) {
                copy.add(file.toURI());
            }
            return copy;
        }

        public Parameters setPkg(String pkg) {
            this.pkg = pkg;
            return this;
        }

        public Parameters setAutoPackage(boolean autoPackage) {
            this.autoPackage = autoPackage;
            return this;
        }

        public Parameters setRootDir(URI rootDir) {
            this.rootDir = rootDir;
            return this;
        }

        public Parameters setCustomClassNames(Map<String, String> map) {
            this.baseURIToClassName = new HashMap<String, String>(map);
            return this;
        }

        public Parameters setMessageListener(MessageListener ml) {
            this.messageListener = ml;
            return this;
        }

        public Parameters setXjcArguments(List<String> xjcArguments) {
            this.xjcArguments = xjcArguments;
            return this;
        }
    }
}

