/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.allarmi.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeHistoryServiceSearchImpl;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.beans.UpdateModel;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceCRUDWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCAllarmeHistoryServiceImpl
extends JDBCAllarmeHistoryServiceSearchImpl
implements IJDBCServiceCRUDWithoutId<AllarmeHistory, JDBCServiceManager> {
    public void create(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeHistory allarmeHistory, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        Long idAllarme = null;
        IdAllarme idLogicAllarme = null;
        idLogicAllarme = allarmeHistory.getIdAllarme();
        if (idLogicAllarme != null) {
            if (idMappingResolutionBehaviour == null || IDMappingBehaviour.ENABLED.equals((Object)idMappingResolutionBehaviour)) {
                idAllarme = ((JDBCAllarmeServiceSearch)this.getServiceManager().getAllarmeServiceSearch()).findTableId(idLogicAllarme, false);
            } else if (IDMappingBehaviour.USE_TABLE_ID.equals((Object)idMappingResolutionBehaviour) && ((idAllarme = idLogicAllarme.getId()) == null || idAllarme <= 0L)) {
                throw new ServiceException("Logic id not contains table id");
            }
        } else {
            throw new ServiceException("IdAllarme not defined");
        }
        sqlQueryObjectInsert.addInsertTable(this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()));
        sqlQueryObjectInsert.addInsertField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().ENABLED, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().STATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().DETTAGLIO_STATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().ACKNOWLEDGED, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().TIMESTAMP_UPDATE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().UTENTE, false), "?");
        sqlQueryObjectInsert.addInsertField("id_allarme", "?");
        IKeyGeneratorObject keyGenerator = this.getAllarmeHistoryFetch().getKeyGeneratorObject((IModel<?>)AllarmeHistory.model());
        long id = jdbcUtilities.insertAndReturnGeneratedKey(sqlQueryObjectInsert, keyGenerator, jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)allarmeHistory.getEnabled(), AllarmeHistory.model().ENABLED.getFieldType()), new JDBCObject((Object)allarmeHistory.getStato(), AllarmeHistory.model().STATO.getFieldType()), new JDBCObject((Object)allarmeHistory.getDettaglioStato(), AllarmeHistory.model().DETTAGLIO_STATO.getFieldType()), new JDBCObject((Object)allarmeHistory.getAcknowledged(), AllarmeHistory.model().ACKNOWLEDGED.getFieldType()), new JDBCObject((Object)allarmeHistory.getTimestampUpdate(), AllarmeHistory.model().TIMESTAMP_UPDATE.getFieldType()), new JDBCObject((Object)allarmeHistory.getUtente(), AllarmeHistory.model().UTENTE.getFieldType()), new JDBCObject((Object)idAllarme, Long.class)});
        allarmeHistory.setId(id);
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeHistory allarmeHistory, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long tableId = allarmeHistory.getId();
        if (tableId == null || tableId <= 0L) {
            throw new ServiceException("Retrieve tableId failed");
        }
        this.update(jdbcProperties, log, connection, sqlQueryObject, (long)tableId, allarmeHistory, idMappingResolutionBehaviour);
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, AllarmeHistory allarmeHistory, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObjectInsert.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObjectDelete.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectUpdate = sqlQueryObjectGet.newSQLQueryObject();
        boolean setIdMappingResolutionBehaviour = idMappingResolutionBehaviour == null || IDMappingBehaviour.ENABLED.equals((Object)idMappingResolutionBehaviour) || IDMappingBehaviour.USE_TABLE_ID.equals((Object)idMappingResolutionBehaviour);
        Long idAllarme = null;
        IdAllarme idLogicAllarme = null;
        idLogicAllarme = allarmeHistory.getIdAllarme();
        if (idLogicAllarme != null) {
            if (idMappingResolutionBehaviour == null || IDMappingBehaviour.ENABLED.equals((Object)idMappingResolutionBehaviour)) {
                idAllarme = ((JDBCAllarmeServiceSearch)this.getServiceManager().getAllarmeServiceSearch()).findTableId(idLogicAllarme, false);
            } else if (IDMappingBehaviour.USE_TABLE_ID.equals((Object)idMappingResolutionBehaviour) && ((idAllarme = idLogicAllarme.getId()) == null || idAllarme <= 0L)) {
                throw new ServiceException("Logic id not contains table id");
            }
        } else {
            throw new ServiceException("IdAllarme not defined");
        }
        sqlQueryObjectUpdate.setANDLogicOperator(true);
        sqlQueryObjectUpdate.addUpdateTable(this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()));
        boolean isUpdate = true;
        ArrayList<JDBCObject> lstObjects = new ArrayList<JDBCObject>();
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().ENABLED, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeHistory.getEnabled(), AllarmeHistory.model().ENABLED.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().STATO, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeHistory.getStato(), AllarmeHistory.model().STATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().DETTAGLIO_STATO, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeHistory.getDettaglioStato(), AllarmeHistory.model().DETTAGLIO_STATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().ACKNOWLEDGED, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeHistory.getAcknowledged(), AllarmeHistory.model().ACKNOWLEDGED.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().TIMESTAMP_UPDATE, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeHistory.getTimestampUpdate(), AllarmeHistory.model().TIMESTAMP_UPDATE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeHistoryFieldConverter().toColumn(AllarmeHistory.model().UTENTE, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeHistory.getUtente(), AllarmeHistory.model().UTENTE.getFieldType()));
        if (setIdMappingResolutionBehaviour) {
            sqlQueryObjectUpdate.addUpdateField("id_allarme", "?");
        }
        if (setIdMappingResolutionBehaviour) {
            lstObjects.add(new JDBCObject((Object)idAllarme, Long.class));
        }
        sqlQueryObjectUpdate.addWhereCondition("id=?");
        lstObjects.add(new JDBCObject((Object)tableId, Long.class));
        if (isUpdate) {
            jdbcUtilities.executeUpdate(sqlQueryObjectUpdate.createSQLUpdate(), jdbcProperties.isShowSql(), lstObjects.toArray(new JDBCObject[0]));
        }
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeHistory allarmeHistory, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(log, connection, sqlQueryObject, allarmeHistory), (ISQLFieldConverter)this.getAllarmeHistoryFieldConverter(), (IJDBCServiceSearchWithoutId)this, null, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeHistory allarmeHistory, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(log, connection, sqlQueryObject, allarmeHistory), (ISQLFieldConverter)this.getAllarmeHistoryFieldConverter(), (IJDBCServiceSearchWithoutId)this, (IExpression)condition, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeHistory allarmeHistory, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(log, connection, sqlQueryObject, allarmeHistory), (ISQLFieldConverter)this.getAllarmeHistoryFieldConverter(), (IJDBCServiceSearchWithoutId)this, (UpdateModel[])updateModels);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getAllarmeHistoryFieldConverter(), (IJDBCServiceSearchWithoutId)this, null, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getAllarmeHistoryFieldConverter(), (IJDBCServiceSearchWithoutId)this, (IExpression)condition, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getAllarmeHistoryFieldConverter(), (IJDBCServiceSearchWithoutId)this, (UpdateModel[])updateModels);
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeHistory allarmeHistory, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        Long id = allarmeHistory.getId();
        if (id != null && this.exists(jdbcProperties, log, connection, sqlQueryObject, id)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, allarmeHistory, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, allarmeHistory, idMappingResolutionBehaviour);
        }
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, AllarmeHistory allarmeHistory, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (this.exists(jdbcProperties, log, connection, sqlQueryObject, tableId)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, tableId, allarmeHistory, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, allarmeHistory, idMappingResolutionBehaviour);
        }
    }

    public void delete(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeHistory allarmeHistory) throws NotImplementedException, ServiceException, Exception {
        Long longId = null;
        if (allarmeHistory.getId() == null) {
            throw new ServiceException("Parameter " + allarmeHistory.getClass().getName() + ".id is null");
        }
        if (allarmeHistory.getId() <= 0L) {
            throw new ServiceException("Parameter " + allarmeHistory.getClass().getName() + ".id is less equals 0");
        }
        longId = allarmeHistory.getId();
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, longId);
    }

    private void deleteEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long id) throws NotImplementedException, ServiceException, Exception {
        if (id != null && id <= 0L) {
            throw new ServiceException("Id is less equals 0");
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectDelete.setANDLogicOperator(true);
        sqlQueryObjectDelete.addDeleteTable(this.getAllarmeHistoryFieldConverter().toTable((IModel)AllarmeHistory.model()));
        if (id != null) {
            sqlQueryObjectDelete.addWhereCondition("id=?");
        }
        jdbcUtilities.execute(sqlQueryObjectDelete.createSQLDelete(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)id, Long.class)});
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        return this.deleteAll(jdbcProperties, log, connection, sqlQueryObject, new JDBCExpression((ISQLFieldConverter)this.getAllarmeHistoryFieldConverter()));
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List<Long> lst = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, new JDBCPaginatedExpression(expression));
        for (Long id : lst) {
            this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, id);
        }
        return new NonNegativeNumber((long)lst.size());
    }

    public void deleteById(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotImplementedException, Exception {
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    public int nativeUpdate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlObject, String sql, Object ... param) throws ServiceException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeUpdate((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlObject, (String)sql, (Object[])param);
    }
}

