/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.allarmi.dao.jdbc;

import java.sql.Connection;
import javax.sql.DataSource;
import org.openspcoop2.core.allarmi.dao.IAllarmeHistoryService;
import org.openspcoop2.core.allarmi.dao.IAllarmeHistoryServiceSearch;
import org.openspcoop2.core.allarmi.dao.IAllarmeNotificaService;
import org.openspcoop2.core.allarmi.dao.IAllarmeNotificaServiceSearch;
import org.openspcoop2.core.allarmi.dao.IAllarmeService;
import org.openspcoop2.core.allarmi.dao.IAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeHistoryService;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeHistoryServiceSearch;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeNotificaService;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeNotificaServiceSearch;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeService;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.utils.UtilsRuntimeException;

public class JDBCLimitedServiceManager
extends JDBCServiceManager {
    private JDBCServiceManager unlimitedJdbcServiceManager;
    private static final String CONNNECTION_MANAGED = "Connection managed from framework";

    public JDBCLimitedServiceManager(JDBCServiceManager jdbcServiceManager) {
        this.datasource = jdbcServiceManager.getDatasourceInternalResource();
        this.connection = jdbcServiceManager.getConnectionInternalResource();
        this.log = jdbcServiceManager.getLoggerInternalResource();
        this.jdbcProperties = jdbcServiceManager.getJdbcPropertiesInternalResource();
        this.unlimitedJdbcServiceManager = jdbcServiceManager;
    }

    @Override
    public Connection getConnection() throws ServiceException {
        throw new ServiceException(CONNNECTION_MANAGED);
    }

    @Override
    public void closeConnection(Connection connection) throws ServiceException {
        throw new ServiceException(CONNNECTION_MANAGED);
    }

    @Override
    protected Connection getConnectionInternalResource() {
        throw new UtilsRuntimeException(CONNNECTION_MANAGED);
    }

    @Override
    protected DataSource getDatasourceInternalResource() {
        throw new UtilsRuntimeException(CONNNECTION_MANAGED);
    }

    @Override
    public IAllarmeServiceSearch getAllarmeServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCAllarmeServiceSearch(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IAllarmeService getAllarmeService() throws ServiceException, NotImplementedException {
        return new JDBCAllarmeService(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IAllarmeHistoryServiceSearch getAllarmeHistoryServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCAllarmeHistoryServiceSearch(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IAllarmeHistoryService getAllarmeHistoryService() throws ServiceException, NotImplementedException {
        return new JDBCAllarmeHistoryService(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IAllarmeNotificaServiceSearch getAllarmeNotificaServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCAllarmeNotificaServiceSearch(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IAllarmeNotificaService getAllarmeNotificaService() throws ServiceException, NotImplementedException {
        return new JDBCAllarmeNotificaService(this.unlimitedJdbcServiceManager);
    }
}

