/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Properties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class SQLScriptBuilder {
    public static void main(String[] args) throws Exception {
        String sqlSourceDir = args[0];
        String sqlDestDir = args[1];
        String sqlScriptName = args[2];
        String modalitaInstallazione = args[3];
        boolean splitDDL_DML = true;
        String versionePrecedente = null;
        String versioneAttuale = null;
        String tipoDatabase = null;
        String configurazioneUpgrade = null;
        boolean configurazioneUpgrade_runtime = true;
        boolean configurazioneUpgrade_config = true;
        boolean configurazioneUpgrade_tracce = true;
        boolean configurazioneUpgrade_statistiche = true;
        boolean configurazioneUpgrade_monitoraggio = true;
        if (args.length > 4) {
            File f;
            versionePrecedente = args[4];
            versioneAttuale = args[5];
            tipoDatabase = args[6];
            if ("aggiornamento".equals(modalitaInstallazione) && args.length > 7 && (f = new File(configurazioneUpgrade = args[7])).exists()) {
                try (FileInputStream fin = new FileInputStream(f);){
                    Properties p = new Properties();
                    p.load(fin);
                    configurazioneUpgrade_runtime = SQLScriptBuilder.readBooleanProperty(p, "upgrade.runtime");
                    configurazioneUpgrade_config = SQLScriptBuilder.readBooleanProperty(p, "upgrade.configurazione");
                    configurazioneUpgrade_tracce = SQLScriptBuilder.readBooleanProperty(p, "upgrade.tracciamento");
                    configurazioneUpgrade_statistiche = SQLScriptBuilder.readBooleanProperty(p, "upgrade.statistiche");
                    configurazioneUpgrade_monitoraggio = SQLScriptBuilder.readBooleanProperty(p, "upgrade.monitoraggio");
                }
            }
        }
        if ("nuova".equals(modalitaInstallazione)) {
            SQLScriptBuilder.buildSql_NuovaInstallazione(new File(sqlSourceDir), new File(sqlDestDir), sqlScriptName, splitDDL_DML);
        } else if ("aggiornamento".equals(modalitaInstallazione)) {
            SQLScriptBuilder.buildSql_Aggiornamento(new File(sqlSourceDir), new File(sqlDestDir), sqlScriptName, versionePrecedente, versioneAttuale, tipoDatabase, configurazioneUpgrade_runtime, configurazioneUpgrade_config, configurazioneUpgrade_tracce, configurazioneUpgrade_statistiche, configurazioneUpgrade_monitoraggio);
        } else {
            throw new Exception("Modalit\u00e0 installazione [" + modalitaInstallazione + "] sconosciuta");
        }
    }

    private static boolean readBooleanProperty(Properties p, String name) throws Exception {
        String tmp = p.getProperty(name);
        if (tmp == null) {
            throw new Exception("Configurazione Upgrade non corretta, propriet\u00e0 [" + name + "] non presente");
        }
        tmp = tmp.trim();
        try {
            return Boolean.valueOf(tmp);
        }
        catch (Exception e) {
            throw new Exception("Configurazione Upgrade non corretta, propriet\u00e0 [" + name + "] non corretta: " + e.getMessage(), e);
        }
    }

    private static void buildSql_NuovaInstallazione(File sqlSourceDir, File sqlDestDir, String sqlScriptName, boolean splitDDL_DML) throws Exception {
        if (!sqlSourceDir.exists()) {
            throw new Exception("Source dir [" + sqlSourceDir.getAbsolutePath() + "] not exists");
        }
        if (!sqlSourceDir.canRead()) {
            throw new Exception("Source dir [" + sqlSourceDir.getAbsolutePath() + "] cannot read");
        }
        if (!sqlDestDir.exists()) {
            throw new Exception("Dest dir [" + sqlDestDir.getAbsolutePath() + "] not exists");
        }
        if (!sqlDestDir.canWrite()) {
            throw new Exception("Dest dir [" + sqlDestDir.getAbsolutePath() + "] cannot write");
        }
        int prefix = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        File[] f = sqlSourceDir.listFiles();
        if (f != null) {
            for (int i = 0; i < f.length; ++i) {
                if (!f[i].isFile()) continue;
                SQLScriptBuilder._createSql(sqlSourceDir, f[i].getName(), sqlDestDir, sqlScriptName, prefix, bout, splitDDL_DML);
            }
        }
        File dest = new File(sqlDestDir, sqlScriptName);
        bout.flush();
        bout.close();
        FileSystemUtilities.writeFile((File)dest, (byte[])bout.toByteArray());
        if (splitDDL_DML) {
            File destInit = new File(sqlDestDir, dest.getName().replace(".sql", "_init.sql"));
            SQLScriptBuilder.splitFileForDDLtoDML(dest, dest, destInit);
        }
    }

    private static void buildSql_Aggiornamento(File sqlSourceDir, File sqlDestDir, String sqlScriptName, String precedenteVersione, String versioneAttuale, String tipoDatabase, boolean configurazioneUpgrade_runtime, boolean configurazioneUpgrade_config, boolean configurazioneUpgrade_tracce, boolean configurazioneUpgrade_statistiche, boolean configurazioneUpgrade_monitoraggio) throws Exception {
        if (!sqlSourceDir.exists()) {
            throw new Exception("Source dir [" + sqlSourceDir.getAbsolutePath() + "] not exists");
        }
        if (!sqlSourceDir.canRead()) {
            throw new Exception("Source dir [" + sqlSourceDir.getAbsolutePath() + "] cannot read");
        }
        if (!sqlDestDir.exists()) {
            throw new Exception("Dest dir [" + sqlDestDir.getAbsolutePath() + "] not exists");
        }
        if (!sqlDestDir.canWrite()) {
            throw new Exception("Dest dir [" + sqlDestDir.getAbsolutePath() + "] cannot write");
        }
        if (precedenteVersione == null) {
            throw new Exception("Precedente versione non fornita");
        }
        if (!precedenteVersione.contains(".")) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] ('.' not found)");
        }
        int indexOfFirstPoint = precedenteVersione.indexOf(".");
        if (indexOfFirstPoint <= 0) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] ('.' not found with index)");
        }
        String productVersionString = precedenteVersione.substring(0, indexOfFirstPoint);
        int productVersion = -1;
        try {
            productVersion = Integer.parseInt(productVersionString);
        }
        catch (Exception e) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (productVersion:" + productVersionString + "): " + e.getMessage(), e);
        }
        int indexOfSecondPoint = precedenteVersione.indexOf(".", indexOfFirstPoint + 1);
        if (indexOfSecondPoint <= 0 || indexOfSecondPoint <= indexOfFirstPoint) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (second '.' not found)");
        }
        String majorVersionString = precedenteVersione.substring(indexOfFirstPoint + 1, indexOfSecondPoint);
        int majorVersion = -1;
        try {
            majorVersion = Integer.parseInt(majorVersionString);
        }
        catch (Exception e) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (majorVersion:" + majorVersionString + "): " + e.getMessage(), e);
        }
        if (precedenteVersione.length() <= indexOfSecondPoint) {
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (length)");
        }
        String minorVersionString = precedenteVersione.substring(indexOfSecondPoint + 1, precedenteVersione.length());
        int minorVersion = -1;
        try {
            minorVersion = Integer.parseInt(minorVersionString);
        }
        catch (Exception e) {
            if (minorVersionString.contains("_")) {
                String newMinor = minorVersionString.split("_")[0];
                try {
                    minorVersion = Integer.parseInt(newMinor);
                }
                catch (Exception eInternal) {
                    throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (minorVersion:" + minorVersionString + " minorVersionBuildNumber:" + newMinor + "): " + eInternal.getMessage(), eInternal);
                }
            }
            throw new Exception("Precedente versione in un formato non corretto [" + precedenteVersione + "] (minorVersion:" + minorVersionString + "): " + e.getMessage(), e);
        }
        int tmpMajorVersion = majorVersion;
        int tmpMinorVersion = minorVersion;
        if (tipoDatabase == null) {
            throw new Exception("TipoDatabase non fornito");
        }
        TipiDatabase tipiDatabase = TipiDatabase.toEnumConstant((String)tipoDatabase);
        if (TipiDatabase.DEFAULT.equals((Object)tipiDatabase)) {
            throw new Exception("TipoDatabase fornito [" + tipoDatabase + "] non valido");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        File infoVersion = null;
        while (true) {
            File tmp;
            String nextVersion;
            String actualVersion;
            File version;
            if ((version = new File(sqlSourceDir, "upgrade_" + (actualVersion = productVersion + "." + tmpMajorVersion + "." + tmpMinorVersion) + "_to_" + (nextVersion = productVersion + "." + tmpMajorVersion + "." + (tmpMinorVersion + 1)))).exists()) {
                if (!version.canRead()) {
                    throw new Exception("Source version dir [" + version.getAbsolutePath() + "] cannot read");
                }
                tmp = SQLScriptBuilder._createSql_Aggiornamento(version, sqlDestDir, bout, nextVersion, tipoDatabase, configurazioneUpgrade_runtime, configurazioneUpgrade_config, configurazioneUpgrade_tracce, configurazioneUpgrade_statistiche, configurazioneUpgrade_monitoraggio);
                if (tmp != null) {
                    infoVersion = tmp;
                }
                ++tmpMinorVersion;
                continue;
            }
            actualVersion = productVersion + "." + tmpMajorVersion + ".x";
            version = new File(sqlSourceDir, "upgrade_" + actualVersion + "_to_" + (nextVersion = productVersion + "." + (tmpMajorVersion + 1) + ".0"));
            if (!version.exists()) break;
            if (!version.canRead()) {
                throw new Exception("Source version dir [" + version.getAbsolutePath() + "] cannot read");
            }
            tmp = SQLScriptBuilder._createSql_Aggiornamento(version, sqlDestDir, bout, nextVersion, tipoDatabase, configurazioneUpgrade_runtime, configurazioneUpgrade_config, configurazioneUpgrade_tracce, configurazioneUpgrade_statistiche, configurazioneUpgrade_monitoraggio);
            if (tmp != null) {
                infoVersion = tmp;
            }
            ++tmpMajorVersion;
            tmpMinorVersion = 0;
        }
        if (infoVersion != null) {
            byte[] content = FileSystemUtilities.readBytesFromFile((File)infoVersion);
            bout.write("\n\n".getBytes());
            bout.write(content);
        }
        bout.flush();
        bout.close();
        String destFileScriptSql = sqlScriptName.replace(".sql", "_upgrade_" + versioneAttuale + ".sql");
        FileSystemUtilities.writeFile((File)new File(sqlDestDir, destFileScriptSql), (byte[])bout.toByteArray());
    }

    private static File _createSql_Aggiornamento(File sqlVersionSourceDir, File sqlDestDir, ByteArrayOutputStream bout, String nextVersion, String tipoDatabase, boolean configurazioneUpgrade_runtime, boolean configurazioneUpgrade_config, boolean configurazioneUpgrade_tracce, boolean configurazioneUpgrade_statistiche, boolean configurazioneUpgrade_monitoraggio) throws Exception {
        File sqlVersionSourceDirInfoVersioneUpgrade;
        File sqlVersionSourceDirDatabase = new File(sqlVersionSourceDir, tipoDatabase);
        Object[] files = sqlVersionSourceDirDatabase.listFiles();
        if (files != null && files.length > 0) {
            boolean writeUpgrade = false;
            Arrays.sort(files);
            for (Object upgradeFile : files) {
                if (!((File)upgradeFile).getName().contains("-runtimePdD-") ? (!((File)upgradeFile).getName().contains("-archiviComunicazioni-") ? (!((File)upgradeFile).getName().contains("-informazioniStatistiche-") ? (!((File)upgradeFile).getName().contains("-monitoraggio-") ? !configurazioneUpgrade_config : !configurazioneUpgrade_monitoraggio) : !configurazioneUpgrade_statistiche) : !configurazioneUpgrade_tracce) : !configurazioneUpgrade_runtime) continue;
                if (!writeUpgrade) {
                    if (bout != null) {
                        if (bout.size() > 0) {
                            bout.write("\n\n".getBytes());
                        }
                        bout.write(("-- Upgrade to " + nextVersion).getBytes());
                    }
                    writeUpgrade = true;
                }
                SQLScriptBuilder._createSqlAggiornamento((File)upgradeFile, bout);
            }
        }
        if ((sqlVersionSourceDirInfoVersioneUpgrade = new File(sqlVersionSourceDir, "info-patch.sql")).exists()) {
            return sqlVersionSourceDirInfoVersioneUpgrade;
        }
        return null;
    }

    private static void _createSql(File sqlSourceDir, String sourceFile, File sqlDestDir, String destFile, int prefix, ByteArrayOutputStream bout, boolean splitDDL_DML) throws Exception {
        File src = new File(sqlSourceDir, sourceFile);
        if (bout != null) {
            byte[] b = FileSystemUtilities.readBytesFromFile((File)src);
            if (bout.size() > 0) {
                bout.write("\n\n".getBytes());
            }
            bout.write(b);
        } else {
            File dest = new File(sqlDestDir, SQLScriptBuilder.parsePrefix(prefix) + destFile);
            FileSystemUtilities.copy((File)src, (File)dest);
            if (splitDDL_DML) {
                File destInit = new File(sqlDestDir, dest.getName().replace(".sql", "_init.sql"));
                SQLScriptBuilder.splitFileForDDLtoDML(dest, dest, destInit);
            }
        }
    }

    private static void _createSqlAggiornamento(File upgradeFile, ByteArrayOutputStream bout) throws Exception {
        if (bout == null) {
            throw new Exception("Param bout is null");
        }
        byte[] b = FileSystemUtilities.readBytesFromFile((File)upgradeFile);
        if (bout.size() > 0) {
            bout.write("\n\n".getBytes());
        }
        bout.write(b);
    }

    private static String parsePrefix(int prefix) {
        if (prefix < 10) {
            return "0" + prefix + "_";
        }
        return prefix + "_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void splitFileForDDLtoDML(File sqlFile, File sqlFileDest, File sqlFileInitDest) throws Exception {
        boolean dmlOpen = false;
        ByteArrayOutputStream boutDDL = new ByteArrayOutputStream();
        ByteArrayOutputStream boutDML = new ByteArrayOutputStream();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(sqlFile));
            while ((line = br.readLine()) != null) {
                if (dmlOpen) {
                    boutDML.write(line.getBytes());
                    boutDML.write("\n".getBytes());
                    if (!line.contains(";")) continue;
                    dmlOpen = false;
                    continue;
                }
                if (SQLScriptBuilder.isDML(line)) {
                    dmlOpen = true;
                    boutDML.write(line.getBytes());
                    boutDML.write("\n".getBytes());
                    if (!line.contains(";")) continue;
                    dmlOpen = false;
                    continue;
                }
                boutDDL.write(line.getBytes());
                boutDDL.write("\n".getBytes());
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Throwable throwable) {}
        }
        if (boutDDL.size() > 0) {
            FileSystemUtilities.writeFile((File)sqlFileDest, (byte[])boutDDL.toByteArray());
        }
        if (boutDML.size() > 0) {
            FileSystemUtilities.writeFile((File)sqlFileInitDest, (byte[])boutDML.toByteArray());
        }
    }

    private static boolean isDML(String line) {
        String tmp = new String(line);
        if ((tmp = tmp.trim().toLowerCase()).startsWith("insert ")) {
            if (tmp.contains("_init_seq ") && tmp.contains("next value ")) {
                return false;
            }
            return !tmp.contains("insert on ");
        }
        if (tmp.startsWith("update ")) {
            return true;
        }
        if (tmp.startsWith("delete ")) {
            return !tmp.contains("on delete cascade");
        }
        return false;
    }
}

