/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons.dao;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.IDAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.tracciamento.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.slf4j.Logger;

public class DAOFactory
implements IDAOFactory {
    private static DAOFactory daoFactory = null;
    private Logger log = null;
    private DAOFactoryProperties daoFactoryProperties = null;

    private static synchronized void initialize(Logger log) throws DAOFactoryException {
        if (daoFactory == null) {
            daoFactory = new DAOFactory(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DAOFactory getInstance(Logger log) throws DAOFactoryException {
        if (daoFactory != null) return daoFactory;
        Class<DAOFactory> clazz = DAOFactory.class;
        synchronized (DAOFactory.class) {
            DAOFactory.initialize(log);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return daoFactory;
        }
    }

    public Logger getLog() {
        return this.log;
    }

    private DAOFactory(Logger log) throws DAOFactoryException {
        try {
            this.log = log;
            this.daoFactoryProperties = DAOFactoryProperties.getInstance(log);
        }
        catch (Exception e) {
            throw new DAOFactoryException(e.getMessage(), e);
        }
    }

    protected DAOFactory(Logger log, DAOFactoryProperties daoFactoryProperties) throws DAOFactoryException {
        try {
            this.log = log;
            this.daoFactoryProperties = daoFactoryProperties;
        }
        catch (Exception e) {
            throw new DAOFactoryException(e.getMessage(), e);
        }
    }

    private Object getServiceManager(IProjectInfo tipoDAO, DataSource ds, Connection connection, Boolean isAutocommit, ServiceManagerProperties smProperties, Logger log) throws DAOFactoryException {
        String daoClassName = null;
        String mode = "";
        org.openspcoop2.core.diagnostica.utils.ProjectInfo daoDiagnostica = org.openspcoop2.core.diagnostica.utils.ProjectInfo.getInstance();
        boolean isDiagnostica = daoDiagnostica.getProjectName().equals(tipoDAO.getProjectName());
        ProjectInfo daoTracciamento = ProjectInfo.getInstance();
        boolean isTracciamento = daoTracciamento.getProjectName().equals(tipoDAO.getProjectName());
        boolean isUtenti = "utenti".equals(tipoDAO.getProjectName());
        try {
            daoClassName = this.daoFactoryProperties.getDAOClassName(tipoDAO);
            Class<?> cServiceManager = Class.forName(daoClassName);
            if (!(isTracciamento || isDiagnostica || isUtenti)) {
                Constructor<?> constrServiceManager = null;
                Object object = null;
                if (smProperties == null) {
                    smProperties = this.daoFactoryProperties.getServiceManagerProperties(tipoDAO);
                }
                if (isAutocommit != null) {
                    smProperties.setAutomaticTransactionManagement(isAutocommit.booleanValue());
                }
                if (log == null) {
                    log = this.log;
                }
                if (ds != null) {
                    mode = "DSMode";
                    constrServiceManager = cServiceManager.getConstructor(DataSource.class, ServiceManagerProperties.class, Logger.class);
                    object = constrServiceManager.newInstance(ds, smProperties, log);
                } else if (connection != null) {
                    mode = "ConnectionMode";
                    constrServiceManager = cServiceManager.getConstructor(Connection.class, ServiceManagerProperties.class, Logger.class);
                    object = constrServiceManager.newInstance(connection, smProperties, log);
                } else if (this.daoFactoryProperties.isTipoAccessoTramiteDatasource(tipoDAO)) {
                    mode = "LookupDSMode";
                    constrServiceManager = cServiceManager.getConstructor(String.class, Properties.class, ServiceManagerProperties.class, Logger.class);
                    object = constrServiceManager.newInstance(this.daoFactoryProperties.getDatasourceJNDIName(tipoDAO), this.daoFactoryProperties.getDatasourceJNDIContext(tipoDAO), smProperties, log);
                } else {
                    mode = "LookupConnectionMode";
                    constrServiceManager = cServiceManager.getConstructor(String.class, String.class, String.class, String.class, ServiceManagerProperties.class, Logger.class);
                    object = constrServiceManager.newInstance(this.daoFactoryProperties.getConnectionUrl(tipoDAO), this.daoFactoryProperties.getConnectionDriverJDBC(tipoDAO), this.daoFactoryProperties.getConnectionAuthUsername(tipoDAO), this.daoFactoryProperties.getConnectionAuthPassword(tipoDAO), smProperties, log);
                }
                return object;
            }
            Constructor<?> constrServiceManager = null;
            Object object = null;
            if (smProperties == null) {
                smProperties = this.daoFactoryProperties.getServiceManagerProperties(tipoDAO);
            }
            if (isAutocommit != null) {
                smProperties.setAutomaticTransactionManagement(isAutocommit.booleanValue());
            }
            if (log == null) {
                log = this.log;
            }
            if (ds != null) {
                mode = "DSMode";
                constrServiceManager = cServiceManager.getConstructor(DataSource.class, String.class, Logger.class);
                object = constrServiceManager.newInstance(ds, smProperties.getDatabaseType(), log);
            } else if (connection != null) {
                mode = "ConnectionMode";
                constrServiceManager = cServiceManager.getConstructor(Connection.class, String.class, Logger.class);
                object = constrServiceManager.newInstance(connection, smProperties.getDatabaseType(), log);
            } else if (this.daoFactoryProperties.isTipoAccessoTramiteDatasource(tipoDAO)) {
                mode = "LookupDSMode";
                constrServiceManager = cServiceManager.getConstructor(String.class, String.class, Properties.class, Logger.class);
                object = constrServiceManager.newInstance(this.daoFactoryProperties.getDatasourceJNDIName(tipoDAO), smProperties.getDatabaseType(), this.daoFactoryProperties.getDatasourceJNDIContext(tipoDAO), log);
            } else {
                mode = "LookupConnectionMode";
                constrServiceManager = cServiceManager.getConstructor(String.class, String.class, String.class, String.class, String.class, Logger.class);
                object = constrServiceManager.newInstance(this.daoFactoryProperties.getConnectionUrl(tipoDAO), this.daoFactoryProperties.getConnectionDriverJDBC(tipoDAO), this.daoFactoryProperties.getConnectionAuthUsername(tipoDAO), this.daoFactoryProperties.getConnectionAuthPassword(tipoDAO), smProperties.getDatabaseType(), log);
            }
            return object;
        }
        catch (Exception e) {
            throw new DAOFactoryException("[class:" + daoClassName + "][mode:" + mode + "]:" + e.getMessage(), e);
        }
    }

    @Override
    public Object getServiceManager(IProjectInfo dao) throws DAOFactoryException {
        return this.getServiceManager(dao, null, null, null, null, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, boolean autoCommit) throws DAOFactoryException {
        return this.getServiceManager(dao, null, null, autoCommit, null, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, DataSource ds) throws DAOFactoryException {
        return this.getServiceManager(dao, ds, null, null, null, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, DataSource ds, boolean autoCommit) throws DAOFactoryException {
        return this.getServiceManager(dao, ds, null, autoCommit, null, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Connection connection) throws DAOFactoryException {
        return this.getServiceManager(dao, null, connection, null, null, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Connection connection, boolean autoCommit) throws DAOFactoryException {
        return this.getServiceManager(dao, null, connection, autoCommit, null, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, ServiceManagerProperties smProperties) throws DAOFactoryException {
        return this.getServiceManager(dao, null, null, null, smProperties, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, boolean autoCommit, ServiceManagerProperties smProperties) throws DAOFactoryException {
        return this.getServiceManager(dao, null, null, autoCommit, smProperties, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, DataSource ds, ServiceManagerProperties smProperties) throws DAOFactoryException {
        return this.getServiceManager(dao, ds, null, null, smProperties, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, DataSource ds, boolean autoCommit, ServiceManagerProperties smProperties) throws DAOFactoryException {
        return this.getServiceManager(dao, ds, null, autoCommit, smProperties, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Connection connection, ServiceManagerProperties smProperties) throws DAOFactoryException {
        return this.getServiceManager(dao, null, connection, null, smProperties, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Connection connection, boolean autoCommit, ServiceManagerProperties smProperties) throws DAOFactoryException {
        return this.getServiceManager(dao, null, connection, autoCommit, smProperties, null);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, null, null, null, null, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, boolean autoCommit, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, null, null, autoCommit, null, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, DataSource ds, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, ds, null, null, null, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, DataSource ds, boolean autoCommit, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, ds, null, autoCommit, null, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Connection connection, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, null, connection, null, null, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Connection connection, boolean autoCommit, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, null, connection, autoCommit, null, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, ServiceManagerProperties smProperties, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, null, null, null, smProperties, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, boolean autoCommit, ServiceManagerProperties smProperties, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, null, null, autoCommit, smProperties, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, DataSource ds, ServiceManagerProperties smProperties, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, ds, null, null, smProperties, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, DataSource ds, boolean autoCommit, ServiceManagerProperties smProperties, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, ds, null, autoCommit, smProperties, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Connection connection, ServiceManagerProperties smProperties, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, null, connection, null, smProperties, log);
    }

    @Override
    public Object getServiceManager(IProjectInfo dao, Connection connection, boolean autoCommit, ServiceManagerProperties smProperties, Logger log) throws DAOFactoryException {
        return this.getServiceManager(dao, null, connection, autoCommit, smProperties, log);
    }
}

