/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons.search.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.openspcoop2.core.commons.search.IdPortaDelegata;
import org.openspcoop2.core.commons.search.IdServizioApplicativo;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.PortaDelegata;
import org.openspcoop2.core.commons.search.PortaDelegataAzione;
import org.openspcoop2.core.commons.search.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IDBSoggettoServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.commons.search.dao.jdbc.converter.PortaDelegataFieldConverter;
import org.openspcoop2.core.commons.search.dao.jdbc.fetch.PortaDelegataFetch;
import org.openspcoop2.core.commons.search.utils.ExpressionProperties;
import org.openspcoop2.generic_project.beans.AliasField;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.Utilities;
import org.openspcoop2.generic_project.utils.UtilsTemplate;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCPortaDelegataServiceSearchImpl
implements IJDBCServiceSearchWithId<PortaDelegata, IdPortaDelegata, JDBCServiceManager> {
    private PortaDelegataFieldConverter _portaDelegataFieldConverter = null;
    private PortaDelegataFetch portaDelegataFetch = new PortaDelegataFetch();
    private JDBCServiceManager jdbcServiceManager = null;

    public PortaDelegataFieldConverter getPortaDelegataFieldConverter() {
        if (this._portaDelegataFieldConverter == null) {
            this._portaDelegataFieldConverter = new PortaDelegataFieldConverter(this.jdbcServiceManager.getJdbcProperties().getDatabaseType());
        }
        return this._portaDelegataFieldConverter;
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.getPortaDelegataFieldConverter();
    }

    public PortaDelegataFetch getPortaDelegataFetch() {
        return this.portaDelegataFetch;
    }

    public IJDBCFetch getFetch() {
        return this.getPortaDelegataFetch();
    }

    public void setServiceManager(JDBCServiceManager serviceManager) throws ServiceException {
        this.jdbcServiceManager = serviceManager;
    }

    public JDBCServiceManager getServiceManager() throws ServiceException {
        return this.jdbcServiceManager;
    }

    public JDBCServiceManager getServiceManager(Connection connection, JDBCServiceManagerProperties jdbcProperties, Logger log) throws ServiceException {
        return new JDBCServiceManager(connection, jdbcProperties, log);
    }

    public IdPortaDelegata convertToId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, PortaDelegata portaDelegata) throws NotImplementedException, ServiceException, Exception {
        IdPortaDelegata idPortaDelegata = new IdPortaDelegata();
        idPortaDelegata.setNome(portaDelegata.getNome());
        return idPortaDelegata;
    }

    public PortaDelegata get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaDelegata id, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_portaDelegata = id != null && id.getId() != null && id.getId() > 0L ? id.getId() : this.findIdPortaDelegata(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, id_portaDelegata, idMappingResolutionBehaviour);
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaDelegata id) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_portaDelegata = this.findIdPortaDelegata(jdbcProperties, log, connection, sqlQueryObject, id, false);
        return id_portaDelegata != null && id_portaDelegata > 0L;
    }

    public List<IdPortaDelegata> findAllIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<IdPortaDelegata> list = new ArrayList<IdPortaDelegata>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            PortaDelegata portaDelegata = this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
            IdPortaDelegata idPortaDelegata = this.convertToId(jdbcProperties, log, connection, sqlQueryObject, portaDelegata);
            list.add(idPortaDelegata);
        }
        return list;
    }

    public List<PortaDelegata> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<PortaDelegata> list = new ArrayList<PortaDelegata>();
        boolean soloDatiIdentificativiServizio = ExpressionProperties.isEnabledSoloDatiIdentificativiServizio((IExpression)expression);
        if (soloDatiIdentificativiServizio) {
            ArrayList<Object> fields = new ArrayList<Object>();
            fields.add(PortaDelegata.model().NOME);
            fields.add(PortaDelegata.model().STATO);
            fields.add(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE);
            fields.add(PortaDelegata.model().NOME_SOGGETTO_EROGATORE);
            fields.add(PortaDelegata.model().TIPO_SERVIZIO);
            fields.add(PortaDelegata.model().NOME_SERVIZIO);
            fields.add(PortaDelegata.model().VERSIONE_SERVIZIO);
            fields.add(PortaDelegata.model().MODE_AZIONE);
            fields.add(PortaDelegata.model().NOME_AZIONE);
            fields.add(PortaDelegata.model().NOME_PORTA_DELEGANTE_AZIONE);
            String aliasSoggettoTipo = "proprietarioSoggettoTipo";
            fields.add(new AliasField(PortaDelegata.model().ID_SOGGETTO.TIPO, aliasSoggettoTipo));
            String aliasSoggettoNome = "proprietarioSoggettoNome";
            fields.add(new AliasField(PortaDelegata.model().ID_SOGGETTO.NOME, aliasSoggettoNome));
            List<Map<String, Object>> returnMap = null;
            try {
                boolean distinct = false;
                returnMap = this.select(jdbcProperties, log, connection, sqlQueryObject, expression, distinct, fields.toArray(new IField[1]));
                for (Map<String, Object> map : returnMap) {
                    PortaDelegata pd = (PortaDelegata)this.getPortaDelegataFetch().fetch(jdbcProperties.getDatabase(), (IModel<?>)PortaDelegata.model(), map);
                    Object proprietarioSoggettoTipo = this.getObjectFromMap(map, aliasSoggettoTipo);
                    Object proprietarioSoggettoNome = this.getObjectFromMap(map, aliasSoggettoNome);
                    if (proprietarioSoggettoTipo != null && proprietarioSoggettoNome != null) {
                        IdSoggetto idSoggetto = new IdSoggetto();
                        if (proprietarioSoggettoTipo != null && proprietarioSoggettoTipo instanceof String) {
                            idSoggetto.setTipo((String)proprietarioSoggettoTipo);
                        }
                        if (proprietarioSoggettoNome != null && proprietarioSoggettoNome instanceof String) {
                            idSoggetto.setNome((String)proprietarioSoggettoNome);
                        }
                        pd.setIdSoggetto(idSoggetto);
                    }
                    list.add(pd);
                }
            }
            catch (NotFoundException notFoundException) {}
        } else {
            List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
            for (Long id : ids) {
                list.add(this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour));
            }
        }
        return list;
    }

    private Object getObjectFromMap(Map<String, Object> map, String name) {
        if (map == null) {
            return null;
        }
        if (map.containsKey(name)) {
            Object o = map.get(name);
            if (o instanceof ObjectUtils.Null) {
                return null;
            }
            return o;
        }
        return null;
    }

    public PortaDelegata find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        long id = this.findTableId(jdbcProperties, log, connection, sqlQueryObject, expression);
        if (id > 0L) {
            return this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
        }
        throw new NotFoundException("Entry with id[" + id + "] not found");
    }

    public NonNegativeNumber count(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List listaQuery = GenericJDBCUtilities.prepareCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model());
        sqlQueryObject.addSelectCountField(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model()) + ".id", "tot", true);
        this.joinEngine((IExpression)expression, sqlQueryObject);
        return GenericJDBCUtilities.count((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), (List)listaQuery);
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaDelegata id) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long id_portaDelegata = this.findIdPortaDelegata(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, id_portaDelegata);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List<Map<String, Object>> map = this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, distinct, new IField[]{field});
        return GenericJDBCUtilities.selectSingleObject(map);
    }

    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        try {
            ISQLQueryObject sqlQueryObjectDistinct = GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((boolean)distinct, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (Logger)log, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IField[])field);
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression, sqlQueryObjectDistinct);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        }
    }

    public Object aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        Map<String, Object> map = this.aggregate(jdbcProperties, log, connection, sqlQueryObject, expression, new FunctionField[]{functionField});
        return GenericJDBCUtilities.selectAggregateObject(map, (FunctionField)functionField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            Map<String, Object> map = list.get(0);
            return map;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (expression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (paginatedExpression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        }
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, expression, null);
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLQueryObject sqlQueryObjectDistinct) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        ArrayList listaQuery = new ArrayList();
        ArrayList listaParams = new ArrayList();
        List returnField = GenericJDBCUtilities.prepareSelect((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), listaQuery, listaParams);
        this.joinEngine(expression, sqlQueryObject);
        List list = GenericJDBCUtilities.select((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((ISQLQueryObject)sqlQueryObject, (ISQLQueryObject)sqlQueryObjectDistinct), (IExpression)expression, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), listaQuery, listaParams, (List)returnField);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public List<Map<String, Object>> union(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List list;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnion((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((list = GenericJDBCUtilities.union((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public NonNegativeNumber unionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        NonNegativeNumber number;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((number = GenericJDBCUtilities.unionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && number.longValue() >= 0L) {
            return number;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public JDBCExpression newExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression((ISQLFieldConverter)this.getPortaDelegataFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression newPaginatedExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression((ISQLFieldConverter)this.getPortaDelegataFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCExpression toExpression(JDBCPaginatedExpression paginatedExpression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression(paginatedExpression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression toPaginatedExpression(JDBCExpression expression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression(expression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaDelegata id, PortaDelegata obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, id, null));
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, PortaDelegata obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, tableId, (IDMappingBehaviour)null));
    }

    private void _mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, PortaDelegata obj, PortaDelegata imgSaved) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        boolean objEqualsToImgSaved_;
        List<BaseBeanWithId> listImgSaved_;
        PortaDelegataServizioApplicativo itemAlreadySaved_;
        List<BaseBeanWithId> listObj_;
        if (imgSaved == null) {
            return;
        }
        obj.setId(imgSaved.getId());
        if (obj.getIdSoggetto() != null && imgSaved.getIdSoggetto() != null) {
            obj.getIdSoggetto().setId(imgSaved.getIdSoggetto().getId());
        }
        if (obj.getPortaDelegataServizioApplicativoList() != null) {
            listObj_ = obj.getPortaDelegataServizioApplicativoList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getPortaDelegataServizioApplicativoList() != null) {
                    listImgSaved_ = imgSaved.getPortaDelegataServizioApplicativoList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        objEqualsToImgSaved_ = false;
                        if (itemObj_.getIdServizioApplicativo() != null && itemObj_.getIdServizioApplicativo().getIdSoggetto() != null && itemImgSaved_.getIdServizioApplicativo() != null && itemImgSaved_.getIdServizioApplicativo().getIdSoggetto() != null) {
                            boolean bl = objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getIdServizioApplicativo().getNome(), (Object)itemImgSaved_.getIdServizioApplicativo().getNome()) && Utilities.equals((Object)itemObj_.getIdServizioApplicativo().getIdSoggetto().getTipo(), (Object)itemImgSaved_.getIdServizioApplicativo().getIdSoggetto().getTipo()) && Utilities.equals((Object)itemObj_.getIdServizioApplicativo().getIdSoggetto().getNome(), (Object)itemImgSaved_.getIdServizioApplicativo().getIdSoggetto().getNome());
                        }
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
                if (itemObj_.getIdServizioApplicativo() == null || itemAlreadySaved_.getIdServizioApplicativo() == null) continue;
                itemObj_.getIdServizioApplicativo().setId(itemAlreadySaved_.getIdServizioApplicativo().getId());
                if (itemObj_.getIdServizioApplicativo().getIdSoggetto() == null || itemAlreadySaved_.getIdServizioApplicativo().getIdSoggetto() == null) continue;
                itemObj_.getIdServizioApplicativo().getIdSoggetto().setId(itemAlreadySaved_.getIdServizioApplicativo().getIdSoggetto().getId());
            }
        }
        if (obj.getPortaDelegataAzioneList() != null) {
            listObj_ = obj.getPortaDelegataAzioneList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getPortaDelegataAzioneList() != null) {
                    listImgSaved_ = imgSaved.getPortaDelegataAzioneList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        objEqualsToImgSaved_ = false;
                        objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getNome(), (Object)itemImgSaved_.getNome());
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
            }
        }
    }

    public PortaDelegata get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
    }

    private PortaDelegata getEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        PortaDelegata portaDelegata = new PortaDelegata();
        ISQLQueryObject sqlQueryObjectGet_portaDelegata = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaDelegata.setANDLogicOperator(true);
        sqlQueryObjectGet_portaDelegata.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model()));
        sqlQueryObjectGet_portaDelegata.addSelectField("id");
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().NOME, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().STATO, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().TIPO_SERVIZIO, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().NOME_SERVIZIO, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().VERSIONE_SERVIZIO, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().MODE_AZIONE, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().NOME_AZIONE, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().NOME_PORTA_DELEGANTE_AZIONE, true));
        sqlQueryObjectGet_portaDelegata.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().CANALE, true));
        sqlQueryObjectGet_portaDelegata.addWhereCondition("id=?");
        portaDelegata = (PortaDelegata)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaDelegata.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)PortaDelegata.model(), (IJDBCFetch)this.getPortaDelegataFetch(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        ISQLQueryObject sqlQueryObjectGet_portaDelegata_soggetto_readFkId = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaDelegata_soggetto_readFkId.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model()));
        sqlQueryObjectGet_portaDelegata_soggetto_readFkId.addSelectField("id_soggetto");
        sqlQueryObjectGet_portaDelegata_soggetto_readFkId.addWhereCondition("id=?");
        sqlQueryObjectGet_portaDelegata_soggetto_readFkId.setANDLogicOperator(true);
        Long idFK_portaDelegata_soggetto = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaDelegata_soggetto_readFkId.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, new JDBCObject[]{new JDBCObject((Object)portaDelegata.getId(), Long.class)});
        ISQLQueryObject sqlQueryObjectGet_portaDelegata_soggetto = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaDelegata_soggetto.addFromTable("soggetti");
        sqlQueryObjectGet_portaDelegata_soggetto.addSelectField("tipo_soggetto");
        sqlQueryObjectGet_portaDelegata_soggetto.addSelectField("nome_soggetto");
        sqlQueryObjectGet_portaDelegata_soggetto.setANDLogicOperator(true);
        sqlQueryObjectGet_portaDelegata_soggetto.addWhereCondition("id=?");
        JDBCObject[] searchParams_portaDelegata_soggetto = new JDBCObject[]{new JDBCObject((Object)idFK_portaDelegata_soggetto, Long.class)};
        ArrayList<Class<String>> listaFieldIdReturnType_portaDelegata_soggetto = new ArrayList<Class<String>>();
        listaFieldIdReturnType_portaDelegata_soggetto.add(String.class);
        listaFieldIdReturnType_portaDelegata_soggetto.add(String.class);
        List listaFieldId_portaDelegata_soggetto = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaDelegata_soggetto.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_portaDelegata_soggetto, searchParams_portaDelegata_soggetto);
        IdSoggetto idSoggetto = new IdSoggetto();
        idSoggetto.setTipo((String)listaFieldId_portaDelegata_soggetto.get(0));
        idSoggetto.setNome((String)listaFieldId_portaDelegata_soggetto.get(1));
        portaDelegata.setIdSoggetto(idSoggetto);
        ISQLQueryObject sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo.setANDLogicOperator(true);
        sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO));
        sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo.addSelectField("id");
        sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo.addWhereCondition("id_porta=?");
        List portaDelegata_portaDelegataServizioApplicativo_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO, (IJDBCFetch)this.getPortaDelegataFetch(), new JDBCObject[]{new JDBCObject((Object)portaDelegata.getId(), Long.class)});
        if (portaDelegata_portaDelegataServizioApplicativo_list != null) {
            for (Object portaDelegata_portaDelegataServizioApplicativo_object : portaDelegata_portaDelegataServizioApplicativo_list) {
                PortaDelegataServizioApplicativo portaDelegata_portaDelegataServizioApplicativo = (PortaDelegataServizioApplicativo)portaDelegata_portaDelegataServizioApplicativo_object;
                ISQLQueryObject sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo_readFkId = sqlQueryObjectGet.newSQLQueryObject();
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo_readFkId.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO));
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo_readFkId.addSelectField("id_servizio_applicativo");
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo_readFkId.addWhereCondition("id=?");
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo_readFkId.setANDLogicOperator(true);
                Long idFK_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo_readFkId.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, new JDBCObject[]{new JDBCObject((Object)portaDelegata_portaDelegataServizioApplicativo.getId(), Long.class)});
                ISQLQueryObject sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo = sqlQueryObjectGet.newSQLQueryObject();
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.addFromTable("servizi_applicativi");
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.addSelectField("nome");
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.addSelectField("id_soggetto");
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.setANDLogicOperator(true);
                sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.addWhereCondition("id=?");
                JDBCObject[] searchParams_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo = new JDBCObject[]{new JDBCObject((Object)idFK_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo, Long.class)};
                ArrayList<Class> listaFieldIdReturnType_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo = new ArrayList<Class>();
                listaFieldIdReturnType_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.add(String.class);
                listaFieldIdReturnType_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.add(Long.class);
                List listaFieldId_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo, searchParams_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo);
                IdServizioApplicativo idServizioApplicativo = new IdServizioApplicativo();
                idServizioApplicativo.setNome((String)listaFieldId_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.get(0));
                Long idSoggettoLong = (Long)listaFieldId_portaDelegata_portaDelegataServizioApplicativo_servizioApplicativo.get(1);
                IdSoggetto idSoggettoSA = (IdSoggetto)this.jdbcServiceManager.getSoggettoServiceSearch().convertToId((Soggetto)((IDBSoggettoServiceSearch)this.jdbcServiceManager.getSoggettoServiceSearch()).get(idSoggettoLong));
                idServizioApplicativo.setIdSoggetto(idSoggettoSA);
                portaDelegata_portaDelegataServizioApplicativo.setIdServizioApplicativo(idServizioApplicativo);
                portaDelegata.addPortaDelegataServizioApplicativo(portaDelegata_portaDelegataServizioApplicativo);
            }
        }
        ISQLQueryObject sqlQueryObjectGet_portaDelegata_portaDelegataAzione = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_portaDelegata_portaDelegataAzione.setANDLogicOperator(true);
        sqlQueryObjectGet_portaDelegata_portaDelegataAzione.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_AZIONE));
        sqlQueryObjectGet_portaDelegata_portaDelegataAzione.addSelectField("id");
        sqlQueryObjectGet_portaDelegata_portaDelegataAzione.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().PORTA_DELEGATA_AZIONE.NOME, true));
        sqlQueryObjectGet_portaDelegata_portaDelegataAzione.addWhereCondition("id_porta=?");
        List portaDelegata_portaDelegataAzione_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_portaDelegata_portaDelegataAzione.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)PortaDelegata.model().PORTA_DELEGATA_AZIONE, (IJDBCFetch)this.getPortaDelegataFetch(), new JDBCObject[]{new JDBCObject((Object)portaDelegata.getId(), Long.class)});
        if (portaDelegata_portaDelegataAzione_list != null) {
            for (Object portaDelegata_portaDelegataAzione_object : portaDelegata_portaDelegataAzione_list) {
                PortaDelegataAzione portaDelegata_portaDelegataAzione = (PortaDelegataAzione)portaDelegata_portaDelegataAzione_object;
                portaDelegata.addPortaDelegataAzione(portaDelegata_portaDelegataAzione);
            }
        }
        return portaDelegata;
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this._exists(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private boolean _exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        boolean existsPortaDelegata = false;
        sqlQueryObject = sqlQueryObject.newSQLQueryObject();
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model()));
        sqlQueryObject.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().NOME, true));
        sqlQueryObject.addWhereCondition("id=?");
        existsPortaDelegata = jdbcUtilities.exists(sqlQueryObject.createSQLQuery(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        return existsPortaDelegata;
    }

    private void joinEngine(IExpression expression, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        String tableName2;
        String tableName1;
        String tableName22;
        String tableName12;
        if (expression.inUseModel((IModel)PortaDelegata.model().ID_SOGGETTO, false)) {
            tableName12 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model());
            tableName22 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().ID_SOGGETTO);
            sqlQueryObject.addWhereCondition(tableName12 + ".id_soggetto=" + tableName22 + ".id");
        }
        if (expression.inUseModel((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO, false)) {
            tableName12 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model());
            tableName22 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO);
            sqlQueryObject.addWhereCondition(tableName12 + ".id=" + tableName22 + ".id_porta");
        }
        if (expression.inUseModel((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO, false)) {
            tableName12 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO);
            tableName22 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO);
            sqlQueryObject.addWhereCondition(tableName12 + ".id_servizio_applicativo=" + tableName22 + ".id");
        }
        if (expression.inUseModel((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO, false)) {
            tableName12 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO);
            tableName22 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO);
            sqlQueryObject.addWhereCondition(tableName12 + ".id_soggetto=" + tableName22 + ".id");
        }
        if (expression.inUseModel((IModel)PortaDelegata.model().PORTA_DELEGATA_AZIONE, false)) {
            tableName12 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model());
            tableName22 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_AZIONE);
            sqlQueryObject.addWhereCondition(tableName12 + ".id=" + tableName22 + ".id_porta");
        }
        boolean addFromPDSA = false;
        if (expression.inUseModel((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO, false) && !expression.inUseModel((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO, false)) {
            sqlQueryObject.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO));
            tableName1 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model());
            tableName2 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO);
            try {
                sqlQueryObject.addWhereCondition(tableName1 + ".id=" + tableName2 + ".id_porta");
            }
            catch (Exception exception) {
                // empty catch block
            }
            addFromPDSA = true;
        }
        if (expression.inUseModel((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO, false)) {
            if (!expression.inUseModel((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO, false)) {
                sqlQueryObject.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO));
                tableName1 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO);
                tableName2 = this.getPortaDelegataFieldConverter().toAliasTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO);
                try {
                    sqlQueryObject.addWhereCondition(tableName1 + ".id_servizio_applicativo=" + tableName2 + ".id");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!addFromPDSA) {
                sqlQueryObject.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO));
            }
        }
    }

    protected List<Object> getRootTablePrimaryKeyValuesEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaDelegata id) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        ArrayList<Object> rootTableIdValues = new ArrayList<Object>();
        Long longId = this.findIdPortaDelegata(jdbcProperties, log, connection, sqlQueryObject.newSQLQueryObject(), id, true);
        rootTableIdValues.add(longId);
        return rootTableIdValues;
    }

    protected Map<String, List<IField>> getMapTableToPKColumnEngine() throws NotImplementedException, Exception {
        PortaDelegataFieldConverter converter = this.getPortaDelegataFieldConverter();
        HashMap<String, List<IField>> mapTableToPKColumn = new HashMap<String, List<IField>>();
        UtilsTemplate utilities = new UtilsTemplate();
        mapTableToPKColumn.put(converter.toTable((IModel)PortaDelegata.model()), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaDelegata.model()))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaDelegata.model().ID_SOGGETTO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaDelegata.model().ID_SOGGETTO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.ID_SOGGETTO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_AZIONE), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)PortaDelegata.model().PORTA_DELEGATA_AZIONE))}));
        return mapTableToPKColumn;
    }

    public List<Long> findAllTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException, Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFindAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model());
        this.joinEngine((IExpression)paginatedExpression, sqlQueryObject);
        List listObjects = GenericJDBCUtilities.findAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), objectIdClass, (List)listaQuery);
        for (Object object : listObjects) {
            list.add((Long)object);
        }
        return list;
    }

    public long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, Exception {
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFind((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model());
        this.joinEngine((IExpression)expression, sqlQueryObject);
        Object res = GenericJDBCUtilities.find((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPortaDelegataFieldConverter(), (IModel)PortaDelegata.model(), objectIdClass, (List)listaQuery);
        if (res != null && (Long)res > 0L) {
            return (Long)res;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private InUse inUseEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        InUse inUse = new InUse();
        inUse.setInUse(false);
        boolean throwNotImplemented = true;
        if (throwNotImplemented) {
            throw new NotImplementedException("NotImplemented");
        }
        return inUse;
    }

    public IdPortaDelegata findId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectGet.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model()));
        sqlQueryObjectGet.addSelectField(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().NOME, true));
        sqlQueryObjectGet.setANDLogicOperator(true);
        sqlQueryObjectGet.addWhereCondition("id=?");
        JDBCObject[] searchParams_portaDelegata = new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)};
        ArrayList<Class<String>> listaFieldIdReturnType_portaDelegata = new ArrayList<Class<String>>();
        listaFieldIdReturnType_portaDelegata.add(String.class);
        IdPortaDelegata id_portaDelegata = null;
        List listaFieldId_portaDelegata = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_portaDelegata, searchParams_portaDelegata);
        if (listaFieldId_portaDelegata == null || listaFieldId_portaDelegata.size() <= 0) {
            if (throwNotFound) {
                throw GenericJDBCUtilities.newNotFoundException();
            }
        } else {
            id_portaDelegata = new IdPortaDelegata();
            id_portaDelegata.setNome((String)listaFieldId_portaDelegata.get(0));
        }
        return id_portaDelegata;
    }

    public Long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaDelegata id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        return this.findIdPortaDelegata(jdbcProperties, log, connection, sqlQueryObject, id, throwNotFound);
    }

    public List<List<Object>> nativeQuery(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeQuery((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)sql, returnClassTypes, (Object[])param);
    }

    protected Long findIdPortaDelegata(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPortaDelegata id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        Long id_portaDelegata;
        block5: {
            JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
            ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
            if (id == null) {
                throw new ServiceException("Id not defined");
            }
            if (id.getNome() == null) {
                throw new ServiceException("Id.nome not defined");
            }
            sqlQueryObjectGet.addFromTable(this.getPortaDelegataFieldConverter().toTable((IModel)PortaDelegata.model()));
            sqlQueryObjectGet.addSelectField("id");
            sqlQueryObjectGet.setANDLogicOperator(true);
            sqlQueryObjectGet.setSelectDistinct(true);
            sqlQueryObjectGet.addWhereCondition(this.getPortaDelegataFieldConverter().toColumn(PortaDelegata.model().NOME, true) + "=?");
            JDBCObject[] searchParams_portaDelegata = new JDBCObject[]{new JDBCObject((Object)id.getNome(), String.class)};
            id_portaDelegata = null;
            try {
                id_portaDelegata = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, searchParams_portaDelegata);
            }
            catch (NotFoundException notFound) {
                if (!throwNotFound) break block5;
                throw new NotFoundException((Throwable)notFound);
            }
        }
        if ((id_portaDelegata == null || id_portaDelegata <= 0L) && throwNotFound) {
            throw GenericJDBCUtilities.newNotFoundException();
        }
        return id_portaDelegata;
    }
}

