/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons.search.utils;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ProtocolFactoryReflectionUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.AccordoServizioParteComuneAzione;
import org.openspcoop2.core.commons.search.AccordoServizioParteComuneGruppo;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.Fruitore;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComuneGruppo;
import org.openspcoop2.core.commons.search.IdPortType;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.Operation;
import org.openspcoop2.core.commons.search.PortType;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.PortaDelegata;
import org.openspcoop2.core.commons.search.Resource;
import org.openspcoop2.core.commons.search.ServizioApplicativo;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteComuneAzioneServiceSearch;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteComuneGruppoServiceSearch;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteComuneServiceSearch;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteSpecificaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IFruitoreServiceSearch;
import org.openspcoop2.core.commons.search.dao.IOperationServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortaApplicativaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortaDelegataServiceSearch;
import org.openspcoop2.core.commons.search.dao.IResourceServiceSearch;
import org.openspcoop2.core.commons.search.dao.IServizioApplicativoServiceSearch;
import org.openspcoop2.core.commons.search.dao.ISoggettoServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCAccordoServizioParteComuneServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.commons.search.utils.ExpressionProperties;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.message.constants.ServiceBinding;
import org.slf4j.Logger;

public class RegistroCore {
    public static JDBCServiceManager getServiceManager(Logger log, String tipoDB, Connection con) throws Exception {
        return RegistroCore.getServiceManager(log, tipoDB, true, con);
    }

    public static JDBCServiceManager getServiceManager(Logger log, String tipoDB, boolean showSql, Connection con) throws Exception {
        ServiceManagerProperties properties = new ServiceManagerProperties();
        properties.setDatabaseType(tipoDB);
        properties.setShowSql(showSql);
        JDBCServiceManager manager = new JDBCServiceManager(con, properties);
        return manager;
    }

    public static List<IDSoggetto> getSoggetti(JDBCServiceManager manager, String protocollo) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getSoggetti(manager, protocolli);
    }

    public static List<IDSoggetto> getSoggetti(JDBCServiceManager manager, List<String> protocolli) throws Exception {
        ArrayList<IDSoggetto> list = new ArrayList<IDSoggetto>();
        ISoggettoServiceSearch soggettoServiceSearch = manager.getSoggettoServiceSearch();
        IPaginatedExpression pag = soggettoServiceSearch.newPaginatedExpression();
        pag.and();
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getOrganizationTypes(protocollo));
            }
            pag.in(Soggetto.model().TIPO_SOGGETTO, types);
        }
        pag.addOrder(Soggetto.model().NOME_SOGGETTO, SortOrder.ASC);
        pag.addOrder(Soggetto.model().TIPO_SOGGETTO, SortOrder.ASC);
        List result = null;
        try {
            result = soggettoServiceSearch.select(pag, true, new IField[]{Soggetto.model().TIPO_SOGGETTO, Soggetto.model().NOME_SOGGETTO});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result != null && result.size() > 0) {
            for (Map map : result) {
                String tipo = (String)map.get(Soggetto.model().TIPO_SOGGETTO.getFieldName());
                String nome = (String)map.get(Soggetto.model().NOME_SOGGETTO.getFieldName());
                list.add(new IDSoggetto(tipo, nome));
            }
        }
        return list;
    }

    public static List<IDSoggetto> getSoggettiFruitori(JDBCServiceManager manager, String protocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getSoggettiFruitori(manager, protocolli, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio);
    }

    public static List<IDSoggetto> getSoggettiFruitori(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws Exception {
        ArrayList<IDSoggetto> list = new ArrayList<IDSoggetto>();
        IFruitoreServiceSearch fruitoreServiceSearch = manager.getFruitoreServiceSearch();
        IPaginatedExpression pag = fruitoreServiceSearch.newPaginatedExpression();
        pag.and();
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getOrganizationTypes(protocollo));
            }
            pag.in(Fruitore.model().ID_FRUITORE.TIPO, types);
        }
        if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
            pag.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE.TIPO, (Object)tipoSoggettoErogatore);
            pag.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE.NOME, (Object)nomeSoggettoErogatore);
        }
        if (tipoServizio != null && nomeServizio != null && versioneServizio != null) {
            pag.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.TIPO, (Object)tipoServizio);
            pag.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.NOME, (Object)nomeServizio);
            pag.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.VERSIONE, (Object)versioneServizio);
        }
        pag.addOrder(Fruitore.model().ID_FRUITORE.NOME, SortOrder.ASC);
        pag.addOrder(Fruitore.model().ID_FRUITORE.TIPO, SortOrder.ASC);
        List result = null;
        try {
            result = fruitoreServiceSearch.select(pag, true, new IField[]{Fruitore.model().ID_FRUITORE.TIPO, Fruitore.model().ID_FRUITORE.NOME});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result != null && result.size() > 0) {
            for (Map map : result) {
                String tipo = (String)map.get(Fruitore.model().ID_FRUITORE.getBaseField().getFieldName() + "." + Fruitore.model().ID_FRUITORE.TIPO.getFieldName());
                String nome = (String)map.get(Fruitore.model().ID_FRUITORE.getBaseField().getFieldName() + "." + Fruitore.model().ID_FRUITORE.NOME.getFieldName());
                list.add(new IDSoggetto(tipo, nome));
            }
        }
        return list;
    }

    public static List<IDSoggetto> getSoggettiErogatori(JDBCServiceManager manager, String protocollo) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getSoggettiErogatori(manager, protocolli);
    }

    public static List<IDSoggetto> getSoggettiErogatori(JDBCServiceManager manager, List<String> protocolli) throws Exception {
        ArrayList<IDSoggetto> list = new ArrayList<IDSoggetto>();
        IAccordoServizioParteSpecificaServiceSearch aspsServiceSearch = manager.getAccordoServizioParteSpecificaServiceSearch();
        IPaginatedExpression pag = aspsServiceSearch.newPaginatedExpression();
        pag.and();
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getOrganizationTypes(protocollo));
            }
            pag.in(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, types);
        }
        pag.addOrder(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, SortOrder.ASC);
        pag.addOrder(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, SortOrder.ASC);
        List result = null;
        try {
            result = aspsServiceSearch.select(pag, true, new IField[]{AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result != null && result.size() > 0) {
            for (Map map : result) {
                String tipo = (String)map.get(AccordoServizioParteSpecifica.model().ID_EROGATORE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO.getFieldName());
                String nome = (String)map.get(AccordoServizioParteSpecifica.model().ID_EROGATORE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME.getFieldName());
                list.add(new IDSoggetto(tipo, nome));
            }
        }
        return list;
    }

    public static List<IDServizio> getServizi(JDBCServiceManager manager, String protocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tag) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getServizi(manager, protocolli, tipoSoggettoErogatore, nomeSoggettoErogatore, tag);
    }

    public static List<IDServizio> getServizi(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tag) throws Exception {
        return RegistroCore.getServizi(manager, protocolli, tipoSoggettoErogatore, nomeSoggettoErogatore, tag, null, null, null);
    }

    public static List<IDServizio> getServizi(JDBCServiceManager manager, String protocollo, String tipoServizio, String nomeServizio, Integer versioneServizio, String tag) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getServizi(manager, protocolli, tipoServizio, nomeServizio, versioneServizio, tag);
    }

    public static List<IDServizio> getServizi(JDBCServiceManager manager, List<String> protocolli, String tipoServizio, String nomeServizio, Integer versioneServizio, String tag) throws Exception {
        return RegistroCore.getServizi(manager, protocolli, null, null, tag, tipoServizio, nomeServizio, versioneServizio);
    }

    private static List<IDServizio> getServizi(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tag, String tipoServizio, String nomeServizio, Integer versioneServizio) throws Exception {
        ArrayList<IDServizio> list = new ArrayList<IDServizio>();
        IAccordoServizioParteSpecificaServiceSearch aspsServiceSearch = manager.getAccordoServizioParteSpecificaServiceSearch();
        IPaginatedExpression pag = aspsServiceSearch.newPaginatedExpression();
        pag.and();
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getServiceTypes(protocollo));
            }
            pag.in(AccordoServizioParteSpecifica.model().TIPO, types);
        }
        if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
            pag.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)tipoSoggettoErogatore);
            pag.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)nomeSoggettoErogatore);
        }
        if (tipoServizio != null && nomeServizio != null && versioneServizio != null) {
            pag.equals(AccordoServizioParteSpecifica.model().TIPO, (Object)tipoServizio);
            pag.equals(AccordoServizioParteSpecifica.model().NOME, (Object)nomeServizio);
            pag.equals(AccordoServizioParteSpecifica.model().VERSIONE, (Object)versioneServizio);
        }
        if (tag != null) {
            IAccordoServizioParteComuneGruppoServiceSearch gruppiServiceSearch = manager.getAccordoServizioParteComuneGruppoServiceSearch();
            IPaginatedExpression pagGruppi = gruppiServiceSearch.newPaginatedExpression();
            pagGruppi.and();
            pagGruppi.equals(AccordoServizioParteComuneGruppo.model().ID_GRUPPO.NOME, (Object)tag);
            List listGruppi = gruppiServiceSearch.findAll(pagGruppi);
            ArrayList<Long> idAccordo = new ArrayList<Long>();
            if (listGruppi != null && !listGruppi.isEmpty()) {
                for (AccordoServizioParteComuneGruppo aspcGruppo : listGruppi) {
                    idAccordo.add(aspcGruppo.getIdAccordoServizioParteComune().getId());
                }
            } else {
                idAccordo.add(-4L);
            }
            CustomField cf = new CustomField("idAccordo", Long.class, "id_accordo", "servizi");
            pag.in((IField)cf, idAccordo);
        }
        pag.addOrder(AccordoServizioParteSpecifica.model().NOME, SortOrder.ASC);
        pag.addOrder(AccordoServizioParteSpecifica.model().VERSIONE, SortOrder.ASC);
        pag.addOrder(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, SortOrder.ASC);
        pag.addOrder(AccordoServizioParteSpecifica.model().TIPO, SortOrder.ASC);
        pag.addOrder(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, SortOrder.ASC);
        List result = null;
        try {
            result = aspsServiceSearch.select(pag, true, new IField[]{AccordoServizioParteSpecifica.model().TIPO, AccordoServizioParteSpecifica.model().NOME, AccordoServizioParteSpecifica.model().VERSIONE, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result != null && result.size() > 0) {
            for (Map map : result) {
                String tipo = (String)map.get(AccordoServizioParteSpecifica.model().TIPO.getFieldName());
                String nome = (String)map.get(AccordoServizioParteSpecifica.model().NOME.getFieldName());
                Integer versione = (Integer)map.get(AccordoServizioParteSpecifica.model().VERSIONE.getFieldName());
                String tipoSoggetto = (String)map.get(AccordoServizioParteSpecifica.model().ID_EROGATORE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO.getFieldName());
                String nomeSoggetto = (String)map.get(AccordoServizioParteSpecifica.model().ID_EROGATORE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME.getFieldName());
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipo, nome, tipoSoggetto, nomeSoggetto, versione);
                list.add(idServizio);
            }
        }
        return list;
    }

    public static List<String> getAzioni(JDBCServiceManager manager, String protocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getAzioni(manager, protocolli, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio);
    }

    public static List<String> getAzioni(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(RegistroCore.getEngineAzioni(manager, protocolli, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, null).keySet());
        if (list != null && !list.isEmpty()) {
            Collections.sort(list);
        }
        return list;
    }

    public static Map<String, String> getAzioniConLabel(JDBCServiceManager manager, String protocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String input) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        Map<String, String> mapAzioni = RegistroCore.getEngineAzioni(manager, protocolli, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, input);
        LinkedList<Map.Entry<String, String>> list = new LinkedList<Map.Entry<String, String>>(mapAzioni.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return sortedMap;
    }

    public static Map<String, String> getEngineAzioni(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String input) throws Exception {
        ArrayList<IdPortType> idPortTypes = new ArrayList<IdPortType>();
        IAccordoServizioParteSpecificaServiceSearch aspsServiceSearch = manager.getAccordoServizioParteSpecificaServiceSearch();
        IPaginatedExpression pag = aspsServiceSearch.newPaginatedExpression();
        pag.and();
        if (protocolli != null && !protocolli.isEmpty()) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getServiceTypes(protocollo));
            }
            pag.in(AccordoServizioParteSpecifica.model().TIPO, types);
        }
        if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
            pag.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)tipoSoggettoErogatore);
            pag.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)nomeSoggettoErogatore);
        }
        if (tipoServizio != null && nomeServizio != null && versioneServizio != null) {
            pag.equals(AccordoServizioParteSpecifica.model().TIPO, (Object)tipoServizio);
            pag.equals(AccordoServizioParteSpecifica.model().NOME, (Object)nomeServizio);
            pag.equals(AccordoServizioParteSpecifica.model().VERSIONE, (Object)versioneServizio);
        }
        List result = null;
        try {
            result = aspsServiceSearch.select(pag, true, new IField[]{AccordoServizioParteSpecifica.model().PORT_TYPE, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.SERVICE_BINDING});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result != null && !result.isEmpty()) {
            for (Map map : result) {
                IdPortType idPortType = new IdPortType();
                Object portType = map.get(AccordoServizioParteSpecifica.model().PORT_TYPE.getFieldName());
                if (portType != null && portType instanceof String) {
                    idPortType.setNome((String)portType);
                }
                String nomeAccordo = (String)map.get(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME.getFieldName());
                Object tipoSoggettoReferenteAccordo = map.get(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO.getFieldName());
                Object nomeSoggettoReferenteAccordo = map.get(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME.getFieldName());
                Object versioneAccordo = map.get(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE.getFieldName());
                IdSoggetto idSoggettoReferente = null;
                if (tipoSoggettoReferenteAccordo != null && tipoSoggettoReferenteAccordo instanceof String && nomeSoggettoReferenteAccordo != null && nomeSoggettoReferenteAccordo instanceof String) {
                    idSoggettoReferente = new IdSoggetto();
                    idSoggettoReferente.setTipo((String)tipoSoggettoReferenteAccordo);
                    idSoggettoReferente.setNome((String)nomeSoggettoReferenteAccordo);
                }
                Integer versione = null;
                if (versioneAccordo != null && versioneAccordo instanceof Integer) {
                    versione = (Integer)versioneAccordo;
                }
                String serviceBindingAccordo = (String)map.get(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.getBaseField().getFieldName() + "." + AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.SERVICE_BINDING.getFieldName());
                IdAccordoServizioParteComune idAccordo = new IdAccordoServizioParteComune();
                idAccordo.setNome(nomeAccordo);
                idAccordo.setVersione(versione);
                idAccordo.setIdSoggetto(idSoggettoReferente);
                idAccordo.setServiceBinding(serviceBindingAccordo);
                idPortType.setIdAccordoServizioParteComune(idAccordo);
                idPortTypes.add(idPortType);
            }
        }
        return RegistroCore.getEngineAzioni(manager, input, idPortTypes);
    }

    private static Map<String, String> getEngineAzioni(JDBCServiceManager manager, String input, List<IdPortType> idPortTypes) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Object> mapAzioni = new HashMap<String, Object>();
        if (idPortTypes != null && !idPortTypes.isEmpty()) {
            for (IdPortType idPortType : idPortTypes) {
                IPaginatedExpression pagAzioni;
                String az;
                List resultAzioni;
                ServiceBinding serviceBinding = ServiceBinding.valueOf((String)idPortType.getIdAccordoServizioParteComune().getServiceBinding().toUpperCase());
                if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                    IResourceServiceSearch aspcResourceServiceSearch = manager.getResourceServiceSearch();
                    IPaginatedExpression pagResources = aspcResourceServiceSearch.newPaginatedExpression();
                    pagResources.and();
                    pagResources.equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idPortType.getIdAccordoServizioParteComune().getNome());
                    if (idPortType.getIdAccordoServizioParteComune().getVersione() != null) {
                        pagResources.equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idPortType.getIdAccordoServizioParteComune().getVersione());
                    }
                    if (idPortType.getIdAccordoServizioParteComune().getIdSoggetto() != null) {
                        pagResources.equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idPortType.getIdAccordoServizioParteComune().getIdSoggetto().getTipo());
                        pagResources.equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idPortType.getIdAccordoServizioParteComune().getIdSoggetto().getNome());
                    }
                    if (StringUtils.isNotEmpty((String)input)) {
                        IExpression exprOrMethod = aspcResourceServiceSearch.newExpression();
                        exprOrMethod.ilike(Resource.model().HTTP_METHOD, input, LikeMode.ANYWHERE);
                        IExpression exprOrPath = aspcResourceServiceSearch.newExpression();
                        exprOrPath.ilike(Resource.model().PATH, input, LikeMode.ANYWHERE);
                        pagResources.or(exprOrMethod, exprOrPath);
                    }
                    resultAzioni = null;
                    try {
                        resultAzioni = aspcResourceServiceSearch.select(pagResources, true, new IField[]{Resource.model().NOME, Resource.model().HTTP_METHOD, Resource.model().PATH});
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                    if (resultAzioni == null || resultAzioni.isEmpty()) continue;
                    for (Map azione : resultAzioni) {
                        az = (String)azione.get(Resource.model().NOME.getFieldName());
                        String httpmethod = (String)azione.get(Resource.model().HTTP_METHOD.getFieldName());
                        String path = (String)azione.get(Resource.model().PATH.getFieldName());
                        String label = httpmethod + " " + path;
                        if (list.contains(az)) continue;
                        list.add(az);
                        mapAzioni.put(az, label);
                    }
                    continue;
                }
                if (idPortType.getNome() != null) {
                    IOperationServiceSearch portTypeAzioneServiceSearch = manager.getOperationServiceSearch();
                    pagAzioni = portTypeAzioneServiceSearch.newPaginatedExpression();
                    pagAzioni.and();
                    pagAzioni.equals(Operation.model().ID_PORT_TYPE.NOME, (Object)idPortType.getNome());
                    pagAzioni.equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idPortType.getIdAccordoServizioParteComune().getNome());
                    if (idPortType.getIdAccordoServizioParteComune().getVersione() != null) {
                        pagAzioni.equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idPortType.getIdAccordoServizioParteComune().getVersione());
                    }
                    if (idPortType.getIdAccordoServizioParteComune().getIdSoggetto() != null) {
                        pagAzioni.equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idPortType.getIdAccordoServizioParteComune().getIdSoggetto().getTipo());
                        pagAzioni.equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idPortType.getIdAccordoServizioParteComune().getIdSoggetto().getNome());
                    }
                    if (StringUtils.isNotEmpty((String)input)) {
                        pagAzioni.ilike(Operation.model().NOME, input, LikeMode.ANYWHERE);
                    }
                    resultAzioni = null;
                    try {
                        resultAzioni = portTypeAzioneServiceSearch.select(pagAzioni, true, Operation.model().NOME);
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                    if (resultAzioni == null || resultAzioni.isEmpty()) continue;
                    for (Map azione : resultAzioni) {
                        az = (String)((Object)azione);
                        if (list.contains(az)) continue;
                        list.add(az);
                        mapAzioni.put(az, az);
                    }
                    continue;
                }
                IAccordoServizioParteComuneAzioneServiceSearch aspcAzioneServiceSearch = manager.getAccordoServizioParteComuneAzioneServiceSearch();
                pagAzioni = aspcAzioneServiceSearch.newPaginatedExpression();
                pagAzioni.and();
                pagAzioni.equals(AccordoServizioParteComuneAzione.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idPortType.getIdAccordoServizioParteComune().getNome());
                if (idPortType.getIdAccordoServizioParteComune().getVersione() != null) {
                    pagAzioni.equals(AccordoServizioParteComuneAzione.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idPortType.getIdAccordoServizioParteComune().getVersione());
                }
                if (idPortType.getIdAccordoServizioParteComune().getIdSoggetto() != null) {
                    pagAzioni.equals(AccordoServizioParteComuneAzione.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idPortType.getIdAccordoServizioParteComune().getIdSoggetto().getTipo());
                    pagAzioni.equals(AccordoServizioParteComuneAzione.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idPortType.getIdAccordoServizioParteComune().getIdSoggetto().getNome());
                }
                if (StringUtils.isNotEmpty((String)input)) {
                    pagAzioni.ilike(AccordoServizioParteComuneAzione.model().NOME, input, LikeMode.ANYWHERE);
                }
                resultAzioni = null;
                try {
                    resultAzioni = aspcAzioneServiceSearch.select(pagAzioni, true, AccordoServizioParteComuneAzione.model().NOME);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                if (resultAzioni == null || resultAzioni.isEmpty()) continue;
                for (Map azione : resultAzioni) {
                    az = (String)((Object)azione);
                    if (list.contains(az)) continue;
                    list.add(az);
                    mapAzioni.put(az, az);
                }
            }
        }
        HashMap<String, String> mapAzioniReturn = new HashMap<String, String>();
        if (list != null && !list.isEmpty()) {
            Collections.sort(list);
            for (String key : list) {
                mapAzioniReturn.put(key, (String)mapAzioni.get(key));
            }
        }
        return mapAzioniReturn;
    }

    public static Map<String, String> getAzioniFromAPIConLabel(JDBCServiceManager manager, String protocollo, String nomeAccordo, String tipoReferente, String nomeReferente, Integer versioneAccordo, String input) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        ArrayList<IdPortType> idPortTypes = new ArrayList<IdPortType>();
        IAccordoServizioParteComuneServiceSearch accordoServizioParteComuneServiceSearch = manager.getAccordoServizioParteComuneServiceSearch();
        IPaginatedExpression pagExpr = accordoServizioParteComuneServiceSearch.newPaginatedExpression();
        pagExpr.and();
        pagExpr.equals(AccordoServizioParteComune.model().ID_REFERENTE.TIPO, (Object)tipoReferente).and().equals(AccordoServizioParteComune.model().ID_REFERENTE.NOME, (Object)nomeReferente);
        pagExpr.equals(AccordoServizioParteComune.model().VERSIONE, (Object)versioneAccordo).and().equals(AccordoServizioParteComune.model().NOME, (Object)nomeAccordo);
        pagExpr.sortOrder(SortOrder.ASC);
        pagExpr.addOrder(AccordoServizioParteComune.model().ID_REFERENTE.TIPO);
        pagExpr.addOrder(AccordoServizioParteComune.model().ID_REFERENTE.NOME);
        pagExpr.addOrder(AccordoServizioParteComune.model().NOME);
        pagExpr.addOrder(AccordoServizioParteComune.model().VERSIONE);
        List listAccordi = accordoServizioParteComuneServiceSearch.findAll(pagExpr);
        for (AccordoServizioParteComune accordoServizioParteComune : listAccordi) {
            IdSoggetto idSoggettoReferente = new IdSoggetto();
            idSoggettoReferente.setTipo(accordoServizioParteComune.getIdReferente().getTipo());
            idSoggettoReferente.setNome(accordoServizioParteComune.getIdReferente().getNome());
            String serviceBindingAccordo = accordoServizioParteComune.getServiceBinding();
            IdAccordoServizioParteComune idAccordoServizioParteComune = new IdAccordoServizioParteComune();
            idAccordoServizioParteComune.setNome(accordoServizioParteComune.getNome());
            idAccordoServizioParteComune.setVersione(accordoServizioParteComune.getVersione());
            idAccordoServizioParteComune.setIdSoggetto(idSoggettoReferente);
            idAccordoServizioParteComune.setServiceBinding(serviceBindingAccordo);
            List<PortType> portTypes = accordoServizioParteComune.getPortType();
            if (portTypes != null && !portTypes.isEmpty()) {
                for (PortType portType : portTypes) {
                    IdPortType idPortType = new IdPortType();
                    idPortType.setNome(portType.getNome());
                    idPortType.setIdAccordoServizioParteComune(idAccordoServizioParteComune);
                    idPortTypes.add(idPortType);
                }
                continue;
            }
            IdPortType idPortType = new IdPortType();
            idPortType.setIdAccordoServizioParteComune(idAccordoServizioParteComune);
            idPortTypes.add(idPortType);
        }
        Map<String, String> mapAzioni = RegistroCore.getEngineAzioni(manager, input, idPortTypes);
        LinkedList<Map.Entry<String, String>> list = new LinkedList<Map.Entry<String, String>>(mapAzioni.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return sortedMap;
    }

    public static List<IDServizioApplicativo> getServiziApplicativiErogatori(JDBCServiceManager manager, String protocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String azione) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getServiziApplicativiErogatori(manager, protocolli, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, azione);
    }

    public static List<IDServizioApplicativo> getServiziApplicativiErogatori(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String azione) throws Exception {
        ArrayList<IDServizioApplicativo> list = new ArrayList<IDServizioApplicativo>();
        IPortaApplicativaServiceSearch paServiceSearch = manager.getPortaApplicativaServiceSearch();
        IPaginatedExpression pag = paServiceSearch.newPaginatedExpression();
        pag.and();
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getOrganizationTypes(protocollo));
            }
            pag.in(PortaApplicativa.model().ID_SOGGETTO.TIPO, types);
        }
        if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
            pag.equals(PortaApplicativa.model().ID_SOGGETTO.TIPO, (Object)tipoSoggettoErogatore);
            pag.equals(PortaApplicativa.model().ID_SOGGETTO.NOME, (Object)nomeSoggettoErogatore);
        }
        if (tipoServizio != null && nomeServizio != null && versioneServizio != null) {
            pag.equals(PortaApplicativa.model().TIPO_SERVIZIO, (Object)tipoServizio);
            pag.equals(PortaApplicativa.model().NOME_SERVIZIO, (Object)nomeServizio);
            pag.equals(PortaApplicativa.model().VERSIONE_SERVIZIO, (Object)versioneServizio);
        }
        if (azione != null) {
            IExpression azioneExpr = paServiceSearch.newExpression();
            azioneExpr.or();
            azioneExpr.equals(PortaApplicativa.model().NOME_AZIONE, (Object)azione);
            azioneExpr.isNull(PortaApplicativa.model().NOME_AZIONE);
            azioneExpr.isEmpty(PortaApplicativa.model().NOME_AZIONE);
            azioneExpr.equals(PortaApplicativa.model().PORTA_APPLICATIVA_AZIONE.NOME, (Object)azione);
            pag.and(new IExpression[]{azioneExpr});
        }
        pag.addOrder(PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.NOME, SortOrder.ASC);
        pag.addOrder(PortaApplicativa.model().ID_SOGGETTO.NOME, SortOrder.ASC);
        pag.addOrder(PortaApplicativa.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
        List result = null;
        try {
            result = paServiceSearch.select(pag, true, new IField[]{PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.NOME, PortaApplicativa.model().ID_SOGGETTO.TIPO, PortaApplicativa.model().ID_SOGGETTO.NOME});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result != null && result.size() > 0) {
            for (Map map : result) {
                String nomeSA = (String)map.get(PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.getBaseField().getFieldName() + "." + PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.getBaseField().getFieldName() + "." + PortaApplicativa.model().PORTA_APPLICATIVA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.NOME.getFieldName());
                String tipoSoggetto = (String)map.get(PortaApplicativa.model().ID_SOGGETTO.getBaseField().getFieldName() + "." + PortaApplicativa.model().ID_SOGGETTO.TIPO.getFieldName());
                String nomeSoggetto = (String)map.get(PortaApplicativa.model().ID_SOGGETTO.getBaseField().getFieldName() + "." + PortaApplicativa.model().ID_SOGGETTO.NOME.getFieldName());
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
                idSA.setIdSoggettoProprietario(idSoggetto);
                idSA.setNome(nomeSA);
                list.add(idSA);
            }
        }
        return list;
    }

    public static List<IDServizioApplicativo> getServiziApplicativiFruitore(JDBCServiceManager manager, String protocollo, String tipoSoggettoFruitore, String nomeSoggettoFruitore, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String azione) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getServiziApplicativiFruitore(manager, protocolli, tipoSoggettoFruitore, nomeSoggettoFruitore, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, azione);
    }

    public static List<IDServizioApplicativo> getServiziApplicativiFruitore(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoFruitore, String nomeSoggettoFruitore, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String azione) throws Exception {
        ArrayList<IDServizioApplicativo> list = new ArrayList<IDServizioApplicativo>();
        IPortaDelegataServiceSearch pdServiceSearch = manager.getPortaDelegataServiceSearch();
        IPaginatedExpression pag = pdServiceSearch.newPaginatedExpression();
        pag.and();
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getOrganizationTypes(protocollo));
            }
            pag.in(PortaDelegata.model().ID_SOGGETTO.TIPO, types);
        }
        if (tipoSoggettoFruitore != null && nomeSoggettoFruitore != null) {
            pag.equals(PortaDelegata.model().ID_SOGGETTO.TIPO, (Object)tipoSoggettoFruitore);
            pag.equals(PortaDelegata.model().ID_SOGGETTO.NOME, (Object)nomeSoggettoFruitore);
        }
        if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
            pag.equals(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, (Object)tipoSoggettoErogatore);
            pag.equals(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, (Object)nomeSoggettoErogatore);
        }
        if (tipoServizio != null && nomeServizio != null && versioneServizio != null) {
            pag.equals(PortaDelegata.model().TIPO_SERVIZIO, (Object)tipoServizio);
            pag.equals(PortaDelegata.model().NOME_SERVIZIO, (Object)nomeServizio);
            pag.equals(PortaDelegata.model().VERSIONE_SERVIZIO, (Object)versioneServizio);
        }
        if (azione != null) {
            IExpression azioneExpr = pdServiceSearch.newExpression();
            azioneExpr.or();
            azioneExpr.equals(PortaDelegata.model().NOME_AZIONE, (Object)azione);
            azioneExpr.isNull(PortaDelegata.model().NOME_AZIONE);
            azioneExpr.isEmpty(PortaDelegata.model().NOME_AZIONE);
            azioneExpr.equals(PortaDelegata.model().PORTA_DELEGATA_AZIONE.NOME, (Object)azione);
            pag.and(new IExpression[]{azioneExpr});
        }
        pag.addOrder(PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.NOME, SortOrder.ASC);
        pag.addOrder(PortaDelegata.model().ID_SOGGETTO.NOME, SortOrder.ASC);
        pag.addOrder(PortaDelegata.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
        List result = null;
        try {
            result = pdServiceSearch.select(pag, true, new IField[]{PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.NOME, PortaDelegata.model().ID_SOGGETTO.TIPO, PortaDelegata.model().ID_SOGGETTO.NOME});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result != null && result.size() > 0) {
            for (Map map : result) {
                String nomeSA = (String)map.get(PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.getBaseField().getFieldName() + "." + PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.getBaseField().getFieldName() + "." + PortaDelegata.model().PORTA_DELEGATA_SERVIZIO_APPLICATIVO.ID_SERVIZIO_APPLICATIVO.NOME.getFieldName());
                String tipoSoggetto = (String)map.get(PortaDelegata.model().ID_SOGGETTO.getBaseField().getFieldName() + "." + PortaDelegata.model().ID_SOGGETTO.TIPO.getFieldName());
                String nomeSoggetto = (String)map.get(PortaDelegata.model().ID_SOGGETTO.getBaseField().getFieldName() + "." + PortaDelegata.model().ID_SOGGETTO.NOME.getFieldName());
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
                idSA.setIdSoggettoProprietario(idSoggetto);
                idSA.setNome(nomeSA);
                list.add(idSA);
            }
        }
        return list;
    }

    public static List<IDServizioApplicativo> getServiziApplicativiFruitore(JDBCServiceManager manager, String protocollo, String tipoSoggettoFruitore, String nomeSoggettoFruitore) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getServiziApplicativiFruitore(manager, protocolli, tipoSoggettoFruitore, nomeSoggettoFruitore);
    }

    public static List<IDServizioApplicativo> getServiziApplicativiFruitore(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoFruitore, String nomeSoggettoFruitore) throws Exception {
        return RegistroCore.getEngineServiziApplicativi(manager, protocolli, tipoSoggettoFruitore, nomeSoggettoFruitore, true);
    }

    public static List<IDServizioApplicativo> getServiziApplicativi(JDBCServiceManager manager, String protocollo, String tipoSoggettoProprietario, String nomeSoggettoProprietario) throws Exception {
        ArrayList<String> protocolli = null;
        if (protocollo != null) {
            protocolli = new ArrayList<String>();
            protocolli.add(protocollo);
        }
        return RegistroCore.getServiziApplicativi(manager, protocolli, tipoSoggettoProprietario, nomeSoggettoProprietario);
    }

    public static List<IDServizioApplicativo> getServiziApplicativi(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoProprietario, String nomeSoggettoProprietario) throws Exception {
        return RegistroCore.getEngineServiziApplicativi(manager, protocolli, tipoSoggettoProprietario, nomeSoggettoProprietario, false);
    }

    private static List<IDServizioApplicativo> getEngineServiziApplicativi(JDBCServiceManager manager, List<String> protocolli, String tipoSoggettoProprietario, String nomeSoggettoProprietario, boolean onlyClient) throws Exception {
        IExpression exprOr;
        ArrayList<IDServizioApplicativo> list = new ArrayList<IDServizioApplicativo>();
        IServizioApplicativoServiceSearch saServiceSearch = manager.getServizioApplicativoServiceSearch();
        IPaginatedExpression pag = saServiceSearch.newPaginatedExpression();
        pag.and();
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getOrganizationTypes(protocollo));
            }
            pag.in(ServizioApplicativo.model().ID_SOGGETTO.TIPO, types);
        }
        if (tipoSoggettoProprietario != null && nomeSoggettoProprietario != null) {
            pag.equals(ServizioApplicativo.model().ID_SOGGETTO.TIPO, (Object)tipoSoggettoProprietario);
            pag.equals(ServizioApplicativo.model().ID_SOGGETTO.NOME, (Object)nomeSoggettoProprietario);
        }
        if (onlyClient) {
            exprOr = saServiceSearch.newExpression();
            exprOr.equals(ServizioApplicativo.model().TIPO, (Object)"client");
            exprOr.or();
            exprOr.equals(ServizioApplicativo.model().AS_CLIENT, (Object)1);
            pag.and(new IExpression[]{exprOr});
        } else {
            exprOr = saServiceSearch.newExpression();
            exprOr.equals(ServizioApplicativo.model().TIPO, (Object)"client");
            exprOr.or();
            exprOr.equals(ServizioApplicativo.model().TIPO, (Object)"server");
            pag.and(new IExpression[]{exprOr});
        }
        pag.addOrder(ServizioApplicativo.model().NOME, SortOrder.ASC);
        pag.addOrder(ServizioApplicativo.model().ID_SOGGETTO.NOME, SortOrder.ASC);
        pag.addOrder(ServizioApplicativo.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
        List result = null;
        try {
            result = saServiceSearch.select(pag, true, new IField[]{ServizioApplicativo.model().NOME, ServizioApplicativo.model().ID_SOGGETTO.TIPO, ServizioApplicativo.model().ID_SOGGETTO.NOME});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (result != null && result.size() > 0) {
            for (Map map : result) {
                String nomeSA = (String)map.get(ServizioApplicativo.model().NOME.getFieldName());
                String tipoSoggetto = (String)map.get(ServizioApplicativo.model().ID_SOGGETTO.getBaseField().getFieldName() + "." + PortaDelegata.model().ID_SOGGETTO.TIPO.getFieldName());
                String nomeSoggetto = (String)map.get(ServizioApplicativo.model().ID_SOGGETTO.getBaseField().getFieldName() + "." + PortaDelegata.model().ID_SOGGETTO.NOME.getFieldName());
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
                idSA.setIdSoggettoProprietario(idSoggetto);
                idSA.setNome(nomeSA);
                list.add(idSA);
            }
        }
        return list;
    }

    public static AccordoServizioParteComune getAPIImplemented(JDBCServiceManager manager, IDSoggetto idSoggetto, String tipoServizio, String nomeServizio, Integer versioneServizio) throws Exception {
        IAccordoServizioParteComuneServiceSearch aspcDAO = manager.getAccordoServizioParteComuneServiceSearch();
        IAccordoServizioParteSpecificaServiceSearch aspsDAO = manager.getAccordoServizioParteSpecificaServiceSearch();
        IExpression expr = aspsDAO.newExpression();
        expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)idSoggetto.getTipo());
        expr.and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)idSoggetto.getNome());
        expr.equals(AccordoServizioParteSpecifica.model().TIPO, (Object)tipoServizio);
        expr.and();
        expr.equals(AccordoServizioParteSpecifica.model().NOME, (Object)nomeServizio);
        expr.and();
        expr.equals(AccordoServizioParteSpecifica.model().VERSIONE, (Object)versioneServizio);
        IPaginatedExpression pagExpr = aspsDAO.toPaginatedExpression(expr);
        CustomField cf = new CustomField("idAccordo", Long.class, "id_accordo", "servizi");
        List list = aspsDAO.select(pagExpr, true, (IField)cf);
        if (list == null || list.isEmpty()) {
            throw new NotFoundException("NonPresente");
        }
        if (list.size() > 1) {
            throw new MultipleResultException("Trovati '" + list.size() + "' api ?");
        }
        Long idAccordoLong = (Long)list.get(0);
        return ((JDBCAccordoServizioParteComuneServiceSearch)aspcDAO).get(idAccordoLong);
    }

    public static List<IDServizio> getErogazioni(JDBCServiceManager manager, List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto) throws Exception {
        return RegistroCore.getErogazioni(manager, protocolli, gruppo, tipoSoggetto, nomeSoggetto, null, null, null, null);
    }

    public static List<IDServizio> getErogazioni(JDBCServiceManager manager, List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione) throws Exception {
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        IPortaApplicativaServiceSearch portaApplicativaDAO = manager.getPortaApplicativaServiceSearch();
        IAccordoServizioParteComuneGruppoServiceSearch aspcGruppiDAO = null;
        if (gruppo != null && !"".equals(gruppo)) {
            aspcGruppiDAO = manager.getAccordoServizioParteComuneGruppoServiceSearch();
        }
        IExpression pAExpr = RegistroCore.getExpressionPA(portaApplicativaDAO, protocolli, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, versioneServizio, nomeAzione);
        List listaPorte = new ArrayList();
        IPaginatedExpression pagPaExpr = portaApplicativaDAO.toPaginatedExpression(pAExpr);
        pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
        pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.NOME, SortOrder.ASC);
        pagPaExpr.addOrder(PortaApplicativa.model().TIPO_SERVIZIO, SortOrder.ASC);
        pagPaExpr.addOrder(PortaApplicativa.model().NOME_SERVIZIO, SortOrder.ASC);
        pagPaExpr.addOrder(PortaApplicativa.model().VERSIONE_SERVIZIO, SortOrder.ASC);
        ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPaExpr);
        listaPorte = portaApplicativaDAO.findAll(pagPaExpr);
        ArrayList<String> lstTmp = new ArrayList<String>();
        for (PortaApplicativa portaApplicativa : listaPorte) {
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome(), portaApplicativa.getVersioneServizio());
            String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
            if (gruppo != null && !"".equals(gruppo)) {
                AccordoServizioParteComune aspc = RegistroCore.getAPIImplemented(manager, idServizio.getSoggettoErogatore(), idServizio.getTipo(), idServizio.getNome(), idServizio.getVersione());
                IPaginatedExpression gruppiExpr = aspcGruppiDAO.newPaginatedExpression();
                gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)aspc.getNome());
                gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)aspc.getVersione());
                gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)aspc.getIdReferente().getNome());
                gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)aspc.getIdReferente().getTipo());
                List lGruppi = aspcGruppiDAO.findAllIds(gruppiExpr);
                boolean found = false;
                if (lGruppi != null && !lGruppi.isEmpty()) {
                    for (IdAccordoServizioParteComuneGruppo gruppoCheck : lGruppi) {
                        if (!gruppoCheck.getIdGruppo().getNome().equals(gruppo)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
            }
            if (lstTmp.contains(uriFromIDServizio)) continue;
            lstTmp.add(uriFromIDServizio);
            lista.add(idServizio);
        }
        return lista;
    }

    private static IExpression getExpressionPA(IPortaApplicativaServiceSearch portaApplicativaDAO, List<String> protocolli, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione) throws Exception {
        IExpression paExpr = portaApplicativaDAO.newExpression();
        if (StringUtils.isNotEmpty((String)tipoSoggetto)) {
            paExpr.equals(PortaApplicativa.model().ID_SOGGETTO.TIPO, (Object)tipoSoggetto);
        }
        if (StringUtils.isNotEmpty((String)nomeSoggetto)) {
            paExpr.and().equals(PortaApplicativa.model().ID_SOGGETTO.NOME, (Object)nomeSoggetto);
        }
        if (StringUtils.isNotEmpty((String)nomeServizio)) {
            paExpr.equals(PortaApplicativa.model().NOME_SERVIZIO, (Object)nomeServizio).and();
        }
        if (StringUtils.isNotEmpty((String)tipoServizio)) {
            paExpr.equals(PortaApplicativa.model().TIPO_SERVIZIO, (Object)tipoServizio).and();
        }
        if (versioneServizio != null) {
            paExpr.equals(PortaApplicativa.model().VERSIONE_SERVIZIO, (Object)versioneServizio).and();
        }
        if (StringUtils.isNotEmpty((String)nomeAzione)) {
            IExpression azioneExpr = portaApplicativaDAO.newExpression();
            azioneExpr.equals(PortaApplicativa.model().NOME_AZIONE, (Object)nomeAzione).or().isNull(PortaApplicativa.model().NOME_AZIONE);
            paExpr.and(new IExpression[]{azioneExpr});
        }
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getOrganizationTypes(protocollo));
            }
            paExpr.in(PortaApplicativa.model().ID_SOGGETTO.TIPO, types);
        }
        paExpr.notEquals(PortaApplicativa.model().MODE_AZIONE, (Object)PortaApplicativaAzioneIdentificazione.DELEGATED_BY);
        return paExpr;
    }

    public static List<IDFruizione> getFruizioni(JDBCServiceManager manager, List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto) throws Exception {
        return RegistroCore.getFruizioni(manager, protocolli, gruppo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null);
    }

    public static List<IDFruizione> getFruizioni(JDBCServiceManager manager, List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione) throws Exception {
        ArrayList<IDFruizione> lista = new ArrayList<IDFruizione>();
        IPortaDelegataServiceSearch portaDelegataDAO = manager.getPortaDelegataServiceSearch();
        IAccordoServizioParteComuneGruppoServiceSearch aspcGruppiDAO = null;
        if (gruppo != null && !"".equals(gruppo)) {
            aspcGruppiDAO = manager.getAccordoServizioParteComuneGruppoServiceSearch();
        }
        IExpression pdExpr = RegistroCore.getExpressionPD(portaDelegataDAO, protocolli, tipoSoggetto, nomeSoggetto, tipoErogatore, nomeErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione);
        List listaPorte = new ArrayList();
        IPaginatedExpression pagPdExpr = portaDelegataDAO.toPaginatedExpression(pdExpr);
        pagPdExpr.addOrder(PortaDelegata.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
        pagPdExpr.addOrder(PortaDelegata.model().ID_SOGGETTO.NOME, SortOrder.ASC);
        pagPdExpr.addOrder(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, SortOrder.ASC);
        pagPdExpr.addOrder(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, SortOrder.ASC);
        pagPdExpr.addOrder(PortaDelegata.model().TIPO_SERVIZIO, SortOrder.ASC);
        pagPdExpr.addOrder(PortaDelegata.model().NOME_SERVIZIO, SortOrder.ASC);
        pagPdExpr.addOrder(PortaDelegata.model().VERSIONE_SERVIZIO, SortOrder.ASC);
        ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPdExpr);
        listaPorte = portaDelegataDAO.findAll(pagPdExpr);
        ArrayList<CallSite> lstTmp = new ArrayList<CallSite>();
        for (PortaDelegata portaDelegata : listaPorte) {
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaDelegata.getTipoServizio(), portaDelegata.getNomeServizio(), portaDelegata.getTipoSoggettoErogatore(), portaDelegata.getNomeSoggettoErogatore(), portaDelegata.getVersioneServizio());
            IDSoggetto idFruitore = new IDSoggetto(portaDelegata.getIdSoggetto().getTipo(), portaDelegata.getIdSoggetto().getNome());
            IDFruizione idFruizione = new IDFruizione();
            idFruizione.setIdServizio(idServizio);
            idFruizione.setIdFruitore(idFruitore);
            String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
            String uriFruizione = idFruitore.toString() + "_" + uriFromIDServizio;
            if (gruppo != null && !"".equals(gruppo)) {
                AccordoServizioParteComune aspc = RegistroCore.getAPIImplemented(manager, idServizio.getSoggettoErogatore(), idServizio.getTipo(), idServizio.getNome(), idServizio.getVersione());
                IPaginatedExpression gruppiExpr = aspcGruppiDAO.newPaginatedExpression();
                gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)aspc.getNome());
                gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)aspc.getVersione());
                gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)aspc.getIdReferente().getNome());
                gruppiExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)aspc.getIdReferente().getTipo());
                List lGruppi = aspcGruppiDAO.findAllIds(gruppiExpr);
                boolean found = false;
                if (lGruppi != null && !lGruppi.isEmpty()) {
                    for (IdAccordoServizioParteComuneGruppo gruppoCheck : lGruppi) {
                        if (!gruppoCheck.getIdGruppo().getNome().equals(gruppo)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
            }
            if (lstTmp.contains(uriFruizione)) continue;
            lstTmp.add((CallSite)((Object)uriFruizione));
            lista.add(idFruizione);
        }
        return lista;
    }

    private static IExpression getExpressionPD(IPortaDelegataServiceSearch portaDelegataDAO, List<String> protocolli, String tipoSoggetto, String nomeSoggetto, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione) throws Exception {
        IExpression pdExpr = portaDelegataDAO.newExpression();
        if (StringUtils.isNotEmpty((String)tipoSoggetto)) {
            pdExpr.equals(PortaDelegata.model().ID_SOGGETTO.TIPO, (Object)tipoSoggetto);
        }
        if (StringUtils.isNotEmpty((String)nomeSoggetto)) {
            pdExpr.and().equals(PortaDelegata.model().ID_SOGGETTO.NOME, (Object)nomeSoggetto);
        }
        if (StringUtils.isNotEmpty((String)nomeErogatore)) {
            pdExpr.equals(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, (Object)nomeErogatore).and();
        }
        if (StringUtils.isNotEmpty((String)tipoErogatore)) {
            pdExpr.equals(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, (Object)tipoErogatore).and();
        }
        if (StringUtils.isNotEmpty((String)tipoServizio)) {
            pdExpr.equals(PortaDelegata.model().TIPO_SERVIZIO, (Object)tipoServizio);
        }
        if (StringUtils.isNotEmpty((String)nomeServizio)) {
            pdExpr.and().equals(PortaDelegata.model().NOME_SERVIZIO, (Object)nomeServizio);
        }
        if (versioneServizio != null) {
            pdExpr.equals(PortaDelegata.model().VERSIONE_SERVIZIO, (Object)versioneServizio).and();
        }
        if (StringUtils.isNotEmpty((String)nomeAzione)) {
            IExpression azioneExpr = portaDelegataDAO.newExpression();
            azioneExpr.equals(PortaDelegata.model().NOME_AZIONE, (Object)nomeAzione).or().isNull(PortaDelegata.model().NOME_AZIONE);
            pdExpr.and(new IExpression[]{azioneExpr});
        }
        if (protocolli != null && protocolli.size() > 0) {
            ArrayList<String> types = new ArrayList<String>();
            for (String protocollo : protocolli) {
                types.addAll(ProtocolFactoryReflectionUtils.getOrganizationTypes(protocollo));
            }
            pdExpr.in(PortaDelegata.model().ID_SOGGETTO.TIPO, types);
        }
        pdExpr.notEquals(PortaDelegata.model().MODE_AZIONE, (Object)PortaDelegataAzioneIdentificazione.DELEGATED_BY);
        return pdExpr;
    }
}

