/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.config.driver.IDServizioUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBSoggettiLib;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDBSoggetti {
    private DriverConfigurazioneDB driver = null;
    private static final String ESEGUO_QUERY_PREFIX = "eseguo query : ";
    private static final String OPERAZIONE_ATOMICA_PREFIX = "operazione this.driver.atomica = ";

    protected DriverConfigurazioneDBSoggetti(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    protected IDSoggetto getIdSoggetto(long idSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getIdSoggetto(idSoggetto, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IDSoggetto getIdSoggetto(long idSoggetto, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDSoggetto iDSoggetto;
        if (idSoggetto <= 0L) {
            return null;
        }
        IDSoggetto idSoggettoObject = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getIdSoggetto(longId)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("DriverConfigurazioneDB::getIdSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.driver.logDebug(ESEGUO_QUERY_PREFIX + DriverConfigurazioneDBLib.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("Nessun risultato trovat eseguendo: " + DriverConfigurazioneDBLib.formatSQLString(sqlQuery, idSoggetto));
            }
            idSoggettoObject = new IDSoggetto();
            idSoggettoObject.setNome(rs.getString("nome_soggetto"));
            idSoggettoObject.setTipo(rs.getString("tipo_soggetto"));
            iDSoggetto = idSoggettoObject;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getIdSoggetto] SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound se2) {
                    throw se2;
                }
                catch (Exception se3) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getIdSoggetto] Exception: " + se3.getMessage(), se3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return iDSoggetto;
    }

    protected Soggetto getSoggetto(IDSoggetto aSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSoggetto == null || aSoggetto.getNome() == null || aSoggetto.getTipo() == null) {
            throw new DriverConfigurazioneException("[getSoggetto] Parametri Non Validi");
        }
        Soggetto soggetto = null;
        Connection con = null;
        String nomeSogg = aSoggetto.getNome();
        String tipoSogg = aSoggetto.getTipo();
        long idSoggetto = -1L;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggetto(idSoggetto)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            idSoggetto = DBUtils.getIdSoggetto(nomeSogg, tipoSogg, con, this.driver.tipoDB, this.driver.tabellaSoggetti);
            if (idSoggetto == -1L) {
                throw new DriverConfigurazioneNotFound("Soggetto [" + aSoggetto.toString() + "] non esistente");
            }
        }
        catch (DriverConfigurazioneNotFound se) {
            throw se;
        }
        catch (CoreException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] DriverException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            this.driver.closeConnection(con);
        }
        soggetto = this.getSoggetto(idSoggetto);
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Soggetto non Esistente.");
        }
        return soggetto;
    }

    protected void createSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDSoggetto type = 1");
            DriverConfigurazioneDBSoggettiLib.CRUDSoggetto(1, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDSoggetto type = 2");
            DriverConfigurazioneDBSoggettiLib.CRUDSoggetto(2, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDSoggetto type = 3");
            DriverConfigurazioneDBSoggettiLib.CRUDSoggetto(3, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Soggetto getRouter() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Soggetto soggetto = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getRouter");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRouter] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        long idRouter = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("is_router = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setInt(1, 1);
            this.driver.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.ABILITATO));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getRouter] Non esiste un Soggetto Router.");
            }
            idRouter = rs.getLong("id");
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRouter] SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound se2) {
                    throw se2;
                }
                catch (Exception se3) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRouter] Exception: " + se3.getMessage(), se3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        soggetto = this.getSoggetto(idRouter);
        soggetto.setRouter(true);
        return soggetto;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDSoggetto> getSoggettiWithSuperuser(String user) throws DriverConfigurazioneException {
        ArrayList<IDSoggetto> idSoggetti = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggettiWithSuperuser");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggettiWithSuperuser] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            ArrayList<IDSoggetto> idTrovati = new ArrayList<IDSoggetto>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("superuser = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, user);
            this.driver.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.ABILITATO));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto id = new IDSoggetto();
                id.setTipo(rs.getString("tipo_soggetto"));
                id.setNome(rs.getString("nome_soggetto"));
                idTrovati.add(id);
            }
            if (!idTrovati.isEmpty()) {
                idSoggetti = new ArrayList<IDSoggetto>();
                idSoggetti.addAll(idTrovati);
            }
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggettiWithSuperuser] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggettiWithSuperuser] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return idSoggetti;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDSoggetto> getSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<IDSoggetto> arrayList;
        ArrayList<IDSoggetto> soggettiVirtuali = new ArrayList<IDSoggetto>();
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggettiVirtuali");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("tipo_soggetto_virtuale");
            sqlQueryObject.addSelectField("nome_soggetto_virtuale");
            sqlQueryObject.addWhereCondition("tipo_soggetto_virtuale IS NOT NULL");
            sqlQueryObject.addWhereCondition("nome_soggetto_virtuale IS NOT NULL");
            sqlQueryObject.addWhereCondition("tipo_soggetto_virtuale<>'\"\"'");
            sqlQueryObject.addWhereCondition("nome_soggetto_virtuale<>'\"\"'");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto soggettoVirtuale = new IDSoggetto(rs.getString("tipo_soggetto_virtuale"), rs.getString("nome_soggetto_virtuale"));
                this.driver.logInfo("aggiunto Soggetto " + soggettoVirtuale + " alla lista dei Soggetti Virtuali");
                soggettiVirtuali.add(soggettoVirtuale);
            }
            rs.close();
            stm.close();
            if (soggettiVirtuali.isEmpty()) {
                throw new DriverConfigurazioneNotFound("[getSoggettiVirtuali] Soggetti virtuali non esistenti");
            }
            this.driver.logInfo("aggiunti " + soggettiVirtuali.size() + " soggetti alla lista dei Soggetti Virtuali");
            arrayList = soggettiVirtuali;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound se2) {
                    throw se2;
                }
                catch (Exception se3) {
                    throw new DriverConfigurazioneException("Exception: " + se3.getMessage(), se3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected Soggetto getSoggetto(long idSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getSoggetto(idSoggetto, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Soggetto getSoggetto(long idSoggetto, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Soggetto soggetto;
        if (idSoggetto <= 0L) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] L'id del soggetto deve essere > 0.");
        }
        Soggetto soggetto2 = null;
        Connection con = null;
        PreparedStatement stm = null;
        PreparedStatement stm1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        String sqlQuery = "";
        if (conParam != null) {
            con = conParam;
        } else if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggetto(longId)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.driver.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getSoggetto] Soggetto non Esistente.");
            }
            soggetto2 = new Soggetto();
            soggetto2.setId(rs.getLong("id"));
            soggetto2.setNome(rs.getString("nome_soggetto"));
            soggetto2.setTipo(rs.getString("tipo_soggetto"));
            soggetto2.setSuperUser(rs.getString("superuser"));
            String tmp = rs.getString("descrizione");
            soggetto2.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("identificativo_porta");
            soggetto2.setIdentificativoPorta(tmp == null || tmp.equals("") ? null : tmp);
            int defaultR = rs.getInt("is_default");
            boolean isDefault = false;
            if (defaultR == 1) {
                isDefault = true;
            }
            soggetto2.setDominioDefault(isDefault);
            int router = rs.getInt("is_router");
            boolean isrouter = false;
            if (router == 1) {
                isrouter = true;
            }
            soggetto2.setRouter(isrouter);
            tmp = rs.getString("pd_url_prefix_rewriter");
            soggetto2.setPdUrlPrefixRewriter(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("pa_url_prefix_rewriter");
            soggetto2.setPaUrlPrefixRewriter(tmp == null || tmp.equals("") ? null : tmp);
            soggetto = soggetto2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound e) {
                    throw new DriverConfigurazioneNotFound(e);
                }
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs1, stm1);
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(rs1, stm1);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return soggetto;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDServizio> getServiziSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<IDServizio> arrayList;
        ArrayList<IDServizio> servizi = new ArrayList<IDServizio>();
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getServiziSoggettiVirtuali");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("tipo_soggetto_virtuale");
            sqlQueryObject.addSelectField("nome_soggetto_virtuale");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.setANDLogicOperator(false);
            sqlQueryObject.addWhereCondition("id_soggetto_virtuale<>-1");
            sqlQueryObject.addWhereCondition(true, new String[]{"tipo_soggetto_virtuale is not null", "nome_soggetto_virtuale is not null"});
            sqlQueryObject.setANDLogicOperator(false);
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                IDServizio servizio = IDServizioUtils.buildIDServizio(rs.getString("tipo_servizio"), rs.getString("servizio"), new IDSoggetto(rs.getString("tipo_soggetto_virtuale"), rs.getString("nome_soggetto_virtuale")), rs.getInt("versione_servizio"));
                servizi.add(servizio);
                this.driver.logInfo("aggiunto Servizio " + servizio.toString() + " alla lista dei servizi erogati da Soggetti Virtuali");
            }
            if (servizi.isEmpty()) {
                throw new DriverConfigurazioneNotFound("[getServiziSoggettiVirtuali] Servizi erogati da Soggetti virtuali non esistenti");
            }
            this.driver.logInfo("aggiunti " + servizi.size() + " servizi alla lista dei servizi erogati da Soggetti Virtuali");
            arrayList = servizi;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound se2) {
                    throw se2;
                }
                catch (Exception se3) {
                    throw new DriverConfigurazioneException("Exception: " + se3.getMessage(), se3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        if (idSoggetto == null) {
            throw new DriverConfigurazioneException("[existsSoggetto::existsSoggetto] Soggetto non Impostato.");
        }
        if (idSoggetto.getNome() == null || "".equals(idSoggetto.getNome())) {
            throw new DriverConfigurazioneException("[existsSoggetto::existsServizioApplicativo] Nome Soggetto non Impostato.");
        }
        if (idSoggetto.getTipo() == null || "".equals(idSoggetto.getTipo())) {
            throw new DriverConfigurazioneException("[existsSoggetto::existsServizioApplicativo] Nome Soggetto non Impostato.");
        }
        Connection con = null;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("existsSoggetto");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            boolean e = DBUtils.getIdSoggetto(idSoggetto.getNome(), idSoggetto.getTipo(), con, this.driver.tipoDB, this.driver.tabellaSoggetti) > 0L;
            this.driver.closeConnection(con);
            return e;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
    }

    protected List<Soggetto> getAllSoggetti() throws DriverConfigurazioneException {
        ArrayList<Soggetto> arrayList;
        String nomeMetodo = "getAllSoggetti";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(OPERAZIONE_ATOMICA_PREFIX + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addSelectField("id");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                lista.add(this.getSoggetto(id));
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<IDSoggetto> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        this.driver.logDebug("getAllIdSoggetti...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdSoggetti") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug(ESEGUO_QUERY_PREFIX + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.driver.logDebug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.driver.logDebug("nomeSoggetto stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            ArrayList<IDSoggetto> idSoggetti = new ArrayList<IDSoggetto>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                idSoggetti.add(idS);
            }
            if (idSoggetti.isEmpty()) {
                if (filtroRicerca != null) {
                    throw new DriverConfigurazioneNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverConfigurazioneNotFound("Soggetti non trovati");
            }
            arrayList = idSoggetti;
        }
        catch (DriverConfigurazioneNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverConfigurazioneException("getAllIdSoggetti error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

