/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDBSoggettiSearch {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDBSoggettiSearch(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    private String getPrefixError(String nomeMetodo) {
        return "[DriverConfigurazioneDB::" + nomeMetodo + "] ";
    }

    protected List<Soggetto> soggettiList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Soggetto> arrayList;
        String nomeMetodo = "soggettiList";
        int idLista = Liste.SOGGETTI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        String filtroProprietaNome = SearchUtils.getFilter(ricerca, idLista, "filtroPropNome");
        String filtroProprietaValore = SearchUtils.getFilter(ricerca, idLista, "filtroPropValore");
        if (filtroProprietaNome != null && "".equals(filtroProprietaNome)) {
            filtroProprietaNome = null;
        }
        if (filtroProprietaValore != null && "".equals(filtroProprietaValore)) {
            filtroProprietaValore = null;
        }
        boolean filtroProprieta = filtroProprietaNome != null || filtroProprietaValore != null;
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filtroProprietaNome : " + filtroProprietaNome);
        this.driver.logDebug("filtroProprietaValore : " + filtroProprietaValore);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("soggettiList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo) + "Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
                sqlQueryObject.addSelectCountField("*", "cont");
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser= ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaSoggetto(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
                sqlQueryObject.addSelectCountField("*", "cont");
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser= ?");
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaSoggetto(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("is_router");
                sqlQueryObject.addSelectField("is_default");
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser= ?");
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaSoggetto(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("is_router");
                sqlQueryObject.addSelectField("is_default");
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser= ?");
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaSoggetto(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto sog = new Soggetto();
                sog.setId(risultato.getLong("id"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                sog.setDescrizione(risultato.getString("descrizione"));
                sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                sog.setRouter(risultato.getInt("is_router") == 1);
                sog.setDominioDefault(risultato.getInt("is_default") == 1);
                lista.add(sog);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo) + "Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Soggetto> soggettiWithServiziList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.soggettiWithServiziList(null, ricerca);
    }

    protected List<Soggetto> soggettiWithServiziList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Soggetto> arrayList;
        String nomeMetodo = "soggettiWithServiziList";
        int idLista = Liste.SOGGETTI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("soggettiWithServiziList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo) + "Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField(this.driver.tabellaSoggetti + ".id", "cont", true);
            sqlQueryObject.addWhereCondition(this.driver.tabellaSoggetti + ".id = servizi.id_soggetto");
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition(this.driver.tabellaSoggetti + ".superuser=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(this.driver.tabellaSoggetti);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField(this.driver.tabellaSoggetti + ".id");
            sqlQueryObject.addSelectField(this.driver.tabellaSoggetti + ".tipo_soggetto");
            sqlQueryObject.addSelectField(this.driver.tabellaSoggetti + ".nome_soggetto");
            sqlQueryObject.addWhereCondition(this.driver.tabellaSoggetti + ".id = servizi.id_soggetto");
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition(this.driver.tabellaSoggetti + ".superuser=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(this.driver.tabellaSoggetti + ".tipo_soggetto");
            sqlQueryObject.addOrderBy(this.driver.tabellaSoggetti + ".nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto sog = new Soggetto();
                sog.setId(risultato.getLong("id"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(sog);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo) + "Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

