/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaleConfigurazioneNodo;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_canaliLIB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void readCanaliConfigurazione(Connection con, CanaliConfigurazione configCanali, boolean readNodi) throws Exception {
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("canali_configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            rs1 = stm1.executeQuery();
            while (rs1.next()) {
                CanaleConfigurazione canale = new CanaleConfigurazione();
                canale.setId(rs1.getLong("id"));
                canale.setNome(rs1.getString("nome"));
                canale.setDescrizione(rs1.getString("descrizione"));
                int v = rs1.getInt("canale_default");
                if (v == 1) {
                    canale.setCanaleDefault(true);
                } else {
                    canale.setCanaleDefault(false);
                }
                configCanali.addCanale(canale);
            }
            rs1.close();
            stm1.close();
            if (readNodi) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addFromTable("canali_nodi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    CanaleConfigurazioneNodo nodo = new CanaleConfigurazioneNodo();
                    nodo.setId(rs1.getLong("id"));
                    nodo.setNome(rs1.getString("nome"));
                    nodo.setDescrizione(rs1.getString("descrizione"));
                    List<String> l = DBUtils.convertToList(rs1.getString("canali"));
                    nodo.setCanaleList(l);
                    configCanali.addNodo(nodo);
                }
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs1, stm1);
            throw throwable;
        }
        JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void CRUDCanaliConfigurazione(int type, Connection con, CanaliConfigurazione canaliConfigurazione) throws DriverConfigurazioneException {
        PreparedStatement updateStmt = null;
        try {
            switch (type) {
                case 1: {
                    int index;
                    String updateQuery;
                    ISQLQueryObject sqlQueryObject;
                    if (canaliConfigurazione == null) {
                        return;
                    }
                    if (canaliConfigurazione.sizeCanaleList() > 0) {
                        for (CanaleConfigurazione canale : canaliConfigurazione.getCanaleList()) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("canali_configurazione");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("descrizione", "?");
                            sqlQueryObject.addInsertField("canale_default", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            index = 1;
                            updateStmt.setString(index++, canale.getNome());
                            updateStmt.setString(index++, canale.getDescrizione());
                            updateStmt.setInt(index++, canale.isCanaleDefault() ? 1 : 0);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                        }
                    }
                    if (canaliConfigurazione.sizeNodoList() <= 0) return;
                    Iterator<BaseBeanWithId> iterator = canaliConfigurazione.getNodoList().iterator();
                    while (iterator.hasNext()) {
                        CanaleConfigurazioneNodo nodo = (CanaleConfigurazioneNodo)iterator.next();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("canali_nodi");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("canali", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        index = 1;
                        updateStmt.setString(index++, nodo.getNome());
                        updateStmt.setString(index++, nodo.getDescrizione());
                        StringBuilder bf = new StringBuilder();
                        for (int i = 0; i < nodo.sizeCanaleList(); ++i) {
                            if (i > 0) {
                                bf.append(",");
                            }
                            bf.append(nodo.getCanale(i));
                        }
                        String canali = bf.toString();
                        updateStmt.setString(index++, canali);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    return;
                }
                case 2: {
                    DriverConfigurazioneDB_canaliLIB.CRUDCanaliConfigurazione(3, con, canaliConfigurazione);
                    if (canaliConfigurazione == null) return;
                    DriverConfigurazioneDB_canaliLIB.CRUDCanaliConfigurazione(1, con, canaliConfigurazione);
                    return;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("canali_configurazione");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("canali_nodi");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDCanaliConfigurazione] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDCanaliConfigurazione] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
        }
    }
}

