/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.driver.ConnettorePropertiesUtilities;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_connettoriLIB {
    public static long CRUDConnettore(int type, Connettore connettore, Connection connection, IDriverBYOK driverBYOK) throws DriverConfigurazioneException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'oggetto Connettore non puo essere null");
        }
        if (type != 3 && (connettore.getNome() == null || connettore.getNome().trim().equals(""))) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore]Il nome Connettore non puo essere null");
        }
        String nomeConnettore = connettore.getNome();
        String endpointtype = connettore.getTipo();
        if (endpointtype == null || endpointtype.trim().equals("")) {
            endpointtype = TipiConnettore.DISABILITATO.getNome();
        }
        String url = null;
        boolean debug = false;
        String nome = null;
        String tipo = null;
        String utente = null;
        String password = null;
        String initcont = null;
        String urlpkg = null;
        String provurl = null;
        String connectionfactory = null;
        String sendas = null;
        String transferMode = null;
        Integer transferModeChunkSize = null;
        boolean proxy = false;
        String proxyType = null;
        String proxyHostname = null;
        String proxyPort = null;
        String proxyUsername = null;
        String proxyPassword = null;
        Integer tempiRispostaConnectionTimeout = null;
        Integer tempiRispostaReadTimeout = null;
        Integer tempiRispostaAvgResponseTime = null;
        String redirectMode = null;
        Integer redirectMaxHop = null;
        String tokenPolicy = null;
        String apiKey = null;
        String apiKeyHeader = null;
        String appId = null;
        String appIdHeader = null;
        boolean isAbilitato = false;
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<String> propertiesGestiteAttraversoColonneAdHoc = new ArrayList<String>();
        String nomeProperty = null;
        String valoreProperty = null;
        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
            nomeProperty = connettore.getProperty(i).getNome();
            valoreProperty = connettore.getProperty(i).getValore();
            if (valoreProperty != null && valoreProperty.equals("")) {
                valoreProperty = null;
            }
            if (nomeProperty.equals("debug") && "true".equals(valoreProperty)) {
                debug = true;
            }
            if (nomeProperty.equals("proxyType")) {
                proxy = true;
                proxyType = valoreProperty;
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                for (Property propertyCheck : connettore.getPropertyList()) {
                    if (propertyCheck.getNome().equals("proxyHostname")) {
                        propertiesGestiteAttraversoColonneAdHoc.add(propertyCheck.getNome());
                        proxyHostname = propertyCheck.getValore();
                    }
                    if (propertyCheck.getNome().equals("proxyPort")) {
                        propertiesGestiteAttraversoColonneAdHoc.add(propertyCheck.getNome());
                        proxyPort = propertyCheck.getValore();
                    }
                    if (propertyCheck.getNome().equals("proxyUsername")) {
                        propertiesGestiteAttraversoColonneAdHoc.add(propertyCheck.getNome());
                        proxyUsername = propertyCheck.getValore();
                    }
                    if (!propertyCheck.getNome().equals("proxyPassword")) continue;
                    propertiesGestiteAttraversoColonneAdHoc.add(propertyCheck.getNome());
                    proxyPassword = propertyCheck.getValore();
                }
            }
            if (nomeProperty.equals("connectionTimeout")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                tempiRispostaConnectionTimeout = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("readConnectionTimeout")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                tempiRispostaReadTimeout = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("avgResponseTime")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                tempiRispostaAvgResponseTime = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("dataTransferMode")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                transferMode = valoreProperty;
            }
            if (nomeProperty.equals("transferChunkSize")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                transferModeChunkSize = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("followRedirects")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                redirectMode = valoreProperty;
            }
            if (nomeProperty.equals("maxHopRedirect")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                redirectMaxHop = Integer.parseInt(valoreProperty);
            }
            if (nomeProperty.equals("tokenPolicy")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                tokenPolicy = valoreProperty;
            }
            if (nomeProperty.equals("apiKey")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                apiKey = valoreProperty;
            }
            if (nomeProperty.equals("apiKeyHeader")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                apiKeyHeader = valoreProperty;
            }
            if (nomeProperty.equals("appId")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                appId = valoreProperty;
            }
            if (nomeProperty.equals("appIdHeader")) {
                propertiesGestiteAttraversoColonneAdHoc.add(nomeProperty);
                appIdHeader = valoreProperty;
            }
            if (TipiConnettore.HTTP.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    url = valoreProperty;
                }
            } else if (TipiConnettore.JMS.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    nome = valoreProperty;
                } else if (nomeProperty.equals("tipo")) {
                    tipo = valoreProperty;
                } else if (nomeProperty.equals("user")) {
                    utente = valoreProperty;
                } else if (nomeProperty.equals("password")) {
                    password = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.factory.initial")) {
                    initcont = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.factory.url.pkgs")) {
                    urlpkg = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.provider.url")) {
                    provurl = valoreProperty;
                } else if (nomeProperty.equals("connection-factory")) {
                    connectionfactory = valoreProperty;
                } else if (nomeProperty.equals("send-as")) {
                    sendas = valoreProperty;
                }
            }
            if (!endpointtype.equalsIgnoreCase(TipiConnettore.DISABILITATO.getNome())) {
                isAbilitato = true;
            }
            if (!nomeProperty.startsWith("-#ext#-")) continue;
            extendedProperties.put(nomeProperty, valoreProperty);
        }
        try {
            long idConnettore = 0L;
            int n = 0;
            switch (type) {
                case 1: {
                    String apiKeyInsert;
                    BYOKWrappedValue byokValue;
                    BYOKWrappedValue byokValue2;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("connettori");
                    sqlQueryObject.addInsertField("endpointtype", "?");
                    sqlQueryObject.addInsertField("url", "?");
                    sqlQueryObject.addInsertField("transfer_mode", "?");
                    sqlQueryObject.addInsertField("transfer_mode_chunk_size", "?");
                    sqlQueryObject.addInsertField("redirect_mode", "?");
                    sqlQueryObject.addInsertField("redirect_max_hop", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("utente", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("enc_password", "?");
                    sqlQueryObject.addInsertField("initcont", "?");
                    sqlQueryObject.addInsertField("urlpkg", "?");
                    sqlQueryObject.addInsertField("provurl", "?");
                    sqlQueryObject.addInsertField("connection_factory", "?");
                    sqlQueryObject.addInsertField("send_as", "?");
                    sqlQueryObject.addInsertField("nome_connettore", "?");
                    sqlQueryObject.addInsertField("debug", "?");
                    sqlQueryObject.addInsertField("proxy", "?");
                    sqlQueryObject.addInsertField("proxy_type", "?");
                    sqlQueryObject.addInsertField("proxy_hostname", "?");
                    sqlQueryObject.addInsertField("proxy_port", "?");
                    sqlQueryObject.addInsertField("proxy_username", "?");
                    sqlQueryObject.addInsertField("proxy_password", "?");
                    sqlQueryObject.addInsertField("enc_proxy_password", "?");
                    sqlQueryObject.addInsertField("connection_timeout", "?");
                    sqlQueryObject.addInsertField("read_timeout", "?");
                    sqlQueryObject.addInsertField("avg_response_time", "?");
                    sqlQueryObject.addInsertField("custom", "?");
                    sqlQueryObject.addInsertField("token_policy", "?");
                    sqlQueryObject.addInsertField("api_key", "?");
                    sqlQueryObject.addInsertField("api_key_header", "?");
                    sqlQueryObject.addInsertField("app_id", "?");
                    sqlQueryObject.addInsertField("app_id_header", "?");
                    String sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = connection.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, endpointtype);
                    stm.setString(index++, isAbilitato ? url : null);
                    stm.setString(index++, isAbilitato ? transferMode : null);
                    if (isAbilitato && transferModeChunkSize != null) {
                        stm.setInt(index++, transferModeChunkSize);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, isAbilitato ? redirectMode : null);
                    if (isAbilitato && redirectMaxHop != null) {
                        stm.setInt(index++, redirectMaxHop);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, isAbilitato ? nome : null);
                    stm.setString(index++, isAbilitato ? tipo : null);
                    stm.setString(index++, isAbilitato ? utente : null);
                    String plainPassword = isAbilitato ? password : null;
                    String encPassword = null;
                    if (isAbilitato && driverBYOK != null && plainPassword != null && (byokValue2 = driverBYOK.wrap(plainPassword)) != null) {
                        encPassword = byokValue2.getWrappedValue();
                        plainPassword = byokValue2.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainPassword);
                    stm.setString(index++, encPassword);
                    stm.setString(index++, isAbilitato ? initcont : null);
                    stm.setString(index++, isAbilitato ? urlpkg : null);
                    stm.setString(index++, isAbilitato ? provurl : null);
                    stm.setString(index++, isAbilitato ? connectionfactory : null);
                    stm.setString(index++, isAbilitato ? sendas : null);
                    stm.setString(index++, nomeConnettore);
                    if (debug) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    if (proxy) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, isAbilitato && proxy ? proxyType : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyHostname : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyPort : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyUsername : null);
                    String plainProxyPassword = isAbilitato ? proxyPassword : null;
                    String encProxyPassword = null;
                    if (isAbilitato && driverBYOK != null && plainProxyPassword != null && (byokValue = driverBYOK.wrap(plainProxyPassword)) != null) {
                        encProxyPassword = byokValue.getWrappedValue();
                        plainProxyPassword = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainProxyPassword);
                    stm.setString(index++, encProxyPassword);
                    if (tempiRispostaConnectionTimeout != null) {
                        stm.setInt(index++, tempiRispostaConnectionTimeout);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (tempiRispostaReadTimeout != null) {
                        stm.setInt(index++, tempiRispostaReadTimeout);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (tempiRispostaAvgResponseTime != null) {
                        stm.setInt(index++, tempiRispostaAvgResponseTime);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, tokenPolicy);
                    String string = apiKeyInsert = isAbilitato ? apiKey : null;
                    if (isAbilitato && apiKey != null && StringUtils.isNotEmpty((String)apiKey) && driverBYOK != null && CostantiConnettori.isConfidential("apiKey")) {
                        BYOKWrappedValue byokValue3 = driverBYOK.wrap(apiKey);
                        if (byokValue3 != null) {
                            apiKeyInsert = byokValue3.getWrappedValue();
                            stm.setString(index++, byokValue3.getWrappedValue());
                        } else {
                            stm.setString(index++, apiKey);
                        }
                    } else {
                        stm.setString(index++, apiKey);
                    }
                    stm.setString(index++, isAbilitato ? apiKeyHeader : null);
                    stm.setString(index++, isAbilitato ? appId : null);
                    stm.setString(index++, isAbilitato ? appIdHeader : null);
                    DriverConfigurazioneDBLib.logDebug("CRUDConnettore CREATE : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, url, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, nome, tipo, utente, plainPassword, encPassword, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, debug, proxy, proxyType, proxyHostname, proxyPort, proxyUsername, plainProxyPassword, encProxyPassword, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaAvgResponseTime, connettore.getCustom() != null && connettore.getCustom() != false, tokenPolicy, apiKeyInsert, apiKeyHeader, appId, appIdHeader));
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inserted " + n + " row(s)");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable("connettori");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("endpointtype = ?");
                    sqlQueryObject.addWhereCondition("nome_connettore = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, endpointtype);
                    stm.setString(2, nomeConnettore);
                    DriverConfigurazioneDBLib.logDebug("Recupero idConnettore inserito : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, nomeConnettore));
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                    }
                    idConnettore = rs.getLong("id");
                    connettore.setId(idConnettore);
                    rs.close();
                    stm.close();
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                            BYOKWrappedValue byokValue4;
                            nomeProperty = connettore.getProperty(i).getNome();
                            if (propertiesGestiteAttraversoColonneAdHoc.contains(nomeProperty)) continue;
                            valoreProperty = connettore.getProperty(i).getValore();
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new DriverConfigurazioneException("Property [" + nomeProperty + "] without value");
                            }
                            String plainValue = valoreProperty;
                            String encValue = null;
                            if (driverBYOK != null && CostantiConnettori.isConfidential(nomeProperty) && (byokValue4 = driverBYOK.wrap(valoreProperty)) != null) {
                                encValue = byokValue4.getWrappedValue();
                                plainValue = byokValue4.getWrappedPlainValue();
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeProperty);
                            stm.setString(2, plainValue);
                            stm.setString(3, encValue);
                            stm.setLong(4, connettore.getId());
                            stm.executeUpdate();
                            stm.close();
                        }
                    } else {
                        if (extendedProperties.size() <= 0) break;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (String nomeP : extendedProperties.keySet()) {
                            BYOKWrappedValue byokValue5;
                            valoreProperty = (String)extendedProperties.get(nomeP);
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new DriverConfigurazioneException("Property [" + nomeP + "] without value");
                            }
                            String plainValue = valoreProperty;
                            String encValue = null;
                            if (driverBYOK != null && CostantiConnettori.isConfidential(nomeProperty) && (byokValue5 = driverBYOK.wrap(valoreProperty)) != null) {
                                encValue = byokValue5.getWrappedValue();
                                plainValue = byokValue5.getWrappedPlainValue();
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeP);
                            stm.setString(2, plainValue);
                            stm.setString(3, encValue);
                            stm.setLong(4, connettore.getId());
                            stm.executeUpdate();
                            stm.close();
                        }
                    }
                    break;
                }
                case 2: {
                    String apiKeyInsert;
                    BYOKWrappedValue byokValue;
                    idConnettore = connettore.getId();
                    if (idConnettore < 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di update.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("connettori");
                    sqlQueryObject.addUpdateField("endpointtype", "?");
                    sqlQueryObject.addUpdateField("url", "?");
                    sqlQueryObject.addUpdateField("transfer_mode", "?");
                    sqlQueryObject.addUpdateField("transfer_mode_chunk_size", "?");
                    sqlQueryObject.addUpdateField("redirect_mode", "?");
                    sqlQueryObject.addUpdateField("redirect_max_hop", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("utente", "?");
                    sqlQueryObject.addUpdateField("password", "?");
                    sqlQueryObject.addUpdateField("enc_password", "?");
                    sqlQueryObject.addUpdateField("initcont", "?");
                    sqlQueryObject.addUpdateField("urlpkg", "?");
                    sqlQueryObject.addUpdateField("provurl", "?");
                    sqlQueryObject.addUpdateField("connection_factory", "?");
                    sqlQueryObject.addUpdateField("send_as", "?");
                    sqlQueryObject.addUpdateField("nome_connettore", "?");
                    sqlQueryObject.addUpdateField("debug", "?");
                    sqlQueryObject.addUpdateField("proxy", "?");
                    sqlQueryObject.addUpdateField("proxy_type", "?");
                    sqlQueryObject.addUpdateField("proxy_hostname", "?");
                    sqlQueryObject.addUpdateField("proxy_port", "?");
                    sqlQueryObject.addUpdateField("proxy_username", "?");
                    sqlQueryObject.addUpdateField("proxy_password", "?");
                    sqlQueryObject.addUpdateField("enc_proxy_password", "?");
                    sqlQueryObject.addUpdateField("connection_timeout", "?");
                    sqlQueryObject.addUpdateField("read_timeout", "?");
                    sqlQueryObject.addUpdateField("avg_response_time", "?");
                    sqlQueryObject.addUpdateField("custom", "?");
                    sqlQueryObject.addUpdateField("token_policy", "?");
                    sqlQueryObject.addUpdateField("api_key", "?");
                    sqlQueryObject.addUpdateField("api_key_header", "?");
                    sqlQueryObject.addUpdateField("app_id", "?");
                    sqlQueryObject.addUpdateField("app_id_header", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = connection.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, endpointtype);
                    stm.setString(index++, url);
                    stm.setString(index++, isAbilitato ? transferMode : null);
                    if (isAbilitato && transferModeChunkSize != null) {
                        stm.setInt(index++, transferModeChunkSize);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, isAbilitato ? redirectMode : null);
                    if (isAbilitato && redirectMaxHop != null) {
                        stm.setInt(index++, redirectMaxHop);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, isAbilitato ? nome : null);
                    stm.setString(index++, isAbilitato ? tipo : null);
                    stm.setString(index++, isAbilitato ? utente : null);
                    String plainPassword = isAbilitato ? password : null;
                    String encPassword = null;
                    if (isAbilitato && driverBYOK != null && plainPassword != null && (byokValue = driverBYOK.wrap(plainPassword)) != null) {
                        encPassword = byokValue.getWrappedValue();
                        plainPassword = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainPassword);
                    stm.setString(index++, encPassword);
                    stm.setString(index++, isAbilitato ? initcont : null);
                    stm.setString(index++, isAbilitato ? urlpkg : null);
                    stm.setString(index++, isAbilitato ? provurl : null);
                    stm.setString(index++, isAbilitato ? connectionfactory : null);
                    stm.setString(index++, isAbilitato ? sendas : null);
                    stm.setString(index++, nomeConnettore);
                    if (debug) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    if (proxy) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, isAbilitato && proxy ? proxyType : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyHostname : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyPort : null);
                    stm.setString(index++, isAbilitato && proxy ? proxyUsername : null);
                    String plainProxyPassword = isAbilitato ? proxyPassword : null;
                    String encProxyPassword = null;
                    if (isAbilitato && driverBYOK != null && plainProxyPassword != null && (byokValue = driverBYOK.wrap(plainProxyPassword)) != null) {
                        encProxyPassword = byokValue.getWrappedValue();
                        plainProxyPassword = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainProxyPassword);
                    stm.setString(index++, encProxyPassword);
                    if (tempiRispostaConnectionTimeout != null) {
                        stm.setInt(index++, tempiRispostaConnectionTimeout);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (tempiRispostaReadTimeout != null) {
                        stm.setInt(index++, tempiRispostaReadTimeout);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (tempiRispostaAvgResponseTime != null) {
                        stm.setInt(index++, tempiRispostaAvgResponseTime);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, tokenPolicy);
                    String string = apiKeyInsert = isAbilitato ? apiKey : null;
                    if (isAbilitato && apiKey != null && StringUtils.isNotEmpty((String)apiKey) && driverBYOK != null && CostantiConnettori.isConfidential("apiKey")) {
                        byokValue = driverBYOK.wrap(apiKey);
                        if (byokValue != null) {
                            apiKeyInsert = byokValue.getWrappedValue();
                            stm.setString(index++, byokValue.getWrappedValue());
                        } else {
                            stm.setString(index++, apiKey);
                        }
                    } else {
                        stm.setString(index++, apiKey);
                    }
                    stm.setString(index++, isAbilitato ? apiKeyHeader : null);
                    stm.setString(index++, isAbilitato ? appId : null);
                    stm.setString(index++, isAbilitato ? appIdHeader : null);
                    stm.setLong(index++, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("CRUDConnettore UPDATE : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, url, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, nome, tipo, utente, plainPassword, encPassword, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, debug, proxy, proxyType, proxyHostname, proxyPort, proxyUsername, plainProxyPassword, encProxyPassword, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaAvgResponseTime, connettore.getCustom() != null && connettore.getCustom() != false, tokenPolicy, apiKeyInsert, apiKeyHeader, appId, appIdHeader, idConnettore));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("connettori_custom");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                            BYOKWrappedValue byokValue6;
                            nomeProperty = connettore.getProperty(i).getNome();
                            if (propertiesGestiteAttraversoColonneAdHoc.contains(nomeProperty)) continue;
                            valoreProperty = connettore.getProperty(i).getValore();
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new DriverConfigurazioneException("Property [" + nomeProperty + "] without value");
                            }
                            String plainValue = valoreProperty;
                            String encValue = null;
                            if (driverBYOK != null && CostantiConnettori.isConfidential(nomeProperty) && (byokValue6 = driverBYOK.wrap(valoreProperty)) != null) {
                                encValue = byokValue6.getWrappedValue();
                                plainValue = byokValue6.getWrappedPlainValue();
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeProperty);
                            stm.setString(2, plainValue);
                            stm.setString(3, encValue);
                            stm.setLong(4, idConnettore);
                            stm.executeUpdate();
                            stm.close();
                        }
                    } else {
                        if (extendedProperties.size() <= 0) break;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("connettori_custom");
                        sqlQueryObject.addInsertField("name", "?");
                        sqlQueryObject.addInsertField("value", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        for (String nomeP : extendedProperties.keySet()) {
                            BYOKWrappedValue byokValue7;
                            valoreProperty = (String)extendedProperties.get(nomeP);
                            if (valoreProperty != null && valoreProperty.equals("")) {
                                valoreProperty = null;
                            }
                            if (valoreProperty == null) {
                                throw new DriverConfigurazioneException("Property [" + nomeP + "] without value");
                            }
                            String plainValue = valoreProperty;
                            String encValue = null;
                            if (driverBYOK != null && CostantiConnettori.isConfidential(nomeProperty) && (byokValue7 = driverBYOK.wrap(valoreProperty)) != null) {
                                encValue = byokValue7.getWrappedValue();
                                plainValue = byokValue7.getWrappedPlainValue();
                            }
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, nomeP);
                            stm.setString(2, plainValue);
                            stm.setString(3, encValue);
                            stm.setLong(4, idConnettore);
                            stm.executeUpdate();
                            stm.close();
                        }
                    }
                    break;
                }
                case 3: {
                    idConnettore = connettore.getId();
                    if (idConnettore < 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di delete.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("connettori_custom");
                    sqlQueryObject.addWhereCondition("id_connettore=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("connettori");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("CRUDConnettore DELETE : \n" + DBUtils.formatSQLString(sqlQuery, idConnettore));
                }
            }
            long l = idConnettore;
            return l;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Connettore getConnettore(long idConnettore, Connection connection, IDriverBYOK driverBYOK) throws DriverConfigurazioneException {
        Connettore connettore;
        Connettore connettore2 = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            DriverConfigurazioneDBLib.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            if (rs.next()) {
                String endpoint = rs.getString("endpointtype");
                if (endpoint == null || endpoint.equals("") || endpoint.equals(TipiConnettore.DISABILITATO.getNome())) {
                    connettore2 = new Connettore();
                    connettore2.setNome(rs.getString("nome_connettore"));
                    connettore2.setTipo(TipiConnettore.DISABILITATO.getNome());
                    connettore2.setId(idConnettore);
                } else {
                    Property prop = null;
                    connettore2 = new Connettore();
                    connettore2.setNome(rs.getString("nome_connettore"));
                    connettore2.setTipo(endpoint);
                    connettore2.setId(idConnettore);
                    if (rs.getInt("debug") == 1) {
                        prop = new Property();
                        prop.setNome("debug");
                        prop.setValore("true");
                        connettore2.addProperty(prop);
                    }
                    DriverConfigurazioneDB_connettoriLIB.readConnettoreProxy(rs, connettore2, driverBYOK);
                    DriverConfigurazioneDB_connettoriLIB.readConnettoreTempiRisposta(rs, connettore2);
                    DriverConfigurazioneDB_connettoriLIB.readConnettoreTransferMode(rs, connettore2);
                    DriverConfigurazioneDB_connettoriLIB.readConnettoreRedirectMode(rs, connettore2);
                    String tokenPolicy = rs.getString("token_policy");
                    if (tokenPolicy != null && !"".equals(tokenPolicy)) {
                        prop = new Property();
                        prop.setNome("tokenPolicy");
                        prop.setValore(tokenPolicy.trim());
                        connettore2.addProperty(prop);
                    }
                    DriverConfigurazioneDB_connettoriLIB.readAutenticazioneApiKey(rs, connettore2, driverBYOK);
                    if (endpoint.equals(CostantiDB.CONNETTORE_TIPO_HTTP)) {
                        DriverConfigurazioneDB_connettoriLIB.readConnettoreHttp(rs, connettore2);
                    } else if (endpoint.equals(TipiConnettore.JMS.getNome())) {
                        DriverConfigurazioneDB_connettoriLIB.readConnettoreJms(rs, connettore2, driverBYOK);
                    } else if (!(endpoint.equals(TipiConnettore.NULL.getNome()) || endpoint.equals(TipiConnettore.NULLECHO.getNome()) || endpoint.equals(TipiConnettore.DISABILITATO.getNome()))) {
                        if (rs.getLong("custom") == 1L) {
                            DriverConfigurazioneDB_connettoriLIB.readPropertiesConnettoreCustom(idConnettore, connettore2, connection, driverBYOK);
                            connettore2.setCustom(true);
                        } else {
                            connettore2.setPropertyList(ConnettorePropertiesUtilities.getPropertiesConnettore(endpoint, connection, DriverConfigurazioneDBLib.tipoDB));
                        }
                    }
                }
            }
            DriverConfigurazioneDB_connettoriLIB.readPropertiesConnettoreExtendedInfo(idConnettore, connettore2, connection, driverBYOK);
            connettore = connettore2;
        }
        catch (SQLException sqle) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::getConnettore] SQLException : " + sqle.getMessage(), sqle);
                catch (DriverConfigurazioneException e) {
                    throw e;
                }
                catch (Exception sqle2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::getConnettore] Exception : " + sqle2.getMessage(), sqle2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return connettore;
    }

    private static void readConnettoreProxy(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        if (rs.getInt("proxy") == 1) {
            Property prop;
            String tmp = rs.getString("proxy_type");
            if (tmp != null && !"".equals(tmp)) {
                prop = new Property();
                prop.setNome("proxyType");
                prop.setValore(tmp.trim());
                connettore.addProperty(prop);
            }
            if ((tmp = rs.getString("proxy_hostname")) != null && !"".equals(tmp)) {
                prop = new Property();
                prop.setNome("proxyHostname");
                prop.setValore(tmp.trim());
                connettore.addProperty(prop);
            }
            if ((tmp = rs.getString("proxy_port")) != null && !"".equals(tmp)) {
                prop = new Property();
                prop.setNome("proxyPort");
                prop.setValore(tmp.trim());
                connettore.addProperty(prop);
            }
            DriverConfigurazioneDB_connettoriLIB.readConnettoreProxyCredentials(rs, connettore, driverBYOK);
        }
    }

    private static void readConnettoreProxyCredentials(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String tmp = rs.getString("proxy_username");
        if (tmp != null && !"".equals(tmp)) {
            Property prop = new Property();
            prop.setNome("proxyUsername");
            prop.setValore(tmp.trim());
            connettore.addProperty(prop);
        }
        tmp = rs.getString("proxy_password");
        String encValue = rs.getString("enc_proxy_password");
        if (tmp != null && !"".equals(tmp)) {
            Property prop = new Property();
            prop.setNome("proxyPassword");
            if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                if (driverBYOK != null) {
                    prop.setValore(driverBYOK.unwrapAsString(encValue));
                } else {
                    prop.setValore(encValue);
                }
            } else {
                prop.setValore(tmp.trim());
            }
            connettore.addProperty(prop);
        }
    }

    private static void readConnettoreTempiRisposta(ResultSet rs, Connettore connettore) throws SQLException {
        int avgResponseTime;
        int readTimeout;
        int connectionTimeout = rs.getInt("connection_timeout");
        if (connectionTimeout > 0) {
            Property prop = new Property();
            prop.setNome("connectionTimeout");
            prop.setValore("" + connectionTimeout);
            connettore.addProperty(prop);
        }
        if ((readTimeout = rs.getInt("read_timeout")) > 0) {
            Property prop = new Property();
            prop.setNome("readConnectionTimeout");
            prop.setValore("" + readTimeout);
            connettore.addProperty(prop);
        }
        if ((avgResponseTime = rs.getInt("avg_response_time")) > 0) {
            Property prop = new Property();
            prop.setNome("avgResponseTime");
            prop.setValore("" + avgResponseTime);
            connettore.addProperty(prop);
        }
    }

    private static void readConnettoreTransferMode(ResultSet rs, Connettore connettore) throws SQLException {
        String transferMode = rs.getString("transfer_mode");
        if (transferMode != null && !"".equals(transferMode)) {
            Property prop = new Property();
            prop.setNome("dataTransferMode");
            prop.setValore(transferMode.trim());
            connettore.addProperty(prop);
            transferMode = rs.getString("transfer_mode_chunk_size");
            if (transferMode != null && !"".equals(transferMode)) {
                prop = new Property();
                prop.setNome("transferChunkSize");
                prop.setValore(transferMode.trim());
                connettore.addProperty(prop);
            }
        }
    }

    private static void readConnettoreRedirectMode(ResultSet rs, Connettore connettore) throws SQLException {
        String redirectMode = rs.getString("redirect_mode");
        if (redirectMode != null && !"".equals(redirectMode)) {
            Property prop = new Property();
            prop.setNome("followRedirects");
            prop.setValore(redirectMode.trim());
            connettore.addProperty(prop);
            redirectMode = rs.getString("redirect_max_hop");
            if (redirectMode != null && !"".equals(redirectMode)) {
                prop = new Property();
                prop.setNome("maxHopRedirect");
                prop.setValore(redirectMode.trim());
                connettore.addProperty(prop);
            }
        }
    }

    private static void readAutenticazioneApiKey(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String apiKey = rs.getString("api_key");
        if (apiKey != null && !"".equals(apiKey)) {
            String appId;
            Property prop = new Property();
            prop.setNome("apiKey");
            if (driverBYOK != null) {
                prop.setValore(driverBYOK.unwrapAsString(apiKey));
            } else {
                prop.setValore(apiKey);
            }
            connettore.addProperty(prop);
            String apiKeyHeader = rs.getString("api_key_header");
            if (apiKeyHeader != null && !"".equals(apiKeyHeader)) {
                prop = new Property();
                prop.setNome("apiKeyHeader");
                prop.setValore(apiKeyHeader.trim());
                connettore.addProperty(prop);
            }
            if ((appId = rs.getString("app_id")) != null && !"".equals(appId)) {
                prop = new Property();
                prop.setNome("appId");
                prop.setValore(appId);
                connettore.addProperty(prop);
                String appIdHeader = rs.getString("app_id_header");
                if (appIdHeader != null && !"".equals(appIdHeader)) {
                    prop = new Property();
                    prop.setNome("appIdHeader");
                    prop.setValore(appIdHeader.trim());
                    connettore.addProperty(prop);
                }
            }
        }
    }

    private static void readConnettoreHttp(ResultSet rs, Connettore connettore) throws DriverConfigurazioneException, SQLException {
        String value = rs.getString("url");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverConfigurazioneException("Connettore di tipo http possiede una url non definita");
        }
        Property prop = new Property();
        prop.setNome("location");
        prop.setValore(value);
        connettore.addProperty(prop);
    }

    private static void readConnettoreJms(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws DriverConfigurazioneException, SQLException, UtilsException {
        String value = rs.getString("nome");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverConfigurazioneException("Connettore di tipo jms possiede il nome della coda/topic non definito");
        }
        Property prop = new Property();
        prop.setNome("location");
        prop.setValore(value);
        connettore.addProperty(prop);
        value = rs.getString("tipo");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo della coda non definito");
        }
        prop = new Property();
        prop.setNome("tipo");
        prop.setValore(value);
        connettore.addProperty(prop);
        value = rs.getString("connection_factory");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverConfigurazioneException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
        }
        prop = new Property();
        prop.setNome("connection-factory");
        prop.setValore(value);
        connettore.addProperty(prop);
        value = rs.getString("send_as");
        if (value != null) {
            value = value.trim();
        }
        if (value == null || "".equals(value) || " ".equals(value)) {
            throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
        }
        prop = new Property();
        prop.setNome("send-as");
        prop.setValore(value);
        connettore.addProperty(prop);
        DriverConfigurazioneDB_connettoriLIB.readConnettoreJmsCredentials(rs, connettore, driverBYOK);
        DriverConfigurazioneDB_connettoriLIB.readConnettoreJmsContext(rs, connettore);
    }

    private static void readConnettoreJmsCredentials(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String usr = rs.getString("utente");
        if (usr != null && !usr.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("user");
            prop.setValore(usr);
            connettore.addProperty(prop);
        }
        String pwd = rs.getString("password");
        String encValue = rs.getString("enc_password");
        if (pwd != null && !pwd.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("password");
            if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                if (driverBYOK != null) {
                    prop.setValore(driverBYOK.unwrapAsString(encValue));
                } else {
                    prop.setValore(encValue);
                }
            } else {
                prop.setValore(pwd);
            }
            connettore.addProperty(prop);
        }
    }

    private static void readConnettoreJmsContext(ResultSet rs, Connettore connettore) throws SQLException {
        String provurl;
        String urlpkg;
        String initcont = rs.getString("initcont");
        if (initcont != null && !initcont.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("context-java.naming.factory.initial");
            prop.setValore(initcont);
            connettore.addProperty(prop);
        }
        if ((urlpkg = rs.getString("urlpkg")) != null && !urlpkg.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("context-java.naming.factory.url.pkgs");
            prop.setValore(urlpkg);
            connettore.addProperty(prop);
        }
        if ((provurl = rs.getString("provurl")) != null && !provurl.trim().equals("")) {
            Property prop = new Property();
            prop.setNome("context-java.naming.provider.url");
            prop.setValore(provurl);
            connettore.addProperty(prop);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void readPropertiesConnettoreCustom(long idConnettore, Connettore connettore, Connection connection, IDriverBYOK driverBYOK) throws DriverConfigurazioneException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            DriverConfigurazioneDBLib.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            while (rs.next()) {
                DriverConfigurazioneDB_connettoriLIB.processPropertiesConnettoreCustom(rs, connettore, driverBYOK);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::readPropertiesConnettoreCustom] SQLException : " + sqle.getMessage(), sqle);
                catch (Exception sqle2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::readPropertiesConnettoreCustom] Exception : " + sqle2.getMessage(), sqle2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
    }

    private static void processPropertiesConnettoreCustom(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String nome = rs.getString("name");
        String valore = rs.getString("value");
        String encValue = rs.getString("enc_value");
        if ("debug".equals(nome)) {
            boolean found = false;
            for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                if (!"debug".equals(connettore.getProperty(i).getNome())) continue;
                found = true;
                break;
            }
            if (found) {
                return;
            }
        }
        Property prop = new Property();
        prop.setNome(nome);
        if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
            if (driverBYOK != null) {
                prop.setValore(driverBYOK.unwrapAsString(encValue));
            } else {
                prop.setValore(encValue);
            }
        } else {
            prop.setValore(valore);
        }
        connettore.addProperty(prop);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readPropertiesConnettoreExtendedInfo(long idConnettore, Connettore connettore, Connection connection, IDriverBYOK driverBYOK) throws DriverConfigurazioneException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            sqlQueryObject.addWhereLikeCondition("name", "-#ext#-%");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            DriverConfigurazioneDBLib.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            while (rs.next()) {
                DriverConfigurazioneDB_connettoriLIB.processPropertiesConnettoreExtendedInfo(rs, connettore, driverBYOK);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::readPropertiesConnettoreExtendedInfo] SQLException : " + sqle.getMessage(), sqle);
                catch (Exception sqle2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::readPropertiesConnettoreExtendedInfo] Exception : " + sqle2.getMessage(), sqle2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
    }

    private static void processPropertiesConnettoreExtendedInfo(ResultSet rs, Connettore connettore, IDriverBYOK driverBYOK) throws SQLException, UtilsException {
        String nome = rs.getString("name");
        String valore = rs.getString("value");
        String encValue = rs.getString("enc_value");
        boolean found = false;
        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
            if (!nome.equals(connettore.getProperty(i).getNome())) continue;
            found = true;
            break;
        }
        if (found) {
            return;
        }
        Property prop = new Property();
        prop.setNome(nome);
        if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
            if (driverBYOK != null) {
                prop.setValore(driverBYOK.unwrapAsString(encValue));
            } else {
                prop.setValore(encValue);
            }
        } else {
            prop.setValore(valore);
        }
        connettore.addProperty(prop);
    }

    protected static boolean isConnettoreAbilitato(Connettore connettore) {
        if (connettore == null) {
            return false;
        }
        String tipo = connettore.getTipo();
        return !TipiConnettore.DISABILITATO.getNome().equals(tipo);
    }

    protected static long getIdConnettoreSARISP(long idServizioApplicativo, Connection con) throws DriverConfigurazioneException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizioApplicativo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore_risp");
            }
            l = idConnettore;
        }
        catch (Exception e) {
            try {
                throw new DriverConfigurazioneException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    protected static long getIdConnettoreSAINV(long idServizioApplicativo, Connection con) throws DriverConfigurazioneException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizioApplicativo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id_connettore_inv");
            }
            l = idConnettore;
        }
        catch (Exception e) {
            try {
                throw new DriverConfigurazioneException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }
}

