/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.DumpConfigurazioneRegola;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_dumpLIB {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void CRUDDumpConfigurazione(int type, Connection con, DumpConfigurazione dumpConfig, Long idProprietario, String tipoProprietario) throws DriverConfigurazioneException {
        PreparedStatement updateStmt = null;
        try {
            switch (type) {
                case 1: {
                    if (dumpConfig == null) {
                        return;
                    }
                    long idRequestIn = -1L;
                    if (dumpConfig.getRichiestaIngresso() != null) {
                        idRequestIn = DriverConfigurazioneDB_dumpLIB.createDumpConfigurazioneRegola(dumpConfig.getRichiestaIngresso(), con);
                    }
                    long idRequestOut = -1L;
                    if (dumpConfig.getRichiestaUscita() != null) {
                        idRequestOut = DriverConfigurazioneDB_dumpLIB.createDumpConfigurazioneRegola(dumpConfig.getRichiestaUscita(), con);
                    }
                    long idResponseIn = -1L;
                    if (dumpConfig.getRispostaIngresso() != null) {
                        idResponseIn = DriverConfigurazioneDB_dumpLIB.createDumpConfigurazioneRegola(dumpConfig.getRispostaIngresso(), con);
                    }
                    long idResponseOut = -1L;
                    if (dumpConfig.getRispostaUscita() != null) {
                        idResponseOut = DriverConfigurazioneDB_dumpLIB.createDumpConfigurazioneRegola(dumpConfig.getRispostaUscita(), con);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("dump_config");
                    sqlQueryObject.addInsertField("proprietario", "?");
                    sqlQueryObject.addInsertField("id_proprietario", "?");
                    sqlQueryObject.addInsertField("dump_realtime", "?");
                    sqlQueryObject.addInsertField("id_richiesta_ingresso", "?");
                    sqlQueryObject.addInsertField("id_richiesta_uscita", "?");
                    sqlQueryObject.addInsertField("id_risposta_ingresso", "?");
                    sqlQueryObject.addInsertField("id_risposta_uscita", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, tipoProprietario);
                    updateStmt.setLong(index++, idProprietario != null ? idProprietario : -1L);
                    updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(dumpConfig.getRealtime()));
                    updateStmt.setLong(index++, idRequestIn);
                    updateStmt.setLong(index++, idRequestOut);
                    updateStmt.setLong(index++, idResponseIn);
                    updateStmt.setLong(index++, idResponseOut);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
                case 2: {
                    DumpConfigurazione dumpConfigOld = DriverConfigurazioneDB_dumpLIB.readDumpConfigurazione(con, idProprietario, tipoProprietario);
                    if (dumpConfigOld != null) {
                        DriverConfigurazioneDB_dumpLIB.CRUDDumpConfigurazione(3, con, dumpConfigOld, idProprietario, tipoProprietario);
                    }
                    if (dumpConfig == null) return;
                    DriverConfigurazioneDB_dumpLIB.CRUDDumpConfigurazione(1, con, dumpConfig, idProprietario, tipoProprietario);
                    return;
                }
                case 3: {
                    if (dumpConfig == null) {
                        return;
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("dump_config_regola");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    if (dumpConfig.getRichiestaIngresso() != null) {
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, dumpConfig.getRichiestaIngresso().getId());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    if (dumpConfig.getRichiestaUscita() != null) {
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, dumpConfig.getRichiestaUscita().getId());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    if (dumpConfig.getRispostaIngresso() != null) {
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, dumpConfig.getRispostaIngresso().getId());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    if (dumpConfig.getRispostaUscita() != null) {
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, dumpConfig.getRispostaUscita().getId());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("dump_config");
                    if (!("config".equals(tipoProprietario) || "configpd".equals(tipoProprietario) || "configpa".equals(tipoProprietario))) {
                        sqlQueryObject.addWhereCondition("id_proprietario=?");
                    }
                    sqlQueryObject.addWhereCondition("proprietario=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    if (!("config".equals(tipoProprietario) || "configpd".equals(tipoProprietario) || "configpa".equals(tipoProprietario))) {
                        updateStmt.setLong(index++, idProprietario);
                    }
                    updateStmt.setString(index++, tipoProprietario);
                    updateStmt.executeUpdate();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDDumpConfigurazione] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDDumpConfigurazione] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    private static long createDumpConfigurazioneRegola(DumpConfigurazioneRegola dumpRegola, Connection con) throws Exception {
        ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
        listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("body", (Object)DriverConfigurazioneDBLib.getValue(dumpRegola.getBody()), InsertAndGeneratedKeyJDBCType.STRING));
        listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("payload", (Object)DriverConfigurazioneDBLib.getValue(dumpRegola.getPayload()), InsertAndGeneratedKeyJDBCType.STRING));
        listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("payload_parsing", (Object)DriverConfigurazioneDBLib.getValue(dumpRegola.getPayloadParsing()), InsertAndGeneratedKeyJDBCType.STRING));
        listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("attachments", (Object)DriverConfigurazioneDBLib.getValue(dumpRegola.getAttachments()), InsertAndGeneratedKeyJDBCType.STRING));
        listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("headers", (Object)DriverConfigurazioneDBLib.getValue(dumpRegola.getHeaders()), InsertAndGeneratedKeyJDBCType.STRING));
        long idDumpconfigurazioneRegola = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)DriverConfigurazioneDBLib.tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("dump_config_regola", "id", "seq_dump_config_regola", "dump_config_regola_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
        if (idDumpconfigurazioneRegola <= 0L) {
            throw new Exception("ID (dump configurazione regola) autoincrementale non ottenuto");
        }
        return idDumpconfigurazioneRegola;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DumpConfigurazione readDumpConfigurazione(Connection con, Long idProprietario, String tipoProprietario) throws Exception {
        DumpConfigurazione dumpConfigurazione;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("dump_config");
            sqlQueryObject.addSelectField("*");
            if (!("config".equals(tipoProprietario) || "configpd".equals(tipoProprietario) || "configpa".equals(tipoProprietario))) {
                sqlQueryObject.addWhereCondition("id_proprietario=?");
            }
            sqlQueryObject.addWhereCondition("proprietario=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            int index = 1;
            if (!("config".equals(tipoProprietario) || "configpd".equals(tipoProprietario) || "configpa".equals(tipoProprietario))) {
                stm1.setLong(index++, idProprietario);
            }
            stm1.setString(index++, tipoProprietario);
            rs1 = stm1.executeQuery();
            DumpConfigurazione dumpConfig = null;
            if (rs1.next()) {
                long idResponseOut;
                long idResponseIn;
                long idRequestOut;
                dumpConfig = new DumpConfigurazione();
                dumpConfig.setId(rs1.getLong("id"));
                dumpConfig.setRealtime(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("dump_realtime")));
                long idRequestIn = rs1.getLong("id_richiesta_ingresso");
                if (idRequestIn > 0L) {
                    dumpConfig.setRichiestaIngresso(DriverConfigurazioneDB_dumpLIB.readDumpConfigurazioneRegola(con, idRequestIn));
                }
                if ((idRequestOut = rs1.getLong("id_richiesta_uscita")) > 0L) {
                    dumpConfig.setRichiestaUscita(DriverConfigurazioneDB_dumpLIB.readDumpConfigurazioneRegola(con, idRequestOut));
                }
                if ((idResponseIn = rs1.getLong("id_risposta_ingresso")) > 0L) {
                    dumpConfig.setRispostaIngresso(DriverConfigurazioneDB_dumpLIB.readDumpConfigurazioneRegola(con, idResponseIn));
                }
                if ((idResponseOut = rs1.getLong("id_risposta_uscita")) > 0L) {
                    dumpConfig.setRispostaUscita(DriverConfigurazioneDB_dumpLIB.readDumpConfigurazioneRegola(con, idResponseOut));
                }
            }
            dumpConfigurazione = dumpConfig;
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs1, stm1);
            throw throwable;
        }
        JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
        return dumpConfigurazione;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DumpConfigurazioneRegola readDumpConfigurazioneRegola(Connection con, long idRegola) throws Exception {
        DumpConfigurazioneRegola dumpConfigurazioneRegola;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("dump_config_regola");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            stm1.setLong(1, idRegola);
            rs1 = stm1.executeQuery();
            DumpConfigurazioneRegola dumpConfig = new DumpConfigurazioneRegola();
            if (rs1.next()) {
                dumpConfig.setId(rs1.getLong("id"));
                dumpConfig.setBody(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("body")));
                dumpConfig.setPayload(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("payload")));
                dumpConfig.setPayloadParsing(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("payload_parsing")));
                dumpConfig.setAttachments(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("attachments")));
                dumpConfig.setHeaders(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("headers")));
            }
            dumpConfigurazioneRegola = dumpConfig;
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs1, stm1);
            throw throwable;
        }
        JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
        return dumpConfigurazioneRegola;
    }
}

