/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_configLIB;
import org.openspcoop2.core.constants.CostantiProprieta;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_genericPropertiesDriver {
    private static Map<String, List<String>> propertiesConfidentials = new HashMap<String, List<String>>();
    private DriverConfigurazioneDB driver = null;
    private DriverConfigurazioneDBUtils utilsDriver = null;

    public static void addConfidentialProperty(String tipo, String nome) {
        List l = propertiesConfidentials.computeIfAbsent(tipo, k -> new ArrayList());
        if (!l.contains(nome)) {
            l.add(nome);
        }
    }

    public static boolean isConfidentialProperty(String tipo, String nome) {
        if (tipo == null || nome == null) {
            return false;
        }
        List<String> l = propertiesConfidentials.get(tipo);
        if (l != null) {
            return DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(l, nome);
        }
        return false;
    }

    private static boolean isConfidentialProperty(List<String> l, String nome) {
        if (l.isEmpty()) {
            return false;
        }
        if (l.contains(nome)) {
            return true;
        }
        if (nome.contains("_@@@_")) {
            return DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialPropertyCustomSeparator(l, nome);
        }
        if (nome.contains("_@@_")) {
            return DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialPropertyDefaultSeparator(l, nome);
        }
        return false;
    }

    private static boolean isConfidentialPropertyCustomSeparator(List<String> l, String nome) {
        String[] tmp = nome.split("_@@@_");
        if (tmp != null && tmp.length > 1 && tmp[1] != null) {
            for (String s : l) {
                if (!tmp[1].equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isConfidentialPropertyDefaultSeparator(List<String> l, String nome) {
        String[] tmp = nome.split("_@@_");
        if (tmp != null && tmp.length > 1 && tmp[1] != null) {
            for (String s : l) {
                if (!tmp[1].equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    protected DriverConfigurazioneDB_genericPropertiesDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
        this.utilsDriver = new DriverConfigurazioneDBUtils(driver);
    }

    protected List<GenericProperties> getGenericProperties() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGenericProperties(null);
    }

    protected List<GenericProperties> getGenericProperties(String tipologia) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<String> listTipologia = new ArrayList<String>();
        if (tipologia != null) {
            listTipologia.add(tipologia);
        }
        return this.getGenericProperties(listTipologia, null, null, true, null);
    }

    protected GenericProperties getGenericProperties(String tipologia, String name) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        List<GenericProperties> l;
        ArrayList<String> listTipologia = new ArrayList<String>();
        if (tipologia != null) {
            listTipologia.add(tipologia);
        }
        if ((l = this.getGenericProperties(listTipologia, null, null, true, name)) == null || l.isEmpty()) {
            throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione Generic Properties non presenti con tipologia '" + tipologia + "' e nome '" + name + "'");
        }
        if (l.size() > 1) {
            throw new DriverConfigurazioneException("[getGenericProperties] Trovata pi\u00f9 di una collezione di propriet\u00e0 con tipologia '" + tipologia + "' e nome '" + name + "'");
        }
        return l.get(0);
    }

    protected List<GenericProperties> getGenericProperties(List<String> tipologia, Integer idLista, ISearch ricerca, boolean throwNotFoundException) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGenericProperties(tipologia, idLista, ricerca, throwNotFoundException, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<GenericProperties> getGenericProperties(List<String> tipologia, Integer idLista, ISearch ricerca, boolean throwNotFoundException, String nomeEsatto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        Integer offset = null;
        Integer limit = null;
        String search = "";
        String filterTipoTokenPolicy = null;
        if (idLista != null && ricerca != null) {
            limit = ricerca.getPageSize(idLista);
            offset = ricerca.getIndexIniziale(idLista);
            search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            filterTipoTokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroTipoTokenPolicy");
            this.driver.logDebug("search : " + search);
            this.driver.logDebug("filterTipoTokenPolicy : " + filterTipoTokenPolicy);
        }
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getGenericProperties");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getGenericProperties] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<Long> listIdLong = new ArrayList<Long>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("generic_properties");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (tipologia != null && !tipologia.isEmpty()) {
                sqlQueryObject.addWhereINCondition("tipologia", true, tipologia.toArray(new String[1]));
            }
            if (filterTipoTokenPolicy != null && !"".equals(filterTipoTokenPolicy)) {
                sqlQueryObject.addWhereCondition("tipo=?");
            }
            if (nomeEsatto != null) {
                sqlQueryObject.addWhereCondition("nome=?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            if (filterTipoTokenPolicy != null && !"".equals(filterTipoTokenPolicy)) {
                stm.setString(index++, filterTipoTokenPolicy);
            }
            if (nomeEsatto != null) {
                stm.setString(index++, nomeEsatto);
            }
            if ((rs = stm.executeQuery()).next() && ricerca != null) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stm.close();
            if (limit != null && limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("generic_properties");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            if (tipologia != null && !tipologia.isEmpty()) {
                sqlQueryObject.addWhereINCondition("tipologia", true, tipologia.toArray(new String[1]));
            }
            if (filterTipoTokenPolicy != null && !"".equals(filterTipoTokenPolicy)) {
                sqlQueryObject.addWhereCondition("tipo=?");
            }
            if (nomeEsatto != null) {
                sqlQueryObject.addWhereCondition("nome=?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            if (limit != null) {
                sqlQueryObject.setLimit(limit.intValue());
            }
            if (offset != null) {
                sqlQueryObject.setOffset(offset.intValue());
            }
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            index = 1;
            if (filterTipoTokenPolicy != null && !"".equals(filterTipoTokenPolicy)) {
                stm.setString(index++, filterTipoTokenPolicy);
            }
            if (nomeEsatto != null) {
                stm.setString(index++, nomeEsatto);
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                long idP = rs.getLong("id");
                listIdLong.add(idP);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getGenericProperties]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getGenericProperties]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        ArrayList<GenericProperties> genericPropertiesList = new ArrayList<GenericProperties>();
        if (!listIdLong.isEmpty()) {
            for (Long id : listIdLong) {
                genericPropertiesList.add(this.getGenericProperties(id));
            }
        }
        if ((genericPropertiesList == null || genericPropertiesList.isEmpty()) && throwNotFoundException) {
            throw new DriverConfigurazioneNotFound("Generic Properties non presenti");
        }
        return genericPropertiesList;
    }

    protected void createGenericProperties(GenericProperties genericProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createGenericProperties");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGenericProperties] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDGenericPropertiesPdD type = 1");
            DriverConfigurazioneDB_configLIB.CRUDGenericProperties(1, genericProperties, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGenericProperties] Errore durante la createSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateGenericProperties(GenericProperties genericProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateGenericProperties");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGenericProperties] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("updateGenericProperties type = 2");
            DriverConfigurazioneDB_configLIB.CRUDGenericProperties(2, genericProperties, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGenericProperties] Errore durante la updateSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteGenericProperties(GenericProperties genericProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteGenericProperties");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGenericProperties] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("deleteGenericProperties type = 3");
            DriverConfigurazioneDB_configLIB.CRUDGenericProperties(3, genericProperties, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGenericProperties] Errore durante la deleteSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected GenericProperties getGenericProperties(long idGenericProperties) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        GenericProperties genericProperties;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stm2 = null;
        ResultSet rs2 = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getGenericProperties");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getGenericProperties] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            GenericProperties genericProperties2 = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("generic_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idGenericProperties);
            rs = stm.executeQuery();
            if (rs.next()) {
                genericProperties2 = new GenericProperties();
                genericProperties2.setNome(rs.getString("nome"));
                genericProperties2.setDescrizione(rs.getString("descrizione"));
                genericProperties2.setTipologia(rs.getString("tipologia"));
                genericProperties2.setTipo(rs.getString("tipo"));
                genericProperties2.setProprietaOggetto(this.utilsDriver.readProprietaOggetto(rs, false));
                long idP = rs.getLong("id");
                genericProperties2.setId(idP);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("generic_property");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_props = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm2 = con.prepareStatement(sqlQuery);
                stm2.setLong(1, idP);
                rs2 = stm2.executeQuery();
                Property genericProperty = null;
                while (rs2.next()) {
                    genericProperty = new Property();
                    genericProperty.setId(rs2.getLong("id"));
                    genericProperty.setNome(rs2.getString("nome"));
                    String plainValue = rs2.getString("valore");
                    String encValue = rs2.getString("enc_value");
                    if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                        IDriverBYOK driverBYOK = this.driver.getDriverUnwrapBYOK();
                        if (driverBYOK != null) {
                            genericProperty.setValore(driverBYOK.unwrapAsString(encValue));
                        } else {
                            genericProperty.setValore(encValue);
                        }
                    } else {
                        genericProperty.setValore(plainValue);
                    }
                    genericProperties2.addProperty(genericProperty);
                }
                rs2.close();
                stm2.close();
            }
            rs.close();
            stm.close();
            if (genericProperties2 == null) {
                throw new DriverConfigurazioneNotFound("Generic Properties non presenti");
            }
            genericProperties = genericProperties2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getGenericProperties]  SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound e) {
                    throw new DriverConfigurazioneNotFound(e);
                }
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getGenericProperties]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs2, stm2);
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(rs2, stm2);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return genericProperties;
    }

    static {
        propertiesConfidentials.put("validationToken", CostantiProprieta.getTokenValidationProperties());
        propertiesConfidentials.put("retrieveToken", CostantiProprieta.getTokenRetrieveProperties());
        propertiesConfidentials.put("attributeAuthority", CostantiProprieta.getAttributeAuthorityProperties());
        List<String> messageSecurityIds = CostantiProprieta.getMessageSecurityIds();
        if (messageSecurityIds != null && !messageSecurityIds.isEmpty()) {
            for (String id : messageSecurityIds) {
                propertiesConfidentials.put(id, CostantiProprieta.getMessageSecurityProperties(id));
            }
        }
    }
}

