/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_gestioneErroreLIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_gestioneErroreDriver {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDB_gestioneErroreDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    protected GestioneErrore getGestioneErroreComponenteCooperazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGestioneErrore(true);
    }

    protected GestioneErrore getGestioneErroreComponenteIntegrazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGestioneErrore(false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GestioneErrore getGestioneErrore(boolean cooperazione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        GestioneErrore gestioneErrore;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        String tipoOperazione = "GestioneErrore per componente di Cooperazione";
        if (!cooperazione) {
            tipoOperazione = "GestioneErrore per componente di Integrazione";
        }
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getGestioneErrore(" + cooperazione + ")");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[" + tipoOperazione + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            Long idGestioneErrore;
            GestioneErrore gestioneErrore2 = null;
            String nomeColonna = "id_ge_cooperazione";
            if (!cooperazione) {
                nomeColonna = "id_ge_integrazione";
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField(nomeColonna);
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            if (rs.next() && (idGestioneErrore = Long.valueOf(rs.getLong(nomeColonna))) > 0L) {
                gestioneErrore2 = DriverConfigurazioneDB_gestioneErroreLIB.getGestioneErrore(idGestioneErrore, con);
            }
            rs.close();
            stm.close();
            if (gestioneErrore2 == null) {
                throw new DriverConfigurazioneNotFound(tipoOperazione + " non presente.");
            }
            gestioneErrore = gestioneErrore2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException(tipoOperazione + " SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound e) {
                    throw new DriverConfigurazioneNotFound(e);
                }
                catch (Exception se2) {
                    throw new DriverConfigurazioneException(tipoOperazione + " Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return gestioneErrore;
    }

    protected void createGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createGestioneErroreComponenteCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGestioneErroreComponenteCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        PreparedStatement pstmt = null;
        try {
            this.driver.logDebug("CRUDGestioneErrore type = 1");
            DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreComponenteCooperazione(1, gestione, con);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addUpdateTable("configurazione");
            sqlQueryObject.addUpdateField("id_ge_cooperazione", "?");
            String updateQuery = sqlQueryObject.createSQLUpdate();
            pstmt = con.prepareStatement(updateQuery);
            pstmt.setLong(1, gestione.getId());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGestioneErroreComponenteCooperazione] Errore: " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(pstmt);
                this.driver.closeConnection(error, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)pstmt);
        this.driver.closeConnection(error, con);
    }

    protected void updateGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateGestioneErroreComponenteCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGestioneErroreComponenteCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDGestioneErrore type = 2");
            DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreComponenteCooperazione(2, gestione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGestioneErroreComponenteCooperazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteGestioneErroreComponenteCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGestioneErroreComponenteCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDGestioneErrore type = 3");
            DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreComponenteCooperazione(3, gestione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGestioneErroreComponenteCooperazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void createGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createGestioneErroreComponenteIntegrazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGestioneErroreComponenteIntegrazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        PreparedStatement pstmt = null;
        try {
            this.driver.logDebug("CRUDGestioneErrore type = 1");
            DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreComponenteIntegrazione(1, gestione, con);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addUpdateTable("configurazione");
            sqlQueryObject.addUpdateField("id_ge_integrazione", "?");
            String updateQuery = sqlQueryObject.createSQLUpdate();
            pstmt = con.prepareStatement(updateQuery);
            pstmt.setLong(1, gestione.getId());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception qe) {
            try {
                error = true;
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGestioneErroreComponenteIntegrazione] Errore: " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(pstmt);
                this.driver.closeConnection(error, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)pstmt);
        this.driver.closeConnection(error, con);
    }

    protected void updateGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateGestioneErroreComponenteIntegrazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGestioneErroreComponenteIntegrazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDGestioneErrore type = 2");
            DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreComponenteIntegrazione(2, gestione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGestioneErroreComponenteIntegrazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteGestioneErroreComponenteIntegrazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGestioneErroreComponenteIntegrazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDGestioneErrore type = 3");
            DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreComponenteIntegrazione(3, gestione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGestioneErroreComponenteIntegrazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }
}

