/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.GestioneErroreCodiceTrasporto;
import org.openspcoop2.core.config.GestioneErroreSoapFault;
import org.openspcoop2.core.config.constants.GestioneErroreComportamento;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_gestioneErroreLIB {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GestioneErrore getGestioneErrore(long idGestioneErrore, Connection con) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        GestioneErrore gestioneErrore;
        GestioneErrore gestioneErrore2 = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("gestione_errore");
            sqlQueryObject.addSelectField("comportamento_default");
            sqlQueryObject.addSelectField("cadenza_rispedizione");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addWhereCondition("id=?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            DriverConfigurazioneDBLib.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idGestioneErrore);
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("Gestione errore con id[" + idGestioneErrore + "] non presente");
            }
            gestioneErrore2 = new GestioneErrore();
            gestioneErrore2.setId(idGestioneErrore);
            gestioneErrore2.setComportamento(GestioneErroreComportamento.toEnumConstant(rs.getString("comportamento_default")));
            gestioneErrore2.setCadenzaRispedizione(rs.getString("cadenza_rispedizione"));
            gestioneErrore2.setNome(rs.getString("nome"));
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("gestione_errore_trasporto");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_gestione_errore = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            stm1.setLong(1, gestioneErrore2.getId());
            rs1 = stm1.executeQuery();
            while (rs1.next()) {
                GestioneErroreCodiceTrasporto trasporto = new GestioneErroreCodiceTrasporto();
                trasporto.setComportamento(GestioneErroreComportamento.toEnumConstant(rs1.getString("comportamento")));
                trasporto.setCadenzaRispedizione(rs1.getString("cadenza_rispedizione"));
                if (rs1.getLong("valore_massimo") > 0L) {
                    String maxVal = "" + rs1.getLong("valore_massimo");
                    trasporto.setValoreMassimo(!maxVal.equals("") ? Integer.valueOf(maxVal) : null);
                }
                if (rs1.getLong("valore_minimo") > 0L) {
                    String minVal = "" + rs1.getLong("valore_minimo");
                    trasporto.setValoreMinimo(!minVal.equals("") ? Integer.valueOf(minVal) : null);
                }
                gestioneErrore2.addCodiceTrasporto(trasporto);
            }
            rs1.close();
            stm1.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("gestione_errore_soap");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_gestione_errore = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            stm1.setLong(1, gestioneErrore2.getId());
            rs1 = stm1.executeQuery();
            while (rs1.next()) {
                GestioneErroreSoapFault soap = new GestioneErroreSoapFault();
                soap.setComportamento(GestioneErroreComportamento.toEnumConstant(rs1.getString("comportamento")));
                soap.setCadenzaRispedizione(rs1.getString("cadenza_rispedizione"));
                soap.setFaultActor(rs1.getString("fault_actor"));
                soap.setFaultCode(rs1.getString("fault_code"));
                soap.setFaultString(rs1.getString("fault_string"));
                gestioneErrore2.addSoapFault(soap);
            }
            rs1.close();
            stm1.close();
            rs.close();
            stm.close();
            gestioneErrore = gestioneErrore2;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException(" SqlException: " + se.getMessage(), se);
                catch (DriverConfigurazioneNotFound e) {
                    throw new DriverConfigurazioneNotFound(e);
                }
                catch (Exception se2) {
                    throw new DriverConfigurazioneException(" Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs1, stm1);
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return gestioneErrore;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdGestioneErrore(String nomeGestioneErrore, Connection con) throws DriverConfigurazioneException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idGestioneErrore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("gestione_errore");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, nomeGestioneErrore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idGestioneErrore = rs.getLong("id");
            }
            l = idGestioneErrore;
        }
        catch (SQLException e) {
            try {
                throw new DriverConfigurazioneException(e);
                catch (Exception e2) {
                    throw new DriverConfigurazioneException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long CRUDGestioneErroreServizioApplicativo(int type, GestioneErrore gestioneErrore, long idSoggettoProprietario, long idServizioApplicativo, boolean invocazioneServizio, Connection con) throws DriverConfigurazioneException {
        if (invocazioneServizio) {
            return DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErrore(type, gestioneErrore, idSoggettoProprietario, idServizioApplicativo, 1, con);
        }
        return DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErrore(type, gestioneErrore, idSoggettoProprietario, idServizioApplicativo, 2, con);
    }

    public static long CRUDGestioneErroreComponenteCooperazione(int type, GestioneErrore gestioneErrore, Connection con) throws DriverConfigurazioneException {
        return DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErrore(type, gestioneErrore, -1L, -1L, 3, con);
    }

    public static long CRUDGestioneErroreComponenteIntegrazione(int type, GestioneErrore gestioneErrore, Connection con) throws DriverConfigurazioneException {
        return DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErrore(type, gestioneErrore, -1L, -1L, 4, con);
    }

    private static long CRUDGestioneErrore(int type, GestioneErrore gestioneErrore, long idSoggettoProprietario, long idServizioApplicativo, int tipoCRUD, Connection con) throws DriverConfigurazioneException {
        if (gestioneErrore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Parametro non valido.");
        }
        Object nomeGestioneErrore = null;
        if (tipoCRUD == 1 || tipoCRUD == 2) {
            if (idSoggettoProprietario <= 0L) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Soggetto proprietario non fornito.");
            }
            if (idServizioApplicativo <= 0L) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Servizio applicativo non fornito.");
            }
            nomeGestioneErrore = "Soggetto(" + idSoggettoProprietario + ")_SA(" + idServizioApplicativo + ")_";
            nomeGestioneErrore = tipoCRUD == 1 ? (String)nomeGestioneErrore + "INV" : (String)nomeGestioneErrore + "RISP";
        } else if (tipoCRUD == 3) {
            nomeGestioneErrore = "componenteCooperazioneGestioneErroreDefaultPdD";
        } else if (tipoCRUD == 4) {
            nomeGestioneErrore = "componenteIntegrazioneGestioneErroreDefaultPdD";
        }
        gestioneErrore.setNome((String)nomeGestioneErrore);
        int tipoOperazione = type;
        long idGestioneErroreChange = -1L;
        if (type == 2) {
            try {
                idGestioneErroreChange = DriverConfigurazioneDB_gestioneErroreLIB.getIdGestioneErrore((String)nomeGestioneErrore, con);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), e);
            }
            if (idGestioneErroreChange <= 0L) {
                tipoOperazione = 1;
            }
        }
        PreparedStatement updateStmt = null;
        PreparedStatement selectStmt = null;
        String updateQuery = "";
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (tipoOperazione) {
                case 1: {
                    int i;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("gestione_errore");
                    sqlQueryObject.addInsertField("comportamento_default", "?");
                    sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, DriverConfigurazioneDBLib.getValue(gestioneErrore.getComportamento()));
                    updateStmt.setString(2, gestioneErrore.getCadenzaRispedizione());
                    updateStmt.setString(3, gestioneErrore.getNome());
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getComportamento(), gestioneErrore.getCadenzaRispedizione(), gestioneErrore.getNome()));
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore type = " + type + " row affected =" + n);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable("gestione_errore");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, gestioneErrore.getNome());
                    selectRS = selectStmt.executeQuery();
                    if (!selectRS.next()) {
                        throw new Exception("id gestione errore non trovato dopo inserimento con nome [" + gestioneErrore.getNome() + "]");
                    }
                    gestioneErrore.setId(selectRS.getLong("id"));
                    selectRS.close();
                    selectStmt.close();
                    for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
                        GestioneErroreCodiceTrasporto tr = gestioneErrore.getCodiceTrasporto(i);
                        int valoreMassimo = -1;
                        int valoreMinimo = -1;
                        if (tr.getValoreMassimo() != null) {
                            valoreMassimo = tr.getValoreMassimo();
                        }
                        if (tr.getValoreMinimo() != null) {
                            valoreMinimo = tr.getValoreMinimo();
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("gestione_errore_trasporto");
                        sqlQueryObject.addInsertField("id_gestione_errore", "?");
                        if (valoreMassimo >= 0) {
                            sqlQueryObject.addInsertField("valore_massimo", "?");
                        }
                        if (valoreMinimo >= 0) {
                            sqlQueryObject.addInsertField("valore_minimo", "?");
                        }
                        sqlQueryObject.addInsertField("comportamento", "?");
                        sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        int index = 1;
                        updateStmt.setLong(index, gestioneErrore.getId());
                        ++index;
                        if (valoreMassimo >= 0) {
                            updateStmt.setInt(index, valoreMassimo);
                            ++index;
                        }
                        if (valoreMinimo >= 0) {
                            updateStmt.setInt(index, valoreMinimo);
                            ++index;
                        }
                        updateStmt.setString(index, DriverConfigurazioneDBLib.getValue(tr.getComportamento()));
                        updateStmt.setString(++index, tr.getCadenzaRispedizione());
                        ++index;
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        if (valoreMassimo >= 0 && valoreMinimo >= 0) {
                            DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione()));
                        } else if (valoreMassimo >= 0) {
                            DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, tr.getComportamento(), tr.getCadenzaRispedizione()));
                        } else if (valoreMinimo >= 0) {
                            DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione()));
                        } else {
                            DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), tr.getComportamento(), tr.getCadenzaRispedizione()));
                        }
                        DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") type = " + type + " row affected =" + n);
                    }
                    for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                        GestioneErroreSoapFault sf = gestioneErrore.getSoapFault(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("gestione_errore_soap");
                        sqlQueryObject.addInsertField("id_gestione_errore", "?");
                        sqlQueryObject.addInsertField("fault_actor", "?");
                        sqlQueryObject.addInsertField("fault_code", "?");
                        sqlQueryObject.addInsertField("fault_string", "?");
                        sqlQueryObject.addInsertField("comportamento", "?");
                        sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, gestioneErrore.getId());
                        updateStmt.setString(2, sf.getFaultActor());
                        updateStmt.setString(3, sf.getFaultCode());
                        updateStmt.setString(4, sf.getFaultString());
                        updateStmt.setString(5, DriverConfigurazioneDBLib.getValue(sf.getComportamento()));
                        updateStmt.setString(6, sf.getCadenzaRispedizione());
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_SoapFault(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), sf.getFaultActor(), sf.getFaultCode(), sf.getFaultString(), sf.getComportamento(), sf.getCadenzaRispedizione()));
                        DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_SoapFault(" + i + ") type = " + type + " row affected =" + n);
                    }
                    break;
                }
                case 2: {
                    int i;
                    gestioneErrore.setId(idGestioneErroreChange);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("gestione_errore");
                    sqlQueryObject.addUpdateField("comportamento_default", "?");
                    sqlQueryObject.addUpdateField("cadenza_rispedizione", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, DriverConfigurazioneDBLib.getValue(gestioneErrore.getComportamento()));
                    updateStmt.setString(2, gestioneErrore.getCadenzaRispedizione());
                    updateStmt.setLong(3, idGestioneErroreChange);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore UPDATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getComportamento(), gestioneErrore.getCadenzaRispedizione(), idGestioneErroreChange));
                    DriverConfigurazioneDBLib.log.debug("CRUGestioneErrore type = " + type + " row affected =" + n);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore_trasporto");
                    sqlQueryObject.addWhereCondition("id_gestione_errore=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErroreChange);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore (Delete old trasporto) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErroreChange));
                    DriverConfigurazioneDBLib.log.debug("CRUGestioneErrore (Delete old trasporto) type = " + type + " row affected =" + n);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore_soap");
                    sqlQueryObject.addWhereCondition("id_gestione_errore=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErroreChange);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore (Delete old soap fault) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErroreChange));
                    DriverConfigurazioneDBLib.log.debug("CRUGestioneErrore (Delete old soap fault) type = " + type + " row affected =" + n);
                    for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
                        GestioneErroreCodiceTrasporto tr = gestioneErrore.getCodiceTrasporto(i);
                        int valoreMassimo = -1;
                        int valoreMinimo = -1;
                        if (tr.getValoreMassimo() != null) {
                            valoreMassimo = tr.getValoreMassimo();
                        }
                        if (tr.getValoreMinimo() != null) {
                            valoreMinimo = tr.getValoreMinimo();
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("gestione_errore_trasporto");
                        sqlQueryObject.addInsertField("id_gestione_errore", "?");
                        if (valoreMassimo >= 0) {
                            sqlQueryObject.addInsertField("valore_massimo", "?");
                        }
                        if (valoreMinimo >= 0) {
                            sqlQueryObject.addInsertField("valore_minimo", "?");
                        }
                        sqlQueryObject.addInsertField("comportamento", "?");
                        sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        int index = 1;
                        updateStmt.setLong(index, gestioneErrore.getId());
                        ++index;
                        if (valoreMassimo >= 0) {
                            updateStmt.setInt(index, valoreMassimo);
                            ++index;
                        }
                        if (valoreMinimo >= 0) {
                            updateStmt.setInt(index, valoreMinimo);
                            ++index;
                        }
                        updateStmt.setString(index, DriverConfigurazioneDBLib.getValue(tr.getComportamento()));
                        updateStmt.setString(++index, tr.getCadenzaRispedizione());
                        ++index;
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        if (valoreMassimo >= 0 && valoreMinimo >= 0) {
                            DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione()));
                        } else if (valoreMassimo >= 0) {
                            DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, tr.getComportamento(), tr.getCadenzaRispedizione()));
                        } else if (valoreMinimo >= 0) {
                            DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione()));
                        } else {
                            DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), tr.getComportamento(), tr.getCadenzaRispedizione()));
                        }
                        DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_Trasporto(" + i + ") type = " + type + " row affected =" + n);
                    }
                    for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                        GestioneErroreSoapFault sf = gestioneErrore.getSoapFault(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("gestione_errore_soap");
                        sqlQueryObject.addInsertField("id_gestione_errore", "?");
                        sqlQueryObject.addInsertField("fault_actor", "?");
                        sqlQueryObject.addInsertField("fault_code", "?");
                        sqlQueryObject.addInsertField("fault_string", "?");
                        sqlQueryObject.addInsertField("comportamento", "?");
                        sqlQueryObject.addInsertField("cadenza_rispedizione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, gestioneErrore.getId());
                        updateStmt.setString(2, sf.getFaultActor());
                        updateStmt.setString(3, sf.getFaultCode());
                        updateStmt.setString(4, sf.getFaultString());
                        updateStmt.setString(5, DriverConfigurazioneDBLib.getValue(sf.getComportamento()));
                        updateStmt.setString(6, sf.getCadenzaRispedizione());
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_SoapFault(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), sf.getFaultActor(), sf.getFaultCode(), sf.getFaultString(), sf.getComportamento(), sf.getCadenzaRispedizione()));
                        DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore_SoapFault(" + i + ") type = " + type + " row affected =" + n);
                    }
                    break;
                }
                case 3: {
                    long idGestioneErrore = DriverConfigurazioneDB_gestioneErroreLIB.getIdGestioneErrore((String)nomeGestioneErrore, con);
                    gestioneErrore.setId(idGestioneErrore);
                    if (idGestioneErrore <= 0L) break;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore_trasporto");
                    sqlQueryObject.addWhereCondition("id_gestione_errore=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErrore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore (Delete trasporto) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore));
                    DriverConfigurazioneDBLib.log.debug("CRUGestioneErrore (Delete trasporto) type = " + type + " row affected =" + n);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore_soap");
                    sqlQueryObject.addWhereCondition("id_gestione_errore=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErrore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore (Delete soap fault) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore));
                    DriverConfigurazioneDBLib.log.debug("CRUGestioneErrore (Delete soap fault) type = " + type + " row affected =" + n);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("gestione_errore");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idGestioneErrore);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore type = " + type + " row affected =" + n);
                    DriverConfigurazioneDBLib.log.debug("CRUDGestioneErrore DELETE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore));
                }
            }
            long sqlQueryObject = n;
            return sqlQueryObject;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }
}

