/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.core.config.ConfigurazioneHandler;
import org.openspcoop2.core.config.ConfigurazioneMessageHandlers;
import org.openspcoop2.core.config.ConfigurazioneServiceHandlers;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_handlerLIB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ConfigurazioneMessageHandlers readConfigurazioneMessageHandlers(Connection con, Long idPortaDelegata, Long idPortaApplicatva, boolean request) throws Exception {
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        try {
            ConfigurazioneMessageHandlers config = null;
            String tabella = "config_handlers";
            if (idPortaDelegata != null) {
                tabella = "pd_handlers";
            } else if (idPortaApplicatva != null) {
                tabella = "pa_handlers";
            }
            ArrayList<CallSite> tipologie = new ArrayList<CallSite>();
            String suffix = request ? "Request" : "Response";
            tipologie.add((CallSite)((Object)("PreIn" + suffix)));
            tipologie.add((CallSite)((Object)("In" + suffix)));
            if (request) {
                tipologie.add((CallSite)((Object)("InProtocol" + suffix)));
            }
            tipologie.add((CallSite)((Object)("Out" + suffix)));
            tipologie.add((CallSite)((Object)("PostOut" + suffix)));
            for (String string : tipologie) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addFromTable(tabella);
                sqlQueryObject.addSelectField("*");
                if (idPortaDelegata != null || idPortaApplicatva != null) {
                    sqlQueryObject.addWhereCondition("id_porta=?");
                }
                sqlQueryObject.addWhereCondition("tipologia=?");
                sqlQueryObject.addOrderBy("posizione");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                int index = 1;
                if (idPortaDelegata != null) {
                    stm1.setLong(index++, idPortaDelegata);
                } else if (idPortaApplicatva != null) {
                    stm1.setLong(index++, idPortaApplicatva);
                }
                stm1.setString(index++, string);
                rs1 = stm1.executeQuery();
                ArrayList<ConfigurazioneHandler> list = new ArrayList<ConfigurazioneHandler>();
                while (rs1.next()) {
                    ConfigurazioneHandler handler = new ConfigurazioneHandler();
                    handler.setId(rs1.getLong("id"));
                    handler.setTipo(rs1.getString("tipo"));
                    handler.setPosizione(rs1.getInt("posizione"));
                    String stato = rs1.getString("stato");
                    if (stato != null && !"".equals(stato)) {
                        handler.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(stato));
                    }
                    list.add(handler);
                }
                rs1.close();
                stm1.close();
                if (list.isEmpty()) continue;
                if (config == null) {
                    config = new ConfigurazioneMessageHandlers();
                }
                if (string.startsWith("PreIn")) {
                    config.setPreInList(list);
                    continue;
                }
                if (string.startsWith("InProtocol")) {
                    config.setInProtocolInfoList(list);
                    continue;
                }
                if (string.startsWith("In")) {
                    config.setInList(list);
                    continue;
                }
                if (string.startsWith("Out")) {
                    config.setOutList(list);
                    continue;
                }
                if (!string.startsWith("PostOut")) continue;
                config.setPostOutList(list);
            }
            Iterator iterator = config;
            return iterator;
        }
        finally {
            JDBCUtilities.closeResources(rs1, stm1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ConfigurazioneServiceHandlers readConfigurazioneServiceHandlers(Connection con, Long idPortaDelegata, Long idPortaApplicatva, boolean request) throws Exception {
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        try {
            ConfigurazioneServiceHandlers config = null;
            String tabella = "config_handlers";
            if (idPortaDelegata != null) {
                tabella = "pd_handlers";
            } else if (idPortaApplicatva != null) {
                tabella = "pa_handlers";
            }
            ArrayList<String> tipologie = new ArrayList<String>();
            tipologie.add("Init");
            tipologie.add("Exit");
            tipologie.add("IntegrationManagerRequest");
            tipologie.add("IntegrationManagerResponse");
            for (String tipologia : tipologie) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addFromTable(tabella);
                sqlQueryObject.addSelectField("*");
                if (idPortaDelegata != null || idPortaApplicatva != null) {
                    sqlQueryObject.addWhereCondition("id_porta=?");
                }
                sqlQueryObject.addWhereCondition("tipologia=?");
                sqlQueryObject.addOrderBy("posizione");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                int index = 1;
                if (idPortaDelegata != null) {
                    stm1.setLong(index++, idPortaDelegata);
                } else if (idPortaApplicatva != null) {
                    stm1.setLong(index++, idPortaApplicatva);
                }
                stm1.setString(index++, tipologia);
                rs1 = stm1.executeQuery();
                ArrayList<ConfigurazioneHandler> list = new ArrayList<ConfigurazioneHandler>();
                while (rs1.next()) {
                    ConfigurazioneHandler handler = new ConfigurazioneHandler();
                    handler.setId(rs1.getLong("id"));
                    handler.setTipo(rs1.getString("tipo"));
                    handler.setPosizione(rs1.getInt("posizione"));
                    String stato = rs1.getString("stato");
                    if (stato != null && !"".equals(stato)) {
                        handler.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(stato));
                    }
                    list.add(handler);
                }
                rs1.close();
                stm1.close();
                if (list.isEmpty()) continue;
                if (config == null) {
                    config = new ConfigurazioneServiceHandlers();
                }
                if (tipologia.equals("Init")) {
                    config.setInitList(list);
                    continue;
                }
                if (tipologia.equals("Exit")) {
                    config.setExitList(list);
                    continue;
                }
                if (tipologia.equals("IntegrationManagerRequest")) {
                    config.setIntegrationManagerRequestList(list);
                    continue;
                }
                if (!tipologia.equals("IntegrationManagerResponse")) continue;
                config.setIntegrationManagerResponseList(list);
            }
            Iterator iterator = config;
            return iterator;
        }
        finally {
            JDBCUtilities.closeResources(rs1, stm1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void CRUDConfigurazioneMessageHandlers(int type, Connection con, Long idPortaDelegata, Long idPortaApplicatva, boolean request, ConfigurazioneMessageHandlers config) throws DriverConfigurazioneException {
        Long idPorta = null;
        String tabella = "config_handlers";
        if (idPortaDelegata != null) {
            tabella = "pd_handlers";
            idPorta = idPortaDelegata;
        } else if (idPortaApplicatva != null) {
            tabella = "pa_handlers";
            idPorta = idPortaApplicatva;
        }
        String suffix = request ? "Request" : "Response";
        PreparedStatement updateStmt = null;
        try {
            switch (type) {
                case 1: {
                    if (config == null) {
                        return;
                    }
                    DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getPreInList(), tabella, "PreIn" + suffix, idPorta);
                    DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getInList(), tabella, "In" + suffix, idPorta);
                    if (request) {
                        DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getInProtocolInfoList(), tabella, "InProtocol" + suffix, idPorta);
                    }
                    DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getOutList(), tabella, "Out" + suffix, idPorta);
                    DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getPostOutList(), tabella, "PostOut" + suffix, idPorta);
                    return;
                }
                case 2: {
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(3, con, idPortaDelegata, idPortaApplicatva, request, null);
                    if (config == null) return;
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(1, con, idPortaDelegata, idPortaApplicatva, request, config);
                    return;
                }
                case 3: {
                    ArrayList<CallSite> tipologie = new ArrayList<CallSite>();
                    tipologie.add((CallSite)((Object)("PreIn" + suffix)));
                    tipologie.add((CallSite)((Object)("In" + suffix)));
                    if (request) {
                        tipologie.add((CallSite)((Object)("InProtocol" + suffix)));
                    }
                    tipologie.add((CallSite)((Object)("Out" + suffix)));
                    tipologie.add((CallSite)((Object)("PostOut" + suffix)));
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable(tabella);
                    sqlQueryObject.setANDLogicOperator(true);
                    if (idPorta != null) {
                        sqlQueryObject.addWhereCondition("id_porta=?");
                    }
                    sqlQueryObject.addWhereINCondition("tipologia", true, tipologie.toArray(new String[1]));
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    if (idPorta != null) {
                        updateStmt.setLong(index++, idPorta);
                    }
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneMessageHandlers] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneMessageHandlers] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void CRUDConfigurazioneServiceHandlers(int type, Connection con, Long idPortaDelegata, Long idPortaApplicatva, boolean request, ConfigurazioneServiceHandlers config) throws DriverConfigurazioneException {
        Long idPorta = null;
        String tabella = "config_handlers";
        if (idPortaDelegata != null) {
            tabella = "pd_handlers";
            idPorta = idPortaDelegata;
        } else if (idPortaApplicatva != null) {
            tabella = "pa_handlers";
            idPorta = idPortaApplicatva;
        }
        String suffix = request ? "Request" : "Response";
        PreparedStatement updateStmt = null;
        try {
            switch (type) {
                case 1: {
                    if (config == null) {
                        return;
                    }
                    DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getInitList(), tabella, "Init", idPorta);
                    DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getExitList(), tabella, "Exit", idPorta);
                    DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getIntegrationManagerRequestList(), tabella, "IntegrationManagerRequest", idPorta);
                    DriverConfigurazioneDB_handlerLIB.createConfigurazioneHandlers(con, config.getIntegrationManagerResponseList(), tabella, "IntegrationManagerResponse", idPorta);
                    return;
                }
                case 2: {
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneServiceHandlers(3, con, idPortaDelegata, idPortaApplicatva, request, null);
                    if (config == null) return;
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneServiceHandlers(1, con, idPortaDelegata, idPortaApplicatva, request, config);
                    return;
                }
                case 3: {
                    ArrayList<String> tipologie = new ArrayList<String>();
                    tipologie.add("Init");
                    tipologie.add("Exit");
                    tipologie.add("IntegrationManagerRequest");
                    tipologie.add("IntegrationManagerResponse");
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable(tabella);
                    sqlQueryObject.setANDLogicOperator(true);
                    if (idPorta != null) {
                        sqlQueryObject.addWhereCondition("id_porta=?");
                    }
                    sqlQueryObject.addWhereINCondition("tipologia", true, tipologie.toArray(new String[1]));
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    if (idPorta != null) {
                        updateStmt.setLong(index++, idPorta);
                    }
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneMessageHandlers] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneMessageHandlers] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createConfigurazioneHandlers(Connection con, List<ConfigurazioneHandler> list, String tabella, String tipologia, Long idPorta) throws Exception {
        if (list != null && !list.isEmpty()) {
            for (ConfigurazioneHandler handler : list) {
                PreparedStatement updateStmt = null;
                try {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable(tabella);
                    if (idPorta != null) {
                        sqlQueryObject.addInsertField("id_porta", "?");
                    }
                    sqlQueryObject.addInsertField("tipologia", "?");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("posizione", "?");
                    sqlQueryObject.addInsertField("stato", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    if (idPorta != null) {
                        updateStmt.setLong(index++, idPorta);
                    }
                    updateStmt.setString(index++, tipologia);
                    updateStmt.setString(index++, handler.getTipo());
                    updateStmt.setInt(index++, handler.getPosizione());
                    updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(handler.getStato()));
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    updateStmt = null;
                }
                catch (Throwable throwable) {
                    JDBCUtilities.closeResources(updateStmt);
                    throw throwable;
                }
                JDBCUtilities.closeResources((PreparedStatement)updateStmt);
            }
        }
    }
}

