/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.RegistroPlugins;
import org.openspcoop2.core.config.constants.PluginSorgenteArchivio;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_pluginsLIB;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_pluginsDriver {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDB_pluginsDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RegistroPlugins getRegistroPlugins() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getRegistroPlugins");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getRegistroPlugins] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        RegistroPlugins registro = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("posizione", true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            ArrayList<String> nomi = new ArrayList<String>();
            while (rs.next()) {
                nomi.add(rs.getString("nome"));
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
            if (!nomi.isEmpty()) {
                if (registro == null) {
                    registro = new RegistroPlugins();
                }
                for (String nome : nomi) {
                    registro.addPlugin(this.getRegistroPlugin(con, nome));
                }
            }
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getRegistroPlugins]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getRegistroPlugins]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        if (registro != null && registro.sizePluginList() > 0) {
            return registro;
        }
        throw new DriverConfigurazioneNotFound("Nessun plugin registrato");
    }

    protected RegistroPlugin getRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getRegistroPlugin(nome, false);
    }

    protected RegistroPlugin getDatiRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getRegistroPlugin(nome, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegistroPlugin getRegistroPlugin(String nome, boolean soloDati) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getRegistroPlugin");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            RegistroPlugin registroPlugin = this.getRegistroPlugin(con, nome, soloDati);
            return registroPlugin;
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected RegistroPlugin getRegistroPlugin(Connection conParam, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getRegistroPlugin(conParam, nome, false);
    }

    protected RegistroPlugin getDatiRegistroPlugin(Connection conParam, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getRegistroPlugin(conParam, nome, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RegistroPlugin getRegistroPlugin(Connection conParam, String nome, boolean soloDati) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        RegistroPlugin plugin = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                plugin = new RegistroPlugin();
                plugin.setId(rs.getLong("id"));
                plugin.setNome(rs.getString("nome"));
                plugin.setPosizione(rs.getInt("posizione"));
                StatoFunzionalita stato = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("stato"));
                plugin.setStato(stato);
                plugin.setDescrizione(rs.getString("descrizione"));
                plugin.setData(rs.getTimestamp("data"));
                String compatibilita = rs.getString("compatibilita");
                if (compatibilita != null && !"".equals(compatibilita)) {
                    if (compatibilita.contains(",")) {
                        String[] tmp = compatibilita.split(",");
                        for (int i = 0; i < tmp.length; ++i) {
                            plugin.addCompatibilita(tmp[i].trim());
                        }
                    } else {
                        plugin.addCompatibilita(compatibilita);
                    }
                }
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
            if (plugin != null && !soloDati) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("registro_plug_jar");
                sqlQueryObject.addWhereCondition("id_plugin=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = conParam.prepareStatement(sqlQuery);
                stm.setLong(1, plugin.getId());
                rs = stm.executeQuery();
                while (rs.next()) {
                    RegistroPluginArchivio archivio = new RegistroPluginArchivio();
                    archivio.setNome(rs.getString("nome"));
                    archivio.setData(rs.getTimestamp("data"));
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                    archivio.setSorgente(DriverConfigurazioneDBLib.getEnumPluginSorgenteArchivio(rs.getString("sorgente")));
                    switch (archivio.getSorgente()) {
                        case JAR: {
                            archivio.setContenuto(jdbcAdapter.getBinaryData(rs, "contenuto"));
                            break;
                        }
                        case URL: {
                            archivio.setUrl(rs.getString("url"));
                            break;
                        }
                        case DIR: {
                            archivio.setDir(rs.getString("dir"));
                            break;
                        }
                    }
                    plugin.addArchivio(archivio);
                }
                rs.close();
                stm.close();
                rs = null;
                stm = null;
            }
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getRegistroPlugin]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getRegistroPlugin]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        if (plugin == null) {
            throw new DriverConfigurazioneNotFound("Plugin '" + nome + "' non esistente");
        }
        return plugin;
    }

    protected RegistroPlugin getRegistroPluginFromPosizione(int posizione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getRegistroPluginFromPosizione(posizione, false);
    }

    protected RegistroPlugin getDatiRegistroPluginFromPosizione(int posizione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getRegistroPluginFromPosizione(posizione, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RegistroPlugin getRegistroPluginFromPosizione(int posizione, boolean soloDati) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getRegistroPlugin");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        RegistroPlugin plugin = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addWhereCondition("posizione=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setInt(1, posizione);
            rs = stm.executeQuery();
            if (rs.next()) {
                plugin = new RegistroPlugin();
                plugin.setId(rs.getLong("id"));
                plugin.setNome(rs.getString("nome"));
                plugin.setPosizione(rs.getInt("posizione"));
                StatoFunzionalita stato = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("stato"));
                plugin.setStato(stato);
                plugin.setDescrizione(rs.getString("descrizione"));
                plugin.setData(rs.getTimestamp("data"));
                String compatibilita = rs.getString("compatibilita");
                if (compatibilita != null && !"".equals(compatibilita)) {
                    if (compatibilita.contains(",")) {
                        String[] tmp = compatibilita.split(",");
                        for (int i = 0; i < tmp.length; ++i) {
                            plugin.addCompatibilita(tmp[i].trim());
                        }
                    } else {
                        plugin.addCompatibilita(compatibilita);
                    }
                }
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
            if (plugin != null && !soloDati) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("registro_plug_jar");
                sqlQueryObject.addWhereCondition("id_plugin=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, plugin.getId());
                rs = stm.executeQuery();
                while (rs.next()) {
                    RegistroPluginArchivio archivio = new RegistroPluginArchivio();
                    archivio.setNome(rs.getString("nome"));
                    archivio.setData(rs.getTimestamp("data"));
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                    archivio.setSorgente(DriverConfigurazioneDBLib.getEnumPluginSorgenteArchivio(rs.getString("sorgente")));
                    switch (archivio.getSorgente()) {
                        case JAR: {
                            archivio.setContenuto(jdbcAdapter.getBinaryData(rs, "contenuto"));
                            break;
                        }
                        case URL: {
                            archivio.setUrl(rs.getString("url"));
                            break;
                        }
                        case DIR: {
                            archivio.setDir(rs.getString("dir"));
                            break;
                        }
                    }
                    plugin.addArchivio(archivio);
                }
                rs.close();
                stm.close();
                rs = null;
                stm = null;
            }
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getRegistroPlugin]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getRegistroPlugin]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        if (plugin == null) {
            throw new DriverConfigurazioneNotFound("Plugin in posizione '" + posizione + "' non esistente");
        }
        return plugin;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean existsRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean bl;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsRegistroPlugin");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[existsRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        int count = -1;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addSelectCountField("registro_plugins.id", "cont");
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            bl = count > 0;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[existsRegistroPlugin]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[existsRegistroPlugin]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getMaxPosizioneRegistroPlugin() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int n;
        ResultSet rs;
        PreparedStatement stm;
        Connection con;
        block10: {
            con = null;
            stm = null;
            rs = null;
            String sqlQuery = "";
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("getMaxPosizioneRegistroPlugin");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[getMaxPosizioneRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addSelectMaxField("registro_plugins.posizione", "max");
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            if (!rs.next()) break block10;
            int n2 = rs.getInt(1);
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getMaxPosizioneRegistroPlugin]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getMaxPosizioneRegistroPlugin]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getNumeroArchiviJarRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int n;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getNumeroArchiviJarRegistroPlugin");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[existsRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        int count = -1;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addSelectCountField("registro_plug_jar.id", "cont");
            sqlQueryObject.addFromTable("registro_plug_jar");
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addWhereCondition("registro_plug_jar.id_plugin = registro_plugins.id");
            sqlQueryObject.addWhereCondition("registro_plugins.nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            n = count;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[getNumeroArchiviJarRegistroPlugin]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[getNumeroArchiviJarRegistroPlugin]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return n;
    }

    protected void createRegistroPlugin(RegistroPlugin plugin) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createRegistroPlugin");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRegistroPlugin type = 1");
            DriverConfigurazioneDB_pluginsLIB.CRUDRegistroPlugin(1, plugin, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRegistroPlugin] Errore durante la createRegistroPlugin : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateRegistroPlugin(RegistroPlugin plugin) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateRegistroPlugin");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRegistroPlugin type = 2");
            DriverConfigurazioneDB_pluginsLIB.CRUDRegistroPlugin(2, plugin, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateRegistroPlugin] Errore durante la updateRegistroPlugin : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteRegistroPlugin(RegistroPlugin plugin) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteRegistroPlugin");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRegistroPlugin type = 3");
            DriverConfigurazioneDB_pluginsLIB.CRUDRegistroPlugin(3, plugin, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRegistroPlugin] Errore durante la deleteRegistroPlugin : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateDatiRegistroPlugin(String nomePlugin, RegistroPlugin plugin) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateDatiRegistroPlugin");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateDatiRegistroPlugin] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("updateDatiRegistroPlugin");
            DriverConfigurazioneDB_pluginsLIB.updateDatiRegistroPlugin(nomePlugin, plugin, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateDatiRegistroPlugin] Errore durante la updateDatiRegistroPlugin : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RegistroPluginArchivio getRegistroPluginArchivio(String nomePlugin, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getRegistroPluginArchivio");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getRegistroPluginArchivio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        RegistroPluginArchivio archivio = null;
        try {
            long idPlugin = DBUtils.getIdRegistroPlugin(nomePlugin, con, this.driver.tipoDB);
            if (idPlugin <= 0L) {
                throw new DriverConfigurazioneNotFound("Plugin '" + nomePlugin + "' non esistente");
            }
            if (nome == null) {
                throw new DriverConfigurazioneException("Nome archivio non indicato");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("registro_plug_jar");
            sqlQueryObject.addWhereCondition("id_plugin=?");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPlugin);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                archivio = new RegistroPluginArchivio();
                archivio.setNome(rs.getString("nome"));
                archivio.setData(rs.getTimestamp("data"));
                IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                archivio.setSorgente(DriverConfigurazioneDBLib.getEnumPluginSorgenteArchivio(rs.getString("sorgente")));
                switch (archivio.getSorgente()) {
                    case JAR: {
                        archivio.setContenuto(jdbcAdapter.getBinaryData(rs, "contenuto"));
                        break;
                    }
                    case URL: {
                        archivio.setUrl(rs.getString("url"));
                        break;
                    }
                    case DIR: {
                        archivio.setDir(rs.getString("dir"));
                        break;
                    }
                }
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
        }
        catch (DriverConfigurazioneNotFound notFound) {
            try {
                throw notFound;
                catch (SQLException se) {
                    throw new DriverConfigurazioneException("[getRegistroPluginArchivio]  SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverConfigurazioneException("[getRegistroPluginArchivio]  Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        if (archivio == null) {
            throw new DriverConfigurazioneNotFound("Archivio '" + nome + "' non esistente nel plugin '" + nomePlugin + "'");
        }
        archivio.setNomePlugin(nomePlugin);
        return archivio;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean existsRegistroPluginArchivio(String nomePlugin, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean bl;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsRegistroPluginArchivio");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[existsRegistroPluginArchivio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        int count = -1;
        try {
            long idPlugin = DBUtils.getIdRegistroPlugin(nomePlugin, con, this.driver.tipoDB);
            if (idPlugin <= 0L) {
                throw new DriverConfigurazioneNotFound("Plugin '" + nomePlugin + "' non esistente");
            }
            if (nome == null) {
                throw new DriverConfigurazioneException("Nome archivio non indicato");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addSelectCountField("registro_plug_jar.id", "cont");
            sqlQueryObject.addFromTable("registro_plug_jar");
            sqlQueryObject.addWhereCondition("id_plugin=?");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPlugin);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
            bl = count > 0;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[existsRegistroPluginArchivio]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[existsRegistroPluginArchivio]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean existsRegistroPluginArchivio(String nomePlugin, PluginSorgenteArchivio tipoSorgente, String sorgente) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean bl;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsRegistroPluginArchivio");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[existsRegistroPluginArchivio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        int count = -1;
        try {
            long idPlugin = DBUtils.getIdRegistroPlugin(nomePlugin, con, this.driver.tipoDB);
            if (idPlugin <= 0L) {
                throw new DriverConfigurazioneNotFound("Plugin '" + nomePlugin + "' non esistente");
            }
            if (tipoSorgente == null) {
                throw new DriverConfigurazioneException("TipoSorgente non indicata");
            }
            if (sorgente == null) {
                throw new DriverConfigurazioneException("Sorgente non indicata");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addSelectCountField("registro_plug_jar.id", "cont");
            sqlQueryObject.addFromTable("registro_plug_jar");
            sqlQueryObject.addWhereCondition("id_plugin=?");
            switch (tipoSorgente) {
                case JAR: {
                    sqlQueryObject.addWhereCondition("nome=?");
                    break;
                }
                case DIR: {
                    sqlQueryObject.addWhereCondition("dir=?");
                    break;
                }
                case URL: {
                    sqlQueryObject.addWhereCondition("url=?");
                    break;
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPlugin);
            stm.setString(2, sorgente);
            rs = stm.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
            bl = count > 0;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[existsRegistroPluginArchivio]  SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[existsRegistroPluginArchivio]  Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return bl;
    }

    protected void createRegistroPluginArchivio(String nomePlugin, RegistroPluginArchivio plugin) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createRegistroPluginArchivio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRegistroPluginArchivio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRegistroPlugin type = 1");
            DriverConfigurazioneDB_pluginsLIB.CRUDRegistroPluginArchivio(1, nomePlugin, plugin, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRegistroPluginArchivio] Errore durante la createRegistroPluginArchivio : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateRegistroPluginArchivio(String nomePlugin, RegistroPluginArchivio plugin) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateRegistroPluginArchivio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateRegistroPluginArchivio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRegistroPlugin type = 2");
            DriverConfigurazioneDB_pluginsLIB.CRUDRegistroPluginArchivio(2, nomePlugin, plugin, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateRegistroPluginArchivio] Errore durante la updateRegistroPluginArchivio : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteRegistroPluginArchivio(String nomePlugin, RegistroPluginArchivio plugin) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteRegistroPluginArchivio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRegistroPluginArchivio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRegistroPlugin type = 3");
            DriverConfigurazioneDB_pluginsLIB.CRUDRegistroPluginArchivio(3, nomePlugin, plugin, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRegistroPluginArchivio] Errore durante la deleteRegistroPluginArchivio : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected List<RegistroPlugin> pluginsArchiviList(ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<RegistroPlugin> arrayList;
        String nomeMetodo = "pluginsArchiviList";
        int idLista = Liste.CONFIGURAZIONE_PLUGINS_ARCHIVI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<RegistroPlugin> lista = new ArrayList<RegistroPlugin>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("pluginsArchiviList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addSelectCountField("id", "cont");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            if ((risultato = (stmt = con.prepareStatement(queryString = sqlQueryObject.createSQLQuery())).executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("posizione");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("data");
            sqlQueryObject.addSelectField("compatibilita");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("posizione");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                RegistroPlugin regola = new RegistroPlugin();
                regola.setId(risultato.getLong("id"));
                regola.setNome(risultato.getString("nome"));
                regola.setPosizione(risultato.getInt("posizione"));
                regola.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(risultato.getString("stato")));
                regola.setDescrizione(risultato.getString("descrizione"));
                Timestamp timestamp = risultato.getTimestamp("data");
                regola.setData(new Date(timestamp.getTime()));
                String compatibilita = risultato.getString("compatibilita");
                if (compatibilita != null) {
                    regola.setCompatibilitaList(Arrays.asList(compatibilita.split(",")));
                }
                lista.add(regola);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<RegistroPluginArchivio> pluginsArchiviJarList(String nome, ISearch ricerca) throws DriverConfigurazioneException {
        return this.pluginsArchiviJarList(nome, ricerca, true);
    }

    private List<RegistroPluginArchivio> pluginsArchiviJarList(String nome, ISearch ricerca, boolean escludiContenuto) throws DriverConfigurazioneException {
        ArrayList<RegistroPluginArchivio> arrayList;
        String nomeMetodo = "pluginsArchiviList";
        int idLista = Liste.CONFIGURAZIONE_PLUGINS_ARCHIVI_JAR;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<RegistroPluginArchivio> lista = new ArrayList<RegistroPluginArchivio>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("pluginsArchiviList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObjectOr = null;
            if (!search.equals("")) {
                ISQLQueryObject sqlQueryObjectJar = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectJar.addWhereLikeCondition("registro_plug_jar.nome", search, true, true);
                sqlQueryObjectJar.addWhereCondition("registro_plug_jar.sorgente = ?");
                sqlQueryObjectJar.setANDLogicOperator(true);
                ISQLQueryObject sqlQueryObjectUrl = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectUrl.addWhereLikeCondition("registro_plug_jar.url", search, true, true);
                sqlQueryObjectUrl.addWhereCondition("registro_plug_jar.sorgente = ?");
                sqlQueryObjectUrl.setANDLogicOperator(true);
                ISQLQueryObject sqlQueryObjectDir = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectDir.addWhereLikeCondition("registro_plug_jar.dir", search, true, true);
                sqlQueryObjectDir.addWhereCondition("registro_plug_jar.sorgente = ?");
                sqlQueryObjectDir.setANDLogicOperator(true);
                sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectOr.setANDLogicOperator(false);
                sqlQueryObjectOr.addWhereCondition(sqlQueryObjectJar.createSQLConditions());
                sqlQueryObjectOr.addWhereCondition(sqlQueryObjectUrl.createSQLConditions());
                sqlQueryObjectOr.addWhereCondition(sqlQueryObjectDir.createSQLConditions());
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addSelectCountField("registro_plug_jar.id", "cont");
            sqlQueryObject.addFromTable("registro_plug_jar");
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addWhereCondition("registro_plug_jar.id_plugin = registro_plugins.id");
            sqlQueryObject.addWhereCondition("registro_plugins.nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            if (sqlQueryObjectOr != null) {
                sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setString(parameterIndex++, nome);
            if (sqlQueryObjectOr != null) {
                stmt.setString(parameterIndex++, DriverConfigurazioneDBLib.getValue(PluginSorgenteArchivio.JAR));
                stmt.setString(parameterIndex++, DriverConfigurazioneDBLib.getValue(PluginSorgenteArchivio.URL));
                stmt.setString(parameterIndex++, DriverConfigurazioneDBLib.getValue(PluginSorgenteArchivio.DIR));
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("registro_plug_jar");
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addWhereCondition("registro_plug_jar.id_plugin = registro_plugins.id");
            sqlQueryObject.addWhereCondition("registro_plugins.nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            if (sqlQueryObjectOr != null) {
                sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
            }
            sqlQueryObject.addSelectField("registro_plug_jar.id");
            sqlQueryObject.addSelectField("registro_plug_jar.nome");
            sqlQueryObject.addSelectField("registro_plug_jar.data");
            sqlQueryObject.addSelectField("registro_plug_jar.sorgente");
            if (!escludiContenuto) {
                sqlQueryObject.addSelectField("registro_plug_jar.contenuto");
            }
            sqlQueryObject.addSelectField("registro_plug_jar.url");
            sqlQueryObject.addSelectField("registro_plug_jar.dir");
            sqlQueryObject.addOrderBy("registro_plug_jar.data");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            parameterIndex = 1;
            stmt.setString(parameterIndex++, nome);
            if (sqlQueryObjectOr != null) {
                stmt.setString(parameterIndex++, DriverConfigurazioneDBLib.getValue(PluginSorgenteArchivio.JAR));
                stmt.setString(parameterIndex++, DriverConfigurazioneDBLib.getValue(PluginSorgenteArchivio.URL));
                stmt.setString(parameterIndex++, DriverConfigurazioneDBLib.getValue(PluginSorgenteArchivio.DIR));
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                RegistroPluginArchivio archivio = new RegistroPluginArchivio();
                archivio.setNome(risultato.getString("nome"));
                archivio.setNomePlugin(nome);
                Timestamp timestamp = risultato.getTimestamp("data");
                archivio.setData(new Date(timestamp.getTime()));
                IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                archivio.setSorgente(DriverConfigurazioneDBLib.getEnumPluginSorgenteArchivio(risultato.getString("sorgente")));
                switch (archivio.getSorgente()) {
                    case JAR: {
                        if (escludiContenuto) break;
                        archivio.setContenuto(jdbcAdapter.getBinaryData(risultato, "contenuto"));
                        break;
                    }
                    case URL: {
                        archivio.setUrl(risultato.getString("url"));
                        break;
                    }
                    case DIR: {
                        archivio.setDir(risultato.getString("dir"));
                    }
                }
                lista.add(archivio);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

