/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.IExtendedInfo;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.ConfigurazionePortaHandler;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MessageSecurityFlow;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.MtomProcessorFlow;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizio;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaSoggettoVirtuale;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletrace;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaCacheDigestQueryParameter;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBTracciamentoLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBTrasformazioniLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_dumpLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_genericPropertiesDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_handlerLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_serviziApplicativiLIB;
import org.openspcoop2.core.constants.CRUDType;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_porteApplicativeLIB {
    public static long CRUDPortaApplicativa(int type, PortaApplicativa aPA, Connection con, IDriverBYOK driverBYOK) throws DriverConfigurazioneException {
        PortaApplicativaSoggettoVirtuale soggVirt;
        long idServizio;
        if (aPA == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non valida.");
        }
        String nomePorta = aPA.getNome();
        String nomeProprietario = aPA.getNomeSoggettoProprietario();
        String tipoProprietario = aPA.getTipoSoggettoProprietario();
        if (nomePorta == null || nomePorta.equals("")) {
            throw new DriverConfigurazioneException("Nome della Porta Applicativa non valido.");
        }
        if (nomeProprietario == null || nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("Nome proprietario Porta Applicativa non valido.");
        }
        if (tipoProprietario == null || tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("Tipo proprietario della Porta Applicativa non valido.");
        }
        PreparedStatement stm = null;
        String sqlQuery = "";
        ResultSet rs = null;
        String descrizione = aPA.getDescrizione();
        String autenticazione = aPA.getAutenticazione();
        String autorizzazione = aPA.getAutorizzazione();
        String autorizzazioneXacmlPolicy = aPA.getXacmlPolicy();
        GestioneToken gestioneToken = aPA.getGestioneToken();
        PortaApplicativaAzione azione = aPA.getAzione();
        PortaApplicativaServizio servizio = aPA.getServizio();
        long l = idServizio = servizio != null && servizio.getId() != null ? servizio.getId() : -1L;
        if (servizio != null && servizio.getTipo() != null && servizio.getNome() != null && servizio.getVersione() != null && servizio.getVersione() > 0) {
            try {
                idServizio = DBUtils.getIdServizio(servizio.getNome(), servizio.getTipo(), servizio.getVersione(), nomeProprietario, tipoProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
            }
            catch (Exception e1) {
                DriverConfigurazioneDBLib.logDebug(e1.getMessage(), e1);
            }
        }
        String tipoSoggVirt = (soggVirt = aPA.getSoggettoVirtuale()) != null ? soggVirt.getTipo() : null;
        String nomeSoggVirt = soggVirt != null ? soggVirt.getNome() : null;
        long idSoggVirt = -1L;
        try {
            idSoggVirt = DBUtils.getIdSoggetto(nomeSoggVirt, tipoSoggVirt, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
        }
        catch (CoreException e1) {
            DriverConfigurazioneDBLib.logError(e1.getMessage(), e1);
        }
        Proprieta propProtocollo = null;
        MtomProcessor mtomProcessor = aPA.getMtomProcessor();
        MTOMProcessorType mtomModeRequest = null;
        MTOMProcessorType mtomModeResponse = null;
        if (mtomProcessor != null) {
            if (mtomProcessor.getRequestFlow() != null) {
                mtomModeRequest = mtomProcessor.getRequestFlow().getMode();
            }
            if (mtomProcessor.getResponseFlow() != null) {
                mtomModeResponse = mtomProcessor.getResponseFlow().getMode();
            }
        }
        MessageSecurity messageSecurity = aPA.getMessageSecurity();
        String messageSecurityStatus = aPA.getStatoMessageSecurity();
        StatoFunzionalita messageSecurityApplyMtomRequest = null;
        StatoFunzionalita messageSecurityApplyMtomResponse = null;
        String securityRequestMode = null;
        String securityResponseMode = null;
        if (messageSecurity != null) {
            if (messageSecurity.getRequestFlow() != null) {
                messageSecurityApplyMtomRequest = messageSecurity.getRequestFlow().getApplyToMtom();
                securityRequestMode = messageSecurity.getRequestFlow().getMode();
            }
            if (messageSecurity.getResponseFlow() != null) {
                messageSecurityApplyMtomResponse = messageSecurity.getResponseFlow().getApplyToMtom();
                securityResponseMode = messageSecurity.getResponseFlow().getMode();
            }
        }
        CorrelazioneApplicativa corrApp = aPA.getCorrelazioneApplicativa();
        CorrelazioneApplicativaRisposta corrAppRisposta = aPA.getCorrelazioneApplicativaRisposta();
        String msgDiagSeverita = null;
        String tracciamentoStato = null;
        String tracciamentoEsiti = null;
        String transazioniTempiElaborazione = null;
        String transazioniToken = null;
        TracciamentoConfigurazione tracciamentoDatabase = null;
        TracciamentoConfigurazione tracciamentoFiletrace = null;
        TracciamentoConfigurazioneFiletrace tracciamentoFiletraceDetails = null;
        if (aPA.getTracciamento() != null) {
            msgDiagSeverita = DriverConfigurazioneDBLib.getValue(aPA.getTracciamento().getSeverita());
            tracciamentoStato = DriverConfigurazioneDBLib.getValue(aPA.getTracciamento().getStato());
            tracciamentoEsiti = aPA.getTracciamento().getEsiti();
            if (aPA.getTracciamento().getTransazioni() != null) {
                transazioniTempiElaborazione = DriverConfigurazioneDBLib.getValue(aPA.getTracciamento().getTransazioni().getTempiElaborazione());
                transazioniToken = DriverConfigurazioneDBLib.getValue(aPA.getTracciamento().getTransazioni().getToken());
            }
            tracciamentoDatabase = aPA.getTracciamento().getDatabase();
            tracciamentoFiletrace = aPA.getTracciamento().getFiletrace();
            tracciamentoFiletraceDetails = aPA.getTracciamento().getFiletraceConfig();
        }
        CorsConfigurazione corsConfigurazione = aPA.getGestioneCors();
        String corsStato = null;
        String corsTipo = null;
        String corsAllAllowOrigins = null;
        String corsAllAllowMethods = null;
        String corsAllAllowHeaders = null;
        String corsAllowCredentials = null;
        int corsAllowMaxAge = 0;
        Integer corsAllowMaxAgeSeconds = null;
        String corsAllowOrigins = null;
        String corsAllowHeaders = null;
        String corsAllowMethods = null;
        String corsAllowExposeHeaders = null;
        if (corsConfigurazione != null) {
            int i;
            StringBuilder bf;
            corsStato = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getStato());
            corsTipo = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getTipo());
            corsAllAllowOrigins = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getAccessControlAllAllowOrigins());
            corsAllAllowMethods = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getAccessControlAllAllowMethods());
            corsAllAllowHeaders = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getAccessControlAllAllowHeaders());
            corsAllowCredentials = DriverConfigurazioneDBLib.getValue(corsConfigurazione.getAccessControlAllowCredentials());
            if (corsConfigurazione.getAccessControlMaxAge() != null) {
                corsAllowMaxAge = 1;
                corsAllowMaxAgeSeconds = corsConfigurazione.getAccessControlMaxAge();
            }
            if (corsConfigurazione.getAccessControlAllowOrigins() != null && corsConfigurazione.getAccessControlAllowOrigins().sizeOriginList() > 0) {
                bf = new StringBuilder();
                for (i = 0; i < corsConfigurazione.getAccessControlAllowOrigins().sizeOriginList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(corsConfigurazione.getAccessControlAllowOrigins().getOrigin(i));
                }
                corsAllowOrigins = bf.toString();
            }
            if (corsConfigurazione.getAccessControlAllowHeaders() != null && corsConfigurazione.getAccessControlAllowHeaders().sizeHeaderList() > 0) {
                bf = new StringBuilder();
                for (i = 0; i < corsConfigurazione.getAccessControlAllowHeaders().sizeHeaderList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(corsConfigurazione.getAccessControlAllowHeaders().getHeader(i));
                }
                corsAllowHeaders = bf.toString();
            }
            if (corsConfigurazione.getAccessControlAllowMethods() != null && corsConfigurazione.getAccessControlAllowMethods().sizeMethodList() > 0) {
                bf = new StringBuilder();
                for (i = 0; i < corsConfigurazione.getAccessControlAllowMethods().sizeMethodList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(corsConfigurazione.getAccessControlAllowMethods().getMethod(i));
                }
                corsAllowMethods = bf.toString();
            }
            if (corsConfigurazione.getAccessControlExposeHeaders() != null && corsConfigurazione.getAccessControlExposeHeaders().sizeHeaderList() > 0) {
                bf = new StringBuilder();
                for (i = 0; i < corsConfigurazione.getAccessControlExposeHeaders().sizeHeaderList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(corsConfigurazione.getAccessControlExposeHeaders().getHeader(i));
                }
                corsAllowExposeHeaders = bf.toString();
            }
        }
        ResponseCachingConfigurazione responseCachingConfigurazone = aPA.getResponseCaching();
        String responseCacheStato = null;
        Integer responseCacheSeconds = null;
        Long responseCacheMaxMsgSize = null;
        String responseCacheHashUrl = null;
        String responseCacheHashQuery = null;
        String responseCacheHashQueryList = null;
        String responseCacheHashHeaders = null;
        String responseCacheHashHeadersList = null;
        String responseCacheHashPayload = null;
        boolean responseCacheNoCache = true;
        boolean responseCacheMaxAge = true;
        boolean responseCacheNoStore = true;
        List<ResponseCachingConfigurazioneRegola> responseCacheRegole = null;
        if (responseCachingConfigurazone != null) {
            responseCacheStato = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getStato());
            responseCacheSeconds = responseCachingConfigurazone.getCacheTimeoutSeconds();
            responseCacheMaxMsgSize = responseCachingConfigurazone.getMaxMessageSize();
            if (responseCachingConfigurazone.getControl() != null) {
                responseCacheNoCache = responseCachingConfigurazone.getControl().getNoCache();
                responseCacheMaxAge = responseCachingConfigurazone.getControl().getMaxAge();
                responseCacheNoStore = responseCachingConfigurazone.getControl().getNoStore();
            }
            if (responseCachingConfigurazone.getHashGenerator() != null) {
                int i;
                StringBuilder bf;
                responseCacheHashUrl = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getHashGenerator().getRequestUri());
                responseCacheHashQuery = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getHashGenerator().getQueryParameters());
                if (StatoFunzionalitaCacheDigestQueryParameter.SELEZIONE_PUNTUALE.equals(responseCachingConfigurazone.getHashGenerator().getQueryParameters()) && responseCachingConfigurazone.getHashGenerator().getQueryParameterList() != null && responseCachingConfigurazone.getHashGenerator().sizeQueryParameterList() > 0) {
                    bf = new StringBuilder();
                    for (i = 0; i < responseCachingConfigurazone.getHashGenerator().sizeQueryParameterList(); ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(responseCachingConfigurazone.getHashGenerator().getQueryParameter(i));
                    }
                    responseCacheHashQueryList = bf.toString();
                }
                responseCacheHashHeaders = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getHashGenerator().getHeaders());
                if (StatoFunzionalita.ABILITATO.equals(responseCachingConfigurazone.getHashGenerator().getHeaders()) && responseCachingConfigurazone.getHashGenerator().getHeaderList() != null && responseCachingConfigurazone.getHashGenerator().sizeHeaderList() > 0) {
                    bf = new StringBuilder();
                    for (i = 0; i < responseCachingConfigurazone.getHashGenerator().sizeHeaderList(); ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(responseCachingConfigurazone.getHashGenerator().getHeader(i));
                    }
                    responseCacheHashHeadersList = bf.toString();
                }
                responseCacheHashPayload = DriverConfigurazioneDBLib.getValue(responseCachingConfigurazone.getHashGenerator().getPayload());
            }
            responseCacheRegole = responseCachingConfigurazone.getRegolaList();
        }
        String behaviour = null;
        if (aPA.getBehaviour() != null) {
            behaviour = aPA.getBehaviour().getNome();
        }
        ConfigurazionePortaHandler configHandlers = aPA.getConfigurazioneHandler();
        ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
        IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoPortaApplicativa();
        try {
            int n = 0;
            int i = 0;
            long idPortaApplicativa = 0L;
            long idProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
            switch (type) {
                case 1: {
                    Ruolo ruolo;
                    BYOKWrappedValue byokValue;
                    String plainValueP;
                    String tipoProprietarioSA;
                    String nomeSA;
                    PortaApplicativaServizioApplicativo servizioApplicativo;
                    BaseBeanWithId cae;
                    BaseBeanWithId flow;
                    BaseBeanWithId resParam;
                    BaseBeanWithId flow2;
                    BaseBeanWithId reqParam;
                    PortaApplicativaAzioneIdentificazione modeAzione;
                    Integer versioneServizio;
                    String tipoServizio = servizio != null ? servizio.getTipo() : null;
                    String nomeServizio = servizio != null ? servizio.getNome() : null;
                    Integer n2 = versioneServizio = servizio != null ? servizio.getVersione() : null;
                    if (idServizio <= 0L) {
                        if (tipoServizio == null || tipoServizio.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                        }
                        if (nomeServizio == null || nomeServizio.equals("")) {
                            throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                        }
                        if (versioneServizio == null) {
                            throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                        }
                    }
                    String nomeAzione = azione != null ? azione.getNome() : null;
                    String patternAzione = azione != null ? azione.getPattern() : null;
                    String nomePortaDeleganteAzione = azione != null ? azione.getNomePortaDelegante() : null;
                    StatoFunzionalita forceInterfaceBased = azione != null ? azione.getForceInterfaceBased() : null;
                    PortaApplicativaAzioneIdentificazione portaApplicativaAzioneIdentificazione = modeAzione = azione != null ? azione.getIdentificazione() : null;
                    if (azione != null) {
                        if (modeAzione == null || modeAzione.equals("")) {
                            modeAzione = PortaApplicativaAzioneIdentificazione.STATIC;
                        }
                        switch (modeAzione) {
                            case CONTENT_BASED: 
                            case URL_BASED: 
                            case HEADER_BASED: {
                                if (patternAzione == null || patternAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case DELEGATED_BY: {
                                if (nomePortaDeleganteAzione == null || nomePortaDeleganteAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Porta Delegante Azione non impostata.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case INPUT_BASED: 
                            case SOAP_ACTION_BASED: 
                            case INTERFACE_BASED: 
                            case PROTOCOL_BASED: {
                                break;
                            }
                            case STATIC: {
                                if (nomeAzione == null || nomeAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                }
                                patternAzione = null;
                                break;
                            }
                        }
                    }
                    String utenteRichiedente = null;
                    utenteRichiedente = aPA.getProprietaOggetto() != null && aPA.getProprietaOggetto().getUtenteRichiedente() != null ? aPA.getProprietaOggetto().getUtenteRichiedente() : DBUtils.getSuperUserServizioSafe(DriverConfigurazioneDBLib.log, "CRUDPortaApplicativa", idServizio, con, DriverConfigurazioneDBLib.tipoDB);
                    Timestamp dataCreazione = null;
                    dataCreazione = aPA.getProprietaOggetto() != null && aPA.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(aPA.getProprietaOggetto().getDataCreazione().getTime()) : (aPA.getOraRegistrazione() != null ? new Timestamp(aPA.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("porte_applicative");
                    sqlQueryObject.addInsertField("nome_porta", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("id_soggetto_virtuale", "?");
                    sqlQueryObject.addInsertField("tipo_soggetto_virtuale", "?");
                    sqlQueryObject.addInsertField("nome_soggetto_virtuale", "?");
                    sqlQueryObject.addInsertField("id_servizio", "?");
                    sqlQueryObject.addInsertField("tipo_servizio", "?");
                    sqlQueryObject.addInsertField("servizio", "?");
                    sqlQueryObject.addInsertField("versione_servizio", "?");
                    sqlQueryObject.addInsertField("azione", "?");
                    sqlQueryObject.addInsertField("mode_azione", "?");
                    sqlQueryObject.addInsertField("pattern_azione", "?");
                    sqlQueryObject.addInsertField("nome_porta_delegante_azione", "?");
                    sqlQueryObject.addInsertField("force_interface_based_azione", "?");
                    sqlQueryObject.addInsertField("mtom_request_mode", "?");
                    sqlQueryObject.addInsertField("mtom_response_mode", "?");
                    sqlQueryObject.addInsertField("security", "?");
                    sqlQueryObject.addInsertField("security_mtom_req", "?");
                    sqlQueryObject.addInsertField("security_mtom_res", "?");
                    sqlQueryObject.addInsertField("security_request_mode", "?");
                    sqlQueryObject.addInsertField("security_response_mode", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("ricevuta_asincrona_sim", "?");
                    sqlQueryObject.addInsertField("ricevuta_asincrona_asim", "?");
                    sqlQueryObject.addInsertField("integrazione", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_stato", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_tipo", "?");
                    sqlQueryObject.addInsertField("validazione_contenuti_mtom", "?");
                    sqlQueryObject.addInsertField("allega_body", "?");
                    sqlQueryObject.addInsertField("scarta_body", "?");
                    sqlQueryObject.addInsertField("gestione_manifest", "?");
                    sqlQueryObject.addInsertField("stateless", "?");
                    sqlQueryObject.addInsertField("behaviour", "?");
                    sqlQueryObject.addInsertField("autenticazione", "?");
                    sqlQueryObject.addInsertField("autenticazione_opzionale", "?");
                    sqlQueryObject.addInsertField("token_policy", "?");
                    sqlQueryObject.addInsertField("token_opzionale", "?");
                    sqlQueryObject.addInsertField("token_validazione", "?");
                    sqlQueryObject.addInsertField("token_introspection", "?");
                    sqlQueryObject.addInsertField("token_user_info", "?");
                    sqlQueryObject.addInsertField("token_forward", "?");
                    sqlQueryObject.addInsertField("token_options", "?");
                    sqlQueryObject.addInsertField("token_authn_issuer", "?");
                    sqlQueryObject.addInsertField("token_authn_client_id", "?");
                    sqlQueryObject.addInsertField("token_authn_subject", "?");
                    sqlQueryObject.addInsertField("token_authn_username", "?");
                    sqlQueryObject.addInsertField("token_authn_email", "?");
                    sqlQueryObject.addInsertField("autorizzazione", "?");
                    sqlQueryObject.addInsertField("autorizzazione_xacml", "?");
                    sqlQueryObject.addInsertField("autorizzazione_contenuto", "?");
                    sqlQueryObject.addInsertField("ruoli_match", "?");
                    sqlQueryObject.addInsertField("token_sa_stato", "?");
                    sqlQueryObject.addInsertField("token_ruoli_stato", "?");
                    sqlQueryObject.addInsertField("token_ruoli_match", "?");
                    sqlQueryObject.addInsertField("token_ruoli_tipologia", "?");
                    sqlQueryObject.addInsertField("scope_stato", "?");
                    sqlQueryObject.addInsertField("scope_match", "?");
                    sqlQueryObject.addInsertField("ricerca_porta_azione_delegata", "?");
                    sqlQueryObject.addInsertField("msg_diag_severita", "?");
                    sqlQueryObject.addInsertField("tracciamento_stato", "?");
                    sqlQueryObject.addInsertField("tracciamento_esiti", "?");
                    sqlQueryObject.addInsertField("transazioni_tempi", "?");
                    sqlQueryObject.addInsertField("transazioni_token", "?");
                    sqlQueryObject.addInsertField("stato", "?");
                    sqlQueryObject.addInsertField("cors_stato", "?");
                    sqlQueryObject.addInsertField("cors_tipo", "?");
                    sqlQueryObject.addInsertField("cors_all_allow_origins", "?");
                    sqlQueryObject.addInsertField("cors_all_allow_methods", "?");
                    sqlQueryObject.addInsertField("cors_all_allow_headers", "?");
                    sqlQueryObject.addInsertField("cors_allow_credentials", "?");
                    sqlQueryObject.addInsertField("cors_allow_max_age", "?");
                    sqlQueryObject.addInsertField("cors_allow_max_age_seconds", "?");
                    sqlQueryObject.addInsertField("cors_allow_origins", "?");
                    sqlQueryObject.addInsertField("cors_allow_headers", "?");
                    sqlQueryObject.addInsertField("cors_allow_methods", "?");
                    sqlQueryObject.addInsertField("cors_allow_expose_headers", "?");
                    sqlQueryObject.addInsertField("response_cache_stato", "?");
                    sqlQueryObject.addInsertField("response_cache_seconds", "?");
                    sqlQueryObject.addInsertField("response_cache_max_msg_size", "?");
                    sqlQueryObject.addInsertField("response_cache_control_nocache", "?");
                    sqlQueryObject.addInsertField("response_cache_control_maxage", "?");
                    sqlQueryObject.addInsertField("response_cache_control_nostore", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_url", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_query", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_query_list", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_headers", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_hdr_list", "?");
                    sqlQueryObject.addInsertField("response_cache_hash_payload", "?");
                    sqlQueryObject.addInsertField("id_sa_default", "?");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("id_port_type", "?");
                    sqlQueryObject.addInsertField("scadenza_correlazione_appl", "?");
                    sqlQueryObject.addInsertField("options", "?");
                    sqlQueryObject.addInsertField("canale", "?");
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, nomePorta);
                    stm.setString(index++, descrizione);
                    stm.setLong(index++, idSoggVirt);
                    stm.setString(index++, tipoSoggVirt);
                    stm.setString(index++, nomeSoggVirt);
                    stm.setLong(index++, idServizio);
                    stm.setString(index++, tipoServizio);
                    stm.setString(index++, nomeServizio);
                    stm.setInt(index++, versioneServizio);
                    stm.setString(index++, azione != null ? azione.getNome() : null);
                    if (modeAzione != null) {
                        stm.setString(index++, modeAzione.toString());
                    } else {
                        stm.setString(index++, null);
                    }
                    stm.setString(index++, patternAzione);
                    stm.setString(index++, nomePortaDeleganteAzione);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(forceInterfaceBased));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(mtomModeRequest));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(mtomModeResponse));
                    stm.setString(index++, messageSecurityStatus);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(messageSecurityApplyMtomRequest));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(messageSecurityApplyMtomResponse));
                    stm.setString(index++, securityRequestMode);
                    stm.setString(index++, securityResponseMode);
                    stm.setLong(index++, idProprietario);
                    stm.setString(index++, aPA.getRicevutaAsincronaSimmetrica() != null ? DriverConfigurazioneDBLib.getValue(aPA.getRicevutaAsincronaSimmetrica()) : null);
                    stm.setString(index++, aPA.getRicevutaAsincronaAsimmetrica() != null ? DriverConfigurazioneDBLib.getValue(aPA.getRicevutaAsincronaAsimmetrica()) : null);
                    stm.setString(index++, aPA.getIntegrazione() != null ? aPA.getIntegrazione() : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPA.getValidazioneContenutiApplicativi().getStato()) : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPA.getValidazioneContenutiApplicativi().getTipo()) : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPA.getValidazioneContenutiApplicativi().getAcceptMtomMessage()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getAllegaBody()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getScartaBody()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getGestioneManifest()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getStateless()) : null);
                    stm.setString(index++, behaviour);
                    stm.setString(index++, autenticazione);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getAutenticazioneOpzionale()) : null);
                    stm.setString(index++, gestioneToken != null ? gestioneToken.getPolicy() : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getTokenOpzionale()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getValidazione()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getIntrospection()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getUserInfo()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getForward()) : null);
                    stm.setString(index++, gestioneToken != null ? gestioneToken.getOptions() : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getIssuer()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getClientId()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getSubject()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getUsername()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getEmail()) : null);
                    stm.setString(index++, autorizzazione);
                    stm.setString(index++, autorizzazioneXacmlPolicy);
                    stm.setString(index++, aPA != null ? aPA.getAutorizzazioneContenuto() : null);
                    stm.setString(index++, aPA != null && aPA.getRuoli() != null && aPA.getRuoli().getMatch() != null ? aPA.getRuoli().getMatch().getValue() : null);
                    stm.setString(index++, aPA != null && aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getAutorizzazioneApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPA.getAutorizzazioneToken().getAutorizzazioneApplicativi()) : null);
                    stm.setString(index++, aPA != null && aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getAutorizzazioneRuoli() != null ? DriverConfigurazioneDBLib.getValue(aPA.getAutorizzazioneToken().getAutorizzazioneRuoli()) : null);
                    stm.setString(index++, aPA != null && aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getRuoli() != null && aPA.getAutorizzazioneToken().getRuoli().getMatch() != null ? aPA.getAutorizzazioneToken().getRuoli().getMatch().getValue() : null);
                    stm.setString(index++, aPA != null && aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getTipologiaRuoli() != null ? aPA.getAutorizzazioneToken().getTipologiaRuoli().getValue() : null);
                    stm.setString(index++, aPA != null && aPA.getScope() != null && aPA.getScope().getStato() != null ? DriverConfigurazioneDBLib.getValue(aPA.getScope().getStato()) : null);
                    stm.setString(index++, aPA != null && aPA.getScope() != null && aPA.getScope().getMatch() != null ? aPA.getScope().getMatch().getValue() : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getRicercaPortaAzioneDelegata()) : null);
                    stm.setString(index++, msgDiagSeverita);
                    stm.setString(index++, tracciamentoStato);
                    stm.setString(index++, tracciamentoEsiti);
                    stm.setString(index++, transazioniTempiElaborazione);
                    stm.setString(index++, transazioniToken);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getStato()) : null);
                    stm.setString(index++, corsStato);
                    stm.setString(index++, corsTipo);
                    stm.setString(index++, corsAllAllowOrigins);
                    stm.setString(index++, corsAllAllowMethods);
                    stm.setString(index++, corsAllAllowHeaders);
                    stm.setString(index++, corsAllowCredentials);
                    stm.setInt(index++, corsAllowMaxAge);
                    if (corsAllowMaxAgeSeconds != null) {
                        stm.setInt(index++, corsAllowMaxAgeSeconds);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, corsAllowOrigins);
                    stm.setString(index++, corsAllowHeaders);
                    stm.setString(index++, corsAllowMethods);
                    stm.setString(index++, corsAllowExposeHeaders);
                    stm.setString(index++, responseCacheStato);
                    if (responseCacheSeconds != null) {
                        stm.setInt(index++, responseCacheSeconds);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (responseCacheMaxMsgSize != null) {
                        stm.setLong(index++, responseCacheMaxMsgSize);
                    } else {
                        stm.setNull(index++, -5);
                    }
                    stm.setInt(index++, responseCacheNoCache ? 1 : 0);
                    stm.setInt(index++, responseCacheMaxAge ? 1 : 0);
                    stm.setInt(index++, responseCacheNoStore ? 1 : 0);
                    stm.setString(index++, responseCacheHashUrl);
                    stm.setString(index++, responseCacheHashQuery);
                    stm.setString(index++, responseCacheHashQueryList);
                    stm.setString(index++, responseCacheHashHeaders);
                    stm.setString(index++, responseCacheHashHeadersList);
                    stm.setString(index++, responseCacheHashPayload);
                    long idServizioApplicativoDefault = -1L;
                    if (aPA.getServizioApplicativoDefault() != null && (idServizioApplicativoDefault = DBUtils.getIdServizioApplicativo(aPA.getServizioApplicativoDefault(), tipoProprietario, nomeProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti)) <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaApplicativa(CREATE)] Impossibile recuperare l'ID del servizio applicativo di default '" + aPA.getServizioApplicativoDefault() + "'.");
                    }
                    stm.setLong(index++, idServizioApplicativoDefault);
                    stm.setLong(index++, aPA.getIdAccordo() != null ? aPA.getIdAccordo() : -1L);
                    stm.setLong(index++, aPA.getIdPortType() != null ? aPA.getIdPortType() : -1L);
                    stm.setString(index++, aPA.getCorrelazioneApplicativa() != null ? aPA.getCorrelazioneApplicativa().getScadenza() : null);
                    stm.setString(index++, aPA.getOptions());
                    stm.setString(index++, aPA.getCanale());
                    if (utenteRichiedente != null) {
                        stm.setString(index++, utenteRichiedente);
                    }
                    if (dataCreazione != null) {
                        stm.setTimestamp(index++, dataCreazione);
                    }
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Created " + n + " row(s)");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("nome_porta = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idProprietario);
                    stm.setString(2, nomePorta);
                    rs = stm.executeQuery();
                    if (!rs.next()) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaApplicativa(CREATE)] Impossibile recuperare l'ID della PortaApplicativa appena create.");
                    }
                    idPortaApplicativa = rs.getLong("id");
                    aPA.setId(idPortaApplicativa);
                    rs.close();
                    stm.close();
                    if (mtomProcessor != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_mtom_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getRequestFlow() != null) {
                            flow2 = mtomProcessor.getRequestFlow();
                            for (i = 0; i < flow2.sizeParameterList(); ++i) {
                                reqParam = flow2.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getPattern());
                                stm.setString(4, reqParam.getContentType());
                                stm.setInt(5, reqParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " mtom request flow con id=" + idPortaApplicativa);
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_mtom_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getResponseFlow() != null) {
                            flow = mtomProcessor.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                resParam = flow.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getPattern());
                                stm.setString(4, resParam.getContentType());
                                stm.setInt(5, resParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " mtom response flow con id=" + idPortaApplicativa);
                    }
                    if (messageSecurity != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_security_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getRequestFlow() != null) {
                            flow2 = messageSecurity.getRequestFlow();
                            for (i = 0; i < flow2.sizeParameterList(); ++i) {
                                BYOKWrappedValue byokValue2;
                                reqParam = flow2.getParameter(i);
                                int indexSec = 1;
                                stm.setLong(indexSec++, idPortaApplicativa);
                                stm.setString(indexSec++, reqParam.getNome());
                                String plainValue = reqParam.getValore();
                                String encValue = null;
                                if (driverBYOK != null && (DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(securityRequestMode, reqParam.getNome()) || BYOKUtilities.isWrappedValue(plainValue)) && (byokValue2 = driverBYOK.wrap(plainValue)) != null) {
                                    encValue = byokValue2.getWrappedValue();
                                    plainValue = byokValue2.getWrappedPlainValue();
                                }
                                stm.setString(indexSec++, plainValue);
                                stm.setString(indexSec++, encValue);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " request flow con id=" + idPortaApplicativa);
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_security_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getResponseFlow() != null) {
                            flow = messageSecurity.getResponseFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                BYOKWrappedValue byokValue3;
                                resParam = flow.getParameter(i);
                                int indexSec = 1;
                                stm.setLong(indexSec++, idPortaApplicativa);
                                stm.setString(indexSec++, resParam.getNome());
                                String plainValue = resParam.getValore();
                                String encValue = null;
                                if (driverBYOK != null && (DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(securityResponseMode, resParam.getNome()) || BYOKUtilities.isWrappedValue(plainValue)) && (byokValue3 = driverBYOK.wrap(plainValue)) != null) {
                                    encValue = byokValue3.getWrappedValue();
                                    plainValue = byokValue3.getWrappedPlainValue();
                                }
                                stm.setString(indexSec++, plainValue);
                                stm.setString(indexSec++, encValue);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " response flow con id=" + idPortaApplicativa);
                    }
                    if (corrApp != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_correlazione");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                            cae = corrApp.getElemento(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDBLib.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDBLib.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " correlazione applicativa con id=" + idPortaApplicativa);
                    }
                    if (corrAppRisposta != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_correlazione_risposta");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrAppRisposta.sizeElementoList(); ++i) {
                            cae = corrAppRisposta.getElemento(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, cae.getNome());
                            stm.setString(3, DriverConfigurazioneDBLib.getValue(cae.getIdentificazione()));
                            if (cae.getPattern() != null) {
                                stm.setString(4, cae.getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDBLib.getValue(cae.getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " correlazione applicativa risposta con id=" + idPortaApplicativa);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("porte_applicative_sa");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                    sqlQueryObject.addInsertField("connettore_nome", "?");
                    sqlQueryObject.addInsertField("connettore_notifica", "?");
                    sqlQueryObject.addInsertField("connettore_descrizione", "?");
                    sqlQueryObject.addInsertField("connettore_stato", "?");
                    sqlQueryObject.addInsertField("connettore_scheduling", "?");
                    sqlQueryObject.addInsertField("connettore_filtri", "?");
                    sqlQueryObject.addInsertField("connettore_coda", "?");
                    sqlQueryObject.addInsertField("connettore_priorita", "?");
                    sqlQueryObject.addInsertField("connettore_max_priorita", "?");
                    sqlQueryObject.addInsertField("utente_richiedente", "?");
                    sqlQueryObject.addInsertField("data_creazione", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    ArrayList<Long> idsPaSa = new ArrayList<Long>();
                    for (i = 0; i < aPA.sizeServizioApplicativoList(); ++i) {
                        servizioApplicativo = aPA.getServizioApplicativo(i);
                        nomeSA = servizioApplicativo.getNome();
                        String nomeProprietarioSA = aPA.getNomeSoggettoProprietario();
                        tipoProprietarioSA = aPA.getTipoSoggettoProprietario();
                        if (nomeSA == null || nomeSA.equals("")) {
                            throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Nome del ServizioApplicativo associato non valido.");
                        }
                        if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Nome Proprietario del ServizioApplicativo associato non valido.");
                        }
                        if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Tipo Proprietario del ServizioApplicativo associato non valido.");
                        }
                        long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                        if (idSA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                        }
                        idsPaSa.add(idSA);
                        String utenteRichiedenteSA = null;
                        utenteRichiedenteSA = servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto().getUtenteRichiedente() != null ? servizioApplicativo.getDatiConnettore().getProprietaOggetto().getUtenteRichiedente() : utenteRichiedente;
                        Timestamp dataCreazioneSA = null;
                        dataCreazioneSA = servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto().getDataCreazione() != null ? new Timestamp(servizioApplicativo.getDatiConnettore().getProprietaOggetto().getDataCreazione().getTime()) : dataCreazione;
                        int indexSA = 1;
                        stm.setLong(indexSA++, idPortaApplicativa);
                        stm.setLong(indexSA++, idSA);
                        stm.setString(indexSA++, servizioApplicativo.getDatiConnettore() != null ? servizioApplicativo.getDatiConnettore().getNome() : null);
                        stm.setInt(indexSA++, servizioApplicativo.getDatiConnettore() != null ? (servizioApplicativo.getDatiConnettore().isNotifica() ? 1 : 0) : 0);
                        stm.setString(indexSA++, servizioApplicativo.getDatiConnettore() != null ? servizioApplicativo.getDatiConnettore().getDescrizione() : null);
                        stm.setString(indexSA++, servizioApplicativo.getDatiConnettore() != null ? DriverConfigurazioneDBLib.getValue(servizioApplicativo.getDatiConnettore().getStato()) : null);
                        stm.setString(indexSA++, servizioApplicativo.getDatiConnettore() != null ? DriverConfigurazioneDBLib.getValue(servizioApplicativo.getDatiConnettore().getScheduling()) : null);
                        String filtri = null;
                        if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getFiltroList() != null && servizioApplicativo.getDatiConnettore().sizeFiltroList() > 0) {
                            StringBuilder bf = new StringBuilder();
                            for (int k = 0; k < servizioApplicativo.getDatiConnettore().sizeFiltroList(); ++k) {
                                if (k > 0) {
                                    bf.append(",");
                                }
                                bf.append(servizioApplicativo.getDatiConnettore().getFiltro(k));
                            }
                            filtri = bf.toString();
                        }
                        stm.setString(indexSA++, filtri);
                        if (servizioApplicativo.getDatiConnettore() != null) {
                            stm.setString(indexSA++, servizioApplicativo.getDatiConnettore().getCoda() != null ? servizioApplicativo.getDatiConnettore().getCoda() : "DEFAULT");
                            stm.setString(indexSA++, servizioApplicativo.getDatiConnettore().getPriorita() != null ? servizioApplicativo.getDatiConnettore().getPriorita() : "DEFAULT");
                            stm.setInt(indexSA++, servizioApplicativo.getDatiConnettore().isPrioritaMax() ? 1 : 0);
                        } else {
                            stm.setString(indexSA++, "DEFAULT");
                            stm.setString(indexSA++, "DEFAULT");
                            stm.setInt(indexSA++, 0);
                        }
                        stm.setString(indexSA++, utenteRichiedenteSA);
                        stm.setTimestamp(indexSA++, dataCreazioneSA);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " servizi applicativi associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    for (i = 0; i < aPA.sizeServizioApplicativoList(); ++i) {
                        int j;
                        servizioApplicativo = aPA.getServizioApplicativo(i);
                        nomeSA = servizioApplicativo.getNome();
                        if (servizioApplicativo.getDatiConnettore() == null || servizioApplicativo.getDatiConnettore().sizeProprietaList() <= 0) continue;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addFromTable("porte_applicative_sa");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        long idSA = (Long)idsPaSa.get(i);
                        long idPA_SA = -1L;
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.setLong(2, idSA);
                        rs = stm.executeQuery();
                        if (rs.next()) {
                            idPA_SA = rs.getLong("id");
                        }
                        rs.close();
                        stm.close();
                        if (idPA_SA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id della registrazione del Servizio Applicativo [" + nomeSA + "](id:" + idSA + ") alla porta applicativa con id:" + idPortaApplicativa);
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_sa_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (j = 0; j < servizioApplicativo.getDatiConnettore().sizeProprietaList(); ++j) {
                            Proprieta p = servizioApplicativo.getDatiConnettore().getProprieta(j);
                            if (p.getValore() == null || "".equals(p.getValore())) continue;
                            stm.setLong(1, idPA_SA);
                            stm.setString(2, p.getNome());
                            stm.setString(3, p.getValore());
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + j + " SetSAProp associati al Servizio Applicativo [" + nomeSA + "](id:" + idSA + ") della PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    if (aPA.getBehaviour() != null) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_behaviour_props");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPA.getBehaviour().sizeProprietaList(); ++i) {
                            propProtocollo = aPA.getBehaviour().getProprieta(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, propProtocollo.getNome());
                            stm.setString(3, propProtocollo.getValore());
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SeBehaviourProp associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pa_auth_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQueryObject.addInsertField("enc_value", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPA.sizeProprietaAutenticazioneList(); ++i) {
                        propProtocollo = aPA.getProprietaAutenticazione(i);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaApplicativa);
                        stm.setString(indexP++, propProtocollo.getNome());
                        plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolPropAutenticazione associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pa_authz_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQueryObject.addInsertField("enc_value", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPA.sizeProprietaAutorizzazioneList(); ++i) {
                        propProtocollo = aPA.getProprietaAutorizzazione(i);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaApplicativa);
                        stm.setString(indexP++, propProtocollo.getNome());
                        plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolPropAutorizzazione associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pa_authzc_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQueryObject.addInsertField("enc_value", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPA.sizeProprietaAutorizzazioneContenutoList(); ++i) {
                        propProtocollo = aPA.getProprietaAutorizzazioneContenuto(i);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaApplicativa);
                        stm.setString(indexP++, propProtocollo.getNome());
                        plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolPropAutorizzazioneContenuti associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pa_ct_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPA.sizeProprietaRateLimitingList(); ++i) {
                        propProtocollo = aPA.getProprietaRateLimiting(i);
                        stm.setLong(1, idPortaApplicativa);
                        stm.setString(2, propProtocollo.getNome());
                        stm.setString(3, propProtocollo.getValore());
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolPropRateLimiting associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("pa_properties");
                    sqlQueryObject.addInsertField("id_porta", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("valore", "?");
                    sqlQueryObject.addInsertField("enc_value", "?");
                    sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    for (i = 0; i < aPA.sizeProprietaList(); ++i) {
                        propProtocollo = aPA.getProprieta(i);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaApplicativa);
                        stm.setString(indexP++, propProtocollo.getNome());
                        plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                    }
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SetProtocolProp associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    n = 0;
                    if (aPA.getRuoli() != null && aPA.getRuoli().sizeRuoloList() > 0) {
                        for (int j = 0; j < aPA.getRuoli().sizeRuoloList(); ++j) {
                            ruolo = aPA.getRuoli().getRuolo(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_ruoli");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPA.getId());
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli alla PortaApplicativa[" + idPortaApplicativa + "]");
                    n = 0;
                    if (aPA.getScope() != null && aPA.getScope().sizeScopeList() > 0) {
                        for (int j = 0; j < aPA.getScope().sizeScopeList(); ++j) {
                            Scope scope = aPA.getScope().getScope(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_scope");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("scope", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPA.getId());
                            stm.setString(2, scope.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto scope[" + scope.getNome() + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " scope alla PortaApplicativa[" + idPortaApplicativa + "]");
                    n = 0;
                    if (aPA.getSoggetti() != null && aPA.getSoggetti().sizeSoggettoList() > 0) {
                        for (int j = 0; j < aPA.getSoggetti().sizeSoggettoList(); ++j) {
                            PortaApplicativaAutorizzazioneSoggetto soggetto = aPA.getSoggetti().getSoggetto(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_soggetti");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("tipo_soggetto", "?");
                            sqlQueryObject.addInsertField("nome_soggetto", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPA.getId());
                            stm.setString(2, soggetto.getTipo());
                            stm.setString(3, soggetto.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto soggetto [" + soggetto.getTipo() + "/" + soggetto.getNome() + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " soggetti alla PortaApplicativa[" + idPortaApplicativa + "]");
                    if (aPA.getServiziApplicativiAutorizzati() != null && aPA.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("porte_applicative_sa_auth");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPA.getServiziApplicativiAutorizzati().sizeServizioApplicativoList(); ++i) {
                            PortaApplicativaAutorizzazioneServizioApplicativo servizioApplicativo2 = aPA.getServiziApplicativiAutorizzati().getServizioApplicativo(i);
                            nomeSA = servizioApplicativo2.getNome();
                            String nomeProprietarioSA = servizioApplicativo2.getNomeSoggettoProprietario();
                            tipoProprietarioSA = servizioApplicativo2.getTipoSoggettoProprietario();
                            if (nomeSA == null || nomeSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Auth]::Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Auth]::Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Auth]::Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            stm.setLong(1, idPortaApplicativa);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " servizi applicativi autorizzati associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    if (aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getServiziApplicativi() != null && aPA.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_token_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPA.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList(); ++i) {
                            PortaApplicativaAutorizzazioneServizioApplicativo servizioApplicativo3 = aPA.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(i);
                            nomeSA = servizioApplicativo3.getNome();
                            String nomeProprietarioSA = servizioApplicativo3.getNomeSoggettoProprietario();
                            tipoProprietarioSA = servizioApplicativo3.getTipoSoggettoProprietario();
                            if (nomeSA == null || nomeSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[TokenAuth]::Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[TokenAuth]::Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[TokenAuth]::Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            stm.setLong(1, idPortaApplicativa);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " servizi applicativi autorizzati (token) associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    n = 0;
                    if (aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getRuoli() != null && aPA.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                        for (int j = 0; j < aPA.getAutorizzazioneToken().getRuoli().sizeRuoloList(); ++j) {
                            ruolo = aPA.getAutorizzazioneToken().getRuoli().getRuolo(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_token_ruoli");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPA.getId());
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] (token) alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli (token) alla PortaApplicativa[" + idPortaApplicativa + "]");
                    n = 0;
                    if (aPA.getAzione() != null && aPA.getAzione().sizeAzioneDelegataList() > 0) {
                        for (int j = 0; j < aPA.getAzione().sizeAzioneDelegataList(); ++j) {
                            String azioneDelegata = aPA.getAzione().getAzioneDelegata(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_azioni");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("azione", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPA.getId());
                            stm.setString(2, azioneDelegata);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto azione delegata [" + azioneDelegata + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " azioni delegate alla PortaApplicativa[" + idPortaApplicativa + "]");
                    n = 0;
                    if (responseCacheRegole != null && responseCacheRegole.size() > 0) {
                        for (int j = 0; j < responseCacheRegole.size(); ++j) {
                            ResponseCachingConfigurazioneRegola regola = responseCacheRegole.get(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_cache_regole");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            if (regola.getReturnCodeMin() != null && regola.getReturnCodeMin() > 0) {
                                sqlQueryObject.addInsertField("status_min", "?");
                            }
                            if (regola.getReturnCodeMax() != null && regola.getReturnCodeMax() > 0) {
                                sqlQueryObject.addInsertField("status_max", "?");
                            }
                            sqlQueryObject.addInsertField("fault", "?");
                            if (regola.getCacheTimeoutSeconds() != null && regola.getCacheTimeoutSeconds() > 0) {
                                sqlQueryObject.addInsertField("cache_seconds", "?");
                            }
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            int indexCR = 1;
                            stm.setLong(indexCR++, aPA.getId());
                            if (regola.getReturnCodeMin() != null && regola.getReturnCodeMin() > 0) {
                                stm.setInt(indexCR++, regola.getReturnCodeMin());
                            }
                            if (regola.getReturnCodeMax() != null && regola.getReturnCodeMax() > 0) {
                                stm.setInt(indexCR++, regola.getReturnCodeMax());
                            }
                            stm.setInt(indexCR++, regola.getFault() ? 1 : 0);
                            if (regola.getCacheTimeoutSeconds() != null && regola.getCacheTimeoutSeconds() > 0) {
                                stm.setInt(indexCR++, regola.getCacheTimeoutSeconds());
                            }
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta regola di cache alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " regole di cache alla PortaApplicativa[" + idPortaApplicativa + "]");
                    n = 0;
                    if (aPA.sizeAttributeAuthorityList() > 0) {
                        for (int j = 0; j < aPA.sizeAttributeAuthorityList(); ++j) {
                            AttributeAuthority aa = aPA.getAttributeAuthority(j);
                            String attributi = null;
                            if (aa.sizeAttributoList() > 0) {
                                StringBuilder bf = new StringBuilder();
                                for (int aaI = 0; aaI < aa.sizeAttributoList(); ++aaI) {
                                    if (aaI > 0) {
                                        bf.append(",");
                                    }
                                    bf.append(aa.getAttributo(aaI));
                                }
                                attributi = bf.toString();
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_aa");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("attributi", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aPA.getId());
                            stm.setString(2, aa.getNome());
                            stm.setString(3, attributi);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto A.A.[" + aa.getNome() + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " A.A. alla PortaApplicativa[" + idPortaApplicativa + "]");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoDatabase, aPA.getId(), "pa", "db");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoFiletrace, aPA.getId(), "pa", "filetrace");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazioneFiletrace(type, con, tracciamentoFiletraceDetails, aPA.getId(), "pa");
                    DriverConfigurazioneDB_dumpLIB.CRUDDumpConfigurazione(type, con, aPA.getDump(), aPA.getId(), "pa");
                    DriverConfigurazioneDBTrasformazioniLib.CRUDTrasformazioni(type, con, aPA.getTrasformazioni(), aPA.getId(), false);
                    if (configHandlers != null) {
                        if (configHandlers.getRequest() != null) {
                            DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, null, aPA.getId(), true, configHandlers.getRequest());
                        }
                        if (configHandlers.getResponse() != null) {
                            DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, null, aPA.getId(), false, configHandlers.getResponse());
                        }
                    }
                    i = 0;
                    if (aPA.sizeExtendedInfoList() > 0 && extInfoConfigurazioneDriver != null) {
                        for (i = 0; i < aPA.sizeExtendedInfoList(); ++i) {
                            extInfoConfigurazioneDriver.createExtendedInfo(con, DriverConfigurazioneDBLib.log, aPA, aPA.getExtendedInfo(i), CRUDType.CREATE);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + i + " associazioni ExtendedInfo<->PortaApplicativa associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    break;
                }
                case 2: {
                    String nomeSA;
                    PortaApplicativaServizioApplicativo servizioApplicativo;
                    Object cae;
                    BaseBeanWithId resParam;
                    BaseBeanWithId flow;
                    BaseBeanWithId reqParam;
                    PortaApplicativaAzioneIdentificazione modeAzione;
                    Integer versioneServizio;
                    String oldNomePA = null;
                    if (aPA.getOldIDPortaApplicativaForUpdate() != null) {
                        oldNomePA = aPA.getOldIDPortaApplicativaForUpdate().getNome();
                    }
                    if (oldNomePA == null || oldNomePA.equals("")) {
                        oldNomePA = nomePorta;
                    }
                    String tipoServizio = servizio != null ? servizio.getTipo() : null;
                    String nomeServizio = servizio != null ? servizio.getNome() : null;
                    Integer n3 = versioneServizio = servizio != null ? servizio.getVersione() : null;
                    if (idServizio <= 0L) {
                        if (tipoServizio == null || tipoServizio.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                        }
                        if (nomeServizio == null || nomeServizio.equals("")) {
                            throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                        }
                        if (versioneServizio == null) {
                            throw new DriverConfigurazioneException("Versione Servizio non impostato.");
                        }
                    }
                    String nomeAzione = azione != null ? azione.getNome() : null;
                    String patternAzione = azione != null ? azione.getPattern() : null;
                    String nomePortaDeleganteAzione = azione != null ? azione.getNomePortaDelegante() : null;
                    StatoFunzionalita forceInterfaceBased = azione != null ? azione.getForceInterfaceBased() : null;
                    PortaApplicativaAzioneIdentificazione portaApplicativaAzioneIdentificazione = modeAzione = azione != null ? azione.getIdentificazione() : null;
                    if (azione != null) {
                        if (modeAzione == null || modeAzione.equals("")) {
                            modeAzione = PortaApplicativaAzioneIdentificazione.STATIC;
                        }
                        switch (modeAzione) {
                            case CONTENT_BASED: 
                            case URL_BASED: 
                            case HEADER_BASED: {
                                if (patternAzione == null || patternAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case DELEGATED_BY: {
                                if (nomePortaDeleganteAzione == null || nomePortaDeleganteAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Porta Delegante Azione non impostata.");
                                }
                                nomeAzione = null;
                                break;
                            }
                            case INPUT_BASED: 
                            case SOAP_ACTION_BASED: 
                            case INTERFACE_BASED: 
                            case PROTOCOL_BASED: {
                                break;
                            }
                            case STATIC: {
                                if (nomeAzione == null || nomeAzione.equals("")) {
                                    throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                }
                                patternAzione = null;
                                break;
                            }
                        }
                    }
                    String utenteUltimaModifica = null;
                    if (aPA.getProprietaOggetto() != null && aPA.getProprietaOggetto().getUtenteUltimaModifica() != null) {
                        utenteUltimaModifica = aPA.getProprietaOggetto().getUtenteUltimaModifica();
                    }
                    Timestamp dataUltimaModifica = null;
                    dataUltimaModifica = aPA.getProprietaOggetto() != null && aPA.getProprietaOggetto().getDataUltimaModifica() != null ? new Timestamp(aPA.getProprietaOggetto().getDataUltimaModifica().getTime()) : DateManager.getTimestamp();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("porte_applicative");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("id_soggetto_virtuale", "?");
                    sqlQueryObject.addUpdateField("tipo_soggetto_virtuale", "?");
                    sqlQueryObject.addUpdateField("nome_soggetto_virtuale", "?");
                    sqlQueryObject.addUpdateField("id_servizio", "?");
                    sqlQueryObject.addUpdateField("tipo_servizio", "?");
                    sqlQueryObject.addUpdateField("servizio", "?");
                    sqlQueryObject.addUpdateField("versione_servizio", "?");
                    sqlQueryObject.addUpdateField("azione", "?");
                    sqlQueryObject.addUpdateField("mode_azione", "?");
                    sqlQueryObject.addUpdateField("pattern_azione", "?");
                    sqlQueryObject.addUpdateField("nome_porta_delegante_azione", "?");
                    sqlQueryObject.addUpdateField("force_interface_based_azione", "?");
                    sqlQueryObject.addUpdateField("mtom_request_mode", "?");
                    sqlQueryObject.addUpdateField("mtom_response_mode", "?");
                    sqlQueryObject.addUpdateField("security", "?");
                    sqlQueryObject.addUpdateField("security_mtom_req", "?");
                    sqlQueryObject.addUpdateField("security_mtom_res", "?");
                    sqlQueryObject.addUpdateField("security_request_mode", "?");
                    sqlQueryObject.addUpdateField("security_response_mode", "?");
                    sqlQueryObject.addUpdateField("nome_porta", "?");
                    sqlQueryObject.addUpdateField("ricevuta_asincrona_sim", "?");
                    sqlQueryObject.addUpdateField("ricevuta_asincrona_asim", "?");
                    sqlQueryObject.addUpdateField("integrazione", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_stato", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_tipo", "?");
                    sqlQueryObject.addUpdateField("validazione_contenuti_mtom", "?");
                    sqlQueryObject.addUpdateField("id_soggetto", "?");
                    sqlQueryObject.addUpdateField("allega_body", "?");
                    sqlQueryObject.addUpdateField("scarta_body", "?");
                    sqlQueryObject.addUpdateField("gestione_manifest", "?");
                    sqlQueryObject.addUpdateField("stateless", "?");
                    sqlQueryObject.addUpdateField("behaviour", "?");
                    sqlQueryObject.addUpdateField("autenticazione", "?");
                    sqlQueryObject.addUpdateField("autenticazione_opzionale", "?");
                    sqlQueryObject.addUpdateField("token_policy", "?");
                    sqlQueryObject.addUpdateField("token_opzionale", "?");
                    sqlQueryObject.addUpdateField("token_validazione", "?");
                    sqlQueryObject.addUpdateField("token_introspection", "?");
                    sqlQueryObject.addUpdateField("token_user_info", "?");
                    sqlQueryObject.addUpdateField("token_forward", "?");
                    sqlQueryObject.addUpdateField("token_options", "?");
                    sqlQueryObject.addUpdateField("token_authn_issuer", "?");
                    sqlQueryObject.addUpdateField("token_authn_client_id", "?");
                    sqlQueryObject.addUpdateField("token_authn_subject", "?");
                    sqlQueryObject.addUpdateField("token_authn_username", "?");
                    sqlQueryObject.addUpdateField("token_authn_email", "?");
                    sqlQueryObject.addUpdateField("autorizzazione", "?");
                    sqlQueryObject.addUpdateField("autorizzazione_xacml", "?");
                    sqlQueryObject.addUpdateField("autorizzazione_contenuto", "?");
                    sqlQueryObject.addUpdateField("ruoli_match", "?");
                    sqlQueryObject.addUpdateField("token_sa_stato", "?");
                    sqlQueryObject.addUpdateField("token_ruoli_stato", "?");
                    sqlQueryObject.addUpdateField("token_ruoli_match", "?");
                    sqlQueryObject.addUpdateField("token_ruoli_tipologia", "?");
                    sqlQueryObject.addUpdateField("scope_stato", "?");
                    sqlQueryObject.addUpdateField("scope_match", "?");
                    sqlQueryObject.addUpdateField("ricerca_porta_azione_delegata", "?");
                    sqlQueryObject.addUpdateField("msg_diag_severita", "?");
                    sqlQueryObject.addUpdateField("tracciamento_stato", "?");
                    sqlQueryObject.addUpdateField("tracciamento_esiti", "?");
                    sqlQueryObject.addUpdateField("transazioni_tempi", "?");
                    sqlQueryObject.addUpdateField("transazioni_token", "?");
                    sqlQueryObject.addUpdateField("stato", "?");
                    sqlQueryObject.addUpdateField("cors_stato", "?");
                    sqlQueryObject.addUpdateField("cors_tipo", "?");
                    sqlQueryObject.addUpdateField("cors_all_allow_origins", "?");
                    sqlQueryObject.addUpdateField("cors_all_allow_methods", "?");
                    sqlQueryObject.addUpdateField("cors_all_allow_headers", "?");
                    sqlQueryObject.addUpdateField("cors_allow_credentials", "?");
                    sqlQueryObject.addUpdateField("cors_allow_max_age", "?");
                    sqlQueryObject.addUpdateField("cors_allow_max_age_seconds", "?");
                    sqlQueryObject.addUpdateField("cors_allow_origins", "?");
                    sqlQueryObject.addUpdateField("cors_allow_headers", "?");
                    sqlQueryObject.addUpdateField("cors_allow_methods", "?");
                    sqlQueryObject.addUpdateField("cors_allow_expose_headers", "?");
                    sqlQueryObject.addUpdateField("response_cache_stato", "?");
                    sqlQueryObject.addUpdateField("response_cache_seconds", "?");
                    sqlQueryObject.addUpdateField("response_cache_max_msg_size", "?");
                    sqlQueryObject.addUpdateField("response_cache_control_nocache", "?");
                    sqlQueryObject.addUpdateField("response_cache_control_maxage", "?");
                    sqlQueryObject.addUpdateField("response_cache_control_nostore", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_url", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_query", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_query_list", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_headers", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_hdr_list", "?");
                    sqlQueryObject.addUpdateField("response_cache_hash_payload", "?");
                    sqlQueryObject.addUpdateField("id_sa_default", "?");
                    sqlQueryObject.addUpdateField("id_accordo", "?");
                    sqlQueryObject.addUpdateField("id_port_type", "?");
                    sqlQueryObject.addUpdateField("scadenza_correlazione_appl", "?");
                    sqlQueryObject.addUpdateField("options", "?");
                    sqlQueryObject.addUpdateField("canale", "?");
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("nome_porta=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = con.prepareStatement(sqlQuery);
                    idPortaApplicativa = DBUtils.getIdPortaApplicativa(oldNomePA, con, DriverConfigurazioneDBLib.tipoDB);
                    if (idPortaApplicativa <= 0L) {
                        idPortaApplicativa = DBUtils.getIdPortaApplicativa(oldNomePA, con, DriverConfigurazioneDBLib.tipoDB);
                    }
                    if (idPortaApplicativa <= 0L) {
                        throw new DriverConfigurazioneException("Impossibile recuperare l'id della Porta Applicativa nomePA[" + oldNomePA + "] (old[" + (aPA.getOldIDPortaApplicativaForUpdate() != null ? aPA.getOldIDPortaApplicativaForUpdate().getNome() : null) + "]");
                    }
                    int index = 1;
                    stm.setString(index++, descrizione);
                    stm.setLong(index++, idSoggVirt);
                    stm.setString(index++, tipoSoggVirt);
                    stm.setString(index++, nomeSoggVirt);
                    stm.setLong(index++, idServizio);
                    stm.setString(index++, tipoServizio);
                    stm.setString(index++, nomeServizio);
                    stm.setInt(index++, versioneServizio);
                    stm.setString(index++, azione != null ? azione.getNome() : null);
                    if (modeAzione != null) {
                        stm.setString(index++, modeAzione.toString());
                    } else {
                        stm.setString(index++, null);
                    }
                    stm.setString(index++, patternAzione);
                    stm.setString(index++, nomePortaDeleganteAzione);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(forceInterfaceBased));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(mtomModeRequest));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(mtomModeResponse));
                    stm.setString(index++, messageSecurityStatus);
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(messageSecurityApplyMtomRequest));
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(messageSecurityApplyMtomResponse));
                    stm.setString(index++, securityRequestMode);
                    stm.setString(index++, securityResponseMode);
                    stm.setString(index++, nomePorta);
                    stm.setString(index++, aPA.getRicevutaAsincronaSimmetrica() != null ? DriverConfigurazioneDBLib.getValue(aPA.getRicevutaAsincronaSimmetrica()) : null);
                    stm.setString(index++, aPA.getRicevutaAsincronaAsimmetrica() != null ? DriverConfigurazioneDBLib.getValue(aPA.getRicevutaAsincronaAsimmetrica()) : null);
                    stm.setString(index++, aPA.getIntegrazione() != null ? aPA.getIntegrazione() : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPA.getValidazioneContenutiApplicativi().getStato()) : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPA.getValidazioneContenutiApplicativi().getTipo()) : null);
                    stm.setString(index++, aPA.getValidazioneContenutiApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPA.getValidazioneContenutiApplicativi().getAcceptMtomMessage()) : null);
                    stm.setLong(index++, idProprietario);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getAllegaBody()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getScartaBody()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getGestioneManifest()) : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getStateless()) : null);
                    stm.setString(index++, behaviour);
                    stm.setString(index++, autenticazione);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getAutenticazioneOpzionale()) : null);
                    stm.setString(index++, gestioneToken != null ? gestioneToken.getPolicy() : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getTokenOpzionale()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getValidazione()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getIntrospection()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getUserInfo()) : null);
                    stm.setString(index++, gestioneToken != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getForward()) : null);
                    stm.setString(index++, gestioneToken != null ? gestioneToken.getOptions() : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getIssuer()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getClientId()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getSubject()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getUsername()) : null);
                    stm.setString(index++, gestioneToken != null && gestioneToken.getAutenticazione() != null ? DriverConfigurazioneDBLib.getValue(gestioneToken.getAutenticazione().getEmail()) : null);
                    stm.setString(index++, autorizzazione);
                    stm.setString(index++, autorizzazioneXacmlPolicy);
                    stm.setString(index++, aPA != null ? aPA.getAutorizzazioneContenuto() : null);
                    stm.setString(index++, aPA != null && aPA.getRuoli() != null && aPA.getRuoli().getMatch() != null ? aPA.getRuoli().getMatch().getValue() : null);
                    stm.setString(index++, aPA != null && aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getAutorizzazioneApplicativi() != null ? DriverConfigurazioneDBLib.getValue(aPA.getAutorizzazioneToken().getAutorizzazioneApplicativi()) : null);
                    stm.setString(index++, aPA != null && aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getAutorizzazioneRuoli() != null ? DriverConfigurazioneDBLib.getValue(aPA.getAutorizzazioneToken().getAutorizzazioneRuoli()) : null);
                    stm.setString(index++, aPA != null && aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getRuoli() != null && aPA.getAutorizzazioneToken().getRuoli().getMatch() != null ? aPA.getAutorizzazioneToken().getRuoli().getMatch().getValue() : null);
                    stm.setString(index++, aPA != null && aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getTipologiaRuoli() != null ? aPA.getAutorizzazioneToken().getTipologiaRuoli().getValue() : null);
                    stm.setString(index++, aPA != null && aPA.getScope() != null && aPA.getScope().getStato() != null ? DriverConfigurazioneDBLib.getValue(aPA.getScope().getStato()) : null);
                    stm.setString(index++, aPA != null && aPA.getScope() != null && aPA.getScope().getMatch() != null ? aPA.getScope().getMatch().getValue() : null);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getRicercaPortaAzioneDelegata()) : null);
                    stm.setString(index++, msgDiagSeverita);
                    stm.setString(index++, tracciamentoStato);
                    stm.setString(index++, tracciamentoEsiti);
                    stm.setString(index++, transazioniTempiElaborazione);
                    stm.setString(index++, transazioniToken);
                    stm.setString(index++, aPA != null ? DriverConfigurazioneDBLib.getValue(aPA.getStato()) : null);
                    stm.setString(index++, corsStato);
                    stm.setString(index++, corsTipo);
                    stm.setString(index++, corsAllAllowOrigins);
                    stm.setString(index++, corsAllAllowMethods);
                    stm.setString(index++, corsAllAllowHeaders);
                    stm.setString(index++, corsAllowCredentials);
                    stm.setInt(index++, corsAllowMaxAge);
                    if (corsAllowMaxAgeSeconds != null) {
                        stm.setInt(index++, corsAllowMaxAgeSeconds);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    stm.setString(index++, corsAllowOrigins);
                    stm.setString(index++, corsAllowHeaders);
                    stm.setString(index++, corsAllowMethods);
                    stm.setString(index++, corsAllowExposeHeaders);
                    stm.setString(index++, responseCacheStato);
                    if (responseCacheSeconds != null) {
                        stm.setInt(index++, responseCacheSeconds);
                    } else {
                        stm.setNull(index++, 4);
                    }
                    if (responseCacheMaxMsgSize != null) {
                        stm.setLong(index++, responseCacheMaxMsgSize);
                    } else {
                        stm.setNull(index++, -5);
                    }
                    stm.setInt(index++, responseCacheNoCache ? 1 : 0);
                    stm.setInt(index++, responseCacheMaxAge ? 1 : 0);
                    stm.setInt(index++, responseCacheNoStore ? 1 : 0);
                    stm.setString(index++, responseCacheHashUrl);
                    stm.setString(index++, responseCacheHashQuery);
                    stm.setString(index++, responseCacheHashQueryList);
                    stm.setString(index++, responseCacheHashHeaders);
                    stm.setString(index++, responseCacheHashHeadersList);
                    stm.setString(index++, responseCacheHashPayload);
                    long idServizioApplicativoDefault = -1L;
                    if (aPA.getServizioApplicativoDefault() != null && (idServizioApplicativoDefault = DBUtils.getIdServizioApplicativo(aPA.getServizioApplicativoDefault(), tipoProprietario, nomeProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti)) <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaApplicativa(CREATE)] Impossibile recuperare l'ID del servizio applicativo di default '" + aPA.getServizioApplicativoDefault() + "'.");
                    }
                    stm.setLong(index++, idServizioApplicativoDefault);
                    stm.setLong(index++, aPA.getIdAccordo() != null ? aPA.getIdAccordo() : -1L);
                    stm.setLong(index++, aPA.getIdPortType() != null ? aPA.getIdPortType() : -1L);
                    stm.setString(index++, aPA.getCorrelazioneApplicativa() != null ? aPA.getCorrelazioneApplicativa().getScadenza() : null);
                    stm.setString(index++, aPA.getOptions());
                    stm.setString(index++, aPA.getCanale());
                    if (utenteUltimaModifica != null) {
                        stm.setString(index++, utenteUltimaModifica);
                    }
                    if (dataUltimaModifica != null) {
                        stm.setTimestamp(index++, dataUltimaModifica);
                    }
                    stm.setString(index++, oldNomePA);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Updated " + n + " row(s).");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_mtom_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.executeUpdate();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_mtom_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.executeUpdate();
                    stm.close();
                    if (mtomProcessor != null) {
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_mtom_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getRequestFlow() != null) {
                            flow = mtomProcessor.getRequestFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                reqParam = flow.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getPattern());
                                stm.setString(4, reqParam.getContentType());
                                stm.setInt(5, reqParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " mtom request flow con id=" + idPortaApplicativa);
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_mtom_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("content_type", "?");
                        sqlQueryObject.addInsertField("required", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (mtomProcessor.getResponseFlow() != null) {
                            MtomProcessorFlow flow3 = mtomProcessor.getResponseFlow();
                            for (i = 0; i < flow3.sizeParameterList(); ++i) {
                                resParam = flow3.getParameter(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getPattern());
                                stm.setString(4, resParam.getContentType());
                                stm.setInt(5, resParam.getRequired() ? 1 : 0);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " mtom response flow con id=" + idPortaApplicativa);
                    }
                    if (messageSecurity != null) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addDeleteTable("pa_security_request");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.executeUpdate();
                        stm.close();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addDeleteTable("pa_security_response");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.executeUpdate();
                        stm.close();
                        reqParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_security_request");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getRequestFlow() != null) {
                            flow = messageSecurity.getRequestFlow();
                            for (i = 0; i < flow.sizeParameterList(); ++i) {
                                BYOKWrappedValue byokValue;
                                reqParam = flow.getParameter(i);
                                int indexSec = 1;
                                stm.setLong(indexSec++, idPortaApplicativa);
                                stm.setString(indexSec++, reqParam.getNome());
                                String plainValue = reqParam.getValore();
                                String encValue = null;
                                if (driverBYOK != null && (DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(securityRequestMode, reqParam.getNome()) || BYOKUtilities.isWrappedValue(plainValue)) && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                                    encValue = byokValue.getWrappedValue();
                                    plainValue = byokValue.getWrappedPlainValue();
                                }
                                stm.setString(indexSec++, plainValue);
                                stm.setString(indexSec++, encValue);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " request flow con id=" + idPortaApplicativa);
                        resParam = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_security_response");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        i = 0;
                        if (messageSecurity.getResponseFlow() != null) {
                            MessageSecurityFlow flow4 = messageSecurity.getResponseFlow();
                            for (i = 0; i < flow4.sizeParameterList(); ++i) {
                                BYOKWrappedValue byokValue;
                                resParam = flow4.getParameter(i);
                                int indexSec = 1;
                                stm.setLong(indexSec++, idPortaApplicativa);
                                stm.setString(indexSec++, resParam.getNome());
                                String plainValue = resParam.getValore();
                                String encValue = null;
                                if (driverBYOK != null && (DriverConfigurazioneDB_genericPropertiesDriver.isConfidentialProperty(securityResponseMode, resParam.getNome()) || BYOKUtilities.isWrappedValue(plainValue)) && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                                    encValue = byokValue.getWrappedValue();
                                    plainValue = byokValue.getWrappedPlainValue();
                                }
                                stm.setString(indexSec++, plainValue);
                                stm.setString(indexSec++, encValue);
                                stm.executeUpdate();
                            }
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " response flow con id=" + idPortaApplicativa);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_correlazione");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.executeUpdate();
                    stm.close();
                    if (corrApp != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_correlazione");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                            cae = corrApp.getElemento(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, ((CorrelazioneApplicativaElemento)cae).getNome());
                            stm.setString(3, DriverConfigurazioneDBLib.getValue(((CorrelazioneApplicativaElemento)cae).getIdentificazione()));
                            if (((CorrelazioneApplicativaElemento)cae).getPattern() != null) {
                                stm.setString(4, ((CorrelazioneApplicativaElemento)cae).getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDBLib.getValue(((CorrelazioneApplicativaElemento)cae).getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " correlazione applicativa con id=" + idPortaApplicativa);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_correlazione_risposta");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.executeUpdate();
                    stm.close();
                    if (corrAppRisposta != null) {
                        cae = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_correlazione_risposta");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome_elemento", "?");
                        sqlQueryObject.addInsertField("mode_correlazione", "?");
                        sqlQueryObject.addInsertField("pattern", "?");
                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < corrAppRisposta.sizeElementoList(); ++i) {
                            cae = corrAppRisposta.getElemento(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, ((CorrelazioneApplicativaRispostaElemento)cae).getNome());
                            stm.setString(3, DriverConfigurazioneDBLib.getValue(((CorrelazioneApplicativaRispostaElemento)cae).getIdentificazione()));
                            if (((CorrelazioneApplicativaRispostaElemento)cae).getPattern() != null) {
                                stm.setString(4, ((CorrelazioneApplicativaRispostaElemento)cae).getPattern());
                            } else {
                                stm.setString(4, "");
                            }
                            stm.setString(5, DriverConfigurazioneDBLib.getValue(((CorrelazioneApplicativaRispostaElemento)cae).getIdentificazioneFallita()));
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inserted " + i + " correlazione applicativa risposta con id=" + idPortaApplicativa);
                    }
                    ArrayList<Long> idsPaSa = new ArrayList<Long>();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative_sa");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    rs = stm.executeQuery();
                    while (rs.next()) {
                        idsPaSa.add(rs.getLong("id"));
                    }
                    rs.close();
                    stm.close();
                    if (!idsPaSa.isEmpty()) {
                        for (Long idsapa : idsPaSa) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addDeleteTable("pa_sa_properties");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idsapa);
                            n = stm.executeUpdate();
                            stm.close();
                            DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta relative all'associazione '" + idsapa + "' (Porta Applicativa " + idPortaApplicativa + ")");
                        }
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " servizi applicativi associati alla Porta Applicativa " + idPortaApplicativa);
                    n = 0;
                    idsPaSa = new ArrayList();
                    for (i = 0; i < aPA.sizeServizioApplicativoList(); ++i) {
                        servizioApplicativo = aPA.getServizioApplicativo(i);
                        nomeSA = servizioApplicativo.getNome();
                        String nomeProprietarioSA = aPA.getNomeSoggettoProprietario();
                        String tipoProprietarioSA = aPA.getTipoSoggettoProprietario();
                        if (nomeSA == null || nomeSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                        }
                        if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                        }
                        if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                            throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                        }
                        long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                        if (idSA <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                        }
                        idsPaSa.add(idSA);
                        String utenteRichiedenteSA = null;
                        if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto().getUtenteRichiedente() != null) {
                            utenteRichiedenteSA = servizioApplicativo.getDatiConnettore().getProprietaOggetto().getUtenteRichiedente();
                        } else if (aPA.getProprietaOggetto() != null && aPA.getProprietaOggetto().getUtenteRichiedente() != null) {
                            utenteRichiedenteSA = aPA.getProprietaOggetto().getUtenteRichiedente();
                        }
                        Timestamp dataCreazioneSA = null;
                        dataCreazioneSA = servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto().getDataCreazione() != null ? new Timestamp(servizioApplicativo.getDatiConnettore().getProprietaOggetto().getDataCreazione().getTime()) : (aPA.getProprietaOggetto() != null && aPA.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(aPA.getProprietaOggetto().getDataCreazione().getTime()) : DateManager.getTimestamp());
                        String utenteUltimaModificaSA = null;
                        if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto().getUtenteUltimaModifica() != null) {
                            utenteUltimaModificaSA = servizioApplicativo.getDatiConnettore().getProprietaOggetto().getUtenteUltimaModifica();
                        }
                        Timestamp dataUltimaModificaSA = null;
                        if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto() != null && servizioApplicativo.getDatiConnettore().getProprietaOggetto().getDataUltimaModifica() != null) {
                            dataUltimaModificaSA = new Timestamp(servizioApplicativo.getDatiConnettore().getProprietaOggetto().getDataUltimaModifica().getTime());
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("porte_applicative_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQueryObject.addInsertField("connettore_nome", "?");
                        sqlQueryObject.addInsertField("connettore_notifica", "?");
                        sqlQueryObject.addInsertField("connettore_descrizione", "?");
                        sqlQueryObject.addInsertField("connettore_stato", "?");
                        sqlQueryObject.addInsertField("connettore_scheduling", "?");
                        sqlQueryObject.addInsertField("connettore_filtri", "?");
                        sqlQueryObject.addInsertField("connettore_coda", "?");
                        sqlQueryObject.addInsertField("connettore_priorita", "?");
                        sqlQueryObject.addInsertField("connettore_max_priorita", "?");
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                        sqlQueryObject.addInsertField("data_creazione", "?");
                        sqlQueryObject.addInsertField("utente_ultima_modifica", "?");
                        sqlQueryObject.addInsertField("data_ultima_modifica", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexSA = 1;
                        stm.setLong(indexSA++, idPortaApplicativa);
                        stm.setLong(indexSA++, idSA);
                        stm.setString(indexSA++, servizioApplicativo.getDatiConnettore() != null ? servizioApplicativo.getDatiConnettore().getNome() : null);
                        stm.setInt(indexSA++, servizioApplicativo.getDatiConnettore() != null ? (servizioApplicativo.getDatiConnettore().isNotifica() ? 1 : 0) : 0);
                        stm.setString(indexSA++, servizioApplicativo.getDatiConnettore() != null ? servizioApplicativo.getDatiConnettore().getDescrizione() : null);
                        stm.setString(indexSA++, servizioApplicativo.getDatiConnettore() != null ? DriverConfigurazioneDBLib.getValue(servizioApplicativo.getDatiConnettore().getStato()) : null);
                        stm.setString(indexSA++, servizioApplicativo.getDatiConnettore() != null ? DriverConfigurazioneDBLib.getValue(servizioApplicativo.getDatiConnettore().getScheduling()) : null);
                        String filtri = null;
                        if (servizioApplicativo.getDatiConnettore() != null && servizioApplicativo.getDatiConnettore().getFiltroList() != null && servizioApplicativo.getDatiConnettore().sizeFiltroList() > 0) {
                            StringBuilder bf = new StringBuilder();
                            for (int k = 0; k < servizioApplicativo.getDatiConnettore().sizeFiltroList(); ++k) {
                                if (k > 0) {
                                    bf.append(",");
                                }
                                bf.append(servizioApplicativo.getDatiConnettore().getFiltro(k));
                            }
                            filtri = bf.toString();
                        }
                        stm.setString(indexSA++, filtri);
                        if (servizioApplicativo.getDatiConnettore() != null) {
                            stm.setString(indexSA++, servizioApplicativo.getDatiConnettore().getCoda() != null ? servizioApplicativo.getDatiConnettore().getCoda() : "DEFAULT");
                            stm.setString(indexSA++, servizioApplicativo.getDatiConnettore().getPriorita() != null ? servizioApplicativo.getDatiConnettore().getPriorita() : "DEFAULT");
                            stm.setInt(indexSA++, servizioApplicativo.getDatiConnettore().isPrioritaMax() ? 1 : 0);
                        } else {
                            stm.setString(indexSA++, "DEFAULT");
                            stm.setString(indexSA++, "DEFAULT");
                            stm.setInt(indexSA++, 0);
                        }
                        stm.setString(indexSA++, utenteRichiedenteSA);
                        stm.setTimestamp(indexSA++, dataCreazioneSA);
                        stm.setString(indexSA++, utenteUltimaModificaSA);
                        stm.setTimestamp(indexSA++, dataUltimaModificaSA);
                        stm.executeUpdate();
                        stm.close();
                        ++n;
                        DriverConfigurazioneDBLib.logDebug("Aggiunta associazione PortaApplicativa<->ServizioApplicativo [" + idPortaApplicativa + "]<->[" + idSA + "]");
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " associazioni PortaApplicativa<->ServizioApplicativo associati alla PortaDelegata[" + idPortaApplicativa + "]");
                    for (i = 0; i < aPA.sizeServizioApplicativoList(); ++i) {
                        int j;
                        servizioApplicativo = aPA.getServizioApplicativo(i);
                        nomeSA = servizioApplicativo.getNome();
                        if (servizioApplicativo.getDatiConnettore() == null || servizioApplicativo.getDatiConnettore().sizeProprietaList() <= 0) continue;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addFromTable("porte_applicative_sa");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        long idSA = (Long)idsPaSa.get(i);
                        long idPaSa = -1L;
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.setLong(2, idSA);
                        rs = stm.executeQuery();
                        if (rs.next()) {
                            idPaSa = rs.getLong("id");
                        }
                        rs.close();
                        stm.close();
                        if (idPaSa <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id della registrazione del Servizio Applicativo [" + nomeSA + "](id:" + idSA + ") alla porta applicativa con id:" + idPortaApplicativa);
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_sa_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (j = 0; j < servizioApplicativo.getDatiConnettore().sizeProprietaList(); ++j) {
                            Proprieta p = servizioApplicativo.getDatiConnettore().getProprieta(j);
                            if (p.getValore() == null || "".equals(p.getValore())) continue;
                            stm.setLong(1, idPaSa);
                            stm.setString(2, p.getNome());
                            stm.setString(3, p.getValore());
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + j + " SetSAProp associati al Servizio Applicativo [" + nomeSA + "](id:" + idSA + ") della PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_behaviour_props");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (aPA.getBehaviour() != null) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_behaviour_props");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPA.getBehaviour().sizeProprietaList(); ++i) {
                            propProtocollo = aPA.getBehaviour().getProprieta(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, propProtocollo.getNome());
                            stm.setString(3, propProtocollo.getValore());
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " SeBehaviourProp associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_auth_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta di autenticazione associate alla Porta Applicativa " + idPortaApplicativa);
                    int newProps = 0;
                    for (i = 0; i < aPA.sizeProprietaAutenticazioneList(); ++i) {
                        BYOKWrappedValue byokValue;
                        propProtocollo = aPA.getProprietaAutenticazione(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_auth_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaApplicativa);
                        stm.setString(indexP++, propProtocollo.getNome());
                        String plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolPropAutenticazione associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_authz_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta di autorizzazione associate alla Porta Applicativa " + idPortaApplicativa);
                    newProps = 0;
                    for (i = 0; i < aPA.sizeProprietaAutorizzazioneList(); ++i) {
                        BYOKWrappedValue byokValue;
                        propProtocollo = aPA.getProprietaAutorizzazione(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_authz_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaApplicativa);
                        stm.setString(indexP++, propProtocollo.getNome());
                        String plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolPropAutorizzazione associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_authzc_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta di autorizzazione contenuti associate alla Porta Applicativa " + idPortaApplicativa);
                    newProps = 0;
                    for (i = 0; i < aPA.sizeProprietaAutorizzazioneContenutoList(); ++i) {
                        BYOKWrappedValue byokValue;
                        propProtocollo = aPA.getProprietaAutorizzazioneContenuto(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_authzc_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaApplicativa);
                        stm.setString(indexP++, propProtocollo.getNome());
                        String plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolPropAutorizzazioneContenuto associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_ct_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta di rate limiting associate alla Porta Applicativa " + idPortaApplicativa);
                    newProps = 0;
                    for (i = 0; i < aPA.sizeProprietaRateLimitingList(); ++i) {
                        propProtocollo = aPA.getProprietaRateLimiting(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_ct_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.setString(2, propProtocollo.getNome());
                        stm.setString(3, propProtocollo.getValore());
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolPropRateLimiting associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta associate alla Porta Applicativa " + idPortaApplicativa);
                    newProps = 0;
                    for (i = 0; i < aPA.sizeProprietaList(); ++i) {
                        BYOKWrappedValue byokValue;
                        propProtocollo = aPA.getProprieta(i);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_properties");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQueryObject.addInsertField("enc_value", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        int indexP = 1;
                        stm.setLong(indexP++, idPortaApplicativa);
                        stm.setString(indexP++, propProtocollo.getNome());
                        String plainValueP = propProtocollo.getValore();
                        String encValueP = null;
                        if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue = driverBYOK.wrap(plainValueP)) != null) {
                            encValueP = byokValue.getWrappedValue();
                            plainValueP = byokValue.getWrappedPlainValue();
                        }
                        stm.setString(indexP++, plainValueP);
                        stm.setString(indexP++, encValueP);
                        stm.executeUpdate();
                        stm.close();
                        ++newProps;
                    }
                    DriverConfigurazioneDBLib.logDebug("Inserted " + newProps + " SetProtocolProp associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_ruoli");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli associati alla Porta Applicativa " + idPortaApplicativa);
                    n = 0;
                    if (aPA.getRuoli() != null && aPA.getRuoli().sizeRuoloList() > 0) {
                        for (int j = 0; j < aPA.getRuoli().sizeRuoloList(); ++j) {
                            Ruolo ruolo = aPA.getRuoli().getRuolo(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_ruoli");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_scope");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " scope associati alla Porta Applicativa " + idPortaApplicativa);
                    n = 0;
                    if (aPA.getScope() != null && aPA.getScope().sizeScopeList() > 0) {
                        for (int j = 0; j < aPA.getScope().sizeScopeList(); ++j) {
                            Scope scope = aPA.getScope().getScope(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_scope");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("scope", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, scope.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto scope[" + scope.getNome() + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " scope alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_soggetti");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " soggetti associati alla Porta Applicativa " + idPortaApplicativa);
                    n = 0;
                    if (aPA.getSoggetti() != null && aPA.getSoggetti().sizeSoggettoList() > 0) {
                        for (int j = 0; j < aPA.getSoggetti().sizeSoggettoList(); ++j) {
                            PortaApplicativaAutorizzazioneSoggetto soggetto = aPA.getSoggetti().getSoggetto(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_soggetti");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("tipo_soggetto", "?");
                            sqlQueryObject.addInsertField("nome_soggetto", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, soggetto.getTipo());
                            stm.setString(3, soggetto.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto soggetto [" + soggetto.getTipo() + "/" + soggetto.getNome() + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " soggetti alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative_sa_auth");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " servizi applicativi autorizzati associati alla Porta Applicativa " + idPortaApplicativa);
                    if (aPA.getServiziApplicativiAutorizzati() != null && aPA.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("porte_applicative_sa_auth");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPA.getServiziApplicativiAutorizzati().sizeServizioApplicativoList(); ++i) {
                            PortaApplicativaAutorizzazioneServizioApplicativo servizioApplicativoAutorizzato = aPA.getServiziApplicativiAutorizzati().getServizioApplicativo(i);
                            String nomeSA2 = servizioApplicativoAutorizzato.getNome();
                            String nomeProprietarioSA = servizioApplicativoAutorizzato.getNomeSoggettoProprietario();
                            String tipoProprietarioSA = servizioApplicativoAutorizzato.getTipoSoggettoProprietario();
                            if (nomeSA2 == null || nomeSA2.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Auth]::Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Auth]::Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Auth]::Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA2, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA2 + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            stm.setLong(1, idPortaApplicativa);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " servizi applicativi autorizzati associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_token_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " servizi applicativi autorizzati (token) associati alla Porta Applicativa " + idPortaApplicativa);
                    if (aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getServiziApplicativi() != null && aPA.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("pa_token_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPA.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList(); ++i) {
                            PortaApplicativaAutorizzazioneServizioApplicativo servizioApplicativoAutorizzato = aPA.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(i);
                            String nomeSA3 = servizioApplicativoAutorizzato.getNome();
                            String nomeProprietarioSA = servizioApplicativoAutorizzato.getNomeSoggettoProprietario();
                            String tipoProprietarioSA = servizioApplicativoAutorizzato.getTipoSoggettoProprietario();
                            if (nomeSA3 == null || nomeSA3.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[TokenAuth]::Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[TokenAuth]::Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[TokenAuth]::Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA3, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA3 + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            stm.setLong(1, idPortaApplicativa);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                        }
                        stm.close();
                        DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " servizi applicativi autorizzati (token) associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_token_ruoli");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli (token) associati alla Porta Applicativa " + idPortaApplicativa);
                    n = 0;
                    if (aPA.getAutorizzazioneToken() != null && aPA.getAutorizzazioneToken().getRuoli() != null && aPA.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                        for (int j = 0; j < aPA.getAutorizzazioneToken().getRuoli().sizeRuoloList(); ++j) {
                            Ruolo ruolo = aPA.getAutorizzazioneToken().getRuoli().getRuolo(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_token_ruoli");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] (token) alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli (token) alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_azioni");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " azioni associati alla Porta Applicativa " + idPortaApplicativa);
                    n = 0;
                    if (aPA.getAzione() != null && aPA.getAzione().sizeAzioneDelegataList() > 0) {
                        for (int j = 0; j < aPA.getAzione().sizeAzioneDelegataList(); ++j) {
                            String azioneDelegata = aPA.getAzione().getAzioneDelegata(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_azioni");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("azione", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, azioneDelegata);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto azione delegata [" + azioneDelegata + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " azione delegate alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_cache_regole");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " regole di cache associate alla PortaApplicativa " + idPortaApplicativa);
                    n = 0;
                    if (responseCacheRegole != null && responseCacheRegole.size() > 0) {
                        for (int j = 0; j < responseCacheRegole.size(); ++j) {
                            ResponseCachingConfigurazioneRegola regola = responseCacheRegole.get(j);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_cache_regole");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            if (regola.getReturnCodeMin() != null && regola.getReturnCodeMin() > 0) {
                                sqlQueryObject.addInsertField("status_min", "?");
                            }
                            if (regola.getReturnCodeMax() != null && regola.getReturnCodeMax() > 0) {
                                sqlQueryObject.addInsertField("status_max", "?");
                            }
                            sqlQueryObject.addInsertField("fault", "?");
                            if (regola.getCacheTimeoutSeconds() != null && regola.getCacheTimeoutSeconds() > 0) {
                                sqlQueryObject.addInsertField("cache_seconds", "?");
                            }
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            int indexCR = 1;
                            stm.setLong(indexCR++, idPortaApplicativa);
                            if (regola.getReturnCodeMin() != null && regola.getReturnCodeMin() > 0) {
                                stm.setInt(indexCR++, regola.getReturnCodeMin());
                            }
                            if (regola.getReturnCodeMax() != null && regola.getReturnCodeMax() > 0) {
                                stm.setInt(indexCR++, regola.getReturnCodeMax());
                            }
                            stm.setInt(indexCR++, regola.getFault() ? 1 : 0);
                            if (regola.getCacheTimeoutSeconds() != null && regola.getCacheTimeoutSeconds() > 0) {
                                stm.setInt(indexCR++, regola.getCacheTimeoutSeconds());
                            }
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta regola di cache alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " regole di cache alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_aa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellate " + n + " A.A. associate alla Porta Applicativa " + idPortaApplicativa);
                    n = 0;
                    if (aPA.sizeAttributeAuthorityList() > 0) {
                        for (int j = 0; j < aPA.sizeAttributeAuthorityList(); ++j) {
                            AttributeAuthority aa = aPA.getAttributeAuthority(j);
                            String attributi = null;
                            if (aa.sizeAttributoList() > 0) {
                                StringBuilder bf = new StringBuilder();
                                for (int aaI = 0; aaI < aa.sizeAttributoList(); ++aaI) {
                                    if (aaI > 0) {
                                        bf.append(",");
                                    }
                                    bf.append(aa.getAttributo(aaI));
                                }
                                attributi = bf.toString();
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("pa_aa");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("attributi", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, aa.getNome());
                            stm.setString(3, attributi);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto A.A.[" + aa.getNome() + "] alla PortaApplicativa[" + idPortaApplicativa + "]");
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " A.A. alla PortaApplicativa[" + idPortaApplicativa + "]");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoDatabase, idPortaApplicativa, "pa", "db");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoFiletrace, idPortaApplicativa, "pa", "filetrace");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazioneFiletrace(type, con, tracciamentoFiletraceDetails, idPortaApplicativa, "pa");
                    DriverConfigurazioneDB_dumpLIB.CRUDDumpConfigurazione(type, con, aPA.getDump(), idPortaApplicativa, "pa");
                    DriverConfigurazioneDBTrasformazioniLib.CRUDTrasformazioni(type, con, aPA.getTrasformazioni(), idPortaApplicativa, false);
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, null, idPortaApplicativa, true, configHandlers != null ? configHandlers.getRequest() : null);
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, null, idPortaApplicativa, false, configHandlers != null ? configHandlers.getResponse() : null);
                    if (extInfoConfigurazioneDriver != null) {
                        extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, DriverConfigurazioneDBLib.log, aPA, CRUDType.UPDATE);
                    }
                    i = 0;
                    if (aPA.sizeExtendedInfoList() > 0 && extInfoConfigurazioneDriver != null) {
                        for (i = 0; i < aPA.sizeExtendedInfoList(); ++i) {
                            extInfoConfigurazioneDriver.createExtendedInfo(con, DriverConfigurazioneDBLib.log, aPA, aPA.getExtendedInfo(i), CRUDType.UPDATE);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + i + " associazioni ExtendedInfo<->PortaApplicativa associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    break;
                }
                case 3: {
                    idPortaApplicativa = DBUtils.getIdPortaApplicativa(nomePorta, con, DriverConfigurazioneDBLib.tipoDB);
                    if (idPortaApplicativa <= 0L) {
                        throw new DriverConfigurazioneException("Non e' stato possibile recuperare l'id della Porta Applicativa.");
                    }
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoDatabase, idPortaApplicativa, "pa", "db");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(type, con, tracciamentoFiletrace, idPortaApplicativa, "pa", "filetrace");
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazioneFiletrace(type, con, tracciamentoFiletraceDetails, idPortaApplicativa, "pa");
                    DriverConfigurazioneDB_dumpLIB.CRUDDumpConfigurazione(type, con, aPA.getDump(), idPortaApplicativa, "pa");
                    DriverConfigurazioneDBTrasformazioniLib.CRUDTrasformazioni(type, con, aPA.getTrasformazioni(), idPortaApplicativa, false);
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, null, idPortaApplicativa, true, configHandlers != null ? configHandlers.getRequest() : null);
                    DriverConfigurazioneDB_handlerLIB.CRUDConfigurazioneMessageHandlers(type, con, null, idPortaApplicativa, false, configHandlers != null ? configHandlers.getResponse() : null);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_aa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellate " + n + " A.A. associate alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_cache_regole");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " regole di cache associate alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_azioni");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellate " + n + " azioni delegate associate alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_token_ruoli");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli (token) associati alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_token_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " servizi applicativi autorizzati (token) associati alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative_sa_auth");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " servizi applicativi autorizzati associati alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_soggetti");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " soggetti associati alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_ruoli");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli associati alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_scope");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " scope associati alla Porta Applicativa " + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_mtom_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " request flow con id=" + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_mtom_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " response flow con id=" + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_security_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " request flow con id=" + idPortaApplicativa);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_security_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " response flow con id=" + idPortaApplicativa);
                    ArrayList<Long> idsPaSa = new ArrayList<Long>();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative_sa");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    rs = stm.executeQuery();
                    while (rs.next()) {
                        idsPaSa.add(rs.getLong("id"));
                    }
                    rs.close();
                    stm.close();
                    if (!idsPaSa.isEmpty()) {
                        for (Long idsapa : idsPaSa) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addDeleteTable("pa_sa_properties");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idsapa);
                            n = stm.executeUpdate();
                            stm.close();
                            DriverConfigurazioneDBLib.logDebug("Eliminate " + n + " proprieta relative all'associazione '" + idsapa + "' (Porta Applicativa " + idPortaApplicativa + ")");
                        }
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative_sa");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " servizi applicativi associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_behaviour_props");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " BehaviourProp associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_security_request");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " security_request flow associate alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_security_response");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " security_response flow associate alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_correlazione");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " correlazione associate alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_correlazione_risposta");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " correlazione della risposta associate alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolProp associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_ct_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolPropRateLimiting associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_authzc_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolPropAutorizzazioneContenuto associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_authz_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolPropAutorizzazione associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("pa_auth_properties");
                    sqlQueryObject.addWhereCondition("id_porta=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " SetProtocolPropAutenticazione associati alla PortaApplicativa[" + idPortaApplicativa + "]");
                    }
                    if (extInfoConfigurazioneDriver != null) {
                        extInfoConfigurazioneDriver.deleteAllExtendedInfo(con, DriverConfigurazioneDBLib.log, aPA, CRUDType.DELETE);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("porte_applicative");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.addWhereCondition("nome_porta=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortaApplicativa);
                    stm.setLong(2, idProprietario);
                    stm.setString(3, nomePorta);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " row(s).");
                }
            }
            long l2 = idPortaApplicativa;
            return l2;
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaApplicativa] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante operazione(" + type + ") CRUDPortaApplicativa.", e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
        }
    }
}

